/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.wdminterface.planningdata;

import com.huawei.nglct.cbb.datamanage.integration.handler.TECIPlanningDataHandler;
import com.huawei.nglct.cbb.datamanage.integration.handler.TECfgItem;
import com.huawei.nglct.cbb.datamanage.integration.model.TEDataCfgDownloadPara;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.db.jni.dbservice.TEGeneralKeyValue;
import com.huawei.nglct.gencfg.TEGenCfgCmdFactory;
import com.huawei.nglct.gencfg.TEGenCfgFunAttr;
import com.huawei.nglct.gencfg.TEGenCfgFunCmd;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgPortAttribute;
import com.huawei.nglct.nemgr.neadapter.TENEFuntionAdapterMgr;
import com.huawei.nglct.nemgr.neadapter.functionadapter.TEGenCfgInterface;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenAttrObjectValue;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenObjectID;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenOperationResult;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenValue;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenValueResult;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.TEWDMInfStaticData;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.TEWDMInfUtil;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.objtypeid.TEObjTypeIDCreator;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.objtypeid.TEPartSource;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.planningdata.TEPlanningDataJniMethod;
import com.huawei.nglct.ngwdm_pub.TEOTNModelDataMgr;
import com.huawei.nglct.po.embeddednemgrmo.TENEMOPO;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import com.huawei.nglct.util.string.TEConvertUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Part;
import gnu.trove.TIntObjectHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;

public class TEPlanninDataHander
implements TECIPlanningDataHandler {
    private static final int INVALID_INT_VALUE = -1;
    private static final Logger normalLoger = TELogFactory.getNormalLogger();
    private static final int EXTENDMDSFLAG = 2;
    public static final String[] attrNameArray = new String[]{"W32PORT_ATTR_ST_SERVICETYPE", "W32PORT_ATTR_ST_SERVICETYPE_2", "W32BRD_ATTR_CAPACITY", "W32PORT_ATTR_ST_SERVICEMODE", "W32PORT_ATTR_LINE_CAPACITY", "W32PORT_ATTR_FECTYPE", "W32PORT_ATTR_FECENABLE", "W32PORT_ATTR_OTN_ODUTSMODE", "W32PORT_ATTR_DCMVALUE_SND1", "W32PORT_ATTR_DCMVALUE_SND2", "W32PORT_ATTR_DCMVALUE_SND3", "W32PORT_ATTR_DCMVALUE_SND4", "W32PORT_ATTR_DCMVALUE_RCV1", "W32PORT_ATTR_DCMVALUE_RCV2", "W32PORT_ATTR_DCMVALUE_RCV3", "W32PORT_ATTR_DCMVALUE_RCV4"};
    private ArrayList<Integer> errorCodeList = new ArrayList();

    public TECfgItem getOperIF(int OperType) {
        return null;
    }

    public String getItemName() {
        return null;
    }

    public int getItemID() {
        return 0;
    }

    public int setToNE(TEDataCfgDownloadPara pPara) {
        normalLoger.info("Set planning data to ne begin.");
        int neID = pPara.getTmpNEInfo().getNeID();
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (null == ne) {
            return 1090596385;
        }
        int errorCode = TEHandleSbiInfo.getInstance().handleSBIConnectOnInter2(neID);
        if (0 != errorCode) {
            return errorCode;
        }
        int slotID = -1;
        int boardType = -1;
        TEGenAttrObjectValue attrValue = null;
        TIntObjectHashMap portAttrMap = null;
        Vector boardList = TEPlanningDataJniMethod.getBoardList(neID);
        TEGenCfgFunCmd funCmd = TEPlanninDataHander.getFunCmd(ne);
        List<TEGenCfgPortAttribute> attributeList = null;
        ArrayList<TEGenAttrObjectValue> attrValueList = new ArrayList<TEGenAttrObjectValue>();
        boolean extendValue = pPara.getCfgItem().getExtendMDS() == 2;
        for (TEBoard board : boardList) {
            slotID = board.getSlotID();
            boardType = board.getBoardType();
            for (String attrName : attrNameArray) {
                portAttrMap = TEGenCfgDataMgr.getPortAttrMap((int)neID, (String)attrName, (int)boardType);
                attributeList = TEPlanninDataHander.constructAttributeList((TIntObjectHashMap<List<TEGenCfgPortAttribute>>)portAttrMap);
                for (TEGenCfgPortAttribute attribute : attributeList) {
                    if (extendValue && this.isOldData(neID, slotID, funCmd, attrName, attribute)) continue;
                    attrValue = TEPlanninDataHander.constructAttrValue(neID, slotID, funCmd, attrName, attribute);
                    attrValue.setNeedSaveDB(false);
                    attrValueList.add(attrValue);
                }
            }
        }
        TEGenOperationResult result = this.setToNEImpl(neID, attrValueList);
        normalLoger.info("Set planning data to ne end.");
        return result.getWholeErrorCode();
    }

    protected boolean isOldData(int neID, int slotID, TEGenCfgFunCmd funCmd, String attrName, TEGenCfgPortAttribute attribute) {
        String objTypeStr = TEWDMInfStaticData.getAttrNameObjTypeNameMap().get(attrName);
        String newAttrName = TEWDMInfStaticData.getOmnipotentAttr(objTypeStr);
        TEGenAttrObjectValue attrValue = TEPlanninDataHander.constructAttrValue(neID, slotID, funCmd, newAttrName, attribute);
        List list = attrValue.getAttrIDList();
        if (list.size() >= 1) {
            TEGenValue genvalue = (TEGenValue)list.get(0);
            return genvalue.getValue().equals("1");
        }
        return false;
    }

    public static List<TEGenCfgPortAttribute> constructAttributeList(TIntObjectHashMap<List<TEGenCfgPortAttribute>> portAttrMap) {
        Object[] attributeListArr;
        ArrayList<TEGenCfgPortAttribute> attributeList = new ArrayList<TEGenCfgPortAttribute>();
        for (Object attrList : attributeListArr = portAttrMap.getValues()) {
            attributeList.addAll((List)attrList);
        }
        return attributeList;
    }

    public static TEGenAttrObjectValue constructAttrValue(int neID, int slotID, TEGenCfgFunCmd funCmd, String attrName, TEGenCfgPortAttribute attribute) {
        int portID = attribute.getPort();
        int pathID = attribute.getPath();
        pathID = TEPlanninDataHander.getNmPath(neID, slotID, portID, pathID, funCmd, attrName);
        String objTypeStr = TEWDMInfUtil.getObjTypeByAttr(funCmd, attrName);
        TEPartSource partSource = TEPlanninDataHander.constructPartSource(slotID, portID, pathID);
        int intObjectID = TEWDMInfStaticData.getObjTypeNameIDMap().get(objTypeStr);
        TEGenObjectID objectID = new TEGenObjectID(TEObjTypeIDCreator.getInstance().createObjectID(neID, intObjectID, partSource));
        TEGenAttrObjectValue attrValue = new TEGenAttrObjectValue();
        attrValue.setObjectID(objectID);
        int attrID = TEWDMInfUtil.getAttrID(attrName, neID);
        partSource = TEPlanninDataHander.constructPartSource(slotID, portID, attribute.getPath());
        String value = TEPlanninDataHander.getAttrValueFromDB(neID, attrName, objTypeStr, partSource, attrID);
        TEGenValue genValue = new TEGenValue();
        genValue.setAttrID(attrID);
        genValue.setAttrName(attrName);
        genValue.setValue(value);
        ArrayList<TEGenValue> attrIDList = new ArrayList<TEGenValue>();
        attrIDList.add(genValue);
        attrValue.setAttrIDList(attrIDList);
        attrValue.setMitLockType((byte)0);
        return attrValue;
    }

    private static String getAttrValueFromDB(int neID, String attrName, String objTypeStr, TEPartSource partSource, int attrID) {
        TEGeneralKeyValue key = new TEGeneralKeyValue();
        key.setAttrID(attrID);
        int intObjectID = TEObjTypeIDCreator.getInstance().getObjTypeID(neID, attrName, objTypeStr, partSource);
        key.setTEOBJECTID(TEObjTypeIDCreator.getInstance().createObjectID(neID, intObjectID, partSource));
        String value = TEWDMInfUtil.getAttrValueFromDB_NoLock(key);
        return value;
    }

    public static TEPartSource constructPartSource(int slotID, int portID, int pathID) {
        Input input = new Input();
        Part part = new Part();
        part.setName("slotid");
        part.setValue(String.valueOf(slotID));
        input.addPart(part);
        part = new Part();
        part.setName("port");
        part.setValue(String.valueOf(portID));
        input.addPart(part);
        part = new Part();
        part.setName("path");
        part.setValue(String.valueOf(pathID));
        input.addPart(part);
        TEPartSource partSource = new TEPartSource(input);
        return partSource;
    }

    public static TEGenCfgFunCmd getFunCmd(TENE ne) {
        SubFunc subFunc = TEPlanninDataHander.getSubFunc(ne.getNEID(), ne);
        if (subFunc == null) {
            return null;
        }
        String fileName = subFunc.getGenCfgAttrDesPath().getContent();
        StringBuffer funCmdFilePath = new StringBuffer("nemgr").append(File.separator).append(fileName);
        String path = TEResourceManager.getPath() + funCmdFilePath.toString();
        TEGenCfgFunCmd funCmd = TEGenCfgCmdFactory.getInstance().getFunCmd(path);
        return funCmd;
    }

    public static boolean isNewOtnModeBoard(int neID, int slotID) {
        TEOTNModelDataMgr otnModelMgr = TEOTNModelDataMgr.getInstance();
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotID);
        return otnModelMgr.isSimpleModelBoard(boardType);
    }

    public static int getNePath(int neID, int slotID, int nmPath) {
        int boardType;
        TEOTNModelDataMgr otnModelMgr = TEOTNModelDataMgr.getInstance();
        int nepath = otnModelMgr.getNePath(nmPath, boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotID));
        if (nepath == -1) {
            nepath = nmPath;
        }
        return nepath;
    }

    public static int getNmPath(int neID, int slotID, int port, int path, TEGenCfgFunCmd funCmd, String attrName) {
        int nmPath = path;
        TEOTNModelDataMgr otnModelMgr = TEOTNModelDataMgr.getInstance();
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotID);
        int grade = otnModelMgr.getGradeFromBoard(boardType);
        if (otnModelMgr.isSupportSimpleModePort(boardType, port)) {
            TEGenCfgFunAttr funAttr = funCmd.getGenCfgFunAttr(attrName, "query");
            if (funAttr == null) {
                normalLoger.info("Get attr(" + attrName + ") for query TEGenCfgFunAttr failed!");
            } else {
                String operationName = funAttr.getPtcode();
                int layer = otnModelMgr.getLayerFromAttrID(operationName);
                int tmpPath = otnModelMgr.getNmPath(layer, grade, path, boardType);
                if (tmpPath != -1) {
                    nmPath = tmpPath;
                }
            }
        }
        return nmPath;
    }

    private static SubFunc getSubFunc(int neID, TENE ne) {
        SubFunc subFunc = null;
        try {
            int neType = ne.getNEType();
            TENEMOPO nemopo = TEPlanningDataJniMethod.getTENEPO(neID);
            String hostVersion = TEConvertUtil.neVersionToString((int)((int)nemopo.getVersion()));
            subFunc = TECreateObjectFactory.getSubFunc((int)neID, (int)neType, (String)hostVersion, (int)2107410);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("", (Throwable)e);
        }
        return subFunc;
    }

    private TEGenOperationResult setToNEImpl(int neID, List<TEGenAttrObjectValue> attrValueList) {
        this.initErrorCodeList();
        TEGenOperationResult result = null;
        TENEFuntionAdapterMgr adapterMgr = TENEFuntionAdapterMgr.getInstance();
        TEGenCfgInterface adpaterIF = (TEGenCfgInterface)adapterMgr.findFunctionInterface(neID, TEGenCfgInterface.class.getName());
        int tempError = 0;
        if (!attrValueList.isEmpty()) {
            List resultList = adpaterIF.setAttribListToNE(adpaterIF.getWDMInterfaceCmdFilePath(), attrValueList);
            for (TEGenOperationResult attrResult : resultList) {
                boolean isexit = false;
                if (attrResult.getWholeErrorCode() != 0) {
                    for (TEGenValueResult genValueResul : attrResult.getGenResultList()) {
                        if (!this.errorCodeList.contains(genValueResul.errorCode)) continue;
                        tempError = genValueResul.errorCode;
                        isexit = true;
                        break;
                    }
                }
                if (!isexit) continue;
                attrResult.setWholeErrorCode(tempError);
                return attrResult;
            }
        }
        result = new TEGenOperationResult();
        result.setErrorInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)0));
        result.setWholeErrorCode(0);
        return result;
    }

    private void initErrorCodeList() {
        if (this.errorCodeList.isEmpty()) {
            this.errorCodeList.add(1090650120);
            this.errorCodeList.add(1201);
            this.errorCodeList.add(37926);
        }
    }
}

