/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.wdminterface;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.db.jni.dbservice.TEGeneralKeyValue;
import com.huawei.nglct.db.jni.dbservice.TEGeneralValue;
import com.huawei.nglct.db.jni.dbservice.TEGnlValueElement;
import com.huawei.nglct.gencfg.TEGenCfgFunAttr;
import com.huawei.nglct.gencfg.TEGenCfgFunCmd;
import com.huawei.nglct.gencfg.frame.TEGnlAttrMgr;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TESubrack;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEPort;
import com.huawei.nglct.nelist.model.TEQueryPortForDataMgr;
import com.huawei.nglct.nelist.model.channel.QueryWDMMode;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.TEWDMInfStaticData;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.objtypeid.TEObjTypeIDCreator;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.objtypeid.TEPartSource;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.specialprocess.TEAttrHandler;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public final class TEWDMInfUtil {
    public static final int TE_ERR_WNEMGR_GET_FROM_DB_FAIL = 1090615127;
    public static final String DEFAULT_SUB_CARD_ID = "255";
    public static final String DEFAULT_PATH_ID = "1";
    public static final String VALUE_INVALID_STR = "/";
    public static final String W32BRD_ATTR_CFGWDMTYPE = "W32BRD_ATTR_CFGWDMTYPE";
    public static final String W32PORT_ATTR_CFGWAVELENTYPE = "W32PORT_ATTR_CFGWAVELENTYPE";
    public static final String W32PORT_ATTR_WAVELENTYPE = "W32PORT_ATTR_WAVELENTYPE";
    public static final String W32BRD_ATTR_WDMTYPE = "W32BRD_ATTR_WDMTYPE";
    public static final String W32BRD_ATTR_CFGUPDOWNWDMTYPE = "W32BRD_ATTR_CFGUPDOWNWDMTYPE";
    public static final String W32BRD_ATTR_CFGUPDOWNWAVE = "W32BRD_ATTR_CFGUPDOWNWAVE";
    public static final String W32BRD_ATTR_UPDOWNWAVE = "W32BRD_ATTR_UPDOWNWAVE";
    public static final String W32PORT_ATTR_ST_SERVICETYPE = "W32PORT_ATTR_ST_SERVICETYPE";
    public static final String W32PORT_ATTR_ST_SERVICETYPE_2 = "W32PORT_ATTR_ST_SERVICETYPE_2";
    public static final String W32PORT_ATTR_OTN_OHTRANS = "W32PORT_ATTR_OTN_OHTRANS";
    public static final int NE_INVALID_WAVELEN = 255;
    public static final int NE_INVALID_WAVETYPE = 255;
    public static final int CNEMGR_INVALID_WAVELEN = 65536;
    public static final String W32PORT_ATTR_RECWAVELEN = "W32PORT_ATTR_RECWAVELEN";
    public static final String W32PORT_ATTR_RECWAVETYPE = "W32PORT_ATTR_RECWAVETYPE";
    public static final String OLDBOARD = "1";

    private TEWDMInfUtil() {
    }

    public static void getOperFromDB(Map<TEGeneralKeyValue, Operation> keyOperMap) {
        List<TEGnlValueElement> elementList = TEWDMInfUtil.constructGnlElementList(keyOperMap);
        TEDaoOperationResult result = TEWDMInfUtil.getElementFromDB(elementList);
        int retCode = result.getResult();
        List data = result.getData();
        TELogFactory.getNormalLogger().info("find gnl value. data.size->" + data.size());
        TELogFactory.getNormalLogger().info("find gnl value. result->" + result.toString());
        Fault fault = null;
        TEGeneralKeyValue key = null;
        if (!data.isEmpty()) {
            TEGnlValueElement ele2 = null;
            Operation oper = null;
            int errCode = -1;
            for (TEGnlValueElement ele2 : data) {
                key = ele2.getGnlKeyValue();
                oper = TEWDMInfUtil.getOperFromMap(keyOperMap, key);
                if (null == oper) continue;
                Output output = oper.getOutput(0);
                TEWDMInfUtil.fillObjIDPartValue(ele2, output);
                TEWDMInfUtil.fillAttrPartValue(ele2, output);
                errCode = ele2.getGnlValue().getErrCode();
                fault = oper.getOutput(0).getFault(0);
                if (fault.getCode() == null || fault.getCode().isEmpty()) {
                    fault.setCode(String.valueOf(errCode));
                }
                keyOperMap.remove(key);
            }
            TEWDMInfUtil.handleFailedOper(keyOperMap, 1090615127);
        } else {
            TEWDMInfUtil.handleFailedOper(keyOperMap, retCode);
        }
    }

    private static Operation getOperFromMap(Map<TEGeneralKeyValue, Operation> keyOperMap, TEGeneralKeyValue key) {
        Set<Map.Entry<TEGeneralKeyValue, Operation>> entrySet = keyOperMap.entrySet();
        Iterator<Map.Entry<TEGeneralKeyValue, Operation>> entryIter = entrySet.iterator();
        Map.Entry<TEGeneralKeyValue, Operation> entry = null;
        while (entryIter.hasNext()) {
            entry = entryIter.next();
            if (!key.equals((Object)entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    private static List<TEGnlValueElement> constructGnlElementList(Map<TEGeneralKeyValue, Operation> keyOperMap) {
        ArrayList<TEGnlValueElement> elementList = new ArrayList<TEGnlValueElement>();
        TEGnlValueElement element = null;
        TEGeneralKeyValue key2 = null;
        Set<TEGeneralKeyValue> keySet = keyOperMap.keySet();
        for (TEGeneralKeyValue key2 : keySet) {
            element = new TEGnlValueElement();
            element.setGnlKeyValue(key2);
            elementList.add(element);
        }
        return elementList;
    }

    public static TEDaoOperationResult getElementFromDB(List<TEGnlValueElement> elementList) {
        StringBuffer buffer = new StringBuffer(0);
        buffer.append("find gnl value. req->").append('\n');
        for (TEGnlValueElement ele : elementList) {
            buffer.append(ele.toString()).append('\n');
        }
        TELogFactory.getNormalLogger().info("find gnl value. req->" + buffer.toString());
        TEDaoOperationResult result = TECommonDaoService.findGnlValue(elementList);
        TELogFactory.getNormalLogger().info("find gnl value. rsp->" + result.getResult());
        return result;
    }

    public static TEDaoOperationResult getElementFromDB(int neID, List<TEGnlValueElement> elementList) {
        TEDaoOperationResult result = null;
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (null == ne) {
            result = new TEDaoOperationResult();
            result.setResult(1090596385);
            return result;
        }
        StringBuffer buffer = new StringBuffer(0);
        buffer.append("find gnl value. req->").append('\n');
        for (TEGnlValueElement ele : elementList) {
            buffer.append(ele.toString()).append('\n');
        }
        TELogFactory.getNormalLogger().info("find gnl value. req->" + buffer.toString());
        result = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findGnlValue(elementList) : TECommonDaoService.findGnlValue_NoLock(elementList);
        TELogFactory.getNormalLogger().info("find gnl value. rsp->" + result.getResult());
        return result;
    }

    public static String getAttrValueFromDB_NoLock(TEGeneralKeyValue key) {
        String attrValue = null;
        ArrayList<TEGnlValueElement> elementList = new ArrayList<TEGnlValueElement>();
        TEGnlValueElement element = new TEGnlValueElement();
        element.setGnlKeyValue(key);
        elementList.add(element);
        StringBuffer buffer = new StringBuffer(0);
        buffer.append("find gnl value. req->").append('\n');
        for (TEGnlValueElement ele : elementList) {
            buffer.append(ele.toString()).append('\n');
        }
        TELogFactory.getNormalLogger().info("find gnl value. req->" + buffer.toString());
        TEDaoOperationResult result = TECommonDaoService.findGnlValue_NoLock(elementList);
        TELogFactory.getNormalLogger().info("find gnl value. rsp->" + result.getResult());
        List data = result.getData();
        TELogFactory.getNormalLogger().info("find gnl value. data.size->" + data.size());
        TELogFactory.getNormalLogger().info("find gnl value. result->" + result.toString());
        if (!data.isEmpty()) {
            TEGnlValueElement ele2 = null;
            for (TEGnlValueElement ele2 : data) {
                int valueType = TEGnlAttrMgr.getInstance().getAttrValueType(key.getAttrID());
                if (0 == valueType) {
                    attrValue = String.valueOf(ele2.getGnlValue().getiValue());
                    continue;
                }
                attrValue = ele2.getGnlValue().getsValue();
            }
        }
        return attrValue;
    }

    private static void handleFailedOper(Map<TEGeneralKeyValue, Operation> keyOperMap, int errorCode) {
        Collection<Operation> operList = keyOperMap.values();
        for (Operation operertion : operList) {
            Fault fault1 = operertion.getOutput(0).getFault(0);
            fault1.setCode(String.valueOf(errorCode));
        }
    }

    private static String getAttrValue(TEGnlValueElement ele, int attrID) {
        int valType = TEGnlAttrMgr.getInstance().getAttrValueType(attrID);
        String attrValue = null;
        int intValue = -1;
        String strValue = null;
        if (0 == valType) {
            intValue = ele.getGnlValue().getiValue();
            attrValue = String.valueOf(intValue);
        } else {
            attrValue = strValue = ele.getGnlValue().getsValue();
        }
        return attrValue;
    }

    private static void fillAttrPartValue(TEGnlValueElement ele, Output output) {
        int attrID = ele.getGnlKeyValue().getAttrID();
        String attrValue = TEWDMInfUtil.getAttrValue(ele, attrID);
        Set attrNameSet = (Set)TEWDMInfStaticData.getAttrIDNameMap().get(attrID);
        if (null != attrNameSet) {
            String attrName2 = null;
            Part part = null;
            for (String attrName2 : attrNameSet) {
                part = output.getPart(attrName2);
                if (null == part) continue;
                TEAttrHandler.getInstance().setAttrPartValue(ele, attrValue, attrName2, output, part);
            }
        }
    }

    private static void fillObjIDPartValue(TEGnlValueElement ele, Output output) {
        int[] objID = ele.getGnlKeyValue().getTEOBJECTID();
        Part part = output.getPart("neid");
        if (null != part && objID.length >= 2) {
            part.setValue(String.valueOf(objID[1]));
        }
        if (null != (part = output.getPart("subCardId"))) {
            part.setValue(DEFAULT_SUB_CARD_ID);
        }
        if (null != (part = output.getPart("slotid")) && objID.length >= 3) {
            int slotID = objID[2];
            part.setValue(String.valueOf(slotID));
        }
        if (null != (part = output.getPart("port")) && objID.length >= 4) {
            int portID = objID[3];
            portID = TEConfigurationDataMgr.getPortRelativeID((int)portID);
            part.setValue(String.valueOf(portID));
        }
        if (null != (part = output.getPart("path"))) {
            if (objID.length >= 5) {
                part.setValue(String.valueOf(objID[4]));
            } else {
                part.setValue("1");
            }
        }
    }

    public static Map<TEGeneralKeyValue, Operation> getKeyOperMap(int neid, TEGenCfgFunCmd funCmd, String attrName, Operation oper) {
        HashMap<TEGeneralKeyValue, Operation> keyOperMap = new HashMap<TEGeneralKeyValue, Operation>();
        String objTypeStr = TEWDMInfUtil.getObjTypeByAttr(funCmd, attrName);
        TEGeneralKeyValue key = TEWDMInfUtil.constructGnlKey(neid, attrName, objTypeStr, new TEPartSource(oper.getInput()));
        keyOperMap.put(key, oper);
        return keyOperMap;
    }

    public static String getObjTypeByAttr(TEGenCfgFunCmd funCmd, String attrName) {
        String objTypeStr = TEWDMInfStaticData.getAttrNameObjTypeNameMap().get(attrName);
        if (null == objTypeStr) {
            TEGenCfgFunAttr funAttr = funCmd.getGenCfgFunAttr(attrName, "query");
            objTypeStr = funAttr.getObjectType();
        }
        return objTypeStr;
    }

    public static int getAttrID(String attrName, int neid) {
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        int neType = neObj.getNEType();
        Integer attrID = TEWDMInfStaticData.getAttrNameIDMap(neType).get(attrName);
        if (null != attrID) {
            return attrID;
        }
        TELogFactory.getNormalLogger().error("get objtype error->" + attrName);
        return -1;
    }

    protected static boolean isOutputContainNMQueryAttr(int neid, Operation oper, boolean isSaveDBFlag, boolean isNeedConvert) {
        Output output = null;
        Part nmAttrPart = null;
        Iterator<String> iter = null;
        String attrName = null;
        HashSet<String> queryFromNEMap = new HashSet<String>();
        queryFromNEMap.add("W32PORT_ATTR_ATTENUATION");
        queryFromNEMap.add("W32PORT_ATTR_ETHWORKMODE");
        queryFromNEMap.add("W32PORT_ATTR_MAXPKGSIZE");
        queryFromNEMap.add("W32PORT_ATTR_INSERTCODE");
        queryFromNEMap.add("W32PORT_ATTR_FIBERLENGTH");
        int len = oper.getOutputCount();
        for (int i = 0; i < len; ++i) {
            output = oper.getOutput(i);
            iter = TEWDMInfStaticData.getKeySets().iterator();
            while (iter.hasNext()) {
                attrName = TEWDMInfUtil.convertActAttrName(neid, iter.next(), isNeedConvert);
                nmAttrPart = output.getPart(attrName);
                if (nmAttrPart != null && queryFromNEMap.contains(attrName) && !isSaveDBFlag) {
                    return false;
                }
                if (null == nmAttrPart) continue;
                return true;
            }
        }
        return false;
    }

    protected static boolean isInputContainNMQueryAttr(int neid, Operation oper, boolean isNeedConvert) {
        Input input = null;
        Part nmAttrPart = null;
        Iterator<String> iter = null;
        String attrName = null;
        input = oper.getInput();
        iter = TEWDMInfStaticData.getKeySets().iterator();
        while (iter.hasNext()) {
            attrName = TEWDMInfUtil.convertActAttrName(neid, iter.next(), isNeedConvert);
            nmAttrPart = input.getPart(attrName);
            if (null == nmAttrPart) continue;
            return true;
        }
        return false;
    }

    public static int saveAttrInfoToDB(Map<TEGnlValueElement, Operation> keyOperMap) {
        Set<TEGnlValueElement> elementSet = keyOperMap.keySet();
        ArrayList<TEGnlValueElement> elementList = new ArrayList<TEGnlValueElement>(elementSet);
        TEDaoOperationResult result = TEWDMInfUtil.saveAttrInfoToDB(elementList, true);
        int retCode = result.getResult();
        if (0 != retCode) {
            Operation oper2 = null;
            Fault fault = null;
            Collection<Operation> operList = keyOperMap.values();
            for (Operation oper2 : operList) {
                fault = new Fault();
                fault.setCode(String.valueOf(retCode));
                oper2.getOutput(0).addFault(fault);
            }
        }
        return retCode;
    }

    public static TEDaoOperationResult saveAttrInfoToDB(List<TEGnlValueElement> elementList, boolean isWriteLog) {
        TEDaoOperationResult result = null;
        if (null != elementList && 0 != elementList.size()) {
            if (isWriteLog) {
                StringBuffer buffer = new StringBuffer(50);
                buffer.append("save attr to database.\n");
                for (TEGnlValueElement element : elementList) {
                    buffer.append(element.toString()).append('\n');
                }
                TELogFactory.getNormalLogger().info(buffer.toString());
            }
            result = TECommonDaoService.saveGnlValueToDB(elementList);
        } else {
            result = new TEDaoOperationResult();
            result.setResult(0);
        }
        TELogFactory.getNormalLogger().info("save gnl value. result->" + result.getResult());
        return result;
    }

    public static TEGnlValueElement constructElement(int neid, TEGenCfgFunCmd funCmd, TEPartSource partSource, String attrName, String valueStr) {
        TEGnlValueElement element = new TEGnlValueElement();
        String objTypeStr = TEWDMInfUtil.getObjTypeByAttr(funCmd, attrName);
        TEGeneralKeyValue key = TEWDMInfUtil.constructGnlKey(neid, attrName, objTypeStr, partSource);
        element.setGnlKeyValue(key);
        TEGeneralValue value = TEWDMInfUtil.constructGnlValue(neid, partSource, attrName);
        element.setGnlValue(value);
        return element;
    }

    protected static TEGeneralKeyValue constructGnlKey(int neid, String attrName, String objTypeStr, TEPartSource partSource) {
        TEGeneralKeyValue key = new TEGeneralKeyValue();
        key.setAttrID(TEWDMInfUtil.getAttrID(attrName, neid));
        int objTpID = TEObjTypeIDCreator.getInstance().getObjTypeID(neid, attrName, objTypeStr, partSource);
        int[] objTypeID = TEObjTypeIDCreator.getInstance().createObjectID(neid, objTpID, partSource);
        key.setTEOBJECTID(objTypeID);
        return key;
    }

    private static TEGeneralValue constructGnlValue(int neid, TEPartSource partSource, String attrName) {
        TEGeneralValue value = new TEGeneralValue();
        TEAttrHandler.getInstance().setElementValue(neid, partSource, attrName, value);
        return value;
    }

    public static Map<Integer, Integer> getPortModeByBoard(int neid, int slotid) {
        if (TESysManagerConstants.SYS_SINGLE_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
            return QueryWDMMode.queryPortMode((int)neid, (int)slotid);
        }
        int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
        return TEWDMInfUtil.getPortModeByBoardInIntel(neid, slotid, boardtype);
    }

    private static Map<Integer, Integer> getPortModeByBoardInIntel(int neid, int slotid, int boardType) {
        List portList = TEQueryPortForDataMgr.getPortListOnInter((int)neid, (int)slotid, (int)boardType);
        HashMap<Integer, Integer> portModeMap = new HashMap<Integer, Integer>();
        int len = portList.size();
        for (int i = 0; i < len; ++i) {
            TEPort port = (TEPort)portList.get(i);
            Integer portMode = (int)port.getPortMode();
            portModeMap.put(port.getPortNo(), portMode);
        }
        return portModeMap;
    }

    public static String convertCfgAttrName(int neid, String attrName, boolean isNeedConvert) {
        if (isNeedConvert) {
            if (attrName.equals(W32BRD_ATTR_WDMTYPE)) {
                return W32BRD_ATTR_CFGWDMTYPE;
            }
            if (attrName.equals(W32PORT_ATTR_WAVELENTYPE)) {
                return W32PORT_ATTR_CFGWAVELENTYPE;
            }
            if (attrName.equals(W32BRD_ATTR_UPDOWNWAVE)) {
                return W32BRD_ATTR_CFGUPDOWNWAVE;
            }
        }
        return attrName;
    }

    public static String convertActAttrName(int neid, String attrName, boolean isNeedConvert) {
        if (isNeedConvert) {
            if (attrName.equals(W32BRD_ATTR_CFGWDMTYPE)) {
                return W32BRD_ATTR_WDMTYPE;
            }
            if (attrName.equals(W32PORT_ATTR_CFGWAVELENTYPE)) {
                return W32PORT_ATTR_WAVELENTYPE;
            }
            if (attrName.equals(W32BRD_ATTR_CFGUPDOWNWAVE)) {
                return W32BRD_ATTR_UPDOWNWAVE;
            }
            if (attrName.equals(W32BRD_ATTR_CFGUPDOWNWDMTYPE)) {
                return "W32BRD_ATTR_UPDOWNWDMTYPE";
            }
        }
        return attrName;
    }

    public static short getSubrackCrossMode(int neid, int subrackID) {
        TESubrack subrack = null;
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        Vector subRackList = ne.getSubrackList();
        for (int i = subRackList.size() - 1; i >= 0; --i) {
            subrack = (TESubrack)subRackList.get(i);
            if (!subrack.getSubrackID().equals(String.valueOf(subrackID))) continue;
            return subrack.getCrossMode();
        }
        return -1;
    }

    public static int getServiceType(int neid, int slotid, int portid, int pathid) {
        int servType = -1;
        TEGeneralKeyValue key = new TEGeneralKeyValue();
        key.setAttrID(271534);
        int abstactPortid = TEQueryPortForDataMgr.getAbstractPortID((int)neid, (int)portid);
        int[] tEOBJECTID = new int[]{61509, neid, slotid, abstactPortid, pathid};
        key.setTEOBJECTID(tEOBJECTID);
        String attrValue = TEWDMInfUtil.getAttrValueFromDB_NoLock(key);
        if (attrValue != null && !attrValue.isEmpty()) {
            servType = Integer.parseInt(attrValue);
        }
        return servType;
    }

    public static int getSubBDTypeFromDB(int neid, int slotid) {
        int subbdType = -1;
        TEGeneralKeyValue key = new TEGeneralKeyValue();
        key.setAttrID(266282);
        int[] tEOBJECTID = new int[]{61442, neid, slotid};
        key.setTEOBJECTID(tEOBJECTID);
        String attrValue = TEWDMInfUtil.getAttrValueFromDB_NoLock(key);
        if (attrValue != null && !attrValue.isEmpty()) {
            subbdType = Integer.parseInt(attrValue);
        }
        return subbdType;
    }
}

