/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.wdminterface;

import com.huawei.nglct.cbb.datamanage.integration.model.TEDataCfgNEInfo;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgAttribute;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgModel;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.TEQueryWDMInfBean;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.TEQueryWDMInfOnIBean;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.TEWDMInfStaticData;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;

public class TEWDMInfUploadProcessor {
    private static final int QUERY_FROM_NE = 1;
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();
    private static TEWDMInfUploadProcessor instance = null;

    public static synchronized TEWDMInfUploadProcessor getInstance() {
        if (instance == null) {
            instance = new TEWDMInfUploadProcessor();
        }
        return instance;
    }

    public TEErrInfoReturn upLoad(TEDataCfgNEInfo neInfo) {
        int neID = neInfo.getNeID();
        int slotID = -1;
        int sfid = this.getSfid();
        TEQueryWDMInfBean bean = this.getQueryWDMInfBean(neID, sfid);
        SubFunc subFunc = this.createSubFunc(neID, sfid);
        Datainterface inputData = null;
        List boardList = TEConfigurationDataMgr.getInstance().getBoardList(neID);
        int boardType = -1;
        Set<String> saveDbAttrs = TEWDMInfStaticData.getAttrNameObjTypeNameMap().keySet();
        TEErrInfoReturn errInfoReturn = new TEErrInfoReturn();
        for (TEBoard board : boardList) {
            boardType = board.getBoardType();
            slotID = board.getSlotID();
            inputData = this.createDataInterface(neID, slotID, boardType, saveDbAttrs);
            if (inputData.getBussinessParams().getRowParams() == null || inputData.getBussinessParams().getRowParams()[0].getParam("attrId") == null || "".equals(inputData.getBussinessParams().getRowParams()[0].getParam("attrId").getValue())) continue;
            e2eLogger.info("begin upLoad the board->" + board.getSlotID() + ", neid->" + neID);
            bean.performBussinessProcess(neID, subFunc, inputData, null, null, null);
            e2eLogger.info("end upLoad the board->" + board.getSlotID() + ", neid->" + neID);
        }
        errInfoReturn.setResult(0);
        return errInfoReturn;
    }

    private boolean isCommuniteError(int errorCode) {
        return errorCode != 0 && errorCode != 1 && errorCode != 2;
    }

    private SubFunc createSubFunc(int neID, int sfid) {
        SubFunc subFunc = null;
        try {
            subFunc = TECreateObjectFactory.getSubFunc((int)neID, (int)sfid);
        }
        catch (Exception e) {
            e2eLogger.error("createSubFunc: Get SubFunc fail!", (Throwable)e);
        }
        return subFunc;
    }

    private TEQueryWDMInfBean getQueryWDMInfBean(int neID, int sfid) {
        TEQueryWDMInfOnIBean processBean = null;
        processBean = new TEQueryWDMInfOnIBean(){

            @Override
            public boolean isNeedOperationlog() {
                return false;
            }
        };
        processBean.isUploadFlag = true;
        return processBean;
    }

    private int getSfid() {
        return 2107410;
    }

    private Datainterface createDataInterface(int neID, int slotID, int boardType, Set<String> saveDbAttrs) {
        Set<String> supportAtrrs = this.getSupportAtrrs(neID, boardType);
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        RowParams rowparams = new RowParams();
        Param param = new Param("queryflag", String.valueOf(1));
        rowparams.addParam(param);
        param = new Param("neid", String.valueOf(neID));
        rowparams.addParam(param);
        param = new Param("slotid", String.valueOf(slotID));
        rowparams.addParam(param);
        param = new Param("srcObjType", "ID_OBJECT_TYPE_NE_BOARD");
        rowparams.addParam(param);
        for (String attrID : saveDbAttrs) {
            if (!supportAtrrs.contains(attrID)) continue;
            param = new Param("attrId", attrID);
            rowparams.addParam(param);
        }
        bussiness.addRowParams(rowparams);
        return inputData;
    }

    private static void logOutputDataError(int neID, int soltID, Datainterface outputData) {
        int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        String errorTipStr = null;
        String errorCodeStr = null;
        String objectName = "";
        String objectID = null;
        if (errorCode == 0) {
            return;
        }
        if (errorCode == 2 || errorCode == 1) {
            String portID = "-1";
            String pathID = "-1";
            int len = outputData.getBussinessParams().getRowParamsCount();
            for (int i = 0; i < len; ++i) {
                RowErrors[] rowErrors = outputData.getBussinessParams().getRowParams(i).getRowErrors();
                if (rowErrors.length == 0) continue;
                for (RowErrors rowError : rowErrors) {
                    errorCodeStr = rowError.getErrorMessage().getErrorcode();
                    if (null == errorCodeStr || errorCodeStr.isEmpty() || errorCodeStr.equals(String.valueOf(38669))) continue;
                    if (rowError.getParam("port") != null && rowError.getParam("port").getValue() != null) {
                        portID = rowError.getParam("port").getValue();
                    }
                    if (rowError.getParam("path") != null && rowError.getParam("path").getValue() != null) {
                        pathID = rowError.getParam("path").getValue();
                    }
                    if (rowError.getParam("attrId") != null && rowError.getParam("attrId").getValue() != null && !"subCardId".equalsIgnoreCase(rowError.getParam("attrId").getValue())) {
                        objectName = rowError.getParam("attrId").getValue();
                    }
                    objectID = String.format("[neID:%d, soltID:%d, portID:%s, pathID:%s]", neID, soltID, portID, pathID);
                    errorTipStr = String.format("obejectID: %s, objectName: %s, errCode: %s ", objectID, objectName, errorCodeStr);
                    e2eLogger.error(errorTipStr);
                }
            }
        } else {
            objectID = String.format("[neID:%d, soltID:%d]", neID, soltID);
            errorTipStr = String.format("obejectID: %s,  errCode: %d ", objectID, errorCode);
            e2eLogger.error(errorTipStr);
        }
    }

    private Set<String> getSupportAtrrs(int neID, int boardType) {
        ArrayList supportAttrList;
        TENE neObj = TENEListMgr.getInstance().getNE(neID);
        int neType = neObj.getNEType();
        String neVersion = neObj.getShowNEVersion();
        HashSet<String> supportAttrs = new HashSet<String>();
        TEGenCfgModel genCfgModel = TEGenCfgDataMgr.getGenCfgMode((int)boardType);
        if (null != genCfgModel && null != (supportAttrList = genCfgModel.getSupportAttrList(neType, neVersion)) && !supportAttrList.isEmpty()) {
            TEGenCfgAttribute genCfgAttribute = null;
            int size = supportAttrList.size();
            for (int i = 0; i < size; ++i) {
                genCfgAttribute = (TEGenCfgAttribute)supportAttrList.get(i);
                supportAttrs.add(genCfgAttribute.getAttrId());
            }
        }
        return supportAttrs;
    }
}

