/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.wdminterface;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEPort;
import com.huawei.nglct.util.cache.TETimeStatMgr;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.errinfo.TEErrInfo;
import com.huawei.nglct.util.string.TEStringUtils;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public final class TEQueryServieType {
    private static final String PATH_ID_ALL = "0";
    private static final int TIME_OUT = 60;

    private TEQueryServieType() {
    }

    public static Hashtable<String, TIntArrayList> queryServiceType(int neId, TIntArrayList slotIdList, TIntObjectHashMap<TEBoard> cacheBoardMap, TIntObjectHashMap<TIntObjectHashMap<TEPort>> cacheSlotPortMap, List<TEErrInfo> errInfoLis) {
        Hashtable<String, TIntArrayList> supportPayloadTye = new Hashtable<String, TIntArrayList>();
        if (null == slotIdList || slotIdList.isEmpty()) {
            return supportPayloadTye;
        }
        int slotID = -1;
        Operation queryPayloadOper = TECreateObjectFactory.getOperation((int)neId, (String)"NSCMD_CFG_GET_SUPPORT_PAYLOADTYPE");
        ArrayList<Operation> payloadOperList = new ArrayList<Operation>();
        int size = slotIdList.size();
        for (int i = 0; i < size; ++i) {
            slotID = slotIdList.get(i);
            payloadOperList.add(TEQueryServieType.getPayloadOper((Operation)queryPayloadOper.clone(), slotID));
        }
        if (null != payloadOperList) {
            Hashtable<String, TIntArrayList> typeTable = TEQueryServieType.querySupPayloadType(payloadOperList, neId, errInfoLis);
            supportPayloadTye.putAll(typeTable);
        }
        return supportPayloadTye;
    }

    private static Operation getPayloadOper(Operation oper, int slotId) {
        oper.getInput().setPartValue("slotid", String.valueOf(slotId));
        oper.getInput().setPartValue("port", PATH_ID_ALL);
        oper.getInput().setPartValue("path", PATH_ID_ALL);
        return oper;
    }

    private static Hashtable<String, TIntArrayList> querySupPayloadType(List<Operation> payloadOperList, int neId, List<TEErrInfo> errInfoList) {
        Hashtable<String, TIntArrayList> supportPayloadTye = new Hashtable<String, TIntArrayList>();
        if (payloadOperList.isEmpty()) {
            TELogFactory.getNormalLogger().error("supportPayloadTye is empty!");
            return supportPayloadTye;
        }
        TETimeStatMgr timer = new TETimeStatMgr(TETimeStatMgr.FLAG_LOG);
        timer.startStat("get 52tom service type. size->" + payloadOperList.size());
        OperationResult result = TEQueryServieType.sendBatCommand(neId, payloadOperList);
        timer.stopStat();
        if (0 != result.retCode) {
            TEErrInfo errInfo = new TEErrInfo();
            errInfo.setObjID(new int[]{neId});
            errInfo.setErrorCode(result.retCode);
            errInfoList.add(errInfo);
            TELogFactory.getNormalLogger().error("Query support payload info fail, the errorCode is" + result.retCode);
            return supportPayloadTye;
        }
        TIntArrayList payloadList = null;
        int errCode = -1;
        TEErrInfo errInfo = null;
        int slotID = -1;
        int shelfID = -1;
        int relativeSlotID = -1;
        int size = payloadOperList.size();
        for (int operIndex = 0; operIndex < size; ++operIndex) {
            Output[] outputArr = payloadOperList.get(operIndex).getOutput();
            for (int i = 0; i < outputArr.length; ++i) {
                Output output = outputArr[i];
                errCode = Integer.parseInt(output.getFault()[0].getCode());
                if (0 != errCode) {
                    if (38662 == errCode) continue;
                    slotID = Integer.parseInt(payloadOperList.get(operIndex).getInput().getPartValue("slotid"));
                    shelfID = TEBoardUtil.getRelativeShelfID((int)slotID);
                    relativeSlotID = TEBoardUtil.bigSlotToSmall((int)slotID);
                    errInfo = new TEErrInfo();
                    errInfo.setObjID(new int[]{neId, shelfID, relativeSlotID});
                    errInfo.setErrorCode(errCode);
                    errInfoList.add(errInfo);
                    continue;
                }
                if (!TEStringUtils.isNumber((String)output.getPartValue("slotid")) || !TEStringUtils.isNumber((String)output.getPartValue("port")) || !TEStringUtils.isNumber((String)output.getPartValue("path"))) continue;
                slotID = Integer.parseInt(output.getPartValue("slotid"));
                int port = Integer.parseInt(output.getPartValue("port"));
                int path = Integer.parseInt(output.getPartValue("path"));
                int payloadNum = Integer.parseInt(output.getPartValue("payloadcount"));
                String payloadStr = output.getPartValue("payloadStr");
                payloadList = new TIntArrayList();
                if (payloadNum > 0) {
                    payloadList.add(0);
                }
                if (null != payloadStr) {
                    int num = payloadStr.length() / 4;
                    String str = null;
                    for (int j = 0; j < num; ++j) {
                        str = payloadStr.substring(j * 4, (j + 1) * 4);
                        int payloadType = Integer.parseInt(str, 16);
                        payloadList.add(payloadType);
                    }
                }
                String key = "" + neId + "-" + slotID + "-" + port + "-" + path;
                supportPayloadTye.put(key, payloadList);
            }
        }
        return supportPayloadTye;
    }

    private static OperationResult sendBatCommand(int neID, List<Operation> allOperList) {
        OperationResult result = null;
        ArrayList<Operation> operList = null;
        int m = 10;
        int n = allOperList.size();
        for (int i = 0; i < n; i += m) {
            operList = new ArrayList<Operation>();
            if (i + m > n) {
                operList.addAll(allOperList.subList(i, n));
            } else {
                operList.addAll(allOperList.subList(i, i + m));
            }
            result = TENECommMgr.getInstance().sendCommand(neID, operList, 20);
            if (0 != result.retCode) break;
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                TELogFactory.getNormalLogger().error("TEGenCfgQueryBean thread sleep error! ", (Throwable)e);
            }
        }
        return result;
    }
}

