/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.wdminterface;

import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.util.string.TEStringUtils;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class TEBD05WDMInfUtil {
    private static final String OPERATION_PARAM_PATH = "path";
    private static final String OPERATION_PARAM_PORT = "port";
    private static final String URL_PARAM_PATHID = "pathid";
    private static final String URL_PARAM_PORTID = "portid";
    public static final int IS_FROM_BD05 = 1;
    public static final int INVALID_PORT_ID = 0;
    public static final int INVALID_PATH_ID = 0;
    public static final int NULL_PARAM_FLAG = -255;

    private TEBD05WDMInfUtil() {
    }

    public static int getIntParam(RowParams rowparams, String paramName, int invalidValue) {
        int value = invalidValue;
        Param param = rowparams.getParam(paramName);
        if (null == param) {
            return -255;
        }
        String obj = param.getValue();
        if (null == obj || obj.isEmpty()) {
            return value;
        }
        if (TEStringUtils.isNumber((String)obj)) {
            value = Integer.parseInt(obj);
        }
        return value;
    }

    public static int getInputPartValue(Operation oper, String partName, int invalidValue) {
        if (null == oper.getInput()) {
            return invalidValue;
        }
        Part part = oper.getInput().getPart(partName);
        if (null == part) {
            return -255;
        }
        String obj = part.getValue();
        if (TEStringUtils.isNumber((String)obj)) {
            return Integer.parseInt(obj);
        }
        return invalidValue;
    }

    public static void filterOperationBeforeSend(Datainterface inputData, List<Operation> operationList) {
        RowParams rowparams = inputData.getBussinessParams().getRowParams(0);
        int portid = TEBD05WDMInfUtil.getIntParam(rowparams, URL_PARAM_PORTID, 0);
        int pathid = TEBD05WDMInfUtil.getIntParam(rowparams, URL_PARAM_PATHID, 0);
        if (0 == portid && 0 == pathid) {
            TEBD05WDMInfUtil.filterNullOperation(operationList);
        } else if (0 != portid && 0 == pathid) {
            TEBD05WDMInfUtil.filterPortOperation(portid, operationList);
        } else if (0 != portid && 0 != pathid) {
            TEBD05WDMInfUtil.filterPortOperation(portid, operationList);
        }
    }

    private static void filterNullOperation(List<Operation> operationList) {
    }

    private static void filterPortOperation(int portid, List<Operation> operationList) {
        if (null == operationList || operationList.isEmpty()) {
            return;
        }
        int operPort = 0;
        Operation oper = null;
        Iterator<Operation> iter = operationList.iterator();
        while (iter.hasNext()) {
            oper = iter.next();
            operPort = TEBD05WDMInfUtil.getInputPartValue(oper, OPERATION_PARAM_PORT, 0);
            if (-255 == operPort || operPort == 0 || portid == operPort) continue;
            iter.remove();
        }
    }

    public static void filterOperationAfterSend(Datainterface intputData, Datainterface outputData) {
        RowParams rowparams = intputData.getBussinessParams().getRowParams(0);
        int portid = TEBD05WDMInfUtil.getIntParam(rowparams, URL_PARAM_PORTID, 0);
        int pathid = TEBD05WDMInfUtil.getIntParam(rowparams, URL_PARAM_PATHID, 0);
        if (0 == portid && 0 == pathid) {
            TEBD05WDMInfUtil.filterNullOutputData(outputData);
        } else if (0 != portid && 0 == pathid) {
            TEBD05WDMInfUtil.filterPortOutputData(portid, outputData);
        } else if (0 != portid && 0 != pathid) {
            TEBD05WDMInfUtil.filterPortOutputData(portid, outputData);
        }
    }

    private static void filterNullOutputData(Datainterface outputData) {
    }

    private static void filterPortOutputData(int portid, Datainterface outputData) {
        if (null == outputData || null == outputData.getBussinessParams() || 0 == outputData.getBussinessParams().getRowParamsCount()) {
            return;
        }
        int rowPort = 0;
        RowParams rowParams = null;
        ArrayList rowparamsList = outputData.getBussinessParams().getRowParamList();
        Iterator rowIter = rowparamsList.iterator();
        while (rowIter.hasNext()) {
            rowParams = (RowParams)rowIter.next();
            rowPort = TEBD05WDMInfUtil.getIntParam(rowParams, OPERATION_PARAM_PORT, 0);
            if (-255 == rowPort || portid == rowPort) continue;
            rowIter.remove();
        }
    }

    private static void filterPortPathOperation(int portid, int pathid, Datainterface outputData) {
        if (null == outputData || null == outputData.getBussinessParams() || 0 == outputData.getBussinessParams().getRowParamsCount()) {
            return;
        }
        int rowPort = 0;
        int rowPath = 0;
        RowParams rowParams = null;
        ArrayList rowparamsList = outputData.getBussinessParams().getRowParamList();
        Iterator rowIter = rowparamsList.iterator();
        while (rowIter.hasNext()) {
            rowParams = (RowParams)rowIter.next();
            rowPort = TEBD05WDMInfUtil.getIntParam(rowParams, OPERATION_PARAM_PORT, 0);
            rowPath = TEBD05WDMInfUtil.getIntParam(rowParams, OPERATION_PARAM_PATH, 0);
            if (-255 == rowPort && -255 == rowPath || portid == rowPort && -255 == rowPath || portid == rowPort && pathid == rowPath) continue;
            rowIter.remove();
        }
    }
}

