/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.vportmapping;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.ngwdm_pub.TEOTNModelShowPathMgr;
import com.huawei.nglct.util.device.port.TEVirtualPortUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.List;

public class TEQueryVPortMappingMsg
extends TECommonWriteLogBean {
    private static final String ETHVALUE = "3";

    public int getTimeOut() {
        return 60;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.refreshDynPortCache(operationList);
        super.handleMessage(neid, operationList, subfunc);
        this.refactorDataInterface();
    }

    private void refactorDataInterface() {
        BussinessParams bus = this.outputData.getBussinessParams();
        TEConfigurationDataMgr cfgMgr = TEConfigurationDataMgr.getInstance();
        int len = bus.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            String portValue;
            Param param;
            RowParams row = bus.getRowParams(i);
            Param tempParam = row.getParam("vPortType");
            if (tempParam != null) {
                param = new Param();
                param.setName("portType");
                param.setValue(TEVirtualPortUtil.getPortType((int)Integer.valueOf(tempParam.getValue())));
                row.addParam(param);
            }
            if ((tempParam = row.getParam("vPort")) != null) {
                param = new Param();
                param.setName("vPortName");
                param.setValue(cfgMgr.getPortName(this.neid, Integer.valueOf(row.getParam("slotid").getValue()).intValue(), Integer.valueOf(tempParam.getValue()).intValue()));
                row.addParam(param);
            }
            if ((tempParam = row.getParam("phyPort")) != null) {
                param = new Param();
                param.setName("phyPortName");
                param.setValue(cfgMgr.getPortName(this.neid, Integer.valueOf(row.getParam("slotid").getValue()).intValue(), Integer.valueOf(tempParam.getValue()).intValue()));
                row.addParam(param);
            }
            if ((tempParam = row.getParam("path")) == null) continue;
            int timeSlots = Integer.valueOf(row.getParam("timeSlots").getValue());
            if (timeSlots == 0) {
                row.getParam("timeSlots").setValue("-");
            }
            if (ETHVALUE.equals(portValue = row.getParam("vPortType").getValue())) {
                param = new Param();
                param.setName("level");
                param.setValue("-");
                row.addParam(param);
                param = new Param();
                param.setName("bandWidth");
                param.setValue(TEVirtualPortUtil.getCapacity((int)Integer.valueOf(row.getParam("vPortType").getValue()), (int)Integer.valueOf(tempParam.getValue()), (int)timeSlots));
                row.addParam(param);
            } else {
                param = new Param();
                param.setName("level");
                param.setValue(TEVirtualPortUtil.getCapacity((int)Integer.valueOf(row.getParam("vPortType").getValue()), (int)Integer.valueOf(tempParam.getValue()), (int)timeSlots));
                row.addParam(param);
                param = new Param();
                param.setName("bandWidth");
                param.setValue("-");
                row.addParam(param);
            }
            int path = Integer.parseInt(row.getParam("path").getValue());
            int phyPort = Integer.parseInt(row.getParam("phyPort").getValue());
            String phyPortName = cfgMgr.getPortName(this.neid, Integer.valueOf(row.getParam("slotid").getValue()).intValue(), phyPort);
            param = new Param();
            param.setName("mappingPath");
            param.setValue(this.getMapPathValue(phyPortName, path));
            row.addParam(param);
            param = new Param();
            param.setName("isAddFlag");
            param.setValue("0");
            row.addParam(param);
        }
    }

    private String getMapPathValue(String portName, int path) {
        String showPath = TEOTNModelShowPathMgr.getInstance().getOTNModelShowPath(path);
        return portName + ":" + showPath;
    }

    private void refreshDynPortCache(List<Operation> opers) {
        for (Operation oper : opers) {
            if (!"NSCMD_CFG_GET_PORT_SERVICEMAP".equals(oper.getName())) continue;
            int bdType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, Integer.valueOf(oper.getInput().getPartValue("slotid")).intValue());
            int len = oper.getOutputCount();
            for (int i = 0; i < len; ++i) {
                Output output = oper.getOutput(i);
                if (!String.valueOf(0).equals(output.getFault(0).getCode())) continue;
                Part pathPart = output.getPart("path");
                pathPart.setValue(String.valueOf(TEVirtualPortUtil.convertNEPathToNMPath((int)bdType, (int)Integer.valueOf(pathPart.getValue()))));
                int slotID = Integer.valueOf(output.getPartValue("slotid"));
                int port = Integer.valueOf(output.getPartValue("vPort"));
                int portLevel = TEVirtualPortUtil.getPortSpeedLevelByVPortType((int)Integer.valueOf(output.getPartValue("vPortType")));
                int portType = "SDH".equals(TEVirtualPortUtil.getPortType((int)Integer.valueOf(output.getPartValue("vPortType")))) ? 1 : 255;
                TEConfigurationDataMgr.getInstance().addLogicPort(this.neid, slotID, port, portType, portLevel);
            }
        }
    }
}

