/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.vportmapping;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.device.port.TEVirtualPortUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TEGetValidODUkResource
extends TECommonWriteLogBean {
    private static final String PORTTYPE_SDH = "SDH";
    private static final String PORTTYPE_ETH = "ETH";
    private static final int VPORTFLAG = 1;
    private static final int PATHFLAG = 2;
    private int slotID;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.slotID = Integer.valueOf(inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
        int queryflag = Integer.valueOf(inputData.getBussinessParams().getRowParams(0).getParam("queryFlag").getValue());
        Datainterface dataInterface = new Datainterface();
        BussinessParams bus = new BussinessParams();
        dataInterface.setBussinessParams(bus);
        this.constructData(bus, 1, queryflag);
        this.constructData(bus, 4, queryflag);
        return dataInterface;
    }

    private void constructData(BussinessParams bus, int domain, int queryFlag) {
        block8: {
            Map pathsMap;
            TEConfigurationDataMgr cfMgr;
            block7: {
                cfMgr = TEConfigurationDataMgr.getInstance();
                List vPortList = TEVirtualPortUtil.getVPortsByDomain((int)cfMgr.getBoardType(this.neid, this.slotID), (int)domain);
                pathsMap = TEVirtualPortUtil.getMappingPortsAndNMPathsByDoamin((int)cfMgr.getBoardType(this.neid, this.slotID), (int)domain);
                if (queryFlag != 1) break block7;
                for (Integer vport : vPortList) {
                    RowParams rowParams = new RowParams();
                    Param param = new Param();
                    param.setName("portType");
                    if (domain == 4) {
                        param.setValue(PORTTYPE_ETH);
                    } else {
                        param.setValue(PORTTYPE_SDH);
                    }
                    rowParams.addParam(param);
                    param = new Param();
                    param.setName("vPort");
                    param.setValue(String.valueOf(vport));
                    rowParams.addParam(param);
                    param = new Param();
                    param.setName("vPortName");
                    param.setValue(cfMgr.getPortName(this.neid, this.slotID, vport.intValue()));
                    rowParams.addParam(param);
                    bus.addRowParams(rowParams);
                }
                break block8;
            }
            if (queryFlag != 2) break block8;
            Iterator phyPorts = pathsMap.keySet().iterator();
            while (phyPorts.hasNext()) {
                int phyPort = (Integer)phyPorts.next();
                List phyPaths = (List)pathsMap.get(phyPort);
                int len = phyPaths.size();
                for (int i = 0; i < len; ++i) {
                    RowParams rowParams = new RowParams();
                    Param param = new Param();
                    param.setName("portType");
                    if (domain == 4) {
                        param.setValue(PORTTYPE_ETH);
                    } else {
                        param.setValue(PORTTYPE_SDH);
                    }
                    rowParams.addParam(param);
                    param = new Param();
                    param.setName("phyPort");
                    param.setValue(String.valueOf(phyPort));
                    rowParams.addParam(param);
                    param = new Param();
                    param.setName("phyPortName");
                    param.setValue(cfMgr.getPortName(this.neid, this.slotID, phyPort));
                    rowParams.addParam(param);
                    param = new Param();
                    param.setName("pathValue");
                    param.setValue(String.valueOf(phyPaths.get(i)));
                    rowParams.addParam(param);
                    bus.addRowParams(rowParams);
                }
            }
        }
    }
}

