/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.tdc.db;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.explorer.beanplugin.TEBeanPluginLog;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.po.embeddednemgrmo.otn.TETDCMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfo;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class TETDCDbMgr {
    public static final String UNKNOWN = "UNKNOWN";
    private static final Logger logger = TELogFactory.getNormalLogger();
    public static final String DB_COL_SLOT = "SlotID";
    public static final String DB_COL_PORT = "PortID";
    public static final String DB_COL_PATH = "PathID";

    private TETDCDbMgr() {
    }

    public static List<TETDCMOPO> getTDCMOFromDB(int neID, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TETDCDbMgr.getTPIDMOFromDB";
        TEBeanPluginLog.logFuncBegin((String)"TETDCDbMgr.getTPIDMOFromDB");
        if (null == errRet) {
            errRet = new TEErrInfoReturn();
        }
        ArrayList<TETDCMOPO> moList = new ArrayList<TETDCMOPO>();
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            if (null == ne) {
                TETDCDbMgr.logNullNEError(neID);
                TETDCDbMgr.setOperFail(neID, errRet, 1090596385);
                TEBeanPluginLog.logFuncEnd((String)"TETDCDbMgr.getTPIDMOFromDB");
                return moList;
            }
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findAll((int[])new int[]{neID}, TETDCMOPO.class) : TECommonDaoService.findAll_NonLock((int[])new int[]{neID}, TETDCMOPO.class);
        }
        catch (Exception e) {
            TETDCDbMgr.logExceptionOnGet(neID, e);
            TETDCDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TETDCDbMgr.getTPIDMOFromDB");
            return moList;
        }
        if (null == dbResult) {
            TETDCDbMgr.logNullErrorOnGet(neID);
            TETDCDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TETDCDbMgr.getTPIDMOFromDB");
            return moList;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            List data = dbResult.getData();
            if (null != data && !data.isEmpty()) {
                for (Object obj : data) {
                    moList.add((TETDCMOPO)obj);
                }
            }
        } else {
            TETDCDbMgr.logRetCodeErrorOnGet(neID, retCode);
            TETDCDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TETDCDbMgr.getTPIDMOFromDB");
        return moList;
    }

    public static TETDCMOPO getTDCFromDB(int neID, int slotid, int port, int pathid) {
        ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
        TEDaoNameValuePair aPair = new TEDaoNameValuePair(DB_COL_SLOT, String.valueOf(slotid));
        criteria.add(aPair);
        aPair = new TEDaoNameValuePair(DB_COL_PORT, String.valueOf(port));
        criteria.add(aPair);
        aPair = new TEDaoNameValuePair(DB_COL_PATH, String.valueOf(pathid));
        criteria.add(aPair);
        TETDCMOPO mopo = null;
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findByID((int[])new int[]{neID}, TETDCMOPO.class, criteria) : TECommonDaoService.findByID_NonLock((int[])new int[]{neID}, TETDCMOPO.class, criteria);
            if (null == dbResult) {
                String tipStr = "Get TETDCMOPO fail! The dbResult is null!! ";
                tipStr = tipStr + String.format("[neID:%d]", neID);
                logger.error(tipStr);
                return mopo;
            }
        }
        catch (Exception e) {
            String tipStr = "Get TETDCMOPO fail! DB oper error! ";
            tipStr = tipStr + String.format("[neID:%d]", neID);
            logger.error(tipStr, (Throwable)e);
            return mopo;
        }
        if (0 == dbResult.getResult() && dbResult.getData().size() > 0) {
            mopo = (TETDCMOPO)dbResult.getData().get(0);
        }
        return mopo;
    }

    public static void updateTDCMOToDB(int neID, TETDCMOPO tdcMO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TETPIDDbMgr.updateTPIDMOToDB";
        TEBeanPluginLog.logFuncBegin((String)"TETPIDDbMgr.updateTPIDMOToDB");
        if (null == tdcMO) {
            return;
        }
        if (null == errRet) {
            errRet = new TEErrInfoReturn();
        }
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.update((int[])new int[]{neID}, (Object)tdcMO) : TECommonDaoService.update_NonLock((int[])new int[]{neID}, (Object)tdcMO);
        }
        catch (Exception e) {
            TETDCDbMgr.logExceptionErrorOnUpdate(neID, e);
            TETDCDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TETPIDDbMgr.updateTPIDMOToDB");
            return;
        }
        if (null == dbResult) {
            TETDCDbMgr.logNullErrorOnUpdate(neID);
            TETDCDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TETPIDDbMgr.updateTPIDMOToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TETDCDbMgr.logRetCodeErrorOnUpdate(neID, retCode);
            TETDCDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TETPIDDbMgr.updateTPIDMOToDB");
    }

    public static void delAllTDCFromDB(int neID, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TETPIDDbMgr.delAllTDCFromDB";
        TEBeanPluginLog.logFuncBegin((String)"TETPIDDbMgr.delAllTDCFromDB");
        List<TETDCMOPO> tdcList = TETDCDbMgr.getTDCMOFromDB(neID, errRet);
        int retCode = errRet.getResult();
        if (0 != retCode) {
            TETDCDbMgr.logRetCodeErrorOnUpdate(neID, retCode);
            errRet.setResult(retCode);
        }
        for (TETDCMOPO tdc : tdcList) {
            TETDCDbMgr.delTDCMOToDB(neID, tdc, errRet);
        }
        TEBeanPluginLog.logFuncBegin((String)"TETPIDDbMgr.delAllTDCFromDB");
    }

    public static void delTDCMOToDB(int neID, TETDCMOPO tdcMO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TETPIDDbMgr.delTDCMOToDB";
        TEBeanPluginLog.logFuncBegin((String)"TETPIDDbMgr.delTDCMOToDB");
        if (null == tdcMO) {
            return;
        }
        if (null == errRet) {
            errRet = new TEErrInfoReturn();
        }
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.delete((int[])new int[]{neID}, (Object)tdcMO) : TECommonDaoService.delete_NonLock((int[])new int[]{neID}, (Object)tdcMO);
        }
        catch (Exception e) {
            TETDCDbMgr.logExceptionErrorOnDel(neID, e);
            TETDCDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TETPIDDbMgr.delTDCMOToDB");
            return;
        }
        if (null == dbResult) {
            TETDCDbMgr.logNullErrorOnDel(neID);
            TETDCDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TETPIDDbMgr.delTDCMOToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TETDCDbMgr.logRetCodeErrorOnDel(neID, retCode);
            TETDCDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TETPIDDbMgr.delTDCMOToDB");
    }

    public static void createTDCMOToDB(int neID, TETDCMOPO tpidMO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TETPIDDbMgr.createTPIDMOToDB";
        TEBeanPluginLog.logFuncBegin((String)"TETPIDDbMgr.createTPIDMOToDB");
        if (null == tpidMO) {
            return;
        }
        if (null == errRet) {
            errRet = new TEErrInfoReturn();
        }
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.create((int[])new int[]{neID}, (Object)tpidMO) : TECommonDaoService.create_NonLock((int[])new int[]{neID}, (Object)tpidMO);
        }
        catch (Exception e) {
            TETDCDbMgr.logExceptionErrorOnCreate(neID, e);
            TETDCDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TETPIDDbMgr.createTPIDMOToDB");
            return;
        }
        if (null == dbResult) {
            TETDCDbMgr.logNullErrorOnCreate(neID);
            TETDCDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TETPIDDbMgr.createTPIDMOToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TETDCDbMgr.logRetCodeErrorOnCreate(neID, retCode);
            TETDCDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TETPIDDbMgr.createTPIDMOToDB");
    }

    private static void setOperFail(int neID, TEErrInfoReturn rspErrRet, int retCode) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String neName = ne.getNEName();
        rspErrRet.setResult(1090605056);
        rspErrRet.addErrInfo(TETDCDbMgr.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, retCode).getErrList());
    }

    public static TEErrInfoReturn constructErrInfoReturn(int neID, int errorCode) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String neName = UNKNOWN;
        if (null != ne) {
            neName = ne.getNEName();
        }
        return TETDCDbMgr.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, errorCode);
    }

    public static TEErrInfoReturn constructErrInfoReturn(int[] objID, String[] objName, int retCode) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        errRet.setResult(2);
        TEErrInfo errInfo = new TEErrInfo();
        errInfo.setObjID(objID);
        errInfo.setObjName(TETDCDbMgr.getObjName(objName));
        errInfo.setErrorCode(retCode);
        errRet.addErrInfo(errInfo);
        return errRet;
    }

    public static String getObjName(String[] objName) {
        StringBuffer objNameBuffer = new StringBuffer();
        int len = objName.length;
        for (int i = 0; i < len; ++i) {
            if (0 != i) {
                objNameBuffer.append('-');
            }
            objNameBuffer.append(objName[i]);
        }
        return objNameBuffer.toString();
    }

    private static void logNullNEError(int neID) {
        logger.error("ne is null! neID->" + neID);
    }

    private static void logRetCodeErrorOnGet(int neID, int retCode) {
        String tipStr = String.format("get mo from db device fail! neID:%d, retCode:%d", neID, retCode);
        logger.error(tipStr);
    }

    private static void logNullErrorOnGet(int neID) {
        logger.error("get mo from db fail! dbResult is null! neID->" + neID);
    }

    private static void logExceptionOnGet(int neID, Exception e) {
        logger.error("get mo from db fail! neID->" + neID, (Throwable)e);
    }

    private static void logRetCodeErrorOnUpdate(int neID, int retCode) {
        String tipStr = String.format("update mo to db device fail! neID:%d, retCode:%d", neID, retCode);
        logger.error(tipStr);
    }

    private static void logNullErrorOnUpdate(int neID) {
        logger.error("update mo to db device fail! dbResult is null! neID->" + neID);
    }

    private static void logExceptionErrorOnUpdate(int neID, Exception e) {
        logger.error("update mo to db device fail! neID->" + neID, (Throwable)e);
    }

    private static void logNullErrorOnCreate(int neID) {
        logger.error("create mo to db device fail! neID->" + neID);
    }

    private static void logExceptionErrorOnCreate(int neID, Exception e) {
        logger.error("create mo to db device fail! neID->" + neID, (Throwable)e);
    }

    private static void logRetCodeErrorOnCreate(int neID, int retCode) {
        String tipStr = String.format("create mo to db device fail! neID:%d, retCode:%d", neID, retCode);
        logger.error(tipStr);
    }

    private static void logNullErrorOnDel(int neID) {
        logger.error("delete mo to db device fail! neID->" + neID);
    }

    private static void logExceptionErrorOnDel(int neID, Exception e) {
        logger.error("delete mo to db device fail! neID->" + neID, (Throwable)e);
    }

    private static void logRetCodeErrorOnDel(int neID, int retCode) {
        String tipStr = String.format("delete mo to db device fail! neID:%d, retCode:%d", neID, retCode);
        logger.error(tipStr);
    }
}

