/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.tdc;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nemgr.ngwdm.tdc.TEScanStateData;
import com.huawei.nglct.nemgr.ngwdm.tdc.TEStateReportHandler;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TEScanStateEventMgr {
    private TEStateReportHandler handlereventrespond = null;
    private Operation oper = null;
    private static Map<Integer, Boolean> registerMap = new HashMap<Integer, Boolean>();
    private static Map<String, List<TEScanStateData>> scanStateCahceMap = new HashMap<String, List<TEScanStateData>>();
    private static TEScanStateEventMgr instance = null;

    public static synchronized TEScanStateEventMgr getInstance() {
        if (instance == null) {
            instance = new TEScanStateEventMgr();
        }
        return instance;
    }

    void register(int neID) {
        if (registerMap.get(neID) == null) {
            this.handlereventrespond = new TEStateReportHandler();
            this.oper = TECreateObjectFactory.getOperation((int)neID, (String)"NSEVT_CFG_TDCMODE_STATE");
            TENECommMgr.getInstance().registerListener(this.oper, (NoticeHandler)this.handlereventrespond);
            registerMap.put(neID, true);
        }
    }

    public void unregister(int neID) {
        this.oper = TECreateObjectFactory.getOperation((int)neID, (String)"NSEVT_CFG_TDCMODE_STATE");
        TENECommMgr.getInstance().unregisterListener(this.oper, (NoticeHandler)this.handlereventrespond);
    }

    public String getScanStatekey(int neID, int slotid) {
        return neID + ":" + slotid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addScanStateElemet(TEScanStateData scanStateData) {
        if (scanStateData == null) {
            return;
        }
        String key = this.getScanStatekey(scanStateData.getNeid(), scanStateData.getSlotid());
        Map<String, List<TEScanStateData>> map = scanStateCahceMap;
        synchronized (map) {
            if (scanStateCahceMap.get(key) == null) {
                ArrayList<TEScanStateData> list = new ArrayList<TEScanStateData>();
                list.add(scanStateData);
                scanStateCahceMap.put(key, list);
            } else {
                List<TEScanStateData> value = scanStateCahceMap.get(key);
                boolean isExist = false;
                int len = value.size();
                for (int i = 0; i < len; ++i) {
                    TEScanStateData elemt = value.get(i);
                    if (elemt == null || !elemt.isKeyEqual(scanStateData)) continue;
                    elemt.setState(scanStateData.getState());
                    isExist = true;
                    break;
                }
                if (!isExist) {
                    value.add(scanStateData);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TEScanStateData> getScanStateData(int neID, int slotid) {
        String key = this.getScanStatekey(neID, slotid);
        Map<String, List<TEScanStateData>> map = scanStateCahceMap;
        synchronized (map) {
            return scanStateCahceMap.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearScanStateCache(int neID, int slotid) {
        String key = this.getScanStatekey(neID, slotid);
        Map<String, List<TEScanStateData>> map = scanStateCahceMap;
        synchronized (map) {
            scanStateCahceMap.remove(key);
        }
    }
}

