/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.spectrum;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.ngwdm.spectrum.TESpectrumBean;
import com.huawei.nglct.util.buffer.TETimeBuffer;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;

public class TESpectrumServlet
extends HttpServlet {
    private static final long serialVersionUID = -2178206740247515719L;
    private static final String SFID_PARAM = "sfid";
    private static final String INPUTDATA_PARAM = "inputdata";
    private static final String NEID_PARAM = "neid";
    private static final String SESSION_SPEC = "spectrum";
    private Datainterface outputData = null;
    private static Logger log = TELogFactory.getNormalLogger();
    private static final int SPEWAVEPIC = 2;
    private static final int SPESkELETONPIC = 3;

    public void emitJPEG(HttpServletRequest request, HttpServletResponse response, BufferedImage image) {
        response.setContentType("image/jpeg");
        try {
            ServletOutputStream out = response.getOutputStream();
            ImageIO.write((RenderedImage)image, "jpg", (OutputStream)out);
        }
        catch (IOException e) {
            TELogFactory.getNormalLogger().error("TESpectrumServlet.emitJPEG() fail!", (Throwable)e);
        }
    }

    public void emitSVG(HttpServletRequest request, HttpServletResponse response, String svgString) {
        response.setContentType("image/svg+xml");
        try {
            BufferedReader in = new BufferedReader(new StringReader(svgString));
            PrintWriter out = response.getWriter();
            String s = in.readLine();
            int i = 0;
            while (s != null) {
                out.println(s);
                if (++i != 5) continue;
                out.println("<script type=\"text/javascript\"><![CDATA[");
                out.println("svgDocument.rootElement.setAttribute('zoomAndPan','disable')");
                out.println("contextMenu.removeChild(contextMenu.firstChild)");
                out.println("]]>");
                out.println("</script>");
            }
            if (out != null) {
                out.close();
            }
            if (in != null) {
                in.close();
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TESpectrumServlet.emitSVG() fail!", (Throwable)e);
        }
    }

    private String getOperObject(HttpServletRequest request) {
        String neid = request.getParameter(NEID_PARAM);
        return neid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        TESpectrumBean spectrumbean = null;
        String operObject = this.getOperObject(request);
        HttpSession session = request.getSession(true);
        TETimeBuffer spectrumBuffer = (TETimeBuffer)session.getAttribute(SESSION_SPEC);
        if (spectrumBuffer == null) {
            spectrumBuffer = new TETimeBuffer();
            spectrumBuffer.setBufferLimit(2);
            spectrumbean = new TESpectrumBean();
            spectrumBuffer.put((Object)operObject, (Object)spectrumbean);
            session.setAttribute(SESSION_SPEC, (Object)spectrumBuffer);
        } else {
            log.info("the spectrum buffer size : " + spectrumBuffer.size());
            spectrumbean = (TESpectrumBean)spectrumBuffer.getDataNotRefresh((Object)operObject);
            if (spectrumbean == null) {
                spectrumbean = new TESpectrumBean();
                spectrumBuffer.put((Object)operObject, (Object)spectrumbean);
            }
        }
        int funid = Integer.parseInt(request.getParameter("funid"));
        if (funid == 2) {
            BufferedImage image = spectrumbean.getWaveImage();
            this.emitJPEG(request, response, image);
            return;
        }
        if (funid == 3) {
            BufferedImage image = spectrumbean.getSkeletonImage();
            this.emitJPEG(request, response, image);
            return;
        }
        int neid = -1;
        int sfid = -1;
        sfid = Integer.parseInt(request.getParameter(SFID_PARAM));
        response.setContentType("text/xml;charset=UTF-8");
        response.setHeader("Cache-Control", "no-cache");
        response.setHeader("Pragma", "no-cache");
        PrintWriter print = response.getWriter();
        Writer out = null;
        String inputDataStr = request.getParameter(INPUTDATA_PARAM);
        Datainterface inputData = null;
        Datainterface allData = null;
        SubFunc subFunc = null;
        try {
            TELogFactory.getInterfaceLogger().info("The sfid is \u00a3\u00ba" + sfid + "\nThe Page request XML is :\n" + inputDataStr);
            inputData = TECreateObjectFactory.parseInputData((String)inputDataStr);
            neid = this.getNEID(inputData);
            if (neid == -1) {
                throw new Exception("Don't write neid!!");
            }
            subFunc = TECreateObjectFactory.getSubFunc((int)neid, (int)sfid);
            spectrumbean.init();
            String ipAddress = request.getRemoteAddr();
            String nmUser = request.getParameter("nmUser");
            this.outputData = allData = spectrumbean.performBussinessProcess(neid, subFunc, inputData, null, nmUser, ipAddress);
            out = new StringWriter();
            this.outputData.marshal(out);
            print.println(out.toString());
            TELogFactory.getInterfaceLogger().info("The sfid is " + sfid + "\nReturn page's XML Data\u00a3\u00ba" + out.toString());
            out.close();
        }
        catch (Exception e) {
            log.error("program inner error\u00a3\u00ba\n", (Throwable)e);
            this.outputData = new Datainterface();
            out = new StringWriter();
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
            try {
                this.outputData.marshal(out);
                print.println(out.toString());
                TELogFactory.getInterfaceLogger().info("The sfid is :" + sfid + "\nReturn page's XML Data is \u00a3\u00ba" + out.toString());
            }
            catch (Exception ex) {
                log.error("Parse fail\u00a3\u00ba", (Throwable)ex);
                return;
            }
        }
        finally {
            if (null != out) {
                out.close();
            }
            if (null != print) {
                print.close();
            }
        }
    }

    private int getNEID(Datainterface inputData) {
        Param[] paramArr = inputData.getBussinessParams().getRowParams(0).getParam();
        int neid = -1;
        int size = paramArr.length;
        for (int i = 0; i < size; ++i) {
            if (!paramArr[i].getName().equalsIgnoreCase(NEID_PARAM)) continue;
            try {
                neid = Integer.parseInt(paramArr[i].getValue());
            }
            catch (NumberFormatException e) {
                log.error("Get neid fail:\n", (Throwable)e);
                return -1;
            }
            return neid;
        }
        return -1;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }
}

