/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.spectrum;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEWaveLengthInfoStaticData;
import com.huawei.nglct.nemgr.ngwdm.spectrum.SpectData;
import com.huawei.nglct.nemgr.ngwdm.spectrum.TENESpectrumRsp;
import com.huawei.nglct.nemgr.ngwdm.spectrum.TEOPTWaveInfo;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;

public class TESpectrumBean
extends TENEExplorerBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String filename = "stringresource_" + TESysManagerBean.getInstance().getlanguage() + ".ini";
    private static String PAKAGE_PATH = "res" + File.separator + filename;
    DecimalFormat formatnum = new DecimalFormat(".000");
    public static final int CBAND_TYPE = 1;
    public static final int LBAND_TYPE = 2;
    public static final int CBAND_320G_TYPE = 3;
    public static final int INVALID_POWER = -600;
    public static final int X_COORDINADE = 32;
    public static final int Y_COORDINADE = 90;
    public static final float OMEGA = 0.12f;
    private static final double C_LIGHT_SPEED = 299792.458;
    private TENESpectrumRsp secturmrsp = null;
    public float power_compensation_value = 0.0f;
    public int slotid;
    public ArrayList al = new ArrayList();
    public SpectData[] m_Data = new SpectData[0];
    public int SPECT_TABLEROW_LENGHT = 6;
    public float max_power;
    public float min_power;
    float fMinWaveLength;
    private int WAVEPIC_HEIGHT = 115;
    private int WAVEPIC_WIDTH = 800;
    private int SKELETONPIC_HEIGHT = 180;
    private int SKELETONPIC_WIDTH = 800;
    private BufferedImage spectWaveimage = new BufferedImage(this.WAVEPIC_WIDTH, this.WAVEPIC_HEIGHT, 1);
    private BufferedImage spectSkeletonimage = new BufferedImage(this.SKELETONPIC_WIDTH, this.SKELETONPIC_HEIGHT, 1);

    public BufferedImage getWaveImage() {
        return this.spectWaveimage;
    }

    public BufferedImage getSkeletonImage() {
        return this.spectSkeletonimage;
    }

    public String getWavePic() {
        return null;
    }

    public String getSkeletonPic() {
        return null;
    }

    public void init() {
        this.al.clear();
        for (int i = 0; i < this.m_Data.length; ++i) {
            this.m_Data[i] = null;
        }
        this.m_Data = new SpectData[0];
    }

    public Datainterface performBussinessProcess(int neID, SubFunc subFuc, Datainterface inputData, Datainterface MemoryData, String user, String ipAddress) {
        this.neid = neID;
        this.subfunc = subFuc;
        RowParams[] rParams = inputData.getBussinessParams().getRowParams();
        int slotid = 0;
        int portid = 0;
        int size = rParams.length;
        for (int i = 0; i < size; ++i) {
            int len = rParams[i].getParam().length;
            for (int j = 0; j < len; ++j) {
                Param[] params = rParams[i].getParam();
                Param param = params[j];
                String name = param.getName();
                String value = param.getValue();
                if (value == null || value.equals("")) continue;
                if ("slotid".equalsIgnoreCase(name)) {
                    slotid = Integer.parseInt(value);
                    continue;
                }
                if ("portid".equalsIgnoreCase(name)) {
                    portid = Integer.parseInt(value);
                    continue;
                }
                if (!"addpower".equalsIgnoreCase(name)) continue;
                this.power_compensation_value = Float.parseFloat(value);
            }
        }
        this.neid = neID;
        this.slotid = slotid;
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotid);
        this.secturmrsp = new TENESpectrumRsp();
        ArrayList nesecList = this.secturmrsp.queryWaveInfo(neID, slotid, portid);
        this.m_Data = new SpectData[nesecList.size()];
        ArrayList tablelist = this.getTableData();
        Datainterface speDataInterface = new Datainterface();
        BussinessParams bParam = new BussinessParams();
        Param tempParam = null;
        int size2 = tablelist.size();
        for (int i = 0; i < size2; ++i) {
            String[] tabledata = (String[])tablelist.get(i);
            RowParams rtnRowParams = new RowParams();
            tempParam = new Param();
            tempParam.setName("no");
            tempParam.setValue("" + (i + 1));
            rtnRowParams.addParam(tempParam);
            tempParam = new Param();
            tempParam.setName("wavenum");
            tempParam.setValue(tabledata[0]);
            rtnRowParams.addParam(tempParam);
            tempParam = new Param();
            tempParam.setName("wavefrequency");
            tempParam.setValue(tabledata[1]);
            rtnRowParams.addParam(tempParam);
            tempParam = new Param();
            tempParam.setName("corewavefre");
            if (boardType == 2214 || boardType == 2355) {
                tempParam.setValue("-");
            } else {
                tempParam.setValue(tabledata[2]);
            }
            rtnRowParams.addParam(tempParam);
            tempParam = new Param();
            tempParam.setName("waveoffset");
            tempParam.setValue(tabledata[3]);
            rtnRowParams.addParam(tempParam);
            tempParam = new Param();
            tempParam.setName("optipower");
            tempParam.setValue(tabledata[4]);
            rtnRowParams.addParam(tempParam);
            tempParam = new Param();
            tempParam.setName("osnr");
            tempParam.setValue(tabledata[5]);
            rtnRowParams.addParam(tempParam);
            bParam.addRowParams(rtnRowParams);
        }
        speDataInterface.setBussinessParams(bParam);
        if (this.secturmrsp.getRecode() != 0) {
            speDataInterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neID, (int)this.secturmrsp.getRecode()));
        } else {
            speDataInterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neID, (int)0));
        }
        this.paintimgpic();
        this.writeLog(neID, subFuc, inputData, user, ipAddress, speDataInterface);
        return speDataInterface;
    }

    private void paintimgpic() {
        Graphics2D waveg2d = (Graphics2D)this.spectWaveimage.getGraphics();
        waveg2d.setFont(new Font(waveg2d.getFont().getFontName(), waveg2d.getFont().getStyle(), 10));
        Graphics2D skeleg2d = (Graphics2D)this.spectSkeletonimage.getGraphics();
        skeleg2d.setFont(new Font(skeleg2d.getFont().getFontName(), skeleg2d.getFont().getStyle(), 10));
        int bandType = this.secturmrsp.getWavetype();
        if (bandType == 1 || bandType == 2 || bandType == -1) {
            this.paint80WaveSCB(waveg2d);
            this.draw80WaveAdumb(skeleg2d);
        } else {
            this.paint32WaveSCB(waveg2d);
            this.draw32WaveAdumb(skeleg2d);
        }
    }

    public ArrayList getTableData() {
        int row = this.secturmrsp.getWaveSize();
        int wavetype = this.secturmrsp.getWavetype();
        ArrayList temp = new ArrayList();
        if (wavetype == 1 || wavetype == 2) {
            this.get80WaveData(1000, -600.0f, row);
        } else if (wavetype == 3) {
            this.get32WaveData();
        }
        if (wavetype == 1 || wavetype == 2) {
            temp = this.get80WaveTable(row);
        } else if (wavetype == 3) {
            temp = this.get32WaveTable();
        }
        return temp;
    }

    protected ArrayList get32WaveTable() {
        ArrayList<String[]> tblist = new ArrayList<String[]>();
        TENE ne = TENEListMgr.getInstance().getNE(this.neid);
        int neType = ne.getNEType();
        String hostVersion = ne.getHostVersion();
        String path = TEPathManager.PACKAGE_PATH + TEGetFilePath.getFilePath((int)neType, (String)hostVersion, (String)PAKAGE_PATH);
        int row = this.secturmrsp.getWaveSize();
        if (this.al == null || this.al.size() == 0) {
            return new ArrayList();
        }
        float fRemainWave = 0.0f;
        double fRealFreq = 0.0;
        for (int i = 0; i < row; ++i) {
            SpectData curData = this.m_Data[i];
            if (curData == null || this.m_Data[i].nPhy_power <= -600L || this.m_Data[i].nBase_power == this.m_Data[i].nPhy_power || !(this.m_Data[i].fWave_length > 0.0f)) continue;
            String[] temp = new String[this.SPECT_TABLEROW_LENGHT];
            temp[0] = TEWaveLengthInfoStaticData.getInstance().getCustomizeWaveNo(this.secturmrsp.getWavetype(), curData.waveNumber);
            temp[1] = curData.wavefrequency;
            fRealFreq = this.getFreqFromWave(curData.fWave_length);
            temp[2] = curData.fWave_length + "/" + fRealFreq;
            fRemainWave = this.getApointedBitFloatValue(curData.fWave_length - curData.fStandard_WaveLength, 2);
            temp[3] = String.valueOf(fRemainWave);
            if (this.isInvalidOSNR(curData.offset)) {
                temp[3] = "---";
            }
            float power = ((float)curData.nPhy_power / 10.0f + this.power_compensation_value) * 10.0f;
            int nPower = Math.round(power);
            float realPower = (float)nPower / 10.0f;
            temp[4] = "" + realPower;
            if (this.m_Data[i].nBase_power > 0L) {
                float tempdata = (float)this.m_Data[i].nBase_power / 10.0f;
                temp[5] = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, this.slotid) == 78 ? (tempdata < 20.0f ? TEResourceUtil.getInstance((String)path).getString("ID_COM_20") : (tempdata > 25.0f ? TEResourceUtil.getInstance((String)path).getString("ID_COM_25") : "" + tempdata)) : "" + tempdata;
            } else {
                temp[5] = "---";
            }
            tblist.add(temp);
        }
        return tblist;
    }

    protected ArrayList get80WaveTable(int wave_length_num) {
        ArrayList<String[]> tblist = new ArrayList<String[]>();
        if (this.al == null || this.al.size() == 0) {
            return new ArrayList();
        }
        int row = this.secturmrsp.getWaveSize();
        float fRemainWave = 0.0f;
        String fRealFreq = null;
        for (int i = 0; i < row; ++i) {
            SpectData curData = this.m_Data[i];
            if (curData == null || curData.nPhy_power <= -600L || curData.nBase_power == curData.nPhy_power || !(curData.fWave_length > 0.0f)) continue;
            String[] temp = new String[this.SPECT_TABLEROW_LENGHT];
            temp[0] = TEWaveLengthInfoStaticData.getInstance().getCustomizeWaveNo(this.secturmrsp.getWavetype(), curData.waveNumber);
            temp[1] = curData.wavefrequency;
            fRealFreq = this.formatnum.format(this.getFreqFromWave(curData.fWave_length));
            temp[2] = this.getApointedBitFloatValue(curData.fWave_length, 2) + "/" + fRealFreq;
            fRemainWave = this.getApointedBitFloatValue(curData.fWave_length - curData.fStandard_WaveLength, 2);
            temp[3] = String.valueOf(fRemainWave);
            if (this.isInvalidOSNR(curData.offset)) {
                temp[3] = "---";
            }
            float power = ((float)curData.nPhy_power / 10.0f + this.power_compensation_value) * 10.0f;
            int nPower = Math.round(power);
            float realPower = (float)nPower / 10.0f;
            temp[4] = "" + realPower;
            temp[5] = curData.nBase_power > 0L ? "" + (float)curData.nBase_power / 10.0f : "---";
            tblist.add(temp);
        }
        return tblist;
    }

    public void get80WaveData(int times, float filter, int n_wave_num) {
        long nPhy_power;
        int index1;
        this.al.clear();
        this.m_Data = this.get80WaveSpectrumData();
        boolean ifHasWave = false;
        for (index1 = 0; index1 < this.m_Data.length; ++index1) {
            nPhy_power = this.m_Data[index1].nPhy_power;
            if (!((float)nPhy_power > filter)) continue;
            ifHasWave = true;
            break;
        }
        if (!ifHasWave) {
            return;
        }
        float fRealMaxWaveLength = this.m_Data[index1].fWave_length;
        float fRealMinWaveLength = this.m_Data[index1].fWave_length;
        float fMaxWaveLength = this.m_Data[this.m_Data.length - 1].fStandard_WaveLength;
        float fMinWaveLength = this.m_Data[0].fStandard_WaveLength;
        for (int i = 0; i < this.m_Data.length; ++i) {
            if (this.m_Data[i] == null || (float)this.m_Data[i].nPhy_power <= filter) continue;
            if (this.m_Data[i].fWave_length > fRealMaxWaveLength) {
                fRealMaxWaveLength = this.m_Data[i].fWave_length;
            }
            if (!(this.m_Data[i].fWave_length < fRealMinWaveLength)) continue;
            fRealMinWaveLength = this.m_Data[i].fWave_length;
        }
        this.fMinWaveLength = fMinWaveLength;
        float fUnit = (fMaxWaveLength - fMinWaveLength) / (float)n_wave_num;
        float delt_x = (fRealMaxWaveLength += fUnit / 2.0f) - (fRealMinWaveLength -= fUnit / 2.0f);
        float fWaveUnit = (fMaxWaveLength - fMinWaveLength) / (float)times;
        this.max_power = (float)this.m_Data[index1].nPhy_power + this.power_compensation_value * 10.0f;
        this.min_power = (float)this.m_Data[index1].nPhy_power + this.power_compensation_value * 10.0f;
        for (float x_off_set = fRealMinWaveLength; x_off_set < fRealMaxWaveLength; x_off_set += fWaveUnit) {
            delt_x = fRealMaxWaveLength - fRealMinWaveLength;
            int index = -1;
            for (int j = 0; j < this.m_Data.length; ++j) {
                float distance;
                SpectData oneData = this.m_Data[j];
                if (oneData == null || (float)oneData.nPhy_power <= filter || !(delt_x >= (distance = Math.abs(oneData.fWave_length - x_off_set)))) continue;
                delt_x = distance;
                index = j;
            }
            if (index == -1) break;
            nPhy_power = this.m_Data[index].nPhy_power;
            long nBase_power = this.m_Data[index].nBase_power;
            if (nBase_power > 0L) {
                nBase_power = nPhy_power - nBase_power;
            }
            float y_off_set = (float)((double)nBase_power + (double)(nPhy_power - nBase_power) * Math.exp(-(delt_x /= 0.1f) * delt_x) + (double)(this.power_compensation_value * 10.0f));
            Long L1 = ((long)(x_off_set * 1000.0f) << 32) + (long)(y_off_set * 1000.0f);
            this.al.add(L1);
            if (y_off_set > this.max_power) {
                this.max_power = y_off_set;
            }
            if (!(y_off_set < this.min_power)) continue;
            this.min_power = y_off_set;
        }
        for (int i = 0; i < this.m_Data.length; ++i) {
            if (this.m_Data[i] == null || (float)this.m_Data[i].nPhy_power <= filter) continue;
            float power = (float)this.m_Data[i].nPhy_power + this.power_compensation_value * 10.0f;
            Long l = ((long)(this.m_Data[i].fWave_length * 1000.0f) << 32) + (long)power * 1000L;
            this.al.add(l);
            if (power > this.max_power) {
                this.max_power = power;
            }
            if (!(power < this.min_power)) continue;
            this.min_power = power;
        }
        Collections.sort(this.al);
    }

    public SpectData[] get80WaveSpectrumData() {
        int rows = this.secturmrsp.getWaveSize();
        ArrayList sectulistdata = this.secturmrsp.getInfolist();
        SpectData[] data = new SpectData[rows];
        for (int i = 0; i < rows; ++i) {
            TEOPTWaveInfo optInfo = (TEOPTWaveInfo)sectulistdata.get(i);
            long nBase_power = optInfo.getOptOSNR();
            long nPhy_power = optInfo.getOptPOWER();
            float fWave_length = (float)optInfo.getOptWAVELENGTH() / 100.0f;
            data[i] = new SpectData();
            data[i].fWave_length = fWave_length;
            data[i].nBase_power = nBase_power;
            data[i].nPhy_power = nPhy_power;
            data[i].offset = optInfo.getOptWAVEEXCURSION();
            data[i].waveNumber = optInfo.getOptWaveNo();
            data[i].frequency = Float.parseFloat(TEWaveLengthInfoStaticData.getInstance().getFrequency(this.secturmrsp.getWavetype(), data[i].waveNumber));
            data[i].fStandard_WaveLength = Float.parseFloat(TEWaveLengthInfoStaticData.getInstance().getWaveLengthInfo(this.secturmrsp.getWavetype(), data[i].waveNumber));
            data[i].wavefrequency = data[i].fStandard_WaveLength + "/" + this.formatnum.format(data[i].frequency);
        }
        return data;
    }

    public void get32WaveData() {
        this.al.clear();
        int bandType = this.secturmrsp.getWavetype();
        float fWave_length = 0.0f;
        int alSize = this.secturmrsp.getWaveSize();
        this.m_Data = new SpectData[alSize];
        for (int i = 0; i < alSize; ++i) {
            ArrayList sectulistdata = this.secturmrsp.getInfolist();
            TEOPTWaveInfo optInfo = (TEOPTWaveInfo)sectulistdata.get(i);
            long nBase_power = optInfo.getOptOSNR();
            long nPhy_power = optInfo.getOptPOWER();
            fWave_length = (float)optInfo.getOptWAVELENGTH() / 100.0f;
            this.m_Data[i] = new SpectData();
            this.m_Data[i].fWave_length = fWave_length;
            this.m_Data[i].nBase_power = nBase_power;
            this.m_Data[i].nPhy_power = nPhy_power;
            this.m_Data[i].waveNumber = optInfo.getOptWaveNo();
            this.m_Data[i].frequency = Float.parseFloat(TEWaveLengthInfoStaticData.getInstance().getFrequency(bandType, this.m_Data[i].waveNumber));
            this.m_Data[i].fStandard_WaveLength = Float.parseFloat(TEWaveLengthInfoStaticData.getInstance().getWaveLengthInfo(bandType, this.m_Data[i].waveNumber));
            this.m_Data[i].wavefrequency = this.m_Data[i].fStandard_WaveLength + "/" + this.m_Data[i].frequency;
            if (nPhy_power <= -600L) continue;
            if (nBase_power > 0L) {
                nBase_power = nPhy_power - nBase_power;
            }
            int iNum = 5;
            for (int t = 0; t < iNum; ++t) {
                float y_off_set;
                float x_off_set = (float)((double)t * 30.440000000000055 / (double)(iNum * 32 * 2));
                double delta_x = x_off_set * 32.0f;
                delta_x /= (double)0.12f;
                if ((y_off_set = (float)((double)nBase_power + (double)(nPhy_power - nBase_power) * Math.exp(-(delta_x /= 30.440000000000055) * delta_x) + (double)(this.power_compensation_value * 10.0f))) < -700.0f) {
                    y_off_set = -700.0f;
                } else if (y_off_set > 200.0f) {
                    y_off_set = 200.0f;
                }
                Long L1 = ((long)((fWave_length + x_off_set) * 1000.0f) << 32) + (long)(y_off_set * 1000.0f);
                this.al.add(L1);
                Long L2 = ((long)((fWave_length - x_off_set) * 1000.0f) << 32) + (long)(y_off_set * 1000.0f);
                this.al.add(L2);
            }
            Collections.sort(this.al);
        }
    }

    protected double getFreqFromWave(float fWaveLength) {
        double fFreq = 0.0;
        if (fWaveLength > 0.0f) {
            fFreq = 299792.458 / (double)fWaveLength;
        }
        fFreq = this.getdoubleApointedBitFloatValue(fFreq, 3);
        return fFreq;
    }

    private double getdoubleApointedBitFloatValue(double value, int numOfBit) {
        int iValue = (int)Math.round(value * Math.pow(10.0, numOfBit));
        double fResult = (double)iValue / Math.pow(10.0, numOfBit);
        return fResult;
    }

    protected float getApointedBitFloatValue(float value, int numOfBit) {
        int iValue = (int)Math.round((double)value * Math.pow(10.0, numOfBit));
        float fResult = (float)((double)iValue / Math.pow(10.0, numOfBit));
        return fResult;
    }

    public void paint80WaveSCB(Graphics2D dc) {
        int i;
        Color c = new Color(239, 239, 239);
        dc.setColor(c);
        dc.fillRect(0, 0, 900, 115);
        if (this.al == null || this.al.size() <= 0) {
            return;
        }
        float min_wave_length = this.fMinWaveLength;
        int wave_length_num = this.secturmrsp.getWaveSize();
        int minWaveLength = 1530;
        int maxWaveLength = 0;
        int wavetype = this.secturmrsp.getWavetype();
        if (wavetype != 2) {
            maxWaveLength = 1570;
        } else {
            minWaveLength = 1570;
            maxWaveLength = 1610;
        }
        int nOffsetY = 4;
        int nOffsetX = 30;
        int addfirstlinex = 18;
        if (wave_length_num == 0) {
            wave_length_num = 40;
        }
        int nHeight = this.WAVEPIC_HEIGHT - 15;
        int nLen = this.SKELETONPIC_WIDTH - 35;
        dc.setColor(Color.gray);
        dc.drawLine(nOffsetX, nOffsetY, nLen, nOffsetY);
        dc.drawLine(nLen, nOffsetY, nLen, nHeight);
        dc.drawLine(nLen, nHeight, nOffsetX, nHeight);
        dc.drawLine(nOffsetX, nHeight, nOffsetX, nOffsetY);
        float max_power = this.max_power / 10.0f;
        float min_power = this.min_power / 10.0f;
        float osnr = max_power - min_power;
        float fUnit = osnr / 5.0f;
        int unit = Math.round(fUnit);
        int maxline = Math.round(max_power) + unit;
        float ratio = (float)(nHeight - nOffsetY) / (float)(unit * 9);
        for (i = 0; i <= 9; ++i) {
            if (i >= 9) continue;
            dc.drawLine(nOffsetX, (nHeight - nOffsetY) / 9 * i + nOffsetY, nLen, (nHeight - nOffsetY) / 9 * i + nOffsetY);
        }
        dc.setColor(Color.black);
        for (i = 1; i <= 9; i += 2) {
            String cs = "" + (maxline - i * unit);
            FontMetrics fontmetri = dc.getFontMetrics();
            int cswidth = fontmetri.stringWidth(cs);
            dc.drawString(cs, nOffsetX - cswidth - 4, (nHeight - nOffsetY) / 9 * i + nOffsetY + 6);
        }
        String cs1 = "dBm";
        dc.drawString(cs1, 2, nOffsetY + 6);
        double nScale = (nLen - nOffsetX - addfirstlinex) / 40;
        dc.drawString("nm/THz", nLen - 8, nHeight + 12);
        dc.setColor(Color.gray);
        int m_DataLength = this.m_Data.length;
        int drawx = 0;
        for (int i2 = 0; i2 < m_DataLength; ++i2) {
            drawx = (int)((double)nOffsetX + (double)(this.m_Data[i2].fStandard_WaveLength - min_wave_length) * nScale);
            dc.drawLine(drawx, nOffsetY, drawx, nHeight);
        }
        double wavelen = this.m_Data[1].fStandard_WaveLength - min_wave_length;
        drawx = (int)((double)drawx + wavelen * nScale);
        dc.drawLine(drawx, nOffsetY, drawx, nHeight);
        dc.setColor(Color.black);
        for (int i3 = minWaveLength; i3 <= maxWaveLength; i3 += 10) {
            int pos = (int)((double)(nOffsetX + addfirstlinex) + (double)(i3 - minWaveLength) * nScale);
            dc.drawLine(pos, nHeight - 8, pos, nHeight);
            double fRealFreq = this.getFreqFromWave(i3);
            String cs = "" + i3 + "/" + this.formatnum.format(fRealFreq);
            if (i3 == minWaveLength) {
                dc.drawString(cs, pos - 10, nHeight + 13);
                continue;
            }
            if (i3 > minWaveLength && maxWaveLength > i3) {
                dc.drawString(cs, pos - 28, nHeight + 13);
                continue;
            }
            dc.drawString(cs, pos - 63, nHeight + 13);
        }
        dc.setColor(Color.red);
        if (this.al.isEmpty()) {
            return;
        }
        int size = this.al.size();
        long l = (Long)this.al.get(0);
        float y1 = (float)((int)l) / 1000.0f;
        float x1 = (float)((int)(l >> 32)) / 1000.0f;
        for (int i4 = 0; i4 < size; ++i4) {
            l = (Long)this.al.get(i4);
            float y = (float)((int)l) / 1000.0f;
            float x = (float)((int)(l >> 32)) / 1000.0f;
            dc.drawLine((int)((double)(nOffsetX + addfirstlinex) + (double)(x1 - 1530.0f) * nScale), (int)((float)nOffsetY + ((float)maxline - y1 / 10.0f) * ratio), (int)((double)(nOffsetX + addfirstlinex) + (double)(x - 1530.0f) * nScale), (int)((float)nOffsetY + ((float)maxline - y / 10.0f) * ratio));
            y1 = y;
            x1 = x;
        }
    }

    public void paint32WaveSCB(Graphics2D grapicDc) {
        Color c = new Color(178, 195, 196);
        grapicDc.setColor(c);
        grapicDc.fillRect(0, 0, 800, 115);
        int nLen = this.WAVEPIC_WIDTH - 17;
        int nheight = this.WAVEPIC_HEIGHT - 15;
        int nOffsetX = 25;
        int nOffsetY = 10;
        grapicDc.setColor(Color.black);
        grapicDc.drawLine(nOffsetX, nOffsetY, nLen, nOffsetY);
        grapicDc.drawLine(nLen, nOffsetY, nLen, nheight);
        grapicDc.drawLine(nLen, nheight, nOffsetX, nheight);
        grapicDc.drawLine(nOffsetX, nheight, nOffsetX, nOffsetY);
        int hline = (nheight - nOffsetY) / 9;
        for (int i = 0; i <= 9; ++i) {
            if (i < 9) {
                grapicDc.drawLine(nOffsetX, hline * (i + 1) + nOffsetY, nLen, hline * (i + 1) + nOffsetY);
            }
            if (i <= 0) continue;
            String cs = "" + (20 - i * 10);
            grapicDc.drawString(cs, 5, hline * i + nOffsetY);
        }
        String cs1 = "dBm";
        grapicDc.drawString(cs1, 2, nOffsetY);
        double nScale = (double)(nLen - nOffsetX) / 31.940000000000055;
        for (int i = 1530; i <= 1560; i += 10) {
            int pos = (int)((double)nOffsetX + ((double)i - 1529.56) * nScale);
            grapicDc.drawLine(pos, nheight - 8, pos, nheight);
            String cs = "" + i;
            grapicDc.drawString(cs, pos - 10, nheight + 13);
        }
        grapicDc.drawString("nm", nLen - 13, nheight + 12);
        grapicDc.setColor(Color.gray);
        int m_DataLength = this.m_Data.length;
        int bandType = this.secturmrsp.getWavetype();
        int wavesize = this.secturmrsp.getWaveSize();
        for (int i = 0; i < wavesize; ++i) {
            if (m_DataLength - 1 - i >= 0) {
                grapicDc.drawLine((int)((double)nOffsetX + ((double)this.m_Data[m_DataLength - 1 - i].fStandard_WaveLength - 1529.56) * nScale), nOffsetY, (int)((double)nOffsetX + ((double)this.m_Data[m_DataLength - 1 - i].fStandard_WaveLength - 1529.56) * nScale), nheight);
                continue;
            }
            int waveNumber = (bandType << 16) + wavesize - i;
            float waveLength = Float.parseFloat(TEWaveLengthInfoStaticData.getInstance().getWaveLengthInfo(this.secturmrsp.getWavetype(), waveNumber));
            grapicDc.drawLine((int)((double)nOffsetX + ((double)waveLength - 1529.56) * nScale), nOffsetY, (int)((double)nOffsetX + ((double)waveLength - 1529.56) * nScale), nheight);
        }
        grapicDc.setColor(Color.red);
        if (this.al == null || this.al.size() == 0) {
            return;
        }
        int size = this.al.size();
        long l = (Long)this.al.get(0);
        float y1 = (float)((int)l) / 1000.0f;
        float x1 = (float)((int)(l >> 32)) / 1000.0f;
        for (int i = 0; i < size; ++i) {
            l = (Long)this.al.get(i);
            float y = (float)((int)l) / 1000.0f;
            float x = (float)((int)(l >> 32)) / 1000.0f;
            if ((double)x1 >= 1529.56 && (double)x1 <= 1561.5) {
                grapicDc.drawLine((int)((double)nOffsetX + ((double)x1 - 1529.56) * nScale), (int)((float)nOffsetY + (200.0f - y1) * (float)(nheight - nOffsetY) / 90.0f / 10.0f), (int)((double)nOffsetX + ((double)x - 1529.56) * nScale), (int)((float)nOffsetY + (200.0f - y) * (float)(nheight - nOffsetY) / 90.0f / 10.0f));
            }
            y1 = y;
            x1 = x;
        }
    }

    protected void draw80WaveAdumb(Graphics2D dc) {
        Color c = new Color(239, 239, 239);
        dc.setColor(c);
        dc.fillRect(0, 0, 900, 180);
        if (this.al == null || this.al.size() <= 0) {
            return;
        }
        float min_wave_length = 1530.0f;
        int nLen = this.SKELETONPIC_WIDTH - 35;
        int nheight = this.SKELETONPIC_HEIGHT - 15;
        int nOffsetX = 30;
        int nOffsetY = 20;
        int addfirstlinex = 18;
        dc.setColor(Color.gray);
        dc.drawLine(nOffsetX, nOffsetY, nLen, nOffsetY);
        dc.drawLine(nLen, nOffsetY, nLen, nheight);
        dc.drawLine(nLen, nheight, nOffsetX, nheight);
        dc.drawLine(nOffsetX, nheight, nOffsetX, nOffsetY);
        double nScale = (nLen - nOffsetX - addfirstlinex) / 40;
        int m_DataLength = this.m_Data.length;
        int drawx = 0;
        for (int i = 0; i < m_DataLength; ++i) {
            drawx = (int)((double)nOffsetX + (double)(this.m_Data[i].fStandard_WaveLength - this.fMinWaveLength) * nScale);
            dc.drawLine(drawx, nOffsetY, drawx, nheight);
        }
        double wavelen = this.m_Data[1].fStandard_WaveLength - this.fMinWaveLength;
        drawx = (int)((double)drawx + wavelen * nScale);
        dc.drawLine(drawx, nOffsetY, drawx, nheight);
        dc.setColor(Color.black);
        for (int i = 1530; i <= 1570; i += 10) {
            int pos = (int)((double)(nOffsetX + addfirstlinex) + (double)(i - 1530) * nScale);
            dc.drawLine(pos - 1, nheight - 8, pos - 1, nheight);
            double fRealFreq = this.getFreqFromWave(i);
            String cs = "" + i + "/" + this.formatnum.format(fRealFreq);
            if (i == 1530) {
                dc.drawString(cs, pos - 10, nheight + 13);
                continue;
            }
            if (i > 1530 && 1570 > i) {
                dc.drawString(cs, pos - 28, nheight + 13);
                continue;
            }
            dc.drawString(cs, pos - 63, nheight + 13);
        }
        dc.drawString("nm/THz", nLen - 8, nheight + 12);
        float fHigh = -70.0f;
        float fLow = 20.0f;
        int waveLengthSize = this.secturmrsp.getWaveSize();
        for (int i = 0; i < waveLengthSize; ++i) {
            SpectData curData = this.m_Data[i];
            if (curData == null || this.m_Data[i].nPhy_power <= -600L || this.m_Data[i].nBase_power == this.m_Data[i].nPhy_power || !(this.m_Data[i].fWave_length > 0.0f)) continue;
            float fPower = (float)(this.m_Data[i].nPhy_power / 10L) + this.power_compensation_value;
            if (fPower > fHigh) {
                fHigh = fPower;
            }
            if (!(fPower < fLow)) continue;
            fLow = fPower;
        }
        int nHigh = (int)(fHigh / 10.0f) * 10 + 10;
        int nLow = (int)(fLow / 10.0f) * 10 - 10;
        if (nHigh <= nLow) {
            nHigh = 20;
            nLow = -10;
        }
        int nLevel = (nHigh - nLow) / 10;
        for (int i = 0; i <= nLevel; ++i) {
            if (i < nLevel - 1) {
                dc.drawLine(nOffsetX, (nheight - nOffsetY) / nLevel * (i + 1) + nOffsetY, nLen, (nheight - nOffsetY) / nLevel * (i + 1) + nOffsetY);
            }
            String cs = "" + (nHigh - i * 10);
            FontMetrics fontmetri = dc.getFontMetrics();
            int cswidth = fontmetri.stringWidth(cs);
            dc.drawString(cs, nOffsetX - cswidth - 4, (nheight - nOffsetY) / nLevel * i + nOffsetY + 4);
        }
        dc.drawString("dBm", 2, nOffsetY - 8);
        if (this.al.isEmpty()) {
            return;
        }
        dc.setColor(Color.red);
        boolean bFirst = true;
        int x1 = 0;
        int y1 = 0;
        for (int i = waveLengthSize - 1; i >= 0; --i) {
            if (this.m_Data[i] == null || this.m_Data[i].nPhy_power <= -600L || this.m_Data[i].nBase_power == this.m_Data[i].nPhy_power || !(this.m_Data[i].fWave_length > 0.0f)) continue;
            float fPower = (float)nHigh - (float)this.m_Data[i].nPhy_power / 10.0f - this.power_compensation_value;
            if (bFirst) {
                x1 = (int)((double)(nOffsetX + addfirstlinex) + (double)(this.m_Data[i].fWave_length - min_wave_length) * nScale);
                y1 = (int)((float)nOffsetY + fPower * (float)(nheight - nOffsetY) / (float)(nLevel * 10));
                dc.fillArc(x1 - 2, y1 - 2, 4, 4, 0, 360);
                bFirst = false;
                continue;
            }
            dc.drawLine(x1, y1, (int)((double)(nOffsetX + addfirstlinex) + (double)(this.m_Data[i].fWave_length - min_wave_length) * nScale), (int)((float)nOffsetY + fPower * (float)(nheight - nOffsetY) / (float)(nLevel * 10)));
            x1 = (int)((double)(nOffsetX + addfirstlinex) + (double)(this.m_Data[i].fWave_length - min_wave_length) * nScale);
            y1 = (int)((float)nOffsetY + fPower * (float)(nheight - nOffsetY) / (float)(nLevel * 10));
            dc.fillArc(x1 - 2, y1 - 2, 4, 4, 0, 360);
        }
    }

    protected void draw32WaveAdumb(Graphics2D dc) {
        Color c = new Color(178, 195, 196);
        dc.setColor(c);
        dc.fillRect(0, 0, 900, 180);
        int nLen = this.SKELETONPIC_WIDTH - 17;
        int nheight = this.SKELETONPIC_HEIGHT - 17;
        int nOffsetX = 25;
        int nOffsetY = 19;
        dc.setColor(Color.black);
        dc.drawLine(nOffsetX, nOffsetY, nLen, nOffsetY);
        dc.drawLine(nLen, nOffsetY, nLen, nheight);
        dc.drawLine(nLen, nheight, nOffsetX, nheight);
        dc.drawLine(nOffsetX, nheight, nOffsetX, nOffsetY);
        double nScale = (double)(nLen - nOffsetX) / 31.940000000000055;
        for (int i = 1530; i <= 1560; i += 10) {
            int pos = (int)((double)nOffsetX + ((double)i - 1529.56) * nScale);
            dc.drawLine(pos, nheight - 8, pos, nheight);
            String cs = "" + i;
            dc.drawString(cs, pos - 10, nheight + 13);
        }
        dc.drawString("nm", nLen - 13, nheight + 12);
        dc.setColor(Color.gray);
        int m_DataLength = this.m_Data.length;
        int bandType = this.secturmrsp.getWavetype();
        int wavesize = this.secturmrsp.getWaveSize();
        for (int i = 0; i < wavesize; ++i) {
            if (m_DataLength - 1 - i >= 0) {
                dc.drawLine((int)((double)nOffsetX + ((double)this.m_Data[m_DataLength - 1 - i].fStandard_WaveLength - 1529.56) * nScale), nOffsetY, (int)((double)nOffsetX + ((double)this.m_Data[m_DataLength - 1 - i].fStandard_WaveLength - 1529.56) * nScale), nheight);
                continue;
            }
            int waveNumber = (bandType << 16) + wavesize - i;
            float waveLength = Float.parseFloat(TEWaveLengthInfoStaticData.getInstance().getWaveLengthInfo(this.secturmrsp.getWavetype(), waveNumber));
            dc.drawLine((int)((double)nOffsetX + ((double)waveLength - 1529.56) * nScale), nOffsetY, (int)((double)nOffsetX + ((double)waveLength - 1529.56) * nScale), nheight);
        }
        if (this.al == null || this.al.size() == 0) {
            return;
        }
        float fHigh = -70.0f;
        float fLow = 20.0f;
        int waveLengthSize = this.secturmrsp.getWaveSize();
        for (int i = 0; i < waveLengthSize; ++i) {
            SpectData curData = this.m_Data[i];
            if (curData == null || this.m_Data[i].nPhy_power <= -600L || this.m_Data[i].nBase_power == this.m_Data[i].nPhy_power || !(this.m_Data[i].fWave_length > 0.0f)) continue;
            float fPower = (float)(this.m_Data[i].nPhy_power / 10L) + this.power_compensation_value;
            if (fPower > fHigh) {
                fHigh = fPower;
            }
            if (!(fPower < fLow)) continue;
            fLow = fPower;
        }
        dc.setColor(Color.black);
        int nHigh = (int)(fHigh / 10.0f) * 10 + 10;
        int nLow = (int)(fLow / 10.0f) * 10 - 10;
        if (nHigh <= nLow) {
            nHigh = 20;
            nLow = -10;
        }
        int nLevel = (nHigh - nLow) / 10;
        for (int i = 0; i <= nLevel; ++i) {
            if (i < nLevel) {
                dc.drawLine(nOffsetX, (nheight - nOffsetY) / nLevel * (i + 1) + nOffsetY, nLen, (nheight - nOffsetY) / nLevel * (i + 1) + nOffsetY);
            }
            String cs = "" + (nHigh - i * 10);
            dc.drawString(cs, 5, (nheight - nOffsetY) / nLevel * i + nOffsetY + 4);
        }
        dc.drawString("dBm", 2, nOffsetY - 5);
        dc.setColor(Color.red);
        boolean bFirst = true;
        int x1 = 0;
        int y1 = 0;
        for (int i = waveLengthSize - 1; i >= 0; --i) {
            if (this.m_Data[i] == null || this.m_Data[i].nPhy_power <= -600L || this.m_Data[i].nBase_power == this.m_Data[i].nPhy_power || !(this.m_Data[i].fWave_length > 0.0f)) continue;
            float fPower = (float)nHigh - (float)this.m_Data[i].nPhy_power / 10.0f - this.power_compensation_value;
            if (bFirst) {
                x1 = (int)((double)nOffsetX + ((double)this.m_Data[i].fWave_length - 1529.56) * nScale);
                y1 = (int)((float)nOffsetY + fPower * (float)(nheight - nOffsetY) / (float)(nLevel * 10));
                dc.fillArc(x1 - 2, y1 - 2, 4, 4, 0, 360);
                bFirst = false;
                continue;
            }
            dc.drawLine(x1, y1, (int)((double)nOffsetX + ((double)this.m_Data[i].fWave_length - 1529.56) * nScale), (int)((float)nOffsetY + fPower * (float)(nheight - nOffsetY) / (float)(nLevel * 10)));
            x1 = (int)((double)nOffsetX + ((double)this.m_Data[i].fWave_length - 1529.56) * nScale);
            y1 = (int)((float)nOffsetY + fPower * (float)(nheight - nOffsetY) / (float)(nLevel * 10));
            dc.fillArc(x1 - 2, y1 - 2, 4, 4, 0, 360);
        }
    }

    public boolean isNeedOperationlog() {
        return true;
    }

    private boolean isInvalidOSNR(long powervalue) {
        return powervalue == Integer.MAX_VALUE;
    }
}

