/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.spectrum;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nemgr.ngwdm.spectrum.TEOPTWaveInfo;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.math.BigInteger;
import java.util.ArrayList;

public class TENESpectrumRsp {
    private int TIME_OUT = 60;
    private int recode = 0;
    private int wavetype = 1;
    private ArrayList infolist = new ArrayList();

    public int getWaveSize() {
        return this.infolist.size();
    }

    public ArrayList queryWaveInfo(int neid, int slotid, int portid) {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        try {
            Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_ANALYDATA");
            Input input = oper.getInput();
            for (Part part : input.getPart()) {
                if (part.getName().equals("slotNum")) {
                    part.setValue("" + slotid);
                    continue;
                }
                if (!part.getName().equals("portNum")) continue;
                int port = portid & 0xFFFF;
                part.setValue("" + port);
            }
            operationList.add(oper);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TENESpectrumRsp.queryWaveInfo() fail!", (Throwable)e);
        }
        OperationResult result = TENECommMgr.getInstance().sendCommand(neid, operationList, this.TIME_OUT);
        if (result.retCode != 0) {
            this.recode = result.retCode;
            return this.infolist;
        }
        int size = operationList.size();
        for (int i = 0; i < size; ++i) {
            Operation operation = (Operation)operationList.get(i);
            for (Output output : operation.getOutput()) {
                if (!output.getFault()[0].getCode().equals("0")) {
                    int f;
                    this.recode = f = Integer.parseInt(output.getFault()[0].getCode());
                    return this.infolist;
                }
                Part[] partArr = output.getPart();
                TEOPTWaveInfo waveinfo = new TEOPTWaveInfo();
                for (Part part : partArr) {
                    int s;
                    String name = part.getName();
                    String value = part.getValue();
                    if (name.equalsIgnoreCase("type") && value != null) {
                        this.setWavetype(new Integer(value));
                    }
                    if (name.equalsIgnoreCase("waveNo") && value != null) {
                        s = new Integer(value);
                        waveinfo.setOptWaveNo(s);
                        continue;
                    }
                    if (name.equalsIgnoreCase("optWAVELENGTH") && value != null) {
                        s = new BigInteger(value).intValue();
                        waveinfo.setOptWAVELENGTH(s);
                        continue;
                    }
                    if (name.equalsIgnoreCase("optWAVEEXCURSION") && value != null) {
                        s = new BigInteger(value).intValue();
                        waveinfo.setOptWAVEEXCURSION(s);
                        continue;
                    }
                    if (name.equalsIgnoreCase("optPOWER") && value != null) {
                        s = new BigInteger(value, 16).intValue();
                        waveinfo.setOptPOWER(s);
                        continue;
                    }
                    if (!name.equalsIgnoreCase("optOSNR") || value == null) continue;
                    s = new BigInteger(value, 16).intValue();
                    if (s == Integer.MAX_VALUE) {
                        s = -600;
                    }
                    waveinfo.setOptOSNR(s);
                }
                this.infolist.add(waveinfo);
            }
        }
        return this.infolist;
    }

    public void setRecode(int recode) {
        this.recode = recode;
    }

    public int getRecode() {
        return this.recode;
    }

    public void setInfolist(ArrayList infolist) {
        this.infolist = infolist;
    }

    public ArrayList getInfolist() {
        return this.infolist;
    }

    public void setWavetype(int wavetype) {
        this.wavetype = wavetype;
    }

    public int getWavetype() {
        return this.wavetype;
    }
}

