/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.spectrum;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TEGetPowerList
implements TENEMgrInterface {
    public boolean filterFlag = false;
    public static String cfgfile = "nemgr" + File.separator + "ngwdm" + File.separator + "conf" + File.separator + "spectrum" + File.separator + "powerinfolist.xml";
    private static Document doc;

    public TEGetPowerList() {
        TEGetPowerList.initDoc();
    }

    private static void initDoc() {
        if (doc == null) {
            Bundle bundle = FrameworkUtil.getBundle(TEGetPowerList.class);
            doc = TEParseXMLFile.parseFile((Bundle)bundle, (String)cfgfile);
        }
    }

    public Datainterface performBussinessProcess(int neID, SubFunc subFuc, Datainterface inputData, Datainterface MemoryData, String user, String ipAddress) {
        RowParams rowparas = inputData.getBussinessParams().getRowParams(0);
        Param boardtypeparam = rowparas.getParam("boardtype");
        String typeparam = boardtypeparam.getValue();
        if (typeparam == null || typeparam.equals("")) {
            this.filterFlag = true;
        }
        ArrayList powerlist = TEGetPowerList.getNeListInfo(doc);
        Datainterface speDataInterface = new Datainterface();
        BussinessParams bParam = new BussinessParams();
        Param tempParam = null;
        if (this.filterFlag) {
            int size = powerlist.size();
            for (int i = 0; i < size; ++i) {
                HashMap neAttributes = (HashMap)powerlist.get(i);
                String boardType = "boardtype";
                RowParams rtnRowParams = new RowParams();
                tempParam = new Param();
                tempParam.setName(boardType);
                tempParam.setValue(neAttributes.get(boardType) + "");
                rtnRowParams.addParam(tempParam);
                String compensationPower = "compensationpower";
                tempParam = new Param();
                tempParam.setName(compensationPower);
                tempParam.setValue(neAttributes.get(compensationPower) + "");
                rtnRowParams.addParam(tempParam);
                bParam.addRowParams(rtnRowParams);
            }
        } else {
            int size = powerlist.size();
            for (int i = 0; i < size; ++i) {
                String boardType = "boardtype";
                String compensationPower = "compensationpower";
                HashMap neAttributes = (HashMap)powerlist.get(i);
                if (!this.ismatcher(neAttributes.get(boardType).toString(), typeparam)) continue;
                RowParams rtnRowParams = new RowParams();
                tempParam = new Param();
                tempParam.setName(boardType);
                tempParam.setValue(neAttributes.get(boardType) + "");
                rtnRowParams.addParam(tempParam);
                tempParam = new Param();
                tempParam.setName(compensationPower);
                tempParam.setValue(neAttributes.get(compensationPower) + "");
                rtnRowParams.addParam(tempParam);
                bParam.addRowParams(rtnRowParams);
            }
        }
        speDataInterface.setBussinessParams(bParam);
        speDataInterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neID, (int)0));
        return speDataInterface;
    }

    public boolean isNeedOperationlog() {
        return false;
    }

    public static ArrayList getNeListInfo(Document doc) {
        ArrayList powerlistInfo = new ArrayList();
        try {
            if (null == doc) {
                return powerlistInfo;
            }
            NodeList neNodeList = doc.getElementsByTagName("boardid");
            Element elem = null;
            NodeList childNodeList = null;
            int isize = neNodeList.getLength();
            for (int i = 0; i < isize; ++i) {
                HashMap<String, String> neAttributes = new HashMap<String, String>();
                elem = (Element)neNodeList.item(i);
                neAttributes.put(elem.getNodeName(), elem.getAttribute("value"));
                childNodeList = elem.getChildNodes();
                int m = childNodeList.getLength();
                for (int j = 0; j < m; ++j) {
                    elem = (Element)childNodeList.item(j);
                    neAttributes.put(elem.getNodeName(), elem.getAttribute("value"));
                }
                powerlistInfo.add(neAttributes);
            }
            return powerlistInfo;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("read powerlistinfo.xml file fail!", (Throwable)e);
            return powerlistInfo;
        }
    }

    public boolean ismatcher(String whole, String sub) {
        String lower = sub.toLowerCase();
        String up = sub.toUpperCase();
        String lowerregEx = lower;
        Pattern lowerpat = Pattern.compile(lowerregEx);
        Matcher lowermat = lowerpat.matcher(whole);
        boolean lowerrs = lowermat.find();
        String upregEx = up;
        Pattern uppat = Pattern.compile(upregEx);
        Matcher upmat = uppat.matcher(whole);
        boolean uprs = upmat.find();
        return lowerrs || uprs;
    }
}

