/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.rs232;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.ngwdm.rs232.TEUsableResource;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;

public class TEGetPortsBean
implements TENEMgrInterface {
    private Datainterface datainterface = new Datainterface();
    private BussinessParams bParams = new BussinessParams();
    private int neID = -1;
    private ArrayList usableResourceList = new ArrayList();
    private TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
    private static final int BDTYPE_TN22SCC = 1208;
    private static final int BDTYPE_TN52SCC = 1564;
    private static final int BDTYPE_TNK2SCC = 1565;
    private static final int BDTYPE_TN12SC1 = 1275;
    private static final int BDTYPE_TN12SC2 = 1262;
    private static final int BDTYPE_TN11ST2 = 2244;
    private static final String INVALID_SUBSLOTID = "255";
    private boolean processingBoardFlag = false;
    private ArrayList processingBoardList = new ArrayList();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neID = neid;
        TENE ne = TENEListMgr.getInstance().getNE(this.neID);
        Vector boardList = ne.getBoardList();
        Collections.sort(boardList);
        if (boardList == null || boardList.size() == 0) {
            this.datainterface.setBussinessParams(this.bParams);
            this.datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)0));
            return this.datainterface;
        }
        Param param = inputData.getBussinessParams().getRowParams(0).getParam("SCCSlotId");
        int SCCSlotId = 0;
        if (null != param) {
            SCCSlotId = Integer.valueOf(param.getValue());
        }
        int SubrackID = TEBoardUtil.getSubrackIDFromSlot((int)neid, (int)SCCSlotId);
        int size = boardList.size();
        for (int i = 0; i < size; ++i) {
            try {
                TEUsableResource usableRes;
                TEBoard board = (TEBoard)boardList.get(i);
                int bdType = board.getBoardType();
                int slotID = board.getSlotID();
                String bdName = board.getBoardName();
                if (TEBoardUtil.getSubrackIDFromSlot((int)neid, (int)slotID) != SubrackID || 1208 != bdType && 1564 != bdType && 1565 != bdType && 1275 != bdType && 1262 != bdType && 2244 != bdType && !TESpecialAttrMgr.getInstance().isCPSupportByType(bdType, "TE_FUNC_CFG_SCC_RS232", "OTN_ATTR_SUPPORT_RS232")) continue;
                ArrayList portList = null;
                portList = this.getPortList(neid, slotID, bdType);
                ArrayList<String> portidList = new ArrayList<String>();
                ArrayList<String> portNameList = new ArrayList<String>();
                int size3 = portList.size();
                for (int l = 0; l < size3; ++l) {
                    int portID = (Integer)portList.get(l);
                    portidList.add(l, portID + "");
                    String portName = this.cfgDataMgr.getPortNameForPTN(this.neID, slotID, bdType, portID);
                    portNameList.add(l, portName);
                }
                if (portidList.size() <= 0 || this.usableResourceList.contains((Object)(usableRes = new TEUsableResource(slotID, bdName, 0, TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)slotID), portidList, portNameList)))) continue;
                this.usableResourceList.add(usableRes);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (null != param) {
            this.getProcessingBoard(SubrackID);
        }
        return this.constructRtnData(SCCSlotId);
    }

    public Datainterface constructRtnData(int sccSlotid) {
        Param param;
        RowParams rParams;
        if (!this.processingBoardFlag) {
            StringBuffer boardNameArray = new StringBuffer();
            int size = this.processingBoardList.size();
            for (int i = 0; i < size; ++i) {
                boardNameArray.append((String)this.processingBoardList.get(i)).append(",");
            }
            rParams = new RowParams();
            param = new Param("boardNameArray", boardNameArray.toString());
            rParams.addParam(param);
            param = new Param("subBoardName", TEBoardUtil.getSubrackNameFromSlot((int)this.neID, (int)sccSlotid));
            rParams.addParam(param);
            this.bParams.addRowParams(rParams);
        }
        int size = this.usableResourceList.size();
        for (int i = 0; i < size; ++i) {
            Option option;
            int j;
            TEUsableResource res = (TEUsableResource)((Object)this.usableResourceList.get(i));
            rParams = new RowParams();
            param = null;
            param = new Param("slotid", Integer.valueOf(res.getSlotID()).toString());
            rParams.addParam(param);
            param = new Param("boardName", res.getBoardName());
            rParams.addParam(param);
            param = new Param("subslotid", Integer.valueOf(res.getSubslotID()).toString());
            rParams.addParam(param);
            param = new Param("subBoardName", res.getSubboardName());
            rParams.addParam(param);
            param = new Param("portid", (String)res.getPortidList().get(0));
            int size1 = res.getPortidList().size();
            for (j = 1; j < size1; ++j) {
                option = new Option((String)res.getPortidList().get(j));
                param.addOption(option);
            }
            rParams.addParam(param);
            param = new Param("portName", (String)res.getPortNameList().get(0));
            size1 = res.getPortNameList().size();
            for (j = 1; j < size1; ++j) {
                option = new Option((String)res.getPortNameList().get(j));
                param.addOption(option);
            }
            rParams.addParam(param);
            this.bParams.addRowParams(rParams);
        }
        this.datainterface.setBussinessParams(this.bParams);
        this.datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)0));
        return this.datainterface;
    }

    private void sortInSlot() {
        int rowCount = this.bParams.getRowParamsCount();
        for (int j = 0; j < rowCount; ++j) {
            int len = this.bParams.getRowParamsCount();
            for (int i = 0; i < len - j - 1; ++i) {
                RowParams rowparam = this.bParams.getRowParams(i);
                RowParams rowparamNext = this.bParams.getRowParams(i + 1);
                String slotid = rowparam.getParam("slotid").getValue();
                String slotnext = rowparamNext.getParam("slotid").getValue();
                if (Integer.parseInt(slotid) <= Integer.parseInt(slotnext)) continue;
                String tempslot = rowparam.getParam("slotid").getValue();
                String tempbdName = rowparam.getParam("boardName").getValue();
                String tempportid = rowparam.getParam("portid").getValue();
                String tempport = rowparam.getParam("portName").getValue();
                rowparam.getParam("slotid").setValue(rowparamNext.getParam("slotid").getValue());
                rowparam.getParam("boardName").setValue(rowparamNext.getParam("boardName").getValue());
                rowparam.getParam("portid").setValue(rowparamNext.getParam("portid").getValue());
                rowparam.getParam("portName").setValue(rowparamNext.getParam("portName").getValue());
                rowparamNext.getParam("slotid").setValue(tempslot);
                rowparamNext.getParam("boardName").setValue(tempbdName);
                rowparamNext.getParam("portid").setValue(tempportid);
                rowparamNext.getParam("portName").setValue(tempport);
            }
        }
    }

    private ArrayList getPortList(int neid, int slotid, int boardType) {
        ArrayList allPortList = this.cfgDataMgr.getBoardPortList(this.neID, boardType);
        return allPortList;
    }

    private ArrayList getExistPortList(ArrayList portList, int slotid) {
        try {
            ArrayList<Operation> operationList = new ArrayList<Operation>();
            Operation oper = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_CFG_SUBBD_GET_PORT");
            Input input = oper.getInput();
            Part part = input.getPart("slotid");
            part.setValue(String.valueOf(slotid));
            input.setPartValue("subslotid", INVALID_SUBSLOTID);
            input.setPartValue("port", "0");
            operationList.add(oper);
            ArrayList<Integer> returnList = new ArrayList<Integer>();
            if (operationList.size() == 0) {
                return returnList;
            }
            int result = TENECommMgr.getInstance().sendCommand((int)this.neID, operationList, (int)10).retCode;
            if (result == 0) {
                Operation oOperation = (Operation)operationList.get(0);
                for (Output output : oOperation.getOutput()) {
                    if (!String.valueOf(0).equals(output.getFault()[0].getCode())) continue;
                    String portId = output.getPartValue("port");
                    returnList.add(Integer.valueOf(portId));
                }
            }
            return returnList;
        }
        catch (Exception e) {
            return new ArrayList();
        }
    }

    public boolean isNeedOperationlog() {
        return false;
    }

    private void getProcessingBoard(int SubrackID) {
        TENE ne = TENEListMgr.getInstance().getNE(this.neID);
        Vector boardList = ne.getClonedBoardList();
        Collections.sort(boardList);
        int size = boardList.size();
        for (int i = 0; i < size; ++i) {
            TEBoard board = (TEBoard)boardList.get(i);
            int bdType = board.getBoardType();
            int slotid = board.getSlotID();
            if (TEBoardUtil.getSubrackIDFromSlot((int)this.neID, (int)slotid) != SubrackID || 1208 != bdType && 1564 != bdType && 1565 != bdType) continue;
            String boardName = slotid + "-" + this.cfgDataMgr.getBoardTypeName(this.neID, bdType);
            if (this.processingBoardList.contains(boardName)) break;
            this.processingBoardList.add(boardName);
            break;
        }
    }
}

