/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.reportform;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.ngwdm.reportform.TEBdReportUtil;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;

public abstract class TENEQueryBoardReportSuperBean
extends TENEExplorerBean {
    private static final String USER_NOT_LOGIN = "37926";
    private static final String BOARD_OUT_POSITION = "38669";
    private static final String BOARD_CANOT_HANDLE = "38754";
    private boolean allSuccess = true;
    private boolean allFail = true;
    String[] tempSccVerStr = new String[]{"/", "/", "/", "/", "/"};
    TENE ne;
    String neName;
    private Vector logicBoardList = new Vector();
    private ArrayList tempOperList = new ArrayList();
    private Vector physicsBoardList = new Vector();
    boolean sccFlg = false;
    private int succCount = 0;
    private int failCount = 0;
    private boolean userNotLogin = false;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            int i;
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            this.outputData.setBussinessParams(new BussinessParams());
            this.ne = TENEListMgr.getInstance().getNE(neid);
            if (this.ne.getLogStatus() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)37926));
                return this.outputData;
            }
            this.neName = this.ne.getNEName();
            int len = this.ne.getBoardList().size();
            for (i = 0; i < len; ++i) {
                this.logicBoardList.add(((TEBoard)this.ne.getBoardList().get(i)).clone());
            }
            if (this.logicBoardList == null || this.logicBoardList.size() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            Collections.sort(this.logicBoardList);
            len = this.ne.getPhyBoardList().size();
            for (i = 0; i < len; ++i) {
                this.physicsBoardList.add(((TEBoard)this.ne.getPhyBoardList().get(i)).clone());
            }
            if (this.physicsBoardList == null || this.physicsBoardList.size() == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            Collections.sort(this.physicsBoardList);
            len = this.logicBoardList.size();
            for (i = 0; i < len; ++i) {
                TEBoard board = (TEBoard)this.logicBoardList.get(i);
                if (board == null) continue;
                int slotID = board.getSlotID();
                this.operationList = this.getOperation(neid, subFunc, inputData, memeryData, board, slotID);
                int result = this.sendMessage(neid);
                if (result == 0) {
                    if (null == this.operationList || 0 == this.operationList.size()) continue;
                    this.tempOperList = (ArrayList)this.operationList.clone();
                    this.operationList.clear();
                    this.operationList = this.getSecondOperation(neid, subFunc, inputData, memeryData, board);
                    if (null != this.operationList && this.operationList.size() > 0) {
                        result = this.sendMessage(neid);
                        if (result != 0) {
                            ++this.failCount;
                        } else {
                            ++this.succCount;
                        }
                    }
                    this.handleMessage(neid, this.operationList, subFunc, board);
                    if (!this.userNotLogin) continue;
                    return this.outputData;
                }
                ++this.failCount;
                this.handleFirstQuery(slotID, result, board);
            }
            if (this.allSuccess && !this.allFail) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            } else if (!this.allSuccess && this.allFail) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
            } else if (!this.allSuccess && !this.allFail) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, TEBoard board, int slotID) {
        this.operationList = new ArrayList();
        Operation operation = null;
        Input input = null;
        Part part = null;
        if (!TEConfigurationDataMgr.getInstance().isSCCBoard(neid, board.getBoardType())) {
            if (!this.isPIUorFAN(board.getBoardType())) {
                operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_BD_VER");
                input = operation.getInput();
                part = input.getPart("slotID");
                part.setValue(Integer.toString(slotID));
                this.operationList.add(operation.clone());
                operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_BD_VERINFO");
                input = operation.getInput();
                part = input.getPart("slotID");
                part.setValue(Integer.toString(slotID));
                this.operationList.add(operation.clone());
            }
        } else if (!this.sccFlg) {
            operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_SYS_GET_NESOFT_VER");
            this.operationList.add(operation);
        }
        operation = TECreateObjectFactory.getOperation((int)neid, (String)this.get_NSCMD_CFG_GET_BDINFO());
        input = operation.getInput();
        input.getPart("slotID").setValue(String.valueOf(slotID));
        input.getPart("bagNum").setValue("0");
        this.operationList.add(operation.clone());
        return this.operationList;
    }

    public ArrayList getSecondOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, TEBoard board) {
        this.operationList = new ArrayList();
        Operation operation = null;
        Input input = null;
        operation = TECreateObjectFactory.getOperation((int)neid, (String)this.get_NSCMD_CFG_GET_BDINFO());
        input = operation.getInput();
        Operation tempOper = null;
        Output tempOutput = null;
        int len = this.tempOperList.size();
        for (int i = 0; i < len; ++i) {
            tempOper = (Operation)this.tempOperList.get(i);
            if (!tempOper.getName().equals(this.get_NSCMD_CFG_GET_BDINFO())) continue;
            tempOutput = tempOper.getOutput(0);
            if (!tempOutput.getFault(0).getCode().equals("0")) {
                ++this.failCount;
                break;
            }
            Part[] partArr = tempOutput.getPart();
            String tempSlotId = "";
            String tempBagTotal = "";
            boolean secondFlg = false;
            for (Part part : partArr) {
                String name = part.getName();
                String value = part.getValue();
                if (name.equals("bagTotal") && null != value) {
                    if (1 == Integer.parseInt(value)) {
                        secondFlg = false;
                        break;
                    }
                    if (Integer.parseInt(value) > 1) {
                        secondFlg = true;
                        tempBagTotal = value;
                    }
                }
                if (!name.equals("slotID") || null == value) continue;
                tempSlotId = value;
            }
            Part part = null;
            if (!secondFlg) continue;
            for (int j = 0; j < Integer.parseInt(tempBagTotal) - 1; ++j) {
                part = input.getPart("slotID");
                part.setValue(tempSlotId);
                part = input.getPart("bagNum");
                part.setValue(String.valueOf(j + 1));
                this.operationList.add(operation.clone());
            }
        }
        return this.operationList;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, TEBoard board) {
        Operation tempOperation = null;
        Output tempOutput = null;
        StringBuffer strBuf = null;
        String tempSoftVer = "/";
        RowParams rowparam = this.buildRowParams(neid, board);
        int tempLen = this.tempOperList.size();
        for (int i = 0; i < tempLen; ++i) {
            tempSoftVer = "/";
            strBuf = new StringBuffer();
            tempOperation = (Operation)this.tempOperList.get(i);
            if (tempOperation.getName().equals("NSCMD_CFG_GET_BD_VER")) {
                tempOutput = tempOperation.getOutput(0);
                this.handleBdVerParam(board, tempOperation, tempOutput, rowparam, tempSoftVer);
                if (!tempOutput.getFault(0).getCode().equals(USER_NOT_LOGIN)) continue;
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)Integer.parseInt(USER_NOT_LOGIN)));
                return;
            }
            if (tempOperation.getName().equals("NSCMD_CFG_GET_BD_VERINFO") && tempOperation.getOutputCount() > 0) {
                tempOutput = tempOperation.getOutput(0);
                this.handleGetbdverinfo(board, tempOperation, tempOutput, rowparam);
            }
            if (TEConfigurationDataMgr.getInstance().isSCCBoard(neid, board.getBoardType())) {
                this.handleSccBoard(this.sccFlg, board, tempOperation, rowparam);
            }
            if (!tempOperation.getName().equals(this.get_NSCMD_CFG_GET_BDINFO())) continue;
            String[] tempDetailArr = new String[]{"/", "/", "/"};
            if (tempOperation.getOutputCount() > 0) {
                tempOutput = tempOperation.getOutput(0);
                if (tempOutput.getFault(0).getCode().equals("0")) {
                    tempDetailArr = this.handleGetBDInfoCmdSucess(operationList, board, tempOutput, strBuf, tempDetailArr);
                } else if (tempOutput.getFault(0).getCode().equals(BOARD_CANOT_HANDLE) || tempOutput.getFault(0).getCode().equals(String.valueOf(45937)) || tempOutput.getFault(0).getCode().equals(String.valueOf(45898)) || tempOutput.getFault(0).getCode().equals(String.valueOf(45936))) {
                    this.allFail = false;
                } else {
                    if (tempOutput.getFault(0).getCode().equals(USER_NOT_LOGIN)) {
                        this.userNotLogin = true;
                        this.allSuccess = false;
                        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)Integer.parseInt(USER_NOT_LOGIN)));
                        return;
                    }
                    this.allSuccess = false;
                    this.handleErrorData(tempOperation, board);
                }
            }
            rowparam.getParam("boardStyle").setValue(tempDetailArr[0]);
            rowparam.getParam("boardBar").setValue(tempDetailArr[1]);
            rowparam.getParam("boardMemo").setValue(tempDetailArr[2]);
        }
        this.outputData.getBussinessParams().addRowParams(rowparam);
    }

    private String[] handleGetBDInfoCmdSucess(ArrayList operationList, TEBoard board, Output tempOutput, StringBuffer strBuf, String[] tempDetailArr) {
        int infoLen;
        byte[] infoByteArr = tempOutput.getPart("bdDetailInfo").getValue().getBytes();
        if (infoByteArr.length < (infoLen = Integer.parseInt(tempOutput.getPart("dataLength").getValue()))) {
            strBuf.append(new String(infoByteArr, 0, infoByteArr.length));
        } else {
            strBuf.append(new String(infoByteArr, 0, infoLen));
        }
        boolean strFlg = true;
        if (1 != Integer.parseInt(tempOutput.getPart("bagTotal").getValue())) {
            String tempSlotId = tempOutput.getPart("slotID").getValue();
            int outLen = operationList.size();
            for (int j = 0; j < outLen; ++j) {
                Operation operation = (Operation)operationList.get(j);
                Output output = operation.getOutput(0);
                if (null == output || null == output.getPart("slotID") || null == output.getPart("slotID").getValue() || !output.getPart("slotID").getValue().equals(tempSlotId)) continue;
                if (output.getFault(0).getCode().equals("0")) {
                    infoByteArr = output.getPart("bdDetailInfo").getValue().getBytes();
                    if (infoByteArr.length < (infoLen = Integer.parseInt(output.getPart("dataLength").getValue()))) {
                        strBuf.append(new String(infoByteArr, 0, infoByteArr.length));
                        continue;
                    }
                    strBuf.append(new String(infoByteArr, 0, infoLen));
                    continue;
                }
                this.handleErrorData(operation, board);
                strFlg = false;
                break;
            }
        }
        if (strFlg) {
            this.allFail = false;
            tempDetailArr = TEBdReportUtil.handleString(strBuf.toString());
        } else {
            this.allSuccess = false;
        }
        return tempDetailArr;
    }

    protected void handleSccBoard(boolean sccFlg, TEBoard board, Operation tempOperation, RowParams rowparam) {
        String[] tempVerStr = new String[]{"/", "/", "/", "/", "/"};
        if (!sccFlg && tempOperation.getName().equals("NSCMD_SYS_GET_NESOFT_VER")) {
            this.tempSccVerStr = TEBdReportUtil.querySccVer(tempOperation);
        }
        if (TEBdReportUtil.isAtPosition(board, this.physicsBoardList)) {
            tempVerStr = this.tempSccVerStr;
        }
        rowparam.getParam("softwareEdition").setValue(tempVerStr[0]);
        rowparam.getParam("biosEdition").setValue(tempVerStr[1]);
        if (!tempVerStr[2].equals("/")) {
            rowparam.getParam("logicEdition").setValue(tempVerStr[2]);
        } else {
            rowparam.getParam("logicEdition").setValue(tempVerStr[3]);
        }
        rowparam.getParam("pcbEdition").setValue(tempVerStr[4]);
    }

    private void handleGetbdverinfo(TEBoard board, Operation tempOperation, Output tempOutput, RowParams rowparam) {
        String[] tempVerStr = new String[]{"/", "/", "/", "/", "/"};
        if (tempOutput.getFault(0).getCode().equals("0")) {
            this.allFail = false;
            tempVerStr = TEBdReportUtil.bdVersionParse(tempOutput.getPart("bdVersionStr").getValue());
        } else {
            this.allSuccess = false;
            if (!tempOutput.getFault(0).getCode().equals(BOARD_OUT_POSITION)) {
                this.handleErrorData(tempOperation, board);
            } else {
                this.allSuccess = true;
            }
        }
        rowparam.getParam("biosEdition").setValue(tempVerStr[0]);
        if (!tempVerStr[1].equals("/")) {
            rowparam.getParam("logicEdition").setValue(tempVerStr[1]);
        } else {
            rowparam.getParam("logicEdition").setValue(tempVerStr[2]);
        }
        rowparam.getParam("pcbEdition").setValue(tempVerStr[3]);
        if (!tempVerStr[4].equals("/")) {
            rowparam.getParam("softwareEdition").setValue(tempVerStr[4]);
        }
    }

    private RowParams buildRowParams(int neid, TEBoard board) {
        RowParams rowparam = new RowParams();
        Param param = new Param("serialNum", "");
        rowparam.addParam(param);
        param = new Param("slotID", String.valueOf(board.getSlotID()));
        rowparam.addParam(param);
        param = new Param("boardname", board.getBoardName());
        rowparam.addParam(param);
        String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)board.getSlotID());
        if (subrackName != null && !subrackName.equals("")) {
            param = new Param("shelfName", subrackName);
            rowparam.addParam(param);
        }
        param = TEBdReportUtil.isAtPosition(board, this.physicsBoardList) ? new Param("boardStatus", "1") : new Param("boardStatus", "0");
        rowparam.addParam(param);
        param = new Param("boardStyle", "/");
        rowparam.addParam(param);
        param = new Param("boardBar", "/");
        rowparam.addParam(param);
        param = new Param("boardMemo", "/");
        rowparam.addParam(param);
        param = new Param("softwareEdition", "/");
        rowparam.addParam(param);
        param = new Param("biosEdition", "/");
        rowparam.addParam(param);
        param = new Param("logicEdition", "/");
        rowparam.addParam(param);
        param = new Param("pcbEdition", "/");
        rowparam.addParam(param);
        return rowparam;
    }

    private void handleBdVerParam(TEBoard board, Operation tempOperation, Output tempOutput, RowParams rowparam, String tempSoftVer) {
        if (tempOutput.getFault(0).getCode().equals("0")) {
            this.allFail = false;
            if (!tempOutput.getPart("softVerHighBit").getValue().equals("") && !tempOutput.getPart("softVerLowBit").getValue().equals("")) {
                String softVerLowBit = tempOutput.getPart("softVerLowBit").getValue();
                if (softVerLowBit.length() < 2 && !softVerLowBit.equals("0")) {
                    softVerLowBit = "0" + softVerLowBit;
                }
                tempSoftVer = tempOutput.getPart("softVerHighBit").getValue() + "." + softVerLowBit;
            }
        } else {
            this.allSuccess = false;
            if (!tempOutput.getFault(0).getCode().equals(BOARD_OUT_POSITION)) {
                this.handleErrorData(tempOperation, board);
            } else {
                this.allSuccess = true;
            }
        }
        if (rowparam.getParam("softwareEdition") == null) {
            Param param = new Param("softwareEdition", tempSoftVer);
            rowparam.addParam(param);
        } else {
            rowparam.getParam("softwareEdition").setValue(tempSoftVer);
        }
    }

    private void handleErrorData(Operation tempOper, TEBoard board) {
        String errorCode = "";
        errorCode = tempOper.getOutput(0).getFault(0).getCode();
        RowErrors rowError = new RowErrors();
        ErrorMessage errorMessage = new ErrorMessage();
        Param errorparam = null;
        errorMessage.setErrorcode(errorCode);
        errorMessage.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot((int)Integer.parseInt(errorCode)));
        rowError.setErrorMessage(errorMessage);
        errorparam = new Param("neid", String.valueOf(this.neid));
        rowError.addParam(errorparam);
        errorparam = new Param("nename", this.ne.getNEName());
        rowError.addParam(errorparam);
        String slotID = tempOper.getInput().getPartValue("slotID");
        String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)Integer.parseInt(slotID));
        if (subrackName != null && !subrackName.equals("")) {
            slotID = subrackName + "-" + TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)Integer.parseInt(slotID));
        }
        errorparam = new Param("slotID", slotID);
        rowError.addParam(errorparam);
        errorparam = new Param("boardname", board.getBoardName());
        rowError.addParam(errorparam);
        RowParams rowparams = new RowParams();
        rowparams.addRowErrors(rowError);
        this.outputData.getBussinessParams().addRowParams(rowparams);
    }

    private void handleFirstQuery(int slotID, int result, TEBoard board) {
        RowParams rowparam = new RowParams();
        Param param = null;
        param = new Param("slotID", "" + slotID);
        rowparam.addParam(param);
        String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotID);
        if (subrackName != null && !subrackName.equals("")) {
            param = new Param("shelfName", subrackName);
            rowparam.addParam(param);
        }
        param = TEBdReportUtil.isAtPosition(board, this.physicsBoardList) ? new Param("boardStatus", "1") : new Param("boardStatus", "0");
        rowparam.addParam(param);
        String value = "/";
        param = new Param("boardStyle", value);
        rowparam.addParam(param);
        param = new Param("boardBar", value);
        rowparam.addParam(param);
        param = new Param("softwareEdition", value);
        rowparam.addParam(param);
        param = new Param("biosEdition", value);
        rowparam.addParam(param);
        param = new Param("logicEdition", value);
        rowparam.addParam(param);
        param = new Param("pcbEdition", value);
        rowparam.addParam(param);
        param = new Param("boardMemo", value);
        rowparam.addParam(param);
        value = board.getBoardName();
        param = new Param("boardname", value);
        rowparam.addParam(param);
        this.handleErrorData(slotID, result, rowparam, value);
        this.outputData.getBussinessParams().addRowParams(rowparam);
    }

    private void handleErrorData(int slotID, int result, RowParams rowparams, String boardname) {
        String errorCode = "" + result;
        RowErrors rowError = new RowErrors();
        ErrorMessage errorMessage = new ErrorMessage();
        Param errorparam = null;
        errorMessage.setErrorcode(errorCode);
        errorMessage.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot((int)Integer.parseInt(errorCode)));
        rowError.setErrorMessage(errorMessage);
        errorparam = new Param("neid", String.valueOf(this.neid));
        rowError.addParam(errorparam);
        errorparam = new Param("nename", this.neName);
        rowError.addParam(errorparam);
        String slotIDs = slotID + "";
        String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotID);
        if (subrackName != null && !subrackName.equals("")) {
            slotIDs = subrackName + "-" + TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slotID);
        }
        errorparam = new Param("slotID", slotIDs);
        rowError.addParam(errorparam);
        errorparam = new Param("boardname", boardname);
        rowError.addParam(errorparam);
        rowparams.addRowErrors(rowError);
    }

    public boolean isPIUorFAN(int boardType) {
        if (TESpecialAttrMgr.getInstance().isCPSupportByType(boardType, "TE_FUNC_CFG_BOARDINFO_REPORT", "REPORT_ATTR_NOSUPPORT_BDVER")) {
            return true;
        }
        if (TEConfigurationDataMgr.getInstance().isFanboard(boardType)) {
            return true;
        }
        return boardType == 1354 || boardType == 1355 || boardType == 1356 || boardType == 1357;
    }

    public boolean isNeedOperationlog() {
        return true;
    }

    protected abstract String get_NSCMD_CFG_GET_BDINFO();
}

