/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.prbs;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.gencfg.TEGenCfgCommon;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.channel.QueryWDMMode;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgAttribute;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgModel;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgPortAttribute;
import com.huawei.nglct.nemgr.necommon.netimelocalization.TENETimeUtility;
import com.huawei.nglct.nemgr.ngwdm.prbs.TEPRBSCache;
import com.huawei.nglct.nemgr.ngwdm.prbs.TEPRBSData;
import com.huawei.nglct.nemgr.ngwdm.prbs.TEPRBSUtility;
import com.huawei.nglct.util.device.board.TEQueryBoardInfoBean;
import com.huawei.nglct.util.device.port.TEVirtualPortUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TEPRBSTableInitBean
extends TENEExplorerBean {
    private int slotid = 0;
    private static final int BOARD_TYPE_12LQMS = 1185;
    private static final int BOARD_TYPE_11TOM = 1194;
    public static final int BOARD_MODE_CONNECT = 162;
    public static final int BOARD_MODE_ALONE = 163;
    public static final int BOARD_MODE_NS1 = 164;
    public static final int BOARD_MODE_RELAY = 169;
    public static final int BOARD_MODE_OPTICALRELAY = 170;
    private static final int BOARD_TYPE_52TOM = 1573;
    private List<String> bdModeSpList = new ArrayList<String>();
    private List<String> portModeSpList = new ArrayList<String>();

    /*
     * Enabled aggressive block sorting
     */
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        RowParams rowpara = inputData.getBussinessParams().getRowParams(0);
        BussinessParams bussiness = new BussinessParams();
        this.outputData = new Datainterface();
        Param para = rowpara.getParam("slotid");
        RowParams rowdata = null;
        TEPRBSData testdata = null;
        String hashvalue = null;
        TEGenCfgPortAttribute portObj = null;
        int portid = -1;
        this.slotid = Integer.parseInt(para.getValue());
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(neid, this.slotid);
        TEGenCfgModel genCfgModel = TEGenCfgDataMgr.getGenCfgMode((int)board.getBoardType());
        if (null == genCfgModel) {
            TELogFactory.getNormalLogger().error("the gencfgmodel of the board is not exist");
            this.outputData.setBussinessParams(bussiness);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
            return this.outputData;
        }
        TEGenCfgAttribute attrObj = genCfgModel.getAttrFromId("W32PORT_ATTR_PRBSTEST");
        if (null == attrObj) {
            TELogFactory.getNormalLogger().error("the TEGenCfgAttribute of the board is not exist");
            this.outputData.setBussinessParams(bussiness);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
            return this.outputData;
        }
        ArrayList portList = attrObj.getPortList();
        if (null == portList || 0 == portList.size()) {
            TELogFactory.getNormalLogger().error("there is not port");
            this.outputData.setBussinessParams(bussiness);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
            return this.outputData;
        }
        ArrayList<Integer> slotIdList = new ArrayList<Integer>();
        slotIdList.add(this.slotid);
        TEQueryBoardInfoBean.queryBoardInfo((int)neid, slotIdList);
        int boardMode = this.getBoardMode();
        HashMap nePortPathMap = TEConfigurationDataMgr.getInstance().getBoardPortPathMap(neid, 1573, this.slotid);
        HashMap portModeMap = this.queryPortMode(board.getBoardType());
        ArrayList logicPortList = TEConfigurationDataMgr.getInstance().getLogicPortList(neid, this.slotid);
        this.bdModeSpList.addAll(TESpecialAttrMgr.getInstance().getCPAttrListValue(neid, this.slotid, "TE_FUNC_CFG_NGWDM_PRBS", "OTN_PRBS_NOTSUPPORT_PORTSANDPATHS_ONSPECIAL_BOARDMODE"));
        this.portModeSpList.addAll(TESpecialAttrMgr.getInstance().getCPAttrListValue(neid, this.slotid, "TE_FUNC_CFG_NGWDM_PRBS", "OTN_PRBS_NOTSUPPORT_PORTSANDPATHS_ONSPECIAL_PORTMODE"));
        int portMode = -1;
        int i = 0;
        int len = portList.size();
        while (true) {
            block16: {
                block17: {
                    if (i >= len) {
                        this.outputData.setBussinessParams(bussiness);
                        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
                        return this.outputData;
                    }
                    portObj = (TEGenCfgPortAttribute)portList.get(i);
                    portid = portObj.getPort();
                    if (TEVirtualPortUtil.isMSOTNBoard((int)board.getBoardType()) && TEVirtualPortUtil.getVPortsByPortType((int)board.getBoardType(), (int)63210).contains(portid)) break block16;
                    if (null == logicPortList || logicPortList.contains(portid)) break block17;
                    TELogFactory.getNormalLogger().info("The port is not exist! portid->" + portid);
                    break block16;
                }
                switch (board.getBoardType()) {
                    case 1541: 
                    case 1566: 
                    case 2208: 
                    case 2209: 
                    case 2211: 
                    case 2281: 
                    case 2293: 
                    case 2294: 
                    case 2309: 
                    case 2310: 
                    case 2311: 
                    case 2424: 
                    case 2425: 
                    case 2502: 
                    case 2503: 
                    case 2948: 
                    case 2950: {
                        if (boardMode != 169 && boardMode != 170) break;
                        break block16;
                    }
                    case 1573: {
                        if (nePortPathMap.containsKey(portid) && ((List)nePortPathMap.get(portid)).contains(portObj.getPath())) break;
                        break block16;
                    }
                    case 1185: {
                        if (boardMode != 164 || portid < 201) break;
                        break block16;
                    }
                    case 1194: {
                        if (!(boardMode == 162 && (portid == 51 && portObj.getPath() != 1 || portid > 201 || portid > 51 && portid <= 54)) && (boardMode != 163 || (portid < 51 || portid > 54 || portObj.getPath() == 1) && (portid != 201 && portid != 203 || portObj.getPath() <= 4) && (portid != 202 && portid != 204 || portObj.getPath() <= 2))) break;
                        break block16;
                    }
                    case 2279: 
                    case 2280: 
                    case 2481: 
                    case 2482: 
                    case 2508: 
                    case 2595: {
                        portMode = (Integer)portModeMap.get(portid);
                        if (!(portMode == 1 ? portObj.getPath() > 2 : portMode == 65535 || portMode != 260 && portObj.getPath() > 1)) break;
                        break block16;
                    }
                    case 3045: 
                    case 3047: {
                        if (!TEPRBSTableInitBean.getIsCurrentPayloadType(neid, this.slotid, portid)) break block16;
                    }
                }
                if (this.checkValidByConfMode(boardMode, portMode, this.slotid, portid, portObj.getPath())) {
                    hashvalue = TEPRBSUtility.getPortName(neid, this.slotid, portid, portObj.getPath());
                    testdata = TEPRBSCache.getInstance().getCahce(hashvalue);
                    if (testdata == null) {
                        rowdata = this.getBlankData(portid, portObj.getPath());
                        rowdata.addParam("path", String.valueOf(portObj.getPath()));
                    } else {
                        rowdata = this.getSaveData(testdata);
                    }
                    bussiness.addRowParams(rowdata);
                }
            }
            ++i;
        }
    }

    private HashMap queryPortMode(int boardType) {
        if (boardType == 2280 || boardType == 2279 || boardType == 2481 || boardType == 2482 || boardType == 2589 || boardType == 2595 || boardType == 2508 || TESpecialAttrMgr.getInstance().isCPSupportByType(boardType, "TE_FUNC_CFG_NGWDM_PRBS", "OTN_ATTR_SUPPORT_PORTMODE")) {
            return QueryWDMMode.queryPortMode((int)this.neid, (int)this.slotid);
        }
        return null;
    }

    private int getBoardMode() {
        if (TEGenCfgCommon.isSupportAttr((int)this.neid, (int)this.slotid, (String)"W32BD_ATTR_SUBBDTYPE")) {
            Output temp;
            ArrayList<Operation> list = new ArrayList<Operation>();
            Operation oper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_CFG_GET_SUBBDTYPE");
            oper.getInput().getPart("slotid").setValue(String.valueOf(this.slotid));
            list.add(oper);
            int result = this.sendMessage(this.neid, list);
            if (result == 0 && (temp = oper.getOutput(0)).getFault(0).getCode().equals("0")) {
                return Integer.parseInt(temp.getPart("W32BD_ATTR_SUBBDTYPE").getValue());
            }
        }
        return -1;
    }

    private RowParams getBlankData(int portid, int path) {
        RowParams param = new RowParams();
        String portname = TEPRBSUtility.getPortName(this.neid, this.slotid, portid, path);
        param.addParam("portid", portid + "");
        param.addParam("portname", portname);
        param.addParam("channel", "-");
        param.addParam("timeunit", "1");
        param.addParam("testtime", "1");
        param.addParam("starttime", "-");
        param.addParam("progress", "0%");
        param.addParam("totalErrNum", "0");
        param.addParam("isaccu", "0");
        param.addParam("teststate", "0");
        return param;
    }

    private RowParams getSaveData(TEPRBSData testdata) {
        this.handledata(testdata);
        RowParams param = new RowParams();
        String portname = TEPRBSUtility.getPortName(this.neid, this.slotid, testdata.getPortid(), testdata.getPath());
        param.addParam("portid", testdata.getPortid() + "");
        param.addParam("portname", portname);
        param.addParam("path", testdata.getPath() + "");
        param.addParam("timeunit", testdata.getTimeUnit() + "");
        param.addParam("testtime", testdata.getTesttime() + "");
        param.addParam("starttime", testdata.getStartTime());
        param.addParam("progress", testdata.getProgress() + "%");
        param.addParam("totalErrNum", testdata.getTotalErrNum() + "");
        param.addParam("isaccu", testdata.isAccumulation() + "");
        param.addParam("teststate", testdata.getTeststate() + "");
        return param;
    }

    private void handledata(TEPRBSData testdata) {
        long totaltesttime;
        if (testdata.getTeststate() == 0) {
            return;
        }
        int timeUnit = testdata.getTimeUnit();
        int abletime = 0;
        abletime = timeUnit == 1 ? 25000 : 900000;
        long currenttime = TENETimeUtility.getNmsUTCTime() + testdata.getNeToNmsTime();
        long starttime = testdata.getStartTimeToLong();
        if (starttime + (totaltesttime = testdata.getTotalTesttimeInMillisecond()) + (long)abletime < currenttime) {
            testdata.setProgress(100);
            testdata.setTeststate(0);
            return;
        }
        long lastreporttime = testdata.getLastreportTime();
        if (lastreporttime == 0L && testdata.getQueryList().size() <= 0) {
            testdata.setTeststate(1);
            return;
        }
    }

    public boolean isNeedOperationlog() {
        return false;
    }

    private boolean checkValidByConfMode(int bdMode, int portMode, int slotid, int portid, int path) {
        boolean result = true;
        if (this.bdModeSpList.isEmpty() && this.portModeSpList.isEmpty()) {
            return result;
        }
        if (!this.bdModeSpList.isEmpty() && bdMode != -1) {
            result = this.getCheckResult(this.bdModeSpList, bdMode, slotid, portid, path);
        }
        if (!this.portModeSpList.isEmpty() && portMode != -1) {
            result = this.getCheckResult(this.portModeSpList, portMode, slotid, portid, path);
        }
        return result;
    }

    private boolean getCheckResult(List<String> modeStrList, int mode, int slotid, int portid, int path) {
        boolean result = true;
        try {
            ArrayList<String> paths = new ArrayList<String>();
            for (String str : modeStrList) {
                if (str.indexOf("(") == -1 && Integer.parseInt(str) == mode) {
                    result = false;
                } else {
                    String tempStr;
                    int index;
                    String tempPort;
                    String modeStr = str.substring(0, str.indexOf("("));
                    if (!modeStr.equals(mode + "") || !"0".equals(tempPort = (index = (tempStr = str.substring(str.indexOf("(") + 1, str.lastIndexOf(")"))).indexOf("{")) == -1 ? tempStr : tempStr.substring(0, tempStr.indexOf("{"))) && !(portid + "").equals(tempPort)) continue;
                    if ("0".equals(tempPort)) {
                        result = false;
                    } else {
                        if (index == -1) continue;
                        if ("0".equals(tempStr = tempStr.substring(tempStr.indexOf("{") + 1, tempStr.lastIndexOf("}")))) {
                            result = false;
                        } else {
                            String[] tempArr = tempStr.split(";");
                            int len = tempArr.length;
                            for (int i = 0; i < len; ++i) {
                                paths.add(tempArr[i]);
                            }
                            if (!paths.contains("" + path)) continue;
                            result = false;
                        }
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("parse failed!", (Throwable)e);
        }
        return result;
    }

    private static boolean getIsCurrentPayloadType(int neID, int slotID, int port) {
        try {
            Operation oper = TECreateObjectFactory.getOperation((int)neID, (String)"NSCMD_CFG_GET_PAYLOADTYPE");
            Input input = oper.getInput();
            Part part = input.getPart("slotid");
            part.setValue(String.valueOf(slotID));
            part = input.getPart("port");
            part.setValue(String.valueOf(port));
            part = input.getPart("path");
            part.setValue("1");
            ArrayList<Operation> operationList = new ArrayList<Operation>();
            operationList.add(oper);
            int result = TENECommMgr.getInstance().sendCommand((int)neID, operationList, (int)60).retCode;
            if (result == 0) {
                Output[] outputArr = ((Operation)operationList.get(0)).getOutput();
                for (int j = 0; j < outputArr.length; ++j) {
                    if (outputArr[j].getFaultCount() <= 0 || Integer.parseInt(outputArr[j].getFault(0).getCode()) != 0) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse Qx description file fail!", (Throwable)e);
        }
        return false;
    }
}

