/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.prbs;

import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.necommon.TEOperationLogUtility;
import com.huawei.nglct.nemgr.necommon.netimelocalization.TENETimeUtility;
import com.huawei.nglct.nemgr.ngwdm.prbs.TEPRBSCache;
import com.huawei.nglct.nemgr.ngwdm.prbs.TEPRBSData;
import com.huawei.nglct.nemgr.ngwdm.prbs.TEPRBSUtility;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.datetime.TEDateUtils;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;

public class TEPRBSQueryBean
extends TENEExplorerBean {
    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        TEOperationLogUtility.setOperaStr((String)this.getOperaStr());
        TEOperationLogUtility.writeLog((int)neid, (SubFunc)subfunc, (Datainterface)inputData, (String)user, (String)ipAddress, (Datainterface)outputData);
    }

    private String getOperaStr() {
        StringBuffer filePath1 = new StringBuffer("ngwdm").append(File.separator).append("res").append(File.separator).append("prbs").append(File.separator).append("prbsres_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil resourceUtil = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath1);
        String dese = "";
        RowParams rowpara = this.inputData.getBussinessParams().getRowParams(0);
        Param para = rowpara.getParam("slotid");
        int slotid = Integer.parseInt(para.getValue());
        para = rowpara.getParam("portid");
        int portid = Integer.parseInt(para.getValue());
        dese = dese + resourceUtil.getString("slot") + slotid + "," + resourceUtil.getString("port") + portid;
        return dese;
    }

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        this.operationList = TENETimeUtility.appendNEDateTimeOperation((int)neid, (ArrayList)TEDataConverter.convertToOperation((SubFunc)subFunc, (Datainterface)inputData, (int)neid));
        return this.operationList;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        long neTime = TENETimeUtility.getNEDateTime((int)neid, (ArrayList)operationList);
        Operation operation = (Operation)operationList.get(0);
        Output[] outputArr = operation.getOutput();
        TEPRBSData testdata = null;
        int len = outputArr.length;
        for (int j = 0; j < len; ++j) {
            Output output = outputArr[j];
            int retCode = new Integer(output.getFault()[0].getCode());
            if (retCode == 38662) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
                return;
            }
            if (retCode != 0) {
                this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList);
                return;
            }
            int teststatus = Integer.parseInt(output.getPart("testStatus").getValue());
            if (j == 0) {
                int testtime;
                testdata = new TEPRBSData(neid);
                int slotid = Integer.parseInt(output.getPart("slotid").getValue());
                testdata.setSlotid(slotid);
                int portid = Integer.parseInt(output.getPart("portid").getValue());
                testdata.setPortid(portid);
                int path = Integer.parseInt(output.getPart("path").getValue());
                testdata.setPath(path);
                int timeunit = Integer.parseInt(output.getPart("timeWay").getValue());
                testdata.setTimeUnit(timeunit);
                Calendar startTime = TEDateUtils.byteStrToCalendar((String)output.getPart("startTime").getValue());
                if (null != startTime) {
                    testdata.setStartTime(startTime.getTimeInMillis());
                }
                if ((testtime = Integer.parseInt(output.getPart("totalPeriodNum").getValue())) == 0) {
                    testtime = 1;
                }
                testdata.setTesttime(testtime);
                testdata.setNeToNmsTime(neTime - TENETimeUtility.getNmsUTCTime());
                if (teststatus == 0) {
                    testdata.setProgress(100);
                }
                testdata.setTeststate(teststatus);
                String hashvalue = TEPRBSUtility.getPortName(neid, slotid, portid, path);
                TEPRBSCache.getInstance().addCahce(hashvalue, testdata);
            }
            int firstpoint = Integer.parseInt(output.getPart("periodNumTested").getValue());
            Part p = output.getPart("errCodeNum");
            String value = p.getValue();
            long errnum = Long.parseLong(value);
            p = output.getPart("prbsLos");
            long prbslosNum = 0L;
            if (null != p && !p.getValue().equals("")) {
                prbslosNum = Long.parseLong(p.getValue());
            }
            if (errnum < 0L) {
                errnum = 0L;
            }
            if (teststatus != 0) {
                TEPRBSUtility.registerListener(neid, TEPRBSUtility.getPortName(neid, testdata.getSlotid(), testdata.getPortid(), testdata.getPath()));
            }
            testdata.setTeststate(teststatus);
            testdata.addQueryResult(errnum, firstpoint, prbslosNum);
        }
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
    }
}

