/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.powergraphmgr;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.io.File;
import java.util.ArrayList;

public class TESetPowerConfigurationBean
extends TENEExplorerBean {
    public static final String NSCMD_CFG_SET_EXTPOWER = "NSCMD_CFG_SET_EXTPOWER";

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Operation operation = TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_CFG_SET_EXTPOWER);
        Input input = operation.getInput();
        RowParams[] inputrows = inputData.getBussinessParams().getRowParams();
        RowParams row = inputrows[0];
        Param para = row.getParam("subrackID");
        if (!this.isParamValid(para)) {
            TELogFactory.getNormalLogger().error("SubrackID is NULL or is invalid");
            return null;
        }
        String subrackIDStr = para.getValue();
        input.getPart("subrackID").setValue(subrackIDStr);
        para = row.getParam("extPowerNum");
        if (!this.isParamValid(para)) {
            TELogFactory.getNormalLogger().error("Power Num is NULL or is invalid");
            return null;
        }
        input.getPart("extPowerNum").setValue(para.getValue());
        StringBuffer strBuf = new StringBuffer();
        int len = inputData.getBussinessParams().getRowParamsCount();
        String subrackIDHextStr = Integer.toHexString(Integer.parseInt(subrackIDStr));
        subrackIDHextStr = this.createComplteHexStr(subrackIDHextStr, 2);
        for (int i = 1; i < len; ++i) {
            RowParams rowparams = inputrows[i];
            Param pCurrent = rowparams.getParam("currentValue");
            Param pSrcSlot = rowparams.getParam("srcSlotID");
            Param pSnkSlot = rowparams.getParam("snkSlotID");
            if (!(this.isParamValid(pCurrent) && this.isParamValid(pSrcSlot) && this.isParamValid(pSnkSlot))) {
                TELogFactory.getNormalLogger().error("parameter is null or invalid");
                continue;
            }
            String str = pCurrent.getValue();
            String hexStr = Integer.toHexString(Integer.parseInt(str));
            strBuf.append(this.createComplteHexStr(hexStr, 4));
            str = pSrcSlot.getValue();
            hexStr = Integer.toHexString(Integer.parseInt(str));
            strBuf.append(subrackIDHextStr);
            strBuf.append(this.createComplteHexStr(hexStr, 2));
            str = pSnkSlot.getValue();
            hexStr = Integer.toHexString(Integer.parseInt(str));
            if (hexStr.equals("0")) {
                strBuf.append(this.createComplteHexStr(hexStr, 4));
                continue;
            }
            strBuf.append(subrackIDHextStr);
            strBuf.append(this.createComplteHexStr(hexStr, 2));
        }
        input.getPart("currentList").setValue(strBuf.toString());
        operationList.add(operation);
        return operationList;
    }

    public String getDetailStr(RowParams rowparams) {
        String lan = TESysManagerBean.getInstance().getlanguage();
        StringBuffer filePath = new StringBuffer();
        filePath.append("ngwdm").append(File.separator).append("res").append(File.separator).append("powergraphmgr").append(File.separator).append("powergraphres_").append(lan).append(".ini");
        TEResourceUtil resourceUtil = TEGetFilePath.getResource((int)this.neid, (String)filePath.toString());
        StringBuffer operDesc = new StringBuffer();
        operDesc.append(resourceUtil.getString("TECMDCODE_SET_POWER_CONFIG")).append(", ");
        Param param = rowparams.getParam("subrackID");
        if (null != param) {
            String subrackIDStr = param.getValue();
            operDesc.append(resourceUtil.getString("subrackID")).append(':').append(subrackIDStr).append(' ');
        }
        if (null != (param = rowparams.getParam("extPowerNum"))) {
            String numStr = param.getValue();
            operDesc.append(resourceUtil.getString("extPowerNum")).append(':').append(numStr).append(' ');
        }
        param = rowparams.getParam("currentValue");
        String currentValue = "";
        String slotID = "";
        if (null != param) {
            currentValue = param.getValue();
            operDesc.append(resourceUtil.getString("currentValue")).append(':').append(currentValue).append(' ');
        }
        if (null != (param = rowparams.getParam("srcSlotID"))) {
            slotID = param.getValue();
            operDesc.append(resourceUtil.getString("srcSlotID")).append(':').append(slotID).append(' ');
        }
        if (null != (param = rowparams.getParam("snkSlotID"))) {
            slotID = param.getValue();
            operDesc.append(resourceUtil.getString("snkSlotID")).append(':').append(slotID).append(' ');
        }
        return operDesc.toString();
    }

    private String createComplteHexStr(String hexStr, int length) {
        String outStr = "";
        int len = hexStr.length();
        if (len < length) {
            StringBuffer strBuf = new StringBuffer();
            int count = length - len;
            for (int i = 0; i < count; ++i) {
                strBuf.append("0");
            }
            strBuf.append(hexStr);
            outStr = strBuf.toString();
        } else {
            outStr = len == length ? hexStr : hexStr.substring(len - length);
        }
        return outStr;
    }

    private boolean isParamValid(Param param) {
        return null != param && null != param.getValue() && !param.getValue().equals("");
    }
}

