/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.powergraphmgr;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.gencfg.TEGenCfgCommon;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ngwdm.powergraphmgr.ConfigInfoObj;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class TEQueryPowerConfigurationBean
extends TENEExplorerBean {
    private static final int TYPE_PHYSICAL = 0;
    private static final int TYPE_LOGIC = 1;
    private static final String NSCMD_CFG_GET_EXTPOWER = "NSCMD_CFG_GET_EXTPOWER";
    private static final String NSCMD_CFG_GET_LOGIC_USEDPOWER = "NSCMD_CFG_GET_LOGIC_USEDPOWER";
    private static final String NSCMD_CFG_GET_USEDPOWER = "NSCMD_CFG_GET_USEDPOWER";
    private static final String KEY_SUBRACK_ID = "subrackID";
    private static final String KEY_SUBRACK_TYPE = "subrackType";
    private static final String KEY_QUERY_TYPE = "queryType";
    private static final int INVALID_INDEX = -1;
    private static final int BOARD_OFFSET = 65536;
    private static final String NGWDM_ATTR_PIUBOARD = "NGWDM_ATTR_PIUBOARD";
    private TENE ne = null;
    private Vector logicBoardList = new Vector();
    private Map<Integer, Integer> usedPowerMap = new HashMap<Integer, Integer>();
    private int subrackID = 0;
    private int subrackType = 111;
    private int type = 0;
    private int minPiuSlotID = 100;
    private int maxPiuSlotID = 110;
    private int middlePiuSlotID = 105;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.ne = TENEListMgr.getInstance().getNE(neid);
        BussinessParams businessparams = inputData.getBussinessParams();
        RowParams rowparams = businessparams.getRowParams(0);
        this.getQueryType(rowparams);
        int subrackType = this.getSubrackType(rowparams);
        this.initIndexRange(subrackType);
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.outputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        this.outputData.setBussinessParams(bussiness);
        RowParams rowParams = new RowParams();
        Param pIndex = new Param("boardIndexList", this.getAddedPiuBoardIndexList());
        rowParams.addParam(pIndex);
        bussiness.addRowParams(rowParams);
        this.getUsedPowerByPiuBoard(operationList);
        this.toRowParams(neid, operationList, bussiness);
        this.handleErrorMessage(bussiness);
    }

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        this.subfunc.clearQxMapping();
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Operation oper = TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_CFG_GET_EXTPOWER);
        oper.getInput().getPart(KEY_SUBRACK_ID).setValue(String.valueOf(this.subrackID));
        operationList.add(0, oper);
        Operation operation = null;
        switch (this.type) {
            case 1: {
                operation = TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_CFG_GET_LOGIC_USEDPOWER);
                break;
            }
            default: {
                operation = TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_CFG_GET_USEDPOWER);
            }
        }
        Input input = operation.getInput();
        input.getPart(KEY_SUBRACK_ID).setValue(String.valueOf(this.subrackID));
        operationList.add(1, operation);
        return operationList;
    }

    private void toRowParams(int neid, ArrayList operationList, BussinessParams bussiness) {
        List<ConfigInfoObj> infoList = this.getConfigInfoList(operationList);
        int count = infoList.size();
        for (int k = 0; k < count; ++k) {
            ConfigInfoObj infoObj = infoList.get(k);
            RowParams rowParam = new RowParams();
            Param pCurrent = new Param("currentValue", String.valueOf(infoObj.currentValue));
            rowParam.addParam(pCurrent);
            Param psrcSlot = new Param("srcSlotID", String.valueOf(infoObj.srcSlotID));
            rowParam.addParam(psrcSlot);
            Param psnkSlot = new Param("snkSlotID", String.valueOf(infoObj.snkSlotID));
            rowParam.addParam(psnkSlot);
            Param pSrcIndex = new Param("srcIndex", String.valueOf(infoObj.srcIndex));
            rowParam.addParam(pSrcIndex);
            Param pSnkIndex = new Param("snkIndex", String.valueOf(infoObj.snkIndex));
            rowParam.addParam(pSnkIndex);
            Param pSrcPower = new Param("srcUsedPower", String.valueOf(infoObj.srcUsedPower));
            rowParam.addParam(pSrcPower);
            Param pSnkPower = new Param("snkUsedPower", String.valueOf(infoObj.snkUsedPower));
            rowParam.addParam(pSnkPower);
            Param pTotalPower = new Param("usedPower", String.valueOf(infoObj.usedPower));
            rowParam.addParam(pTotalPower);
            Param pExsit = new Param("hasConnect", String.valueOf(infoObj.hasConnect));
            rowParam.addParam(pExsit);
            bussiness.addRowParams(rowParam);
        }
    }

    private void handleErrorMessage(BussinessParams bussiness) {
        boolean allFail = true;
        boolean allSucc = true;
        int len = this.operationList.size();
        for (int i = 0; i < len; ++i) {
            Operation oper = (Operation)this.operationList.get(i);
            int size = oper.getOutputCount();
            for (int j = 0; j < size; ++j) {
                Output output = oper.getOutput(j);
                String errorCode = output.getFault()[0].getCode();
                if (!String.valueOf(0).equals(errorCode)) {
                    allSucc = false;
                    RowParams row = new RowParams();
                    RowErrors error = new RowErrors();
                    ErrorMessage errorMessage = new ErrorMessage();
                    errorMessage.setErrorcode(errorCode);
                    errorMessage.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot((int)Integer.parseInt(errorCode)));
                    error.setErrorMessage(errorMessage);
                    Param errorparam = null;
                    Input input = oper.getInput();
                    int subrackId = Integer.parseInt(input.getPart(KEY_SUBRACK_ID).getValue());
                    String subrackName = TEBoardUtil.getSubrackNameFromSubrackID((int)this.neid, (int)subrackId);
                    errorparam = new Param("nename", this.ne.getNEName());
                    error.addParam(errorparam);
                    errorparam = new Param("subrackName", subrackName);
                    error.addParam(errorparam);
                    row.addRowErrors(error);
                    bussiness.addRowParams(row);
                    continue;
                }
                allFail = false;
            }
        }
        this.constructErrorMessage(allSucc, allFail);
    }

    private void getUsedPowerByPiuBoard(ArrayList operationList) {
        int errCode = 0;
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            Operation oper = (Operation)operationList.get(i);
            if (!oper.getName().equals(NSCMD_CFG_GET_USEDPOWER) && !oper.getName().equals(NSCMD_CFG_GET_LOGIC_USEDPOWER)) continue;
            Output output = null;
            String slotIDStr = "";
            int slotID = 0;
            String usedPowerStr = "";
            int usedPower = 0;
            int row = oper.getOutputCount();
            for (int j = 0; j < row; ++j) {
                output = oper.getOutput(j);
                errCode = Integer.parseInt(output.getFault(0).getCode());
                if (0 != errCode) continue;
                slotIDStr = output.getPartValue("slotID");
                usedPowerStr = output.getPartValue("usedPower");
                if ("" == slotIDStr || null == slotIDStr || "" == usedPowerStr || null == usedPowerStr) continue;
                slotID = Integer.parseInt(slotIDStr);
                usedPower = Integer.parseInt(usedPowerStr);
                this.usedPowerMap.put(slotID &= 0xFF, usedPower);
            }
        }
    }

    private List<ConfigInfoObj> getConfigInfoList(ArrayList operationList) {
        int errCode = 0;
        ArrayList<ConfigInfoObj> infoObjList = new ArrayList<ConfigInfoObj>();
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            Operation oper = (Operation)operationList.get(i);
            if (!oper.getName().equals(NSCMD_CFG_GET_EXTPOWER)) continue;
            int currentValue = 0;
            String srcSlotIDStr = "";
            int srcSlotID = 0;
            String snkSlotIDStr = "";
            int snkSlotID = 0;
            int slotIndex = 0;
            int srcUsedPower = 0;
            int snkUsedPower = 0;
            boolean isExist = false;
            int jLen = oper.getOutputCount();
            for (int j = 0; j < jLen; ++j) {
                ConfigInfoObj infoObj = new ConfigInfoObj();
                Output output = oper.getOutput(j);
                errCode = Integer.parseInt(output.getFault(0).getCode());
                if (0 != errCode || null == output.getPartValue("currentValue") || null == output.getPartValue("srcSlotID") || null == output.getPartValue("snkSlotID")) continue;
                infoObj.currentValue = currentValue = Integer.parseInt(output.getPartValue("currentValue"));
                srcSlotIDStr = output.getPartValue("srcSlotID");
                srcSlotID = Integer.parseInt(srcSlotIDStr);
                infoObj.srcSlotID = srcSlotID &= 0xFF;
                snkSlotIDStr = output.getPartValue("snkSlotID");
                snkSlotID = Integer.parseInt(snkSlotIDStr);
                infoObj.snkSlotID = snkSlotID &= 0xFF;
                if (0 != srcSlotID && 0 != snkSlotID && srcSlotID > snkSlotID) {
                    int slotid = snkSlotID;
                    snkSlotID = srcSlotID;
                    srcSlotID = slotid;
                }
                infoObj.srcIndex = slotIndex = this.convertSlotIdToIndex(srcSlotID);
                if (0 == srcSlotID) {
                    srcUsedPower = 0;
                } else if (this.usedPowerMap.containsKey(srcSlotID)) {
                    srcUsedPower = this.usedPowerMap.get(srcSlotID);
                }
                infoObj.srcUsedPower = srcUsedPower;
                infoObj.snkIndex = slotIndex = this.convertSlotIdToIndex(snkSlotID);
                if (0 == snkSlotID) {
                    snkUsedPower = 0;
                } else if (this.usedPowerMap.containsKey(snkSlotID)) {
                    snkUsedPower = this.usedPowerMap.get(snkSlotID);
                }
                infoObj.snkUsedPower = snkUsedPower;
                isExist = false;
                if (slotIndex > -1) {
                    isExist = true;
                }
                infoObj.hasConnect = isExist;
                infoObj.usedPower = srcUsedPower + snkUsedPower;
                infoObjList.add(infoObj);
            }
        }
        return infoObjList;
    }

    private void initIndexRange(int subrackType) {
        if (Integer.parseInt("112") == subrackType || Integer.parseInt("117") == subrackType) {
            this.minPiuSlotID = 100;
            this.maxPiuSlotID = 104;
        } else if (Integer.parseInt("111") == subrackType || Integer.parseInt("118") == subrackType) {
            this.minPiuSlotID = 100;
            this.maxPiuSlotID = 110;
            this.middlePiuSlotID = 105;
        } else {
            this.minPiuSlotID = 0;
            this.maxPiuSlotID = 0;
        }
    }

    private void getQueryType(RowParams rowparams) {
        Param param = rowparams.getParam(KEY_QUERY_TYPE);
        if (null != param && null != param.getValue() && !"".equals(param.getValue())) {
            this.type = Integer.valueOf(param.getValue());
        }
    }

    private String getAddedPiuBoardIndexList() {
        Vector boardList = this.ne.getBoardList();
        int len = boardList.size();
        for (int i = 0; i < len; ++i) {
            int index;
            int slotID;
            int subrackid;
            TEBoard board = (TEBoard)boardList.get(i);
            if (!this.isPiuLogicBoard(board) || (subrackid = TEBoardUtil.getSubrackIDFromSlot((int)this.neid, (int)(slotID = board.getSlotID()))) != this.subrackID) continue;
            if (0 != subrackid) {
                slotID %= subrackid * 65536;
            }
            if (-1 == (index = this.convertSlotIdToIndex(slotID))) continue;
            this.logicBoardList.add(index);
        }
        String listStr = "";
        if (this.logicBoardList != null && this.logicBoardList.size() != 0) {
            Collections.sort(this.logicBoardList);
            listStr = this.logicBoardList.toString();
        }
        return listStr;
    }

    private boolean isPiuLogicBoard(TEBoard board) {
        int boardType = board.getBoardType();
        return TEGenCfgCommon.isSupportAttr((int)boardType, (String)NGWDM_ATTR_PIUBOARD);
    }

    private int convertSlotIdToIndex(int slotId) {
        int index = -1;
        if (slotId < this.minPiuSlotID || slotId > this.maxPiuSlotID) {
            index = -1;
        } else if (this.subrackType == Integer.parseInt("117") || this.subrackType == Integer.parseInt("112")) {
            index = slotId - this.minPiuSlotID;
        } else if (this.subrackType == Integer.parseInt("118") || this.subrackType == Integer.parseInt("111")) {
            if (slotId < this.middlePiuSlotID) {
                index = slotId - this.minPiuSlotID;
            } else if (slotId > this.middlePiuSlotID) {
                index = slotId - this.minPiuSlotID - 1;
            }
        }
        return index;
    }

    private int getSubrackType(RowParams rowparams) {
        int subrackType = Integer.parseInt("111");
        Param param = rowparams.getParam(KEY_SUBRACK_TYPE);
        if (!this.isParamValid(param)) {
            TELogFactory.getNormalLogger().error("Invalid subrack type");
            subrackType = -1;
        }
        subrackType = Integer.parseInt(param.getValue());
        param = rowparams.getParam(KEY_SUBRACK_ID);
        if (!this.isParamValid(param)) {
            this.subrackID = 0;
            TELogFactory.getNormalLogger().debug("Invalid subrack ID, set default value 0");
        } else {
            this.subrackID = Integer.parseInt(param.getValue());
        }
        return subrackType;
    }

    private void constructErrorMessage(boolean allSucc, boolean allFail) {
        if (allSucc) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        } else if (allFail) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1));
        }
    }

    private boolean isParamValid(Param param) {
        return null != param && null != param.getValue() && !param.getValue().equals("");
    }
}

