/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.portprotection;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.util.ArrayList;
import java.util.List;

public abstract class TEQueryPortProtectionSwitchStateSuperBean
extends TENEExplorerBean {
    private TEResourceUtil res = null;
    protected static final int SWITCH_REQUEST_NR = 0;
    protected static final int SWITCH_REQUEST_AUTO = 4;
    protected static final int SWITCH_REQUEST_WTR = 5;
    protected static final int SWITCH_REQUEST_MS = 7;
    protected static final int SWITCH_REQUEST_SD = 9;
    protected static final int SWITCH_REQUEST_SF = 12;
    protected static final int SWITCH_REQUEST_FS = 14;
    protected static final int SWITCH_REQUEST_SFP = 15;
    protected static final int WORKING = 1;
    protected static final int PROTECTION = 0;
    protected static final int DLSU = 255;
    protected static final int PATH_STATE_NR = 0;
    protected static final int PATH_STATE_SD = 1;
    protected static final int PATH_STATE_SF = 2;
    protected static final int SERVICE_SOURCE_HAND = 0;
    protected static final int SERVICE_SOURCE_ITG = 1;
    protected static final int NSCMD_PPS_GET_PATH_SWSTATE = 29922;
    public boolean userNewCommandFlag = false;
    protected static final int NSCMD_PPS_GET_PATH_SWSTATE_EX = 35313;
    protected static final int NSCMD_ITGPPS_GET_PATH_SWSTATE = 31762;
    protected static final int LOCAL_POINT = 0;
    protected static final int PEER_POINT = 1;
    protected static final int LINEPROTECTION = 4;

    protected abstract StringBuffer getResFilePath();

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            this.res = TEGetFilePath.getResource((int)neid, (StringBuffer)this.getResFilePath());
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            if (errorCode == 1090646019) {
                return;
            }
            ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
            int userID = 0;
            if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = 0;
                }
            }
            String operateObject = "";
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            operateObject = null == neObj ? String.valueOf(neid) : neObj.getNEName();
            if (errorCode == 0 || errorCode == 2 || errorCode == 1) {
                int rowCount = outputData.getBussinessParams().getRowParamsCount();
                for (int i = 0; i < rowCount; ++i) {
                    RowParams rowParams = outputData.getBussinessParams().getRowParams(i);
                    if (rowParams.getRowErrorsCount() <= 0 && rowParams.getParamCount() <= 0) continue;
                    this.setSwitchStatusLogInfo(rowParams, ipAddress, userID, operateObject, loginfoList);
                }
            } else {
                int count = inputData.getBussinessParams().getRowParamsCount();
                for (int j = 0; j < count; ++j) {
                    StringBuffer sb = new StringBuffer();
                    sb.append(this.res.getString("protection_group_name"));
                    String unknown = this.res.getString("unknown");
                    String groupId = inputData.getBussinessParams().getRowParams(j).getParam("groupId").getValue();
                    TELogInfo logInfo = new TELogInfo();
                    sb.append(operateObject).append("-").append(groupId);
                    sb.append(this.res.getString("switch_state")).append(unknown);
                    sb.append(this.res.getString("working_unit_status")).append(unknown);
                    sb.append(this.res.getString("protection_unit_status")).append(unknown);
                    if (this.userNewCommandFlag) {
                        sb.append(this.res.getString("switchPoint")).append(unknown);
                    }
                    logInfo.setOperateDesc(sb.toString());
                    logInfo.setErrCode(errorCode);
                    logInfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                    logInfo.setResult(2);
                    logInfo.setCmdID(subfunc.getCode());
                    logInfo.setLocation(ipAddress);
                    logInfo.setUserID(userID);
                    logInfo.setUserName(TESysManagerBean.getInstance().getSysUser());
                    logInfo.setOperateObject(operateObject);
                    logInfo.setOperateName(subfunc.getSubFuncDes(neid));
                    loginfoList.add(logInfo);
                }
            }
            int size = loginfoList.size();
            for (int i = 0; i < size; ++i) {
                TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList.get(i)));
            }
        }
        catch (NumberFormatException e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
        catch (IndexOutOfBoundsException e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }

    private void setSwitchStatusLogInfo(RowParams rowParams, String ipAddress, int userID, String operateObject, List loginfoList) {
        String unknown = this.res.getString("unknown");
        int errorCount = rowParams.getRowErrorsCount();
        boolean failFlag = false;
        for (int i = 0; i < errorCount; ++i) {
            RowErrors rowErrors = rowParams.getRowErrors(i);
            int errorCode = Integer.parseInt(rowErrors.getErrorMessage().getErrorcode());
            if (0 == errorCode) continue;
            TELogInfo logInfo = new TELogInfo();
            logInfo.setCmdID(this.subfunc.getCode());
            logInfo.setLocation(ipAddress);
            logInfo.setUserID(userID);
            logInfo.setUserName(TESysManagerBean.getInstance().getSysUser());
            logInfo.setOperateObject(operateObject);
            logInfo.setOperateName(this.subfunc.getSubFuncDes(this.neid));
            StringBuffer sb = new StringBuffer();
            sb.append(this.res.getString("protection_group_name"));
            String neName = rowErrors.getParam("nename").getValue();
            String groupId = rowErrors.getParam("groupId").getValue();
            sb.append(neName).append("-").append(groupId);
            sb.append(this.res.getString("switch_state")).append(unknown);
            sb.append(this.res.getString("working_unit_status")).append(unknown);
            sb.append(this.res.getString("protection_unit_status")).append(unknown);
            if (this.userNewCommandFlag) {
                sb.append(this.res.getString("switchPoint")).append(unknown);
            }
            logInfo.setOperateDesc(sb.toString());
            logInfo.setErrCode(errorCode);
            logInfo.setErrInfo(rowErrors.getErrorMessage().getErrorinfo());
            logInfo.setResult(2);
            loginfoList.add(logInfo);
            failFlag = true;
        }
        if (!failFlag) {
            TELogInfo logInfo = new TELogInfo();
            logInfo.setCmdID(this.subfunc.getCode());
            logInfo.setLocation(ipAddress);
            logInfo.setUserID(userID);
            logInfo.setUserName(TESysManagerBean.getInstance().getSysUser());
            logInfo.setOperateObject(operateObject);
            logInfo.setOperateName(this.subfunc.getSubFuncDes(this.neid));
            StringBuffer sb = new StringBuffer();
            sb.append(this.res.getString("protection_group_name"));
            String neName = rowParams.getParam("nename").getValue();
            String groupId = rowParams.getParam("groupId").getValue();
            sb.append(neName).append("-").append(groupId);
            int switchingResquest = Integer.parseInt(rowParams.getParam("switchingRequest").getValue());
            int currentWorkingPath = Integer.parseInt(rowParams.getParam("currentWorkingPath").getValue());
            sb.append(this.res.getString("switch_state"));
            switch (switchingResquest) {
                case 0: {
                    sb.append(this.res.getString("nr"));
                    break;
                }
                case 4: {
                    sb.append(this.res.getString("auto"));
                    break;
                }
                case 5: {
                    sb.append(this.res.getString("wtr"));
                    break;
                }
                case 9: {
                    sb.append(this.res.getString("sd"));
                    break;
                }
                case 12: {
                    sb.append(this.res.getString("sf"));
                    break;
                }
                case 15: {
                    sb.append(this.res.getString("sfp"));
                    break;
                }
                case 7: {
                    if (1 == currentWorkingPath) {
                        sb.append(this.res.getString("msworking"));
                        break;
                    }
                    sb.append(this.res.getString("msprotection"));
                    break;
                }
                case 14: {
                    if (1 == currentWorkingPath) {
                        sb.append(this.res.getString("fsworking"));
                        break;
                    }
                    if (0 != currentWorkingPath) break;
                    sb.append(this.res.getString("fsprotection"));
                    break;
                }
                default: {
                    sb.append(unknown);
                }
            }
            if (255 == currentWorkingPath) {
                sb.append(this.res.getString("delaystartup"));
            }
            sb.append(this.res.getString("working_unit_status"));
            int workingPathStatus = Integer.parseInt(rowParams.getParam("workingPathStatus").getValue());
            switch (workingPathStatus) {
                case 0: {
                    sb.append(this.res.getString("normal"));
                    break;
                }
                case 1: {
                    sb.append(this.res.getString("sdstatus"));
                    break;
                }
                case 2: {
                    sb.append(this.res.getString("sfstatus"));
                    break;
                }
                default: {
                    sb.append(unknown);
                }
            }
            sb.append(this.res.getString("protection_unit_status"));
            int protectionPathStatus = Integer.parseInt(rowParams.getParam("protectionPathStatus").getValue());
            switch (protectionPathStatus) {
                case 0: {
                    sb.append(this.res.getString("normal"));
                    break;
                }
                case 1: {
                    sb.append(this.res.getString("sdstatus"));
                    break;
                }
                case 2: {
                    sb.append(this.res.getString("sfstatus"));
                    break;
                }
                default: {
                    sb.append(unknown);
                }
            }
            if (rowParams.getParam("switchPoint") != null) {
                sb.append(this.res.getString("switchPoint"));
                int switchPoint = Integer.parseInt(rowParams.getParam("protectionPathStatus").getValue());
                switch (switchPoint) {
                    case 0: {
                        sb.append(this.res.getString("switchPoint0"));
                        break;
                    }
                    case 1: {
                        sb.append(this.res.getString("switchPoint1"));
                        break;
                    }
                    default: {
                        sb.append(unknown);
                    }
                }
            }
            logInfo.setOperateDesc(sb.toString());
            logInfo.setResult(0);
            logInfo.setErrCode(0);
            logInfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)0));
            loginfoList.add(logInfo);
        }
    }
}

