/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.portprotection;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TEModifyPortProtectionGroupSuper
extends TENEExplorerBean {
    public static final int TIME_OUT = 20;
    public static final String WPROTECTIONUNIT = "2";
    public static final String PPROTECTIONUNIT = "1";
    private static final String SINGLE_MODE = "0";
    private static final String DUAL_MODE = "1";
    public TEResourceUtil res = null;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.createOperationList();
            this.createSDSFOperationList();
            this.createSwitchTypeAndAPSOperationList();
            int result = TENECommMgr.getInstance().sendCommand((int)neid, (List)this.operationList, (int)20).retCode;
            this.outputData = new Datainterface();
            if (result == 0) {
                this.handleMessage(neid, this.operationList, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Exception in the performBussinessProcess method", (Throwable)e);
        }
        return this.outputData;
    }

    public void createSwitchTypeAndAPSOperationList() {
    }

    public void createSDSFOperationList() {
    }

    public void createOperationList() {
        this.operationList = new ArrayList();
        Operation operation = null;
        RowParams[] rParams = this.inputData.getBussinessParams().getRowParams();
        int size = rParams.length;
        for (int i = 0; i < size; ++i) {
            Input input = null;
            Part part = null;
            operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PPS_SET_DELAYTIME");
            if (rParams[i].getParam("pdelayTime") != null) {
                input = operation.getInput();
                part = input.getPart("neId");
                part.setValue(rParams[i].getParam("neId").getValue());
                part = input.getPart("groupId");
                part.setValue(rParams[i].getParam("groupId").getValue());
                part = input.getPart("protectionUnit");
                part.setValue("1");
                part = input.getPart("delayTime");
                part.setValue(rParams[i].getParam("pdelayTime").getValue());
                this.operationList.add(operation);
            }
            operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PPS_SET_DELAYTIME");
            if (rParams[i].getParam("wdelayTime") != null) {
                input = operation.getInput();
                part = input.getPart("neId");
                part.setValue(rParams[i].getParam("neId").getValue());
                part = input.getPart("groupId");
                part.setValue(rParams[i].getParam("groupId").getValue());
                part = input.getPart("protectionUnit");
                part.setValue(WPROTECTIONUNIT);
                part = input.getPart("delayTime");
                part.setValue(rParams[i].getParam("wdelayTime").getValue());
                this.operationList.add(operation);
            }
            if (rParams[i].getParam("revertiveMode") != null) {
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PPS_SET_RESTORE_MODE");
                input = operation.getInput();
                part = input.getPart("neId");
                part.setValue(rParams[i].getParam("neId").getValue());
                part = input.getPart("groupId");
                part.setValue(rParams[i].getParam("groupId").getValue());
                part = input.getPart("revertiveMode");
                part.setValue(rParams[i].getParam("revertiveMode").getValue());
                part = input.getPart("wtrTime");
                part.setValue(rParams[i].getParam("wtrTime").getValue());
                this.operationList.add(operation);
            }
            if (rParams[i].getParam("SDEnable") == null) continue;
            operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PPS_SET_SDFLAG");
            input = operation.getInput();
            part = input.getPart("neId");
            part.setValue(rParams[i].getParam("neId").getValue());
            part = input.getPart("groupId");
            part.setValue(rParams[i].getParam("groupId").getValue());
            part = input.getPart("SDEnable");
            part.setValue(rParams[i].getParam("SDEnable").getValue());
            this.operationList.add(operation);
        }
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            StringBuffer filePath = new StringBuffer();
            filePath.append("ngwdm").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("portprotection").append(File.separator).append("portprotectionres_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
            this.res = TEGetFilePath.getResource((int)neid, (StringBuffer)filePath);
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            if (errorCode == 1090646019) {
                return;
            }
            ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
            TELogInfo loginf = new TELogInfo();
            loginf.setCmdID(subfunc.getCode());
            loginf.setLocation(ipAddress);
            loginf.setUserName(TESysManagerBean.getInstance().getSysUser());
            loginf.setOperateName(subfunc.getSubFuncDes(neid));
            loginf.setOperateObject("");
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            loginf.setOperateObject(null == neObj ? String.valueOf(neid) : neObj.getNEName());
            String desc = "";
            RowParams rowParams = inputData.getBussinessParams().getRowParams(0);
            desc = desc + this.res.getString("protection_group_name") + loginf.getOperateObject() + "-" + rowParams.getParam("groupId").getValue() + this.res.getString("protection_type");
            int protectionType = Integer.parseInt(rowParams.getParam("protectionType").getValue());
            String protectionTypeStr = "";
            String controlUnit = "";
            switch (protectionType) {
                case 1: {
                    protectionTypeStr = protectionTypeStr + this.res.getString("board_protection");
                    break;
                }
                case 3: {
                    protectionTypeStr = protectionTypeStr + this.res.getString("client_protection");
                    if ("".equals(rowParams.getParam("cwPath").getValue())) break;
                    controlUnit = controlUnit + this.res.getString("control_unit_working_path") + rowParams.getParam("cwPath").getValue();
                    break;
                }
                case 4: {
                    protectionTypeStr = protectionTypeStr + this.res.getString("line_protection");
                    break;
                }
            }
            desc = desc + protectionTypeStr + this.res.getString("working_unit") + rowParams.getParam("workingUnit").getValue() + this.res.getString("working_unit_delaytime") + (float)Integer.parseInt(rowParams.getParam("wdelayTime").getValue()) / 10.0f + this.res.getString("time_unit") + this.res.getString("protection_unit") + rowParams.getParam("protectionUnit").getValue() + this.res.getString("protection_unit_delaytime") + (float)Integer.parseInt(rowParams.getParam("pdelayTime").getValue()) / 10.0f + this.res.getString("time_unit") + controlUnit;
            if (rowParams.getParam("revertiveMode") != null) {
                desc = desc + this.res.getString("revertive_mode");
                int reveMode = Integer.parseInt(rowParams.getParam("revertiveMode").getValue());
                desc = reveMode == 1 ? desc + this.res.getString("revertive") + this.res.getString("wtr_time") + rowParams.getParam("wtrTime").getValue() + this.res.getString("time_unit") : desc + this.res.getString("non_revertive");
            }
            desc = desc + this.res.getString("sd_trigger_flag");
            int sdEnable = Integer.parseInt(rowParams.getParam("sdEnable").getValue());
            desc = desc + this.res.getString(sdEnable == 1 ? "enabled" : "disabled");
            if (rowParams.getParam("switchMode") != null) {
                String switchMode = rowParams.getParam("switchMode").getValue();
                desc = desc + this.res.getString("switchMode");
                if (switchMode.equals(SINGLE_MODE)) {
                    desc = desc + this.res.getString("singleMode");
                } else {
                    desc = desc + this.res.getString("dualMode");
                    String channelUnit = rowParams.getParam("channelUnit").getValue();
                    desc = desc + this.res.getString("channelUnit");
                    desc = desc + channelUnit;
                }
            }
            if (rowParams.getParam("switchDectTime") != null) {
                desc = desc + this.res.getString("switchDectTime");
                desc = desc + rowParams.getParam("switchDectTime").getValue();
            }
            desc = desc + this.getAPSLog(rowParams);
            loginf.setOperateDesc(desc);
            if (errorCode == 0) {
                loginf.setResult(0);
                loginf.setErrCode(0);
                loginf.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                loginfoList.add(loginf);
            } else if (errorCode == 2 || errorCode == 1) {
                loginf.setResult(errorCode);
                if (null == outputData.getBussinessParams() || outputData.getBussinessParams().getRowParamsCount() == 0) {
                    loginf.setErrCode(errorCode);
                }
                int len = outputData.getBussinessParams().getRowParamsCount();
                for (int i = 0; i < len; ++i) {
                    RowErrors[] rowErrors = outputData.getBussinessParams().getRowParams(i).getRowErrors();
                    if (rowErrors.length <= 0) continue;
                    loginf.setErrCode(Integer.parseInt(rowErrors[0].getErrorMessage().getErrorcode()));
                    loginf.setErrInfo(rowErrors[0].getErrorMessage().getErrorinfo());
                    loginfoList.add(loginf);
                    break;
                }
            } else {
                loginf.setResult(2);
                loginf.setErrCode(errorCode);
                loginf.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                loginfoList.add(loginf);
            }
            int size = loginfoList.size();
            for (int i = 0; i < size; ++i) {
                TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList.get(i)));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }

    private String getAPSLog(RowParams rowParams) {
        String desc = "";
        if (rowParams.getParam("switchType") != null) {
            String switchType = rowParams.getParam("switchType").getValue();
            desc = desc + this.res.getString("switchType");
            if (SINGLE_MODE.equals(switchType)) {
                desc = desc + this.res.getString("APS_MODE_0");
            } else {
                desc = desc + this.res.getString("APS_MODE_1");
                String apsChannel = rowParams.getParam("apsChannel").getValue();
                desc = desc + this.res.getString("apsChannel");
                desc = desc + apsChannel;
            }
        }
        return desc;
    }
}

