/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.portprotection;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TEDeletePortProtectionGroupSuper
extends TENEExplorerBean {
    public static final int PROTECTION_GROUP_NOT_EXIST_ERRORCODE = 39298;
    public static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    public static final String PORT_PROTECTION_RES = "ngwdm" + File.separator + "res" + File.separator + "portprotection" + File.separator + "portprotectionres_" + LANGUAGE + ".ini";
    public TEResourceUtil resourceUtil = null;
    public List logInfoList = new ArrayList();
    public TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        super.handleMessage(neid, operationList, subfunc, filterErrorCodeList);
        int errorCode = Integer.parseInt(this.outputData.getErrorMessage().getErrorcode());
        if (0 == errorCode || 1 == errorCode) {
            try {
                if (!subfunc.getTransSupport() && 0 != (errorCode = TENEListUtils.sendVerify((int)neid))) {
                    this.outputData = new Datainterface();
                    this.outputData.setBussinessParams(new BussinessParams());
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)errorCode));
                }
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("Exception in the handleMessage method", (Throwable)e);
            }
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> filterErrorCodeList = new ArrayList<Integer>();
        filterErrorCodeList.add(new Integer(39298));
        return filterErrorCodeList;
    }

    protected String getResFilePath() {
        return PORT_PROTECTION_RES;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        this.resourceUtil = TEGetFilePath.getResource((int)neid, (String)this.getResFilePath());
        try {
            if (outputData.getErrorMessage().getErrorcode().equals(String.valueOf(1090646019))) {
                return;
            }
            TENE neObj = this.cfgDataMgr.getNE(neid);
            String operateObject = "";
            operateObject = null == neObj ? String.valueOf(neid) : neObj.getNEName();
            String operateName = subfunc.getSubFuncDes(neid);
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            switch (errorCode) {
                case 1090646019: {
                    break;
                }
                case 0: 
                case 1: 
                case 2: {
                    this.log(user, ipAddress, operateObject, operateName, errorCode);
                    break;
                }
                default: {
                    this.logOther(user, ipAddress, operateObject, operateName, errorCode);
                }
            }
            int size = this.logInfoList.size();
            for (int i = 0; i < size; ++i) {
                TELogMgr.writeLog((TELogInfo)((TELogInfo)this.logInfoList.get(i)));
            }
        }
        catch (Exception e) {
            return;
        }
    }

    public void log(String user, String ipAddress, String operateObject, String operateName, int errorCode) {
        RowParams rowParams = null;
        int rowCount = this.inputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < rowCount; ++i) {
            String desc = "";
            TELogInfo loginfo = new TELogInfo();
            loginfo.setCmdID(this.subfunc.getCode());
            loginfo.setLocation(ipAddress);
            loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
            loginfo.setOperateObject(operateObject);
            loginfo.setOperateName(operateName);
            rowParams = this.inputData.getBussinessParams().getRowParams(i);
            int groupId = Integer.parseInt(rowParams.getParam("groupId").getValue());
            int proType = Integer.parseInt(rowParams.getParam("protype").getValue());
            String protectionType = "";
            switch (proType) {
                case 1: {
                    protectionType = this.resourceUtil.getString("board_protection");
                    break;
                }
                case 3: {
                    protectionType = this.resourceUtil.getString("client_protection");
                    break;
                }
                case 4: {
                    protectionType = this.resourceUtil.getString("line_protection");
                    break;
                }
            }
            String workUnit = rowParams.getParam("workingunit").getValue();
            String controlUnitWorkingPath = rowParams.getParam("controlunitworkingpath").getValue();
            String workUnitDelayTime = rowParams.getParam("workingunitdelaytime").getValue();
            String proUnit = rowParams.getParam("protectionunit").getValue();
            String proUnitDelayTime = rowParams.getParam("protectionunitdelaytime").getValue();
            desc = desc + this.resourceUtil.getString("protection_group_name") + operateObject + "-" + groupId + this.resourceUtil.getString("protection_type") + protectionType;
            if (rowParams.getParam("revertivemode") != null) {
                String revMode = rowParams.getParam("revertivemode").getValue();
                String wtrTime = rowParams.getParam("wtrtime").getValue();
                desc = desc + this.resourceUtil.getString("revertive_mode") + revMode + this.resourceUtil.getString("wtr_time") + wtrTime;
            }
            desc = desc + this.resourceUtil.getString("time_unit") + this.resourceUtil.getString("working_unit") + workUnit + this.resourceUtil.getString("working_unit_delaytime") + (float)Integer.parseInt(workUnitDelayTime) / 10.0f + this.resourceUtil.getString("time_unit") + this.resourceUtil.getString("protection_unit") + proUnit + this.resourceUtil.getString("protection_unit_delaytime") + (float)Integer.parseInt(proUnitDelayTime) / 10.0f + this.resourceUtil.getString("time_unit");
            if (proType == 3) {
                desc = desc + this.resourceUtil.getString("control_unit_working_path") + controlUnitWorkingPath;
            }
            if (rowParams.getParam("sdtriggerflag") != null) {
                String sdFlag = rowParams.getParam("sdtriggerflag").getValue();
                desc = desc + this.resourceUtil.getString("sd_trigger_flag") + sdFlag;
            }
            if (rowParams.getParam("switchDectTime") != null) {
                desc = desc + this.resourceUtil.getString("switchDectTime");
                desc = desc + rowParams.getParam("switchDectTime").getValue();
            }
            desc = desc + this.getSwitchTypeAndApsChannelLog(rowParams);
            loginfo.setOperateDesc(desc);
            boolean errorFlag = false;
            int m = this.outputData.getBussinessParams().getRowParamsCount();
            block6: for (int j = 0; j < m; ++j) {
                RowErrors[] rowErrors = this.outputData.getBussinessParams().getRowParams(j).getRowErrors();
                int n = rowErrors.length;
                for (int k = 0; k < n; ++k) {
                    int errorGroupId = Integer.parseInt(rowErrors[j].getParam("groupId").getValue());
                    if (groupId != errorGroupId) continue;
                    loginfo.setResult(2);
                    loginfo.setErrCode(Integer.parseInt(rowErrors[j].getErrorMessage().getErrorcode()));
                    loginfo.setErrInfo(rowErrors[j].getErrorMessage().getErrorinfo());
                    errorFlag = true;
                    continue block6;
                }
            }
            if (!errorFlag) {
                loginfo.setResult(0);
                loginfo.setErrCode(0);
                loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
            }
            this.logInfoList.add(loginfo);
        }
    }

    private String getSwitchTypeAndApsChannelLog(RowParams rowParams) {
        if (rowParams.getParam("switchType") != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.resourceUtil.getString("switchType"));
            String switchType = rowParams.getParam("switchType").getValue();
            if ("0".equals(switchType)) {
                sb.append(this.resourceUtil.getString("APS_MODE_0"));
            } else {
                sb.append(this.resourceUtil.getString("APS_MODE_1"));
                String apsChannel = rowParams.getParam("apsChannel").getValue();
                sb.append(this.resourceUtil.getString("apsChannel"));
                sb.append(apsChannel);
            }
            return sb.toString();
        }
        return "";
    }

    public void logOther(String user, String ipAddress, String operateObject, String operateName, int errorCode) {
        TELogInfo loginfo = new TELogInfo();
        loginfo.setCmdID(this.subfunc.getCode());
        loginfo.setLocation(ipAddress);
        loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
        loginfo.setOperateObject(operateObject);
        loginfo.setOperateName(operateName);
        loginfo.setOperateDesc(operateName);
        loginfo.setResult(2);
        loginfo.setErrCode(errorCode);
        loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
        this.logInfoList.add(loginfo);
    }
}

