/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.portprotection;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public abstract class TECreatePortProtectionGroupSuperBean
extends TENEExplorerBean {
    protected static final int TIME_OUT = 20;
    protected static final int PROTECTION_GROUPID_MIN = 1;
    protected static final int PROTECTION_GROUPID_MAX = 65535;
    protected static final String MANAGE_RANGE_OUT = "4294967295";
    protected int protectionGroupId;
    protected String otherDevice = "";
    protected TEResourceUtil res = null;
    protected String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    protected String filename = "portprotection" + File.separator + "portprotectionres_" + this.LANGUAGE + ".ini";
    protected String PAKAGE_PATH = "ngwdm" + File.separator + "res" + File.separator + this.filename;
    private TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();

    protected abstract int processSecodeOperations(ArrayList var1, ArrayList var2) throws Exception;

    public abstract OperationResult sendFirstOperation(int var1, ArrayList var2, SubFunc var3);

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.otherDevice = TEGetFilePath.getResource((int)neid, (String)this.getResFilePath()).getString("otherdevice");
            ArrayList allOperation = this.createOperationList();
            ArrayList firstOpertaion = (ArrayList)allOperation.get(0);
            int result = this.sendFirstOperation((int)neid, (ArrayList)firstOpertaion, (SubFunc)subFunc).retCode;
            if (result == 0) {
                this.handleMessage(neid, firstOpertaion, this.subfunc);
                this.processSecodeOperations(allOperation, firstOpertaion);
            } else {
                this.outputData = new Datainterface();
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Exception in the performBussinessProcess method", (Throwable)e);
        }
        this.filterErrorMessage();
        return this.outputData;
    }

    protected String getResFilePath() {
        return this.PAKAGE_PATH;
    }

    public ArrayList createOperationList() {
        ArrayList allOperation = new ArrayList();
        ArrayList<Operation> firstOperation = new ArrayList<Operation>();
        ArrayList<Operation> secondOperation = new ArrayList<Operation>();
        this.protectionGroupId = this.getProtectionGroupID();
        RowParams[] rParams = this.inputData.getBussinessParams().getRowParams();
        int size = rParams.length;
        for (int i = 0; i < size; ++i) {
            Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PPS_CREATE_PROTPAIR");
            Input input = operation.getInput();
            Part part = input.getPart("neId");
            part.setValue(rParams[i].getParam("neId").getValue());
            part = input.getPart("groupId");
            part.setValue(String.valueOf(this.protectionGroupId));
            part = input.getPart("protectionType");
            part.setValue(rParams[i].getParam("protectionType").getValue());
            firstOperation.add(operation);
            if (rParams[i].getParam("wprotectionGroupUnit") != null) {
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PPS_SET_PROTPAIR_BDPARA");
                input = operation.getInput();
                part = input.getPart("neId");
                part.setValue(rParams[i].getParam("neId").getValue());
                part = input.getPart("groupId");
                part.setValue(String.valueOf(this.protectionGroupId));
                part = input.getPart("protectionGroupUnit");
                part.setValue(rParams[i].getParam("wprotectionGroupUnit").getValue());
                part = input.getPart("returnNeId");
                part.setValue(rParams[i].getParam("wneId").getValue());
                part = input.getPart("slotId");
                part.setValue(rParams[i].getParam("wslotId").getValue());
                part = input.getPart("boardType");
                part.setValue(rParams[i].getParam("wboardType").getValue());
                part = input.getPart("portId");
                part.setValue(rParams[i].getParam("wportId").getValue());
                part = input.getPart("pathId");
                part.setValue(rParams[i].getParam("wpathId").getValue());
                firstOperation.add(operation);
            }
            if (rParams[i].getParam("pprotectionGroupUnit") != null) {
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PPS_SET_PROTPAIR_BDPARA");
                input = operation.getInput();
                part = input.getPart("neId");
                part.setValue(rParams[i].getParam("neId").getValue());
                part = input.getPart("groupId");
                part.setValue(String.valueOf(this.protectionGroupId));
                part = input.getPart("protectionGroupUnit");
                part.setValue(rParams[i].getParam("pprotectionGroupUnit").getValue());
                part = input.getPart("returnNeId");
                part.setValue(rParams[i].getParam("pneId").getValue());
                part = input.getPart("slotId");
                part.setValue(rParams[i].getParam("pslotId").getValue());
                part = input.getPart("boardType");
                part.setValue(rParams[i].getParam("pboardType").getValue());
                part = input.getPart("portId");
                part.setValue(rParams[i].getParam("pportId").getValue());
                part = input.getPart("pathId");
                part.setValue(rParams[i].getParam("ppathId").getValue());
                firstOperation.add(operation);
            }
            if (rParams[i].getParam("cwprotectionGroupUnit") != null) {
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PPS_SET_PROTPAIR_BDPARA");
                input = operation.getInput();
                part = input.getPart("neId");
                part.setValue(rParams[i].getParam("neId").getValue());
                part = input.getPart("groupId");
                part.setValue(String.valueOf(this.protectionGroupId));
                part = input.getPart("protectionGroupUnit");
                part.setValue(rParams[i].getParam("cwprotectionGroupUnit").getValue());
                part = input.getPart("returnNeId");
                part.setValue(rParams[i].getParam("cwneId").getValue());
                part = input.getPart("slotId");
                part.setValue(rParams[i].getParam("cwslotId").getValue());
                part = input.getPart("boardType");
                part.setValue(rParams[i].getParam("cwboardType").getValue());
                part = input.getPart("portId");
                part.setValue(rParams[i].getParam("cwportId").getValue());
                part = input.getPart("pathId");
                part.setValue(rParams[i].getParam("cwpathId").getValue());
                firstOperation.add(operation);
            }
            if (rParams[i].getParam("dwprotectionGroupUnit") != null) {
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PPS_SET_PROTPAIR_BDPARA");
                input = operation.getInput();
                part = input.getPart("neId");
                part.setValue(rParams[i].getParam("neId").getValue());
                part = input.getPart("groupId");
                part.setValue(String.valueOf(this.protectionGroupId));
                part = input.getPart("protectionGroupUnit");
                part.setValue(rParams[i].getParam("dwprotectionGroupUnit").getValue());
                part = input.getPart("returnNeId");
                part.setValue(rParams[i].getParam("dwneId").getValue());
                part = input.getPart("slotId");
                part.setValue(rParams[i].getParam("dwslotId").getValue());
                part = input.getPart("boardType");
                part.setValue(rParams[i].getParam("dwboardType").getValue());
                part = input.getPart("portId");
                part.setValue(rParams[i].getParam("dwportId").getValue());
                part = input.getPart("pathId");
                part.setValue(rParams[i].getParam("dwpathId").getValue());
                firstOperation.add(operation);
            }
            if (rParams[i].getParam("revertiveMode") != null) {
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PPS_SET_RESTORE_MODE");
                input = operation.getInput();
                part = input.getPart("neId");
                part.setValue(rParams[i].getParam("neId").getValue());
                part = input.getPart("groupId");
                part.setValue(String.valueOf(this.protectionGroupId));
                part = input.getPart("revertiveMode");
                part.setValue(rParams[i].getParam("revertiveMode").getValue());
                part = input.getPart("wtrTime");
                part.setValue(rParams[i].getParam("wtrTime").getValue());
                secondOperation.add(operation);
            }
            operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PPS_SET_DELAYTIME");
            if (rParams[i].getParam("pdelayTime") != null) {
                input = operation.getInput();
                part = input.getPart("neId");
                part.setValue(rParams[i].getParam("neId").getValue());
                part = input.getPart("groupId");
                part.setValue(String.valueOf(this.protectionGroupId));
                part = input.getPart("protectionUnit");
                part.setValue("1");
                part = input.getPart("delayTime");
                part.setValue(rParams[i].getParam("pdelayTime").getValue());
                secondOperation.add(operation);
            }
            operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PPS_SET_DELAYTIME");
            if (rParams[i].getParam("wdelayTime") != null) {
                input = operation.getInput();
                part = input.getPart("neId");
                part.setValue(rParams[i].getParam("neId").getValue());
                part = input.getPart("groupId");
                part.setValue(String.valueOf(this.protectionGroupId));
                part = input.getPart("protectionUnit");
                part.setValue("2");
                part = input.getPart("delayTime");
                part.setValue(rParams[i].getParam("wdelayTime").getValue());
                secondOperation.add(operation);
            }
            if (rParams[i].getParam("SDEnable") != null) {
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PPS_SET_SDFLAG");
                input = operation.getInput();
                part = input.getPart("neId");
                part.setValue(rParams[i].getParam("neId").getValue());
                part = input.getPart("groupId");
                part.setValue(String.valueOf(this.protectionGroupId));
                part = input.getPart("SDEnable");
                part.setValue(rParams[i].getParam("SDEnable").getValue());
                secondOperation.add(operation);
            }
            if (rParams[i].getParam("switchDectTime") != null) {
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PPS_SET_CONFIRMTIME");
                input = operation.getInput();
                part = input.getPart("neId");
                part.setValue(rParams[i].getParam("neId").getValue());
                part = input.getPart("groupId");
                part.setValue(String.valueOf(this.protectionGroupId));
                part = input.getPart("switchDectTime");
                part.setValue(rParams[i].getParam("switchDectTime").getValue());
                secondOperation.add(operation);
            }
            if (rParams[i].getParam("switchType") != null) {
                String switchTypeValue = rParams[i].getParam("switchType").getValue();
                operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PPS_SET_SWITCHTYPE");
                input = operation.getInput();
                part = input.getPart("neId");
                part.setValue(rParams[i].getParam("neId").getValue());
                part = input.getPart("groupId");
                part.setValue(String.valueOf(this.protectionGroupId));
                part = input.getPart("switchType");
                part.setValue(switchTypeValue);
                secondOperation.add(operation);
            }
            if (rParams[i].getParam("apsChannel") == null) continue;
            String apsChannelValue = rParams[i].getParam("apsChannel").getValue();
            operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PPS_SET_MFASNUM");
            input = operation.getInput();
            part = input.getPart("neId");
            part.setValue(rParams[i].getParam("neId").getValue());
            part = input.getPart("groupId");
            part.setValue(String.valueOf(this.protectionGroupId));
            part = input.getPart("apsChannel");
            part.setValue(apsChannelValue);
            secondOperation.add(operation);
        }
        allOperation.add(firstOperation);
        allOperation.add(secondOperation);
        return allOperation;
    }

    protected int getProtectionGroupID() {
        int protectionGroupID = 1;
        ArrayList<Integer> usedGroupIdList = new ArrayList<Integer>();
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_PPS_GET_PROTPAIR");
        Input input = operation.getInput();
        input.setPartValue("neId", "0");
        input.setPartValue("groupId", "0");
        this.operationList = new ArrayList();
        this.operationList.add(operation);
        int result = TENECommMgr.getInstance().sendCommand((int)this.neid, (List)this.operationList, null, (int)20, (boolean)false).retCode;
        if (0 == result) {
            operation = (Operation)this.operationList.get(0);
            int m = operation.getOutputCount();
            for (int i = 0; i < m; ++i) {
                Output output = operation.getOutput(i);
                if (!output.getFault(0).getCode().equals("0")) continue;
                Integer groupId = Integer.valueOf(output.getPartValue("groupId"));
                usedGroupIdList.add(groupId);
            }
        }
        if (usedGroupIdList.size() > 0) {
            while (protectionGroupID <= 65535 && usedGroupIdList.contains(protectionGroupID)) {
                ++protectionGroupID;
            }
        }
        return protectionGroupID;
    }

    protected void filterErrorMessage() {
        BussinessParams bussinessParams = this.outputData.getBussinessParams();
        if (null != bussinessParams) {
            int rowCount = bussinessParams.getRowParamsCount();
            for (int i = 0; i < rowCount; ++i) {
                RowParams rowParams = bussinessParams.getRowParams(i);
                if (null == rowParams) continue;
                int errorCount = rowParams.getRowErrorsCount();
                for (int j = errorCount - 1; j >= 0; --j) {
                    RowErrors rowErrors1 = rowParams.getRowErrors(j);
                    for (int k = j - 1; k >= 0; --k) {
                        RowErrors rowErrors2 = rowParams.getRowErrors(k);
                        if (!rowErrors1.getErrorMessage().getErrorcode().equals(rowErrors2.getErrorMessage().getErrorcode())) continue;
                        rowParams.removeRowErrors(rowErrors1);
                    }
                }
            }
        }
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            if (errorCode == 1090646019) {
                return;
            }
            ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
            TELogInfo logInfStr = new TELogInfo();
            logInfStr.setCmdID(subfunc.getCode());
            logInfStr.setLocation(ipAddress);
            if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
                int userID = 0;
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = 0;
                }
                logInfStr.setUserID(userID);
            }
            logInfStr.setUserName(TESysManagerBean.getInstance().getSysUser());
            logInfStr.setOperateName(subfunc.getSubFuncDes(neid));
            logInfStr.setOperateObject("");
            logInfStr.setOperateDesc(this.portProtectionToString(inputData));
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            if (null == neObj) {
                logInfStr.setOperateObject(String.valueOf(neid));
            } else {
                logInfStr.setOperateObject(neObj.getNEName());
            }
            if (errorCode == 0) {
                logInfStr.setResult(0);
                logInfStr.setErrCode(0);
                logInfStr.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                loginfoList.add(logInfStr);
            } else if (errorCode == 2 || errorCode == 1) {
                logInfStr.setResult(errorCode);
                if (null == outputData.getBussinessParams() || outputData.getBussinessParams().getRowParamsCount() == 0) {
                    logInfStr.setErrCode(errorCode);
                }
                int len = outputData.getBussinessParams().getRowParamsCount();
                for (int i = 0; i < len; ++i) {
                    RowErrors[] rowErrors = outputData.getBussinessParams().getRowParams(i).getRowErrors();
                    if (rowErrors.length <= 0) continue;
                    logInfStr.setErrCode(Integer.parseInt(rowErrors[0].getErrorMessage().getErrorcode()));
                    logInfStr.setErrInfo(rowErrors[0].getErrorMessage().getErrorinfo());
                    loginfoList.add(logInfStr);
                    break;
                }
            } else {
                logInfStr.setResult(2);
                logInfStr.setErrCode(errorCode);
                logInfStr.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                loginfoList.add(logInfStr);
            }
            int size = loginfoList.size();
            for (int i = 0; i < size; ++i) {
                TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList.get(i)));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }

    private String portProtectionToString(Datainterface inputData) {
        String boardTypeName;
        String controlBoardport1;
        StringBuffer strBuf = new StringBuffer();
        Param[] params = inputData.getBussinessParams().getRowParams(0).getParam();
        int neId = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"neId").getValue());
        String groupId = String.valueOf(this.protectionGroupId);
        String neName = this.mgr.getNE(neId).getNEName();
        StringBuffer filePath = new StringBuffer();
        filePath.append("ngwdm").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("portprotection").append(File.separator).append("portprotectionres_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        this.res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        strBuf.append(this.res.getString("protection_group_name")).append(neName).append("-").append(groupId).append(this.res.getString("protection_type"));
        int protectionType = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"protectionType").getValue());
        if (4 == protectionType) {
            strBuf.append(this.res.getString("line_protection"));
        }
        if (1 == protectionType) {
            strBuf.append(this.res.getString("board_protection"));
        }
        if (3 == protectionType) {
            strBuf.append(this.res.getString("client_protection"));
        }
        if (Datainterface.getParam((Param[])params, (String)"revertiveMode") != null) {
            int revertiveMode = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"revertiveMode").getValue());
            String wtrTime = Datainterface.getParam((Param[])params, (String)"wtrTime").getValue();
            strBuf.append(this.res.getString("revertive_mode"));
            if (1 == revertiveMode) {
                strBuf.append(this.res.getString("revertive"));
                strBuf.append(this.res.getString("wtr_time")).append(wtrTime).append(this.res.getString("time_unit"));
            } else {
                strBuf.append(this.res.getString("non_revertive"));
            }
        }
        strBuf.append(this.res.getString("working_unit"));
        int wneId = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"wneId").getValue());
        String wneName = this.mgr.getNE(wneId).getNEName();
        int wslotId = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"wslotId").getValue());
        int wportId = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"wportId").getValue());
        String workBoard = "";
        String subrackname = "";
        int wboardType = 0;
        if (wslotId == 0) {
            workBoard = "";
        } else {
            wboardType = TEConfigurationDataMgr.getInstance().getBoardType(neId, wslotId);
            subrackname = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)wslotId);
            workBoard = subrackname.isEmpty() ? workBoard : subrackname + "-";
            workBoard = workBoard + TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)wslotId) + "-" + TEConfigurationDataMgr.getInstance().getBoardTypeName(neId, wboardType) + "-" + TEConfigurationDataMgr.getInstance().getPortName(neId, wslotId, wboardType, wportId);
        }
        strBuf.append(wneName).append("-").append(workBoard);
        strBuf.append(this.res.getString("working_unit_delaytime"));
        int wDelaytime = 0;
        if (!Datainterface.getParam((Param[])params, (String)"wdelayTime").getValue().equals("-")) {
            wDelaytime = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"wdelayTime").getValue());
        }
        strBuf.append(String.valueOf((float)wDelaytime / 10.0f)).append(this.res.getString("time_unit"));
        strBuf.append(this.res.getString("protection_unit"));
        int pneId = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"pneId").getValue());
        String pneName = this.mgr.getNE(pneId).getNEName();
        int pslotId = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"pslotId").getValue());
        int pportId = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"pportId").getValue());
        String protectBoard = "";
        int pboardType = 0;
        if (pslotId == 0) {
            protectBoard = "";
        } else {
            pboardType = TEConfigurationDataMgr.getInstance().getBoardType(neId, pslotId);
            subrackname = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)pslotId);
            protectBoard = subrackname.isEmpty() ? protectBoard : subrackname + "-";
            protectBoard = protectBoard + TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)pslotId) + "-" + TEConfigurationDataMgr.getInstance().getBoardTypeName(neId, pboardType) + "-" + TEConfigurationDataMgr.getInstance().getPortName(neId, pslotId, pboardType, pportId);
        }
        strBuf.append(pneName).append("-").append(protectBoard);
        strBuf.append(this.res.getString("protection_unit_delaytime"));
        int pDelaytime = 0;
        if (!Datainterface.getParam((Param[])params, (String)"pdelayTime").getValue().equals("-")) {
            pDelaytime = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"pdelayTime").getValue());
        }
        strBuf.append(String.valueOf((float)pDelaytime / 10.0f)).append(this.res.getString("time_unit"));
        if (null != Datainterface.getParam((Param[])params, (String)"cwprotectionGroupUnit")) {
            int cwslotId = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"cwslotId").getValue());
            int cwportId1 = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"cwportId").getValue());
            controlBoardport1 = "";
            int cwboardType = 0;
            boardTypeName = "";
            if (cwslotId == 0) {
                controlBoardport1 = "";
            } else if (!MANAGE_RANGE_OUT.equals(Datainterface.getParam((Param[])params, (String)"cwneId").getValue())) {
                int cwneId = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"cwneId").getValue());
                String cwneName = this.mgr.getNE(cwneId).getNEName();
                cwboardType = TEConfigurationDataMgr.getInstance().getBoardType(neId, cwslotId);
                boardTypeName = TEConfigurationDataMgr.getInstance().getBoardTypeName(neId, cwboardType);
                subrackname = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)cwslotId);
                controlBoardport1 = subrackname.isEmpty() ? controlBoardport1 : subrackname + "-";
                controlBoardport1 = controlBoardport1 + TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)cwslotId) + "-" + boardTypeName + "-" + TEConfigurationDataMgr.getInstance().getPortName(neId, cwslotId, cwboardType, cwportId1);
                strBuf.append(this.res.getString("control_unit_working_path"));
                strBuf.append(cwneName).append("-").append(controlBoardport1);
            } else {
                strBuf.append(this.res.getString("control_unit_working_path")).append(this.otherDevice);
            }
        }
        if (null != Datainterface.getParam((Param[])params, (String)"dwprotectionGroupUnit")) {
            int dwslotId = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"dwslotId").getValue());
            int dwportId1 = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"dwportId").getValue());
            controlBoardport1 = "";
            int dwboardType = 0;
            boardTypeName = "";
            if (dwslotId == 0) {
                controlBoardport1 = "";
            } else if (!MANAGE_RANGE_OUT.equals(Datainterface.getParam((Param[])params, (String)"dwneId").getValue())) {
                int dwneId = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"dwneId").getValue());
                String dwneName = this.mgr.getNE(dwneId).getNEName();
                dwboardType = TEConfigurationDataMgr.getInstance().getBoardType(neId, dwslotId);
                boardTypeName = TEConfigurationDataMgr.getInstance().getBoardTypeName(neId, dwboardType);
                subrackname = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)dwslotId);
                controlBoardport1 = subrackname.isEmpty() ? controlBoardport1 : subrackname + "-";
                controlBoardport1 = controlBoardport1 + TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)dwslotId) + "-" + boardTypeName + "-" + TEConfigurationDataMgr.getInstance().getPortName(neId, dwslotId, dwboardType, dwportId1);
                strBuf.append(this.res.getString("control_unit_working_path"));
                strBuf.append(dwneName).append("-").append(controlBoardport1);
            } else {
                strBuf.append(this.res.getString("control_unit_working_path")).append(this.otherDevice);
            }
        }
        if (Datainterface.getParam((Param[])params, (String)"SDEnable") != null) {
            strBuf.append(this.res.getString("sd_trigger_flag"));
            int sdFlag = Integer.parseInt(Datainterface.getParam((Param[])params, (String)"SDEnable").getValue());
            if (sdFlag == 1) {
                strBuf.append(this.res.getString("enabled"));
            } else {
                strBuf.append(this.res.getString("disabled"));
            }
        }
        if (Datainterface.getParam((Param[])params, (String)"switchDectTime") != null) {
            strBuf.append(this.res.getString("switchDectTime"));
            strBuf.append(Datainterface.getParam((Param[])params, (String)"switchDectTime").getValue());
        }
        if (Datainterface.getParam((Param[])params, (String)"switchType") != null) {
            strBuf.append(this.res.getString("switchType"));
            String switchType = Datainterface.getParam((Param[])params, (String)"switchType").getValue();
            if ("0".equals(switchType)) {
                strBuf.append(this.res.getString("APS_MODE_0"));
            } else {
                strBuf.append(this.res.getString("APS_MODE_1"));
                String apsChannel = Datainterface.getParam((Param[])params, (String)"apsChannel").getValue();
                strBuf.append(this.res.getString("apsChannel"));
                strBuf.append(apsChannel);
            }
        }
        return strBuf.toString();
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> filterArrayList = new ArrayList<Integer>();
        filterArrayList.add(37898);
        return filterArrayList;
    }
}

