/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.oxc_u2kv2r1c00;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEWaveLengthInfoStaticData;
import com.huawei.nglct.nemgr.ngwdm.oxc.TEWDMOXCCommon;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TEWDMSingleBoardOXCCreateBean
extends TENEExplorerBean {
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String STRING_SOURCE = "ngwdm" + File.separator + "res" + File.separator + "oxc" + File.separator + "oxcres_" + LANGUAGE + ".ini";
    private TEResourceUtil resource = null;
    private List logInfoList = new ArrayList();
    private TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
    private TEWaveLengthInfoStaticData waveLeninfo = TEWaveLengthInfoStaticData.getInstance();

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        int rowCount = inputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < rowCount; ++i) {
            long freqnum;
            int freq;
            int band;
            int wave;
            RowParams rParams = inputData.getBussinessParams().getRowParams(i);
            if (rParams.getParam("srcwave") != null && rParams.getParam("srcwave").getValue() != null) {
                wave = Integer.parseInt(rParams.getParam("srcwave").getValue());
                band = Integer.parseInt(rParams.getParam("srcband").getValue());
                freq = this.waveLeninfo.getFrequencybyWaveNoBy(band, wave);
                if (freq != -1) {
                    freqnum = (long)freq * 1000L;
                    rParams.addParam("srcCenterFreq", String.valueOf(freqnum));
                    rParams.addParam("srcBandWidth", TEWDMOXCCommon.STND_BANDWIDTH);
                }
            }
            if (rParams.getParam("snkwave") == null || rParams.getParam("snkwave").getValue() == null) continue;
            wave = Integer.parseInt(rParams.getParam("snkwave").getValue());
            band = Integer.parseInt(rParams.getParam("snkband").getValue());
            freq = this.waveLeninfo.getFrequencybyWaveNoBy(band, wave);
            if (freq == -1) continue;
            freqnum = (long)freq * 1000L;
            rParams.addParam("sinkCenterFreq", String.valueOf(freqnum));
            rParams.addParam("sinkBandWidth", TEWDMOXCCommon.STND_BANDWIDTH);
        }
        super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
        this.setOperationObject();
        try {
            TENEListUtils.sendVerify((int)neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEWDMSingleBoardOXCCreateBean.performBussinessProcess() fail!", (Throwable)e);
        }
        return this.outputData;
    }

    public boolean isNeedOperationlog() {
        return true;
    }

    private void setOperationObject() {
        BussinessParams bussiness = this.outputData.getBussinessParams();
        if (null != bussiness) {
            int rowCount = bussiness.getRowParamsCount();
            for (int i = 0; i < rowCount; ++i) {
                RowParams rowParams = bussiness.getRowParams(i);
                if (null == rowParams) continue;
                int rowErrorsCount = rowParams.getRowErrorsCount();
                for (int j = 0; j < rowErrorsCount; ++j) {
                    RowErrors rowErrs = rowParams.getRowErrors(j);
                    if (null == rowErrs) continue;
                    int slotId = Integer.parseInt(rowErrs.getParam("srcslot").getValue());
                    int bdType = this.cfgDataMgr.getBoardType(this.neid, slotId);
                    String bdName = this.cfgDataMgr.getBoardTypeName(this.neid, bdType);
                    int portId = Integer.parseInt(rowErrs.getParam("srcport").getValue());
                    String portName = this.cfgDataMgr.getPortName(this.neid, slotId, bdType, portId);
                    int bandId = Integer.parseInt(rowErrs.getParam("srcband").getValue());
                    String bandName = TEWaveLengthInfoStaticData.getWaveBandTypeName((int)bandId);
                    String waveNo = "";
                    if (rowErrs.getParam("srcwave") == null || rowErrs.getParam("srcwave").getValue() == null) {
                        rowErrs.getParam("srcCenterFreq").getValue();
                        int waveFreq = Integer.parseInt(rowErrs.getParam("srcCenterFreq").getValue()) / 1000;
                        waveNo = TEWDMOXCCommon.getGridLessShowWavelenth(bandId, Integer.parseInt(rowErrs.getParam("srcCenterFreq").getValue()), Integer.parseInt(rowErrs.getParam("srcBandWidth").getValue()), this.waveLeninfo.getWaveNoByFrequency(bandId, waveFreq));
                    } else {
                        waveNo = rowErrs.getParam("srcwave").getValue();
                    }
                    String source = "";
                    String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotId);
                    if (!"".equals(subrackName)) {
                        source = source + subrackName + "-";
                    }
                    source = source + TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slotId);
                    source = source + "-" + bdName + "-" + portName + "-" + bandName + "-" + waveNo;
                    rowErrs.addParam(new Param("source", source));
                    slotId = Integer.parseInt(rowErrs.getParam("snkslot").getValue());
                    bdType = this.cfgDataMgr.getBoardType(this.neid, slotId);
                    bdName = this.cfgDataMgr.getBoardTypeName(this.neid, bdType);
                    portId = Integer.parseInt(rowErrs.getParam("snkport").getValue());
                    portName = this.cfgDataMgr.getPortName(this.neid, slotId, bdType, portId);
                    String sink = "";
                    subrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotId);
                    if (!"".equals(subrackName)) {
                        sink = sink + subrackName + "-";
                    }
                    sink = sink + TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slotId) + "-" + bdName + "-" + portName + "-" + bandName + "-" + waveNo;
                    rowErrs.addParam(new Param("sink", sink));
                }
            }
        }
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        this.resource = TEGetFilePath.getResource((int)neid, (String)STRING_SOURCE);
        try {
            if (outputData.getErrorMessage().getErrorcode().equals(String.valueOf(1090646019))) {
                return;
            }
            TENE neObj = this.cfgDataMgr.getNE(neid);
            String operObject = "";
            operObject = null == neObj ? String.valueOf(neid) : neObj.getNEName();
            String operateName = subfunc.getSubFuncDes(neid);
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            switch (errorCode) {
                case 1090646019: {
                    break;
                }
                case 0: {
                    this.logSuccess(user, ipAddress, operObject, operateName, errorCode);
                    break;
                }
                case 1: {
                    this.logSuccess(user, ipAddress, operObject, operateName, errorCode);
                    this.logFail(user, ipAddress, operObject, operateName);
                    break;
                }
                case 2: {
                    this.logFail(user, ipAddress, operObject, operateName);
                    break;
                }
                default: {
                    this.logOther(user, ipAddress, operObject, operateName, errorCode);
                }
            }
            int size = this.logInfoList.size();
            for (int i = 0; i < size; ++i) {
                TELogMgr.writeLog((TELogInfo)((TELogInfo)this.logInfoList.get(i)));
            }
        }
        catch (Exception e) {
            return;
        }
    }

    private void logSuccess(String user, String ipAddress, String operateObject, String operateName, int errorCode) {
        RowParams rowParams = null;
        int rowCount = this.inputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < rowCount; ++i) {
            String desc = "";
            TELogInfo loginf = new TELogInfo();
            loginf.setCmdID(this.subfunc.getCode());
            loginf.setLocation(ipAddress);
            loginf.setUserName(TESysManagerBean.getInstance().getSysUser());
            loginf.setOperateObject(operateObject);
            loginf.setOperateName(operateName);
            rowParams = this.inputData.getBussinessParams().getRowParams(i);
            int slot = Integer.parseInt(rowParams.getParam("srcslot").getValue());
            int bdType = this.cfgDataMgr.getBoardType(this.neid, slot);
            String boardName = this.cfgDataMgr.getBoardTypeName(this.neid, bdType);
            int portId = Integer.parseInt(rowParams.getParam("srcport").getValue());
            String portName = this.cfgDataMgr.getPortName(this.neid, slot, bdType, portId);
            int bandId = Integer.parseInt(rowParams.getParam("srcband").getValue());
            String bandName = TEWaveLengthInfoStaticData.getWaveBandTypeName((int)bandId);
            String waveNo = rowParams.getParam("srcwave").getValue();
            desc = desc + operateName + "," + this.resource.getString("source") + "[" + operateObject + "-";
            String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slot);
            if (!"".equals(subrackName)) {
                desc = desc + subrackName + "-";
            }
            desc = desc + TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slot) + "-" + boardName + "-" + portName + "-" + bandName + "-" + waveNo + "],";
            slot = Integer.parseInt(rowParams.getParam("snkslot").getValue());
            bdType = this.cfgDataMgr.getBoardType(this.neid, slot);
            boardName = this.cfgDataMgr.getBoardTypeName(this.neid, bdType);
            portId = Integer.parseInt(rowParams.getParam("snkport").getValue());
            portName = this.cfgDataMgr.getPortName(this.neid, slot, bdType, portId);
            desc = desc + this.resource.getString("sink") + "[" + operateObject + "-";
            subrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slot);
            if (!"".equals(subrackName)) {
                desc = desc + subrackName + "-";
            }
            desc = desc + TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slot) + "-" + boardName + "-" + portName + "-" + bandName + "-" + waveNo + "]";
            loginf.setOperateDesc(desc);
            loginf.setResult(0);
            loginf.setErrCode(0);
            loginf.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
            this.logInfoList.add(loginf);
        }
    }

    private void logFail(String user, String ipAddress, String operateObject, String operateName) {
        int len = this.outputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            RowErrors[] rowErrors = this.outputData.getBussinessParams().getRowParams(i).getRowErrors();
            int size = rowErrors.length;
            for (int j = 0; j < size; ++j) {
                String descStr = "";
                int slotId = Integer.parseInt(rowErrors[j].getParam("srcslot").getValue());
                int bdType = this.cfgDataMgr.getBoardType(this.neid, slotId);
                String boardName = this.cfgDataMgr.getBoardTypeName(this.neid, bdType);
                int portId = Integer.parseInt(rowErrors[j].getParam("srcport").getValue());
                String portName = this.cfgDataMgr.getPortName(this.neid, slotId, bdType, portId);
                int bandId = Integer.parseInt(rowErrors[j].getParam("srcband").getValue());
                String bandName = TEWaveLengthInfoStaticData.getWaveBandTypeName((int)bandId);
                String waveNo = rowErrors[j].getParam("srcwave").getValue();
                descStr = descStr + operateName + "," + this.resource.getString("source") + "[" + operateObject + "-";
                String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotId);
                if (!"".equals(subrackName)) {
                    descStr = descStr + subrackName + "-";
                }
                descStr = descStr + TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slotId) + "-" + boardName + "-" + portName + "-" + bandName + "-" + waveNo + "],";
                slotId = Integer.parseInt(rowErrors[j].getParam("snkslot").getValue());
                bdType = this.cfgDataMgr.getBoardType(this.neid, slotId);
                boardName = this.cfgDataMgr.getBoardTypeName(this.neid, bdType);
                portId = Integer.parseInt(rowErrors[j].getParam("snkport").getValue());
                portName = this.cfgDataMgr.getPortName(this.neid, slotId, bdType, portId);
                descStr = descStr + this.resource.getString("sink") + "[" + operateObject + "-";
                subrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotId);
                if (!"".equals(subrackName)) {
                    descStr = descStr + subrackName + "-";
                }
                descStr = descStr + TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slotId) + "-" + boardName + "-" + portName + "-" + bandName + "-" + waveNo + "]";
                for (int k = this.logInfoList.size() - 1; k >= 0; --k) {
                    TELogInfo loginfo = (TELogInfo)this.logInfoList.get(k);
                    if (!loginfo.getOperateDesc().equalsIgnoreCase(descStr)) continue;
                    this.logInfoList.remove(k);
                }
                TELogInfo log = new TELogInfo();
                log.setCmdID(this.subfunc.getCode());
                log.setLocation(ipAddress);
                log.setUserName(TESysManagerBean.getInstance().getSysUser());
                log.setOperateObject(operateObject);
                log.setOperateName(operateName);
                log.setOperateDesc(descStr);
                log.setResult(2);
                log.setErrCode(Integer.parseInt(rowErrors[j].getErrorMessage().getErrorcode()));
                log.setErrInfo(rowErrors[i].getErrorMessage().getErrorinfo());
                this.logInfoList.add(log);
            }
        }
    }

    private void logOther(String user, String ipAddress, String operateObject, String operateName, int errorCode) {
        TELogInfo loginf = new TELogInfo();
        loginf.setCmdID(this.subfunc.getCode());
        loginf.setLocation(ipAddress);
        loginf.setUserName(TESysManagerBean.getInstance().getSysUser());
        loginf.setOperateObject(operateObject);
        loginf.setOperateName(operateName);
        loginf.setOperateDesc(operateName);
        loginf.setResult(2);
        loginf.setErrCode(errorCode);
        loginf.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
        this.logInfoList.add(loginf);
    }
}

