/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.oxc_u2kv2r1c00;

import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEWaveLengthInfoStaticData;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.ngwdm.oxc.TEOXCDataBean;
import com.huawei.nglct.nemgr.ngwdm.oxc.TEQuerySingleStationOXCSuperBean;
import com.huawei.nglct.nemgr.ngwdm.oxc.TEWDMOXCCommon;
import java.util.ArrayList;

public class TEQuerySingleStationOXCBean
extends TEQuerySingleStationOXCSuperBean {
    public TEQuerySingleStationOXCBean() {
        this.bandMap.put("0", "CAndL");
        this.bandMap.put("1", "C");
        this.bandMap.put("2", "L");
        this.bandMap.put("3", "C32");
        this.bandMap.put("4", "RAMANC");
        this.bandMap.put("5", "RAMANL");
        this.bandMap.put("6", "CWDM");
        this.bandMap.put("7", "SMC");
        this.bandMap.put("8", "C96A");
        this.bandMap.put("9", "C96B");
        this.bandMap.put("10", "C192");
        this.manualMap.put("2", "manualmodel");
        this.manualMap.put("1", "automodel");
        this.manualMap.put("0", "manualmodel");
        this.ssMap.put("0", "hand");
        this.ssMap.put("1", "itg");
    }

    @Override
    protected void convertOXCDataToRowData(Datainterface output, ArrayList eventList, int neid) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        TEConfigurationDataMgr cfgData = TEConfigurationDataMgr.getInstance();
        TEWaveLengthInfoStaticData waveLeninfo = TEWaveLengthInfoStaticData.getInstance();
        RowParams rowparams = null;
        int size = eventList.size();
        for (int i = 0; i < size; ++i) {
            TEOXCDataBean record = (TEOXCDataBean)eventList.get(i);
            rowparams = new RowParams();
            rowparams.addParam("oxcid", record.getOxcID() + "");
            TEBoard srcBoard = ne.getBoard(record.getSrcSlotID());
            rowparams.addParam("srcSlotId", String.valueOf(record.getSrcSlotID()));
            rowparams.addParam("srcSlot", TEWDMOXCCommon.getName(neid, record.getSrcSlotID(), srcBoard.getBoardName()));
            String srcPortName = cfgData.getPortName(neid, record.getSrcSlotID(), srcBoard.getBoardType(), record.getSrcPortID());
            rowparams.addParam("srcPort", srcPortName);
            rowparams.addParam("srcBand", record.getSrcBandID() + "");
            rowparams.addParam("srcBandName", this.bandMap.get(String.valueOf(record.getSrcBandID())) + "");
            int srcBand = record.getSrcBandID();
            int srcWaveFreq = record.getSrcCenterFreq() / 1000;
            int srcBandWidth = record.getSrcBandWidth();
            int srcwaveNo = -1;
            if (srcBandWidth == 50000) {
                srcwaveNo = waveLeninfo.getWaveNoByFrequency(srcBand, srcWaveFreq);
            }
            String srcWaveLenInfo = "/";
            if (srcwaveNo != -1) {
                srcWaveLenInfo = String.valueOf(srcwaveNo);
            }
            rowparams.addParam("srcWaveLenNO", srcWaveLenInfo);
            String waveLength = TEWDMOXCCommon.getGridLessShowWavelenth(srcBand, record.getSrcCenterFreq(), srcBandWidth, srcwaveNo);
            rowparams.addParam("srcWaveLen", waveLength);
            rowparams.addParam("srcCenterFreq", String.valueOf(record.getSrcCenterFreq()));
            rowparams.addParam("srcBandWidth", String.valueOf(record.getSrcBandWidth()));
            TEBoard sinkBoard = ne.getBoard(record.getSinkSlotID());
            String sinkBdTypeName = sinkBoard.getBoardTypeName();
            rowparams.addParam("sinkSlotId", String.valueOf(record.getSinkSlotID()));
            rowparams.addParam("sinkSlot", TEWDMOXCCommon.getName(neid, record.getSinkSlotID(), sinkBdTypeName));
            String sinkPortName = cfgData.getPortName(neid, record.getSinkSlotID(), sinkBoard.getBoardType(), record.getSinkPortID());
            rowparams.addParam("sinkPort", sinkPortName);
            rowparams.addParam("sinkBand", record.getSinkBandID() + "");
            rowparams.addParam("sinkBandName", this.bandMap.get(String.valueOf(record.getSinkBandID())) + "");
            int snkBand = record.getSinkBandID();
            int snkWaveFreq = record.getSinkCenterFreq() / 1000;
            int snkwaveNo = -1;
            int snkBandWidth = record.getSinkBandWidth();
            if (snkBandWidth == 50000) {
                snkwaveNo = waveLeninfo.getWaveNoByFrequency(snkBand, snkWaveFreq);
            }
            String snkWaveLenInfo = "/";
            if (snkwaveNo != -1) {
                snkWaveLenInfo = String.valueOf(snkwaveNo);
            }
            rowparams.addParam("sinkWaveLenNO", snkWaveLenInfo);
            String waveLengthSnk = TEWDMOXCCommon.getGridLessShowWavelenth(snkBand, record.getSinkCenterFreq(), snkBandWidth, snkwaveNo);
            rowparams.addParam("sinkWaveLen", waveLengthSnk);
            rowparams.addParam("sinkCenterFreq", String.valueOf(record.getSinkCenterFreq()));
            rowparams.addParam("sinkBandWidth", String.valueOf(record.getSinkBandWidth()));
            rowparams.addParam("belongoxcid", record.getBelongOXCID() + "");
            rowparams.addParam("manual", record.getManual() + "");
            rowparams.addParam("manualName", this.resourceUtil.getString(this.manualMap.get(String.valueOf(record.getManual())).toString()) + "");
            rowparams.addParam("serviceSource", record.getSerSource() + "");
            rowparams.addParam("serviceSourceName", this.resourceUtil.getString(this.ssMap.get(String.valueOf(record.getSerSource())).toString()) + "");
            if (srcBoard.getBoardType() == 1542 || srcBoard.getBoardType() == 2213 || srcBoard.getBoardType() == 2430 || sinkBoard.getBoardType() == 1542 || sinkBoard.getBoardType() == 2213 || sinkBoard.getBoardType() == 2430 || TESpecialAttrMgr.getInstance().isCPSupportByType(srcBoard.getBoardType(), "TE_FUNC_CFG_WDM_OXC", "OTN_ATTR_SUPPORT_PID_AND_OXCSRC")) {
                rowparams.addParam("isPIDoxc", "true");
            } else {
                rowparams.addParam("isPIDoxc", "false");
            }
            output.getBussinessParams().addRowParams(rowparams);
        }
    }
}

