/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.oxc_u2kv2r1c00;

import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEWaveLengthInfoStaticData;
import com.huawei.nglct.nemgr.ngwdm.oxc.TEQueryLittleOxcSuperBean;
import com.huawei.nglct.nemgr.ngwdm.oxc.TEWDMOXCCommon;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;

public class TEQueryLittleOxcBean
extends TEQueryLittleOxcSuperBean {
    @Override
    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        String oId = this.inputData.getBussinessParams().getRowParams(0).getParam("oxcid").getValue();
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        TEWaveLengthInfoStaticData waveLeninfo = TEWaveLengthInfoStaticData.getInstance();
        TEConfigurationDataMgr cfgData = TEConfigurationDataMgr.getInstance();
        if (null != operationList && operationList.size() > 0) {
            int i;
            ArrayList errorData = TEDataConverter.joinOperation((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
            Operation operation = null;
            RowParams rowparams = null;
            Output output = null;
            this.outputData.setBussinessParams(new BussinessParams());
            boolean succ = false;
            boolean fault = false;
            boolean row_succ = false;
            int len = operationList.size();
            for (i = 0; i < len; ++i) {
                operation = (Operation)operationList.get(i);
                TEDataConverter.handleSpecialStr((Operation)operation);
                if (operation.getOutputCount() == 0) {
                    succ = true;
                }
                int size = operation.getOutputCount();
                for (int row = 0; row < size; ++row) {
                    output = operation.getOutput(row);
                    row_succ = TEDataConverter.handleRowError((Output)output, (ArrayList)filterErrorCodeList);
                    if (row_succ) {
                        String belongoxcId;
                        succ = true;
                        boolean flag = false;
                        int errorSize = output.getFaultCount();
                        for (int a = 0; a < errorSize; ++a) {
                            int faultCode = Integer.parseInt(output.getFault(a).getCode());
                            if (0 == faultCode || filterErrorCodeList.contains(faultCode)) continue;
                            flag = true;
                            break;
                        }
                        if (!flag && (belongoxcId = output.getPartValue("belongoxcid")).equals(oId)) {
                            rowparams = this.createRowParam(ne, waveLeninfo, cfgData, output);
                            this.outputData.getBussinessParams().addRowParams(rowparams);
                        }
                    }
                    row_succ = false;
                }
            }
            if (null != errorData && !errorData.isEmpty()) {
                fault = true;
                rowparams = new RowParams();
                int size = errorData.size();
                for (i = 0; i < size; ++i) {
                    rowparams.addRowErrors((RowErrors)errorData.get(i));
                }
                this.outputData.getBussinessParams().addRowParams(rowparams);
            }
            this.outputData.setErrorMessage(new ErrorMessage());
            if (succ && !fault) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
            } else if (!succ && fault) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
            }
        } else {
            this.outputData = null;
        }
    }

    private RowParams createRowParam(TENE ne, TEWaveLengthInfoStaticData waveLeninfo, TEConfigurationDataMgr cfgData, Output output) {
        int neid = ne.getNEID();
        RowParams rowparams = new RowParams();
        String oxcid = output.getPartValue("oxcid");
        Param param = new Param("oxcid", oxcid);
        rowparams.addParam(param);
        String srcSlot = output.getPartValue("srcSlot");
        int srcSlotId = Integer.parseInt(srcSlot);
        TEBoard srcBoard = ne.getBoard(srcSlotId);
        String srcBdTypeName = srcBoard.getBoardTypeName();
        String srcSlotStr = TEWDMOXCCommon.getName(neid, srcSlotId, srcBdTypeName);
        param = new Param("srcSlot", srcSlotStr);
        rowparams.addParam(param);
        String srcPort = output.getPartValue("srcPort");
        String srcPortName = cfgData.getPortName(neid, srcSlotId, srcBoard.getBoardType(), Integer.parseInt(srcPort));
        param = new Param("srcPort", srcPortName);
        rowparams.addParam(param);
        String srcWaveBand = output.getPartValue("srcBand");
        param = new Param("srcBand", srcWaveBand);
        rowparams.addParam(param);
        int srcBand = Integer.parseInt(srcWaveBand);
        int srcWaveLenFreq = Integer.parseInt(output.getPartValue("srcCenterFreq"));
        int waveFreq = srcWaveLenFreq / 1000;
        int waveNo = waveLeninfo.getWaveNoByFrequency(srcBand, waveFreq);
        String srcWaveLenInfo = "/";
        if (waveNo != -1) {
            srcWaveLenInfo = String.valueOf(waveNo);
        }
        param = new Param("srcWaveLenNO", srcWaveLenInfo);
        rowparams.addParam(param);
        int srcBandWidth = Integer.parseInt(output.getPartValue("srcBandWidth"));
        String waveLength = TEWDMOXCCommon.getGridLessShowWavelenth(srcBand, srcWaveLenFreq, srcBandWidth, waveNo);
        param = new Param("srcWaveLen", waveLength);
        rowparams.addParam(param);
        String sinkSlot = output.getPartValue("sinkSlot");
        int sinkSlotId = Integer.parseInt(sinkSlot);
        TEBoard sinkBoard = ne.getBoard(sinkSlotId);
        String sinkBdTypeName = sinkBoard.getBoardTypeName();
        String sinkSlotStr = TEWDMOXCCommon.getName(neid, sinkSlotId, sinkBdTypeName);
        param = new Param("sinkSlot", sinkSlotStr);
        rowparams.addParam(param);
        String sinkPort = output.getPartValue("sinkPort");
        String sinkPortName = cfgData.getPortName(neid, sinkSlotId, sinkBoard.getBoardType(), Integer.parseInt(sinkPort));
        param = new Param("sinkPort", sinkPortName);
        rowparams.addParam(param);
        String sinkWaveBand = output.getPartValue("sinkBand");
        param = new Param("sinkBand", sinkWaveBand);
        rowparams.addParam(param);
        int snkBand = Integer.parseInt(sinkWaveBand);
        int snkWaveLenFreq = Integer.parseInt(output.getPartValue("sinkCenterFreq"));
        int waveFreqSnk = snkWaveLenFreq / 1000;
        int waveNoSnk = waveLeninfo.getWaveNoByFrequency(snkBand, waveFreqSnk);
        String snkWaveLenInfo = "/";
        if (waveNo != -1) {
            snkWaveLenInfo = String.valueOf(waveNoSnk);
        }
        param = new Param("sinkWaveLenNO", snkWaveLenInfo);
        rowparams.addParam(param);
        int snkBandWidth = Integer.parseInt(output.getPartValue("sinkBandWidth"));
        String waveLengthSnk = TEWDMOXCCommon.getGridLessShowWavelenth(snkBand, snkWaveLenFreq, snkBandWidth, waveNoSnk);
        param = new Param("sinkWaveLen", waveLengthSnk);
        rowparams.addParam(param);
        String belongoxcid = output.getPartValue("belongoxcid");
        param = new Param("belongoxcid", belongoxcid);
        rowparams.addParam(param);
        param = new Param("manual", output.getPartValue("manual"));
        rowparams.addParam(param);
        return rowparams;
    }
}

