/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.oxc;

import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEWaveLengthInfoStaticData;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public abstract class TEWDMSingleSiteOXCCreateSuperBean
extends TENEExplorerBean {
    protected List oxcIdList = new ArrayList();
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String STRING_SOURCE = "ngwdm" + File.separator + "res" + File.separator + "oxc" + File.separator + "oxcres_" + LANGUAGE + ".ini";
    private TEResourceUtil resourceUtil = null;
    private List logInfoList = new ArrayList();
    private TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();

    public boolean isNeedOperationlog() {
        return true;
    }

    protected void setOperationObject() {
        BussinessParams bussinessParams = this.outputData.getBussinessParams();
        if (null != bussinessParams) {
            int rowCount = bussinessParams.getRowParamsCount();
            for (int i = 0; i < rowCount; ++i) {
                RowParams rowParams = bussinessParams.getRowParams(i);
                if (null == rowParams) continue;
                int rowErrorsCount = rowParams.getRowErrorsCount();
                for (int j = 0; j < rowErrorsCount; ++j) {
                    RowErrors rowErrors = rowParams.getRowErrors(j);
                    if (null == rowErrors) continue;
                    int slotId = Integer.parseInt(rowErrors.getParam("srcslot").getValue());
                    int bdType = this.cfgDataMgr.getBoardType(this.neid, slotId);
                    String bdName = this.cfgDataMgr.getBoardTypeName(this.neid, bdType);
                    int portId = Integer.parseInt(rowErrors.getParam("srcport").getValue());
                    String portName = this.cfgDataMgr.getPortName(this.neid, slotId, bdType, portId);
                    int bandId = Integer.parseInt(rowErrors.getParam("srcband").getValue());
                    String bandName = TEWaveLengthInfoStaticData.getWaveBandTypeName((int)bandId);
                    String waveNo = rowErrors.getParam("srcwave").getValue();
                    String inSubrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotId);
                    String inSlotName = TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slotId) + "";
                    if (!"".equals(inSubrackName)) {
                        inSlotName = inSubrackName + "-" + inSlotName;
                    }
                    String source = inSlotName + "-" + bdName + "-" + portName + "-" + bandName + "-" + waveNo;
                    rowErrors.addParam(new Param("source", source));
                    slotId = Integer.parseInt(rowErrors.getParam("snkslot").getValue());
                    bdType = this.cfgDataMgr.getBoardType(this.neid, slotId);
                    bdName = this.cfgDataMgr.getBoardTypeName(this.neid, bdType);
                    portId = Integer.parseInt(rowErrors.getParam("snkport").getValue());
                    portName = this.cfgDataMgr.getPortName(this.neid, slotId, bdType, portId);
                    String outSubrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotId);
                    String outSlotName = TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slotId) + "";
                    if (!"".equals(outSubrackName)) {
                        outSlotName = outSubrackName + "-" + outSlotName;
                    }
                    String sink = outSlotName + "-" + bdName + "-" + portName + "-" + bandName + "-" + waveNo;
                    rowErrors.addParam(new Param("sink", sink));
                }
            }
        }
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        this.resourceUtil = TEGetFilePath.getResource((int)neid, (String)STRING_SOURCE);
        try {
            if (outputData.getErrorMessage().getErrorcode().equals(String.valueOf(1090646019))) {
                return;
            }
            TENE neObj = this.cfgDataMgr.getNE(neid);
            String operateObject = "";
            operateObject = null == neObj ? String.valueOf(neid) : neObj.getNEName();
            String operateName = subfunc.getSubFuncDes(neid);
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            switch (errorCode) {
                case 1090646019: {
                    break;
                }
                case 0: {
                    this.logSuccess(user, ipAddress, operateObject, operateName, errorCode);
                    break;
                }
                case 1: {
                    this.logSuccess(user, ipAddress, operateObject, operateName, errorCode);
                    this.logFail(user, ipAddress, operateObject, operateName);
                    break;
                }
                case 2: {
                    this.logFail(user, ipAddress, operateObject, operateName);
                    break;
                }
                default: {
                    this.logOther(user, ipAddress, operateObject, operateName, errorCode);
                }
            }
            int size = this.logInfoList.size();
            for (int i = 0; i < size; ++i) {
                TELogMgr.writeLog((TELogInfo)((TELogInfo)this.logInfoList.get(i)));
            }
        }
        catch (Exception e) {
            return;
        }
    }

    private void logSuccess(String user, String ipAddress, String operateObject, String operateName, int errorCode) {
        RowParams rowParams = null;
        int rowCount = this.inputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < rowCount; ++i) {
            String desc = "";
            TELogInfo loginfo = new TELogInfo();
            loginfo.setCmdID(this.subfunc.getCode());
            loginfo.setLocation(ipAddress);
            loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
            loginfo.setOperateObject(operateObject);
            loginfo.setOperateName(operateName);
            rowParams = this.inputData.getBussinessParams().getRowParams(i);
            int slotId = Integer.parseInt(rowParams.getParam("srcslot").getValue());
            int bdType = this.cfgDataMgr.getBoardType(this.neid, slotId);
            String boardName = this.cfgDataMgr.getBoardTypeName(this.neid, bdType);
            int portId = Integer.parseInt(rowParams.getParam("srcport").getValue());
            String portName = this.cfgDataMgr.getPortName(this.neid, slotId, bdType, portId);
            int bandId = Integer.parseInt(rowParams.getParam("srcband").getValue());
            String bandName = TEWaveLengthInfoStaticData.getWaveBandTypeName((int)bandId);
            String waveNo = rowParams.getParam("srcwave").getValue();
            String inSubrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotId);
            String inSlotName = TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slotId) + "";
            if (!"".equals(inSubrackName)) {
                inSlotName = inSubrackName + "-" + inSlotName;
            }
            desc = desc + operateName + "," + this.resourceUtil.getString("source") + "[" + operateObject + "-" + inSlotName + "-" + boardName + "-" + portName + "-" + bandName + "-" + waveNo + "],";
            slotId = Integer.parseInt(rowParams.getParam("snkslot").getValue());
            bdType = this.cfgDataMgr.getBoardType(this.neid, slotId);
            boardName = this.cfgDataMgr.getBoardTypeName(this.neid, bdType);
            portId = Integer.parseInt(rowParams.getParam("snkport").getValue());
            portName = this.cfgDataMgr.getPortName(this.neid, slotId, bdType, portId);
            String outSubrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotId);
            String outSlotName = TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slotId) + "";
            if (!"".equals(outSubrackName)) {
                outSlotName = outSubrackName + "-" + outSlotName;
            }
            desc = desc + this.resourceUtil.getString("sink") + "[" + operateObject + "-" + outSlotName + "-" + boardName + "-" + portName + "-" + bandName + "-" + waveNo + "]";
            loginfo.setOperateDesc(desc);
            loginfo.setResult(0);
            loginfo.setErrCode(0);
            loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
            this.logInfoList.add(loginfo);
        }
    }

    private void logFail(String user, String ipAddress, String operateObject, String operateName) {
        int len = this.outputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            RowErrors[] rowErrors = this.outputData.getBussinessParams().getRowParams(i).getRowErrors();
            int size = rowErrors.length;
            for (int j = 0; j < size; ++j) {
                String desc = "";
                int slotId = Integer.parseInt(rowErrors[j].getParam("srcslot").getValue());
                int bdType = this.cfgDataMgr.getBoardType(this.neid, slotId);
                String boardName = this.cfgDataMgr.getBoardTypeName(this.neid, bdType);
                int portId = Integer.parseInt(rowErrors[j].getParam("srcport").getValue());
                String portName = this.cfgDataMgr.getPortName(this.neid, slotId, bdType, portId);
                int bandId = Integer.parseInt(rowErrors[j].getParam("srcband").getValue());
                String bandName = TEWaveLengthInfoStaticData.getWaveBandTypeName((int)bandId);
                String waveNo = rowErrors[j].getParam("srcwave").getValue();
                String inSubrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotId);
                String inSlotName = TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slotId) + "";
                if (!"".equals(inSubrackName)) {
                    inSlotName = inSubrackName + "-" + inSlotName;
                }
                desc = desc + operateName + "," + this.resourceUtil.getString("source") + "[" + operateObject + "-" + inSlotName + "-" + boardName + "-" + portName + "-" + bandName + "-" + waveNo + "],";
                slotId = Integer.parseInt(rowErrors[j].getParam("snkslot").getValue());
                bdType = this.cfgDataMgr.getBoardType(this.neid, slotId);
                boardName = this.cfgDataMgr.getBoardTypeName(this.neid, bdType);
                portId = Integer.parseInt(rowErrors[j].getParam("snkport").getValue());
                portName = this.cfgDataMgr.getPortName(this.neid, slotId, bdType, portId);
                String outSubrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotId);
                String outSlotName = TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slotId) + "";
                if (!"".equals(outSubrackName)) {
                    outSlotName = outSubrackName + "-" + outSlotName;
                }
                desc = desc + this.resourceUtil.getString("sink") + "[" + operateObject + "-" + outSlotName + "-" + boardName + "-" + portName + "-" + bandName + "-" + waveNo + "]";
                for (int k = this.logInfoList.size() - 1; k >= 0; --k) {
                    TELogInfo loginfo = (TELogInfo)this.logInfoList.get(k);
                    if (!loginfo.getOperateDesc().equalsIgnoreCase(desc)) continue;
                    this.logInfoList.remove(k);
                }
                TELogInfo loginfo = new TELogInfo();
                loginfo.setCmdID(this.subfunc.getCode());
                loginfo.setLocation(ipAddress);
                loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
                loginfo.setOperateObject(operateObject);
                loginfo.setOperateName(operateName);
                loginfo.setOperateDesc(desc);
                loginfo.setResult(2);
                loginfo.setErrCode(Integer.parseInt(rowErrors[j].getErrorMessage().getErrorcode()));
                loginfo.setErrInfo(rowErrors[i].getErrorMessage().getErrorinfo());
                this.logInfoList.add(loginfo);
            }
        }
    }

    private void logOther(String user, String ipAddress, String operateObject, String operateName, int errorCode) {
        TELogInfo loginfo = new TELogInfo();
        loginfo.setCmdID(this.subfunc.getCode());
        loginfo.setLocation(ipAddress);
        loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
        loginfo.setOperateObject(operateObject);
        loginfo.setOperateName(operateName);
        loginfo.setOperateDesc(operateName);
        loginfo.setResult(2);
        loginfo.setErrCode(errorCode);
        loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
        this.logInfoList.add(loginfo);
    }
}

