/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.oxc;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nemgr.ngwdm.oxc.TEWDMSingleSiteOXCCreateSuperBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;

public class TEWDMSingleSiteOXCCreateBean
extends TEWDMSingleSiteOXCCreateSuperBean {
    private static final int MIN_OXCGROUP_ID = 1;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        try {
            this.setOXCIdList();
            int rowCount = inputData.getBussinessParams().getRowParamsCount();
            for (int i = 0; i < rowCount; ++i) {
                RowParams rParams = inputData.getBussinessParams().getRowParams(i);
                if (rParams.getParam("oxcid") == null) continue;
                rParams.getParam("oxcid").setValue(String.valueOf(this.getOXCID()));
            }
            this.operationList = TEDataConverter.convertToOperation((SubFunc)subFunc, (Datainterface)inputData, (int)neid);
            int result = this.sendMessage(neid);
            if (result == 0) {
                ArrayList filterErrorCodeList = this.getFilterErrorCodeList();
                this.handleMessage(neid, this.operationList, subFunc, filterErrorCodeList);
                TENEListUtils.sendVerify((int)neid);
                this.setOperationObject();
            } else {
                this.outputData = new Datainterface();
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEWDMSingleSiteOXCCreateBean perform failed!", (Throwable)e);
        }
        return this.outputData;
    }

    private void setOXCIdList() {
        this.operationList = new ArrayList();
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_OXC_GET_E2EOXC");
        if (operation != null) {
            Input input = operation.getInput();
            input.setPartValue("srcSlot", "0");
            input.setPartValue("sinkSlot", "0");
            this.operationList.add(operation);
            int result = this.sendMessage(this.neid);
            if (result == 0) {
                Output output = null;
                boolean row_succ = true;
                operation = (Operation)this.operationList.get(0);
                int n = operation.getOutputCount();
                for (int j = 0; j < n; ++j) {
                    int oxcid;
                    output = operation.getOutput(j);
                    if (output == null) continue;
                    int m = output.getFaultCount();
                    for (int i = 0; i < m; ++i) {
                        int errorCode = Integer.parseInt(output.getFault(i).getCode());
                        if (errorCode == 0) continue;
                        row_succ = false;
                        break;
                    }
                    if (!row_succ || (oxcid = Integer.parseInt(output.getPartValue("oxcid"))) <= 0) continue;
                    this.oxcIdList.add(new Integer(oxcid));
                }
            }
        }
    }

    private int getOXCID() {
        int oxcId = 1;
        if (this.oxcIdList == null) {
            this.oxcIdList = new ArrayList();
        }
        if (this.oxcIdList.size() > 0) {
            while (this.oxcIdList.contains(new Integer(oxcId))) {
                ++oxcId;
            }
        }
        this.oxcIdList.add(new Integer(oxcId));
        return oxcId;
    }
}

