/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.oxc;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.nelist.model.TEWaveLengthInfoStaticData;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nemgr.ngwdm.oxc.TEWDMOXCBoardInfoBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEWDMOXCCommon {
    private static final String WDM_OXC_BOARD_PATH = "nemgr" + File.separator + "ngwdm" + File.separator + "conf" + File.separator + "oxc" + File.separator + "oxcboard.xml";
    private static final String WORK_BAND_BY_BOARD_PATH = "nemgr" + File.separator + "ngwdm" + File.separator + "conf" + File.separator + "oxc" + File.separator + "workbandbyboard.xml";
    private static TEWaveLengthInfoStaticData waveLeninfo = TEWaveLengthInfoStaticData.getInstance();
    public static String STND_BANDWIDTH = "50000";

    public static Map getOXCBoardMap(int neid) {
        Bundle bundle = FrameworkUtil.getBundle(TEWDMOXCCommon.class);
        Document doc = null;
        try {
            doc = TEParseXMLFile.parseFile((Bundle)bundle, (String)WDM_OXC_BOARD_PATH);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse XML File fail!", (Throwable)e);
            return null;
        }
        if (doc != null) {
            HashMap<Integer, TEWDMOXCBoardInfoBean> oxcBoardMap = new HashMap<Integer, TEWDMOXCBoardInfoBean>();
            NodeList firstNodeList = doc.getChildNodes();
            Node firstNode = firstNodeList.item(0);
            NodeList secondNodeList = firstNode.getChildNodes();
            int m = secondNodeList.getLength();
            for (int i = 0; i < m; ++i) {
                Node secondNode = secondNodeList.item(i);
                if (!secondNode.getNodeName().equalsIgnoreCase("board_type")) continue;
                TEWDMOXCBoardInfoBean boardInfoBean = new TEWDMOXCBoardInfoBean();
                String boardType = secondNode.getAttributes().getNamedItem("value").getNodeValue();
                boardInfoBean.setBoardType(Integer.parseInt(boardType));
                NodeList thirdNodeList = secondNode.getChildNodes();
                int n = thirdNodeList.getLength();
                for (int j = 0; j < n; ++j) {
                    String portName;
                    Node fourNode;
                    int k;
                    int mn;
                    NodeList fourNodeList;
                    Node thirdNode = thirdNodeList.item(j);
                    if (thirdNode.getNodeName().equalsIgnoreCase("input_port")) {
                        fourNodeList = thirdNode.getChildNodes();
                        mn = fourNodeList.getLength();
                        for (k = 0; k < mn; ++k) {
                            fourNode = fourNodeList.item(k);
                            if (!fourNode.getNodeName().equalsIgnoreCase("port")) continue;
                            portName = fourNode.getAttributes().getNamedItem("value").getNodeValue();
                            boardInfoBean.addSrcPortList(portName);
                        }
                        continue;
                    }
                    if (!thirdNode.getNodeName().equalsIgnoreCase("output_port")) continue;
                    fourNodeList = thirdNode.getChildNodes();
                    mn = fourNodeList.getLength();
                    for (k = 0; k < mn; ++k) {
                        fourNode = fourNodeList.item(k);
                        if (!fourNode.getNodeName().equalsIgnoreCase("port")) continue;
                        portName = fourNode.getAttributes().getNamedItem("value").getNodeValue();
                        boardInfoBean.addSnkPortList(portName);
                    }
                }
                oxcBoardMap.put(Integer.valueOf(boardType), boardInfoBean);
            }
            return oxcBoardMap;
        }
        return null;
    }

    public static String getFindWaveBandCmd(int neid, int boardType, int portId) {
        if (TEGenCfgDataMgr.isSupportAttr((int)neid, (int)boardType, (int)portId, (String)"W32BRD_ATTR_CFGWORKBAND")) {
            return "NSCMD_CFG_GET_WORKBAND_LOG";
        }
        if (TEGenCfgDataMgr.isSupportAttr((int)neid, (int)boardType, (int)portId, (String)"W32BRD_ATTR_CFGWDMTYPE")) {
            return "NSCMD_CFG_GET_WAVELEN_LOG";
        }
        if (TEGenCfgDataMgr.isSupportAttr((int)neid, (int)boardType, (int)portId, (String)"W32BRD_ATTR_CFGUPDOWNWDMTYPE")) {
            return "NSCMD_CFG_GET_MDWAVE_LOG";
        }
        if (TEGenCfgDataMgr.isSupportAttr((int)neid, (int)boardType, (int)portId, (String)"W32BRD_ATTR_MDBANDLOG")) {
            return "NSCMD_CFG_GET_MDBANDWAVE_LOG";
        }
        return "";
    }

    public static List getWorkBandList(int neid, int boardType) {
        ArrayList<String> bandList = new ArrayList<String>();
        Bundle bundle = FrameworkUtil.getBundle(TEWDMOXCCommon.class);
        Document doc = null;
        try {
            doc = TEParseXMLFile.parseFile((Bundle)bundle, (String)WORK_BAND_BY_BOARD_PATH);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse XML File fail!", (Throwable)e);
            return null;
        }
        if (doc != null) {
            NodeList firstNodeList = doc.getChildNodes();
            Node firstNode = firstNodeList.item(0);
            NodeList secondNodeList = firstNode.getChildNodes();
            int m = secondNodeList.getLength();
            for (int i = 0; i < m; ++i) {
                int bdType;
                Node secondNode = secondNodeList.item(i);
                if (!secondNode.getNodeName().equalsIgnoreCase("board") || (bdType = Integer.parseInt(secondNode.getAttributes().getNamedItem("type").getNodeValue())) != boardType) continue;
                NodeList thirdNodeList = secondNode.getChildNodes();
                int n = thirdNodeList.getLength();
                for (int j = 0; j < n; ++j) {
                    Node thirdNode = thirdNodeList.item(j);
                    if (!thirdNode.getNodeName().equalsIgnoreCase("band")) continue;
                    String bandId = thirdNode.getAttributes().getNamedItem("id").getNodeValue();
                    bandList.add(bandId);
                }
            }
        }
        return bandList;
    }

    public static int getBandParity(int neid, int boardType, int bandId) {
        int parity = 0;
        Bundle bundle = FrameworkUtil.getBundle(TEWDMOXCCommon.class);
        Document doc = null;
        try {
            doc = TEParseXMLFile.parseFile((Bundle)bundle, (String)WORK_BAND_BY_BOARD_PATH);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse XML File fail!", (Throwable)e);
            return parity;
        }
        if (doc != null) {
            NodeList firstNodeList = doc.getChildNodes();
            Node firstNode = firstNodeList.item(0);
            NodeList secondNodeList = firstNode.getChildNodes();
            int m = secondNodeList.getLength();
            for (int i = 0; i < m; ++i) {
                int bdType;
                Node secondNode = secondNodeList.item(i);
                if (!secondNode.getNodeName().equalsIgnoreCase("board") || (bdType = Integer.parseInt(secondNode.getAttributes().getNamedItem("type").getNodeValue())) != boardType) continue;
                NodeList thirdNodeList = secondNode.getChildNodes();
                boolean flag = false;
                int n = thirdNodeList.getLength();
                for (int j = 0; j < n; ++j) {
                    int waveBandId;
                    Node thirdNode = thirdNodeList.item(j);
                    if (!thirdNode.getNodeName().equalsIgnoreCase("band") || (waveBandId = Integer.parseInt(thirdNode.getAttributes().getNamedItem("id").getNodeValue())) != bandId) continue;
                    parity = Integer.parseInt(thirdNode.getAttributes().getNamedItem("parity").getNodeValue());
                    flag = true;
                    break;
                }
                if (flag) break;
            }
        }
        return parity;
    }

    public static String getName(int neid, int slotid, String srcBdTypeName) {
        String srName = TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)slotid);
        String info = "";
        info = !srName.equals("") ? srName + "-" + TEBoardUtil.getSlotIDFromSlot((int)neid, (int)slotid) + "-" + srcBdTypeName : slotid + "-" + srcBdTypeName;
        return info;
    }

    public static String getBandName(int bandid) {
        String bandName = "";
        switch (bandid) {
            case 0: {
                bandName = "C+L";
                break;
            }
            case 1: {
                bandName = "C";
                break;
            }
            case 2: {
                bandName = "L";
                break;
            }
            case 3: {
                bandName = "C32";
                break;
            }
            case 4: {
                bandName = "RAMAN_C";
                break;
            }
            case 5: {
                bandName = "RAMAN_L";
                break;
            }
            case 6: {
                bandName = "CWDM";
                break;
            }
            case 7: {
                bandName = "SMC";
                break;
            }
            case 8: {
                bandName = "C96A";
                break;
            }
            case 9: {
                bandName = "C96B";
                break;
            }
            case 10: {
                bandName = "C192";
                break;
            }
        }
        return bandName;
    }

    public static String getGridLessShowWavelenth(int bandType, int waveFreq, int bandWidth, int waveNo) {
        StringBuffer sb = new StringBuffer();
        if (waveNo != -1) {
            sb.append(TEWDMOXCCommon.getBandName(bandType));
            sb.append("/");
            sb.append(waveNo);
            sb.append("/");
            String freqStr = waveLeninfo.getFrequency(bandType, waveNo);
            sb.append(freqStr);
            sb.append("THz");
        } else {
            long freqLong = (long)waveFreq * 100000L;
            String waveFreqStr = String.valueOf(freqLong);
            if (waveFreqStr.length() < 8) {
                return String.valueOf(waveFreq);
            }
            String frontFreq = waveFreqStr.substring(0, 3);
            String behindFreq = waveFreqStr.substring(3, 8);
            String freqStr = frontFreq + "." + behindFreq;
            sb.append(freqStr);
            sb.append("THz");
            sb.append("+-");
            float waveWidth = (float)bandWidth / 2000.0f;
            sb.append(waveWidth);
            sb.append("GHz");
        }
        return sb.toString();
    }
}

