/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.oxc;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TEWriteLogCommonImpl;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.circuitpack.TEPortParaRecord;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nemgr.ngwdm.oxc.TEEdgePortData;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.List;

public class TEWDMGetOXCEdgePortBean
extends TENEExplorerBean {
    private List edgePointList = new ArrayList();
    private static final int IN_DIRECTION = 0;
    private static final int OUT_DIRECTION = 1;
    private static final String NULL_QUERY = "38662";

    public boolean isNeedOperationlog() {
        return true;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> codeList = new ArrayList<Integer>();
        codeList.add(new Integer(NULL_QUERY));
        return codeList;
    }

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        String edge_port;
        int k;
        RowParams[] rowParamses;
        super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
        int errorCode = Integer.parseInt(this.outputData.getErrorMessage().getErrorcode());
        if (2 == errorCode) {
            return this.outputData;
        }
        TEConfigurationDataMgr confData = TEConfigurationDataMgr.getInstance();
        TENE ne = confData.getNE(neid);
        ArrayList<TEEdgePortData> fixedEdgePointList = new ArrayList<TEEdgePortData>();
        BussinessParams bussinessParams = this.outputData.getBussinessParams();
        if (bussinessParams != null && (rowParamses = bussinessParams.getRowParams()) != null && rowParamses.length > 0) {
            int m = rowParamses.length;
            for (int i = 0; i < m; ++i) {
                int slotId = Integer.parseInt(rowParamses[i].getParam("Slot").getValue());
                int portId = Integer.parseInt(rowParamses[i].getParam("Port").getValue());
                int inattr = Integer.parseInt(rowParamses[i].getParam("inPort").getValue());
                int outattr = Integer.parseInt(rowParamses[i].getParam("outPort").getValue());
                TEEdgePortData edgePort1 = null;
                TEEdgePortData edgePort2 = null;
                TEBoard board = ne.getBoard(slotId);
                if (board == null) continue;
                int boardType = board.getBoardType();
                TEPortParaRecord portPara = confData.getPortParaRecord(neid, boardType, portId);
                if (null != portPara) {
                    if (portPara.inName != null && !portPara.inName.isEmpty()) {
                        edgePort1 = new TEEdgePortData(slotId, portId, inattr, 0);
                        edgePort1.setPortName(portPara.inName);
                    }
                    if (portPara.outName != null && !portPara.outName.isEmpty()) {
                        edgePort2 = new TEEdgePortData(slotId, portId, outattr, 1);
                        edgePort2.setPortName(portPara.outName);
                    }
                }
                if (TEGenCfgDataMgr.isSupportAttr((int)neid, (int)boardType, (int)portId, (String)"W32PORT_ATTR_OXC_EDGEPOINT_FIX")) {
                    if (boardType == 1542 && 3 <= portId && portId <= 6) {
                        if (null != edgePort1 && (7 == this.getLogiPortType(neid, slotId, portId) || 8 == this.getLogiPortType(neid, slotId, portId))) {
                            fixedEdgePointList.add(edgePort1);
                        }
                        if (null == edgePort2 || 7 != this.getLogiPortType(neid, slotId, portId) && 8 != this.getLogiPortType(neid, slotId, portId)) continue;
                        fixedEdgePointList.add(edgePort2);
                        continue;
                    }
                    if (null != edgePort1) {
                        fixedEdgePointList.add(edgePort1);
                    }
                    if (null == edgePort2) continue;
                    fixedEdgePointList.add(edgePort2);
                    continue;
                }
                if (null != edgePort1) {
                    this.edgePointList.add(edgePort1);
                }
                if (null == edgePort2) continue;
                this.edgePointList.add(edgePort2);
            }
        }
        this.operationList.clear();
        this.removePortUsedByFiber();
        ArrayList<TEEdgePortData> selectPointList = new ArrayList<TEEdgePortData>();
        if (this.edgePointList.size() > 0) {
            for (int t = this.edgePointList.size() - 1; t >= 0; --t) {
                TEEdgePortData edgePort = (TEEdgePortData)this.edgePointList.get(t);
                if (edgePort.getInattr() != 0) continue;
                selectPointList.add(edgePort);
                this.edgePointList.remove(t);
            }
        }
        Datainterface output = new Datainterface();
        output.setBussinessParams(new BussinessParams());
        RowParams rowparams = new RowParams();
        if (fixedEdgePointList.size() > 0) {
            Param param = new Param("fixed", "");
            int n = fixedEdgePointList.size();
            for (k = 0; k < n; ++k) {
                TEEdgePortData edgePort = (TEEdgePortData)fixedEdgePointList.get(k);
                TEBoard board = ne.getBoard(edgePort.getSlotID());
                if (board == null) {
                    TELogFactory.getNormalLogger().info("[TEWDMGetOXCEdgePortBean] board is null.");
                    continue;
                }
                int boardType = board.getBoardType();
                edge_port = this.getPortName(edgePort.getSlotID(), confData.getBoardTypeName(neid, boardType), edgePort.getPortID(), "(" + edgePort.getPortName() + ")");
                if ("".equals(param.getValue())) {
                    param.setValue(edge_port);
                    continue;
                }
                Option option = new Option(edge_port);
                param.addOption(option);
            }
            rowparams.addParam(param);
            fixedEdgePointList.clear();
        }
        if (selectPointList.size() > 0) {
            Param param = new Param("select", "");
            for (k = selectPointList.size() - 1; k >= 0; --k) {
                TEEdgePortData edgePort = (TEEdgePortData)selectPointList.get(k);
                TEBoard board = ne.getBoard(edgePort.getSlotID());
                if (board == null) {
                    TELogFactory.getNormalLogger().info("[TEWDMGetOXCEdgePortBean] board is null.");
                    continue;
                }
                int boardType = board.getBoardType();
                String edge_port2 = this.getPortName(edgePort.getSlotID(), confData.getBoardTypeName(neid, boardType), edgePort.getPortID(), "(" + edgePort.getPortName() + ")" + "[" + edgePort.getOutattr() + ",0]");
                if ("".equals(param.getValue())) {
                    param.setValue(edge_port2);
                    continue;
                }
                Option option = new Option(edge_port2);
                param.addOption(option);
            }
            rowparams.addParam(param);
            selectPointList.clear();
        }
        if (this.edgePointList.size() > 0) {
            Param param = new Param("selected", "");
            int n = this.edgePointList.size();
            for (k = 0; k < n; ++k) {
                TEEdgePortData edgePort = (TEEdgePortData)this.edgePointList.get(k);
                TEBoard board = ne.getBoard(edgePort.getSlotID());
                if (board == null) {
                    TELogFactory.getNormalLogger().info("[TEWDMGetOXCEdgePortBean] board is null.");
                    continue;
                }
                int boardType = board.getBoardType();
                edge_port = this.getPortName(edgePort.getSlotID(), confData.getBoardTypeName(neid, boardType), edgePort.getPortID(), "(" + edgePort.getPortName() + ")" + "[" + edgePort.getOutattr() + ",1]");
                if ("".equals(param.getValue())) {
                    param.setValue(edge_port);
                    continue;
                }
                Option option = new Option(edge_port);
                param.addOption(option);
            }
            rowparams.addParam(param);
            this.edgePointList.clear();
        }
        output.getBussinessParams().addRowParams(rowparams);
        ErrorMessage error = this.outputData.getErrorMessage();
        output.setErrorMessage(error);
        return output;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        final SubFunc subfunction = subfunc;
        final int neID = neid;
        new TEWriteLogCommonImpl(){

            public String getOperationDescribtion() {
                return subfunction.getSubFuncDes(neID);
            }
        }.writeLog(neid, subfunc, inputData, user, ipAddress, outputData);
    }

    private void resetEdgePointAttr(int slotId, int portId, int inOrout) {
        if (this.edgePointList.size() > 0) {
            for (int i = this.edgePointList.size() - 1; i >= 0; --i) {
                TEEdgePortData edgePort = (TEEdgePortData)this.edgePointList.get(i);
                if (edgePort.getSlotID() != slotId || edgePort.getPortID() != portId || edgePort.getOutattr() != inOrout) continue;
                this.edgePointList.remove(i);
                break;
            }
        }
    }

    private void removePortUsedByFiber() {
        try {
            Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_FIBERMGR_GET");
            Input input = operation.getInput();
            input.setPartValue("srcNE", String.valueOf(this.neid));
            input.setPartValue("srcSolt", "0");
            input.setPartValue("snkNE", String.valueOf(this.neid));
            input.setPartValue("snkSolt", "0");
            this.operationList.add(operation);
            int result = this.sendMessage(this.neid);
            if (result == 0 && !this.operationList.isEmpty()) {
                operation = (Operation)this.operationList.get(0);
                int m = operation.getOutputCount();
                for (int i = 0; i < m; ++i) {
                    Output output = operation.getOutput(i);
                    boolean flag = false;
                    int errorSize = output.getFaultCount();
                    for (int j = 0; j < errorSize; ++j) {
                        if (Integer.parseInt(output.getFault(j).getCode()) == 0) continue;
                        flag = true;
                        break;
                    }
                    if (flag) continue;
                    int slotId = Integer.parseInt(output.getPartValue("srcSolt"));
                    int portId = Integer.parseInt(output.getPartValue("srcPort"));
                    this.resetEdgePointAttr(slotId, portId, 1);
                    slotId = Integer.parseInt(output.getPartValue("snkSolt"));
                    portId = Integer.parseInt(output.getPartValue("snkPort"));
                    this.resetEdgePointAttr(slotId, portId, 0);
                }
                this.operationList.clear();
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
        }
    }

    private String getPortName(int slotid, String boardName, int portNo, String portName) {
        String name = "";
        String name1 = "";
        String subrackname = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotid);
        name = !subrackname.equals("") ? subrackname + "-" + TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slotid) + "-" : slotid + "-";
        name1 = slotid + "-";
        name = name + boardName + "-" + portNo + portName;
        name1 = name1 + boardName + "-" + portNo + portName;
        name = name + "|" + name1;
        return name;
    }

    private int getLogiPortType(int neID, int slotID, int portID) {
        try {
            Operation oper = TECreateObjectFactory.getOperation((int)neID, (String)"NSCMD_CFG_GET_PORT");
            ArrayList<Operation> operationList = new ArrayList<Operation>();
            Operation tmpOper = null;
            Input input = null;
            tmpOper = (Operation)oper.clone();
            input = tmpOper.getInput();
            input.getPart("slotID").setValue(String.valueOf(slotID));
            input.getPart("portID").setValue(String.valueOf(portID));
            operationList.add(tmpOper);
            int resualt = TECommuNEMgr.getInstance().sendCommand((int)neID, operationList, (int)this.TIME_OUT, (SubFunc)this.subfunc).retCode;
            if (resualt == 0) {
                int iLen = operationList.size();
                for (int i = 0; i < iLen; ++i) {
                    tmpOper = (Operation)operationList.get(i);
                    if (!tmpOper.getOutput(0).getFault(0).getCode().equals(String.valueOf(0))) continue;
                    return Integer.parseInt(tmpOper.getOutput(0).getPartValue("portType"));
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEWDMGetOXCEdgePortBean.getLogiPortType() fail!", (Throwable)e);
        }
        return 0;
    }
}

