/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.oxc;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.PageParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEWaveLengthInfoStaticData;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.ngwdm.oxc.TEOXCDataBean;
import com.huawei.nglct.nemgr.ngwdm.oxc.TEOXCDataComparator;
import com.huawei.nglct.nemgr.ngwdm.oxc.TEWDMOXCCommon;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class TEQuerySingleStationOXCSuperBean
extends TECommonWriteLogBean {
    private static final int FIND_NULL_ERROR_CODE = 38662;
    private static final int SERVICE_SOURCE_HAND = 0;
    private static final int SERVICE_SOURCE_ITG = 1;
    private static int OXC_QUERY_TIME_OUT = 60;
    private static final String SORT_BY_COL = "sortParam";
    private static final String SORT_BY_PARAM = "sortby";
    private static final String SORT_BY_ASC = "asc";
    private static final String SORT_BY_DES = "des";
    private String sortby = "asc";
    private int sortCol = 1;
    private static Datainterface outputList = null;
    ArrayList stationOxcList = new ArrayList();
    protected final Map bandMap = new HashMap();
    protected final Map manualMap = new HashMap();
    protected final Map ssMap = new HashMap();
    private static final String STRING_SOURCE = "ngwdm" + File.separator + "res" + File.separator + "oxc" + File.separator + "oxcres_" + TESysManagerBean.getInstance().getlanguage() + ".ini";
    protected TEResourceUtil resourceUtil = null;
    private static final int BDTYPE_TN12PTQX = 1542;
    private static final int BDTYPE_TN54NPO2 = 2213;

    public TEQuerySingleStationOXCSuperBean() {
        this.bandMap.put("0", "cAndLBand");
        this.bandMap.put("1", "CBand");
        this.bandMap.put("2", "LBand");
        this.bandMap.put("3", "C32Band");
        this.bandMap.put("4", "RAMANC");
        this.bandMap.put("5", "RAMANL");
        this.bandMap.put("6", "CWDM");
        this.bandMap.put("7", "SMC");
        this.bandMap.put("8", "C96A");
        this.bandMap.put("9", "C96B");
        this.bandMap.put("10", "C192");
        this.manualMap.put("2", "manualmodel");
        this.manualMap.put("1", "automodel");
        this.ssMap.put("0", "hand");
        this.ssMap.put("1", "itg");
    }

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.resourceUtil = TEGetFilePath.getResource((int)neid, (String)STRING_SOURCE);
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        if (ne.getLogStatus() == 0) {
            this.outputData = new Datainterface();
            BussinessParams bus = new BussinessParams();
            RowParams row = new RowParams();
            RowErrors rowerror = new RowErrors();
            Param param = new Param();
            param.setName("nename");
            param.setValue(ne.getNEName());
            rowerror.addParam(param);
            rowerror.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)37926));
            row.addRowErrors(rowerror);
            bus.addRowParams(row);
            this.outputData.setBussinessParams(bus);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
            return this.outputData;
        }
        PageParams pageParams = inputData.getPageParams();
        RowParams[] rowParams = inputData.getBussinessParams().getRowParams();
        if (null != rowParams[0].getParam("filename")) {
            return outputList;
        }
        int size = pageParams.getParamCount();
        for (int i = 0; i < size; ++i) {
            if (pageParams.getParam(i).getName().equals(SORT_BY_PARAM)) {
                this.sortby = pageParams.getParam(i).getValue();
                continue;
            }
            if (!pageParams.getParam(i).getName().equals(SORT_BY_COL)) continue;
            this.sortCol = Integer.parseInt(pageParams.getParam(i).getValue());
        }
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        TEOXCDataBean oxcData = null;
        if (null != operationList && !operationList.isEmpty()) {
            Operation operation = null;
            Output output = null;
            this.outputData.setBussinessParams(new BussinessParams());
            boolean isSucc = false;
            boolean fault = false;
            boolean row_succ = false;
            int serSource = 0;
            int len = operationList.size();
            for (int i = 0; i < len; ++i) {
                operation = (Operation)operationList.get(i);
                if ("NSCMD_CFG_GET_ITG_E2EOXC".equals(operation.getName())) {
                    serSource = 1;
                }
                TEDataConverter.handleSpecialStr((Operation)operation);
                if (operation.getOutputCount() == 0) {
                    isSucc = true;
                }
                int size = operation.getOutputCount();
                for (int row = 0; row < size; ++row) {
                    output = operation.getOutput(row);
                    row_succ = TEDataConverter.handleRowError((Output)output, (ArrayList)filterErrorCodeList);
                    if (row_succ) {
                        isSucc = true;
                        boolean flag = false;
                        int errorSize = output.getFaultCount();
                        for (int a = 0; a < errorSize; ++a) {
                            int faultCode = Integer.parseInt(output.getFault(a).getCode());
                            if (0 == faultCode || filterErrorCodeList.contains(faultCode)) continue;
                            flag = true;
                            break;
                        }
                        if (!flag) {
                            if (output.getFault(0).getCode().equals("38662")) continue;
                            String oxcid = output.getPartValue("oxcid");
                            if (Integer.parseInt(oxcid) != 0) {
                                String sinkBandWidth;
                                String sinkCenterFreq;
                                String srcBandWidth;
                                String srcCenterFreq;
                                oxcData = new TEOXCDataBean();
                                oxcData.setOxcID(Integer.parseInt(oxcid));
                                String srcSlot = output.getPartValue("srcSlot");
                                int srcSlotId = Integer.parseInt(srcSlot);
                                oxcData.setSrcSlotID(srcSlotId);
                                String srcPort = output.getPartValue("srcPort");
                                oxcData.setSrcPortID(Integer.parseInt(srcPort));
                                String srcBand = output.getPartValue("srcBand");
                                oxcData.setSrcBandID(Integer.parseInt(srcBand));
                                String srcWaveLenNOa = output.getPartValue("srcWaveLenNO");
                                if (srcWaveLenNOa != null) {
                                    oxcData.setSrcWaveLenNO(Integer.parseInt(srcWaveLenNOa));
                                }
                                if ((srcCenterFreq = output.getPartValue("srcCenterFreq")) != null) {
                                    oxcData.setSrcCenterFreq(Integer.parseInt(srcCenterFreq));
                                }
                                if ((srcBandWidth = output.getPartValue("srcBandWidth")) != null) {
                                    oxcData.setSrcBandWidth(Integer.parseInt(srcBandWidth));
                                }
                                String sinkSlot = output.getPartValue("sinkSlot");
                                int sinkSlotId = Integer.parseInt(sinkSlot);
                                oxcData.setSinkSlotID(sinkSlotId);
                                String sinkPort = output.getPartValue("sinkPort");
                                oxcData.setSinkPortID(Integer.parseInt(sinkPort));
                                String sinkBand = output.getPartValue("sinkBand");
                                oxcData.setSinkBandID(Integer.parseInt(sinkBand));
                                String sinkWaveLenNOa = output.getPartValue("sinkWaveLenNO");
                                if (sinkWaveLenNOa != null) {
                                    oxcData.setSinkWaveLenNO(Integer.parseInt(sinkWaveLenNOa));
                                }
                                if ((sinkCenterFreq = output.getPartValue("sinkCenterFreq")) != null) {
                                    oxcData.setSinkCenterFreq(Integer.parseInt(sinkCenterFreq));
                                }
                                if ((sinkBandWidth = output.getPartValue("sinkBandWidth")) != null) {
                                    oxcData.setSinkBandWidth(Integer.parseInt(sinkBandWidth));
                                }
                                String belongoxcid = output.getPartValue("belongoxcid");
                                oxcData.setBelongOXCID(Integer.parseInt(belongoxcid));
                                int mode = Integer.parseInt(output.getPartValue("manual"));
                                oxcData.setManual(mode);
                                oxcData.setSerSource(serSource);
                                this.stationOxcList.add(oxcData);
                            }
                        }
                    }
                    row_succ = false;
                }
            }
            TEOXCDataComparator oxcComparator = new TEOXCDataComparator();
            if (this.sortby.equalsIgnoreCase(SORT_BY_DES)) {
                oxcComparator.setSortBy(1);
                oxcComparator.setcolSort(this.sortCol);
            } else {
                oxcComparator.setSortBy(0);
                oxcComparator.setcolSort(this.sortCol);
            }
            Collections.sort(this.stationOxcList, oxcComparator);
            outputList = this.outputData;
            this.convertOXCDataToRowData(this.outputData, this.stationOxcList, neid);
            this.outputData.setErrorMessage(new ErrorMessage());
            if (isSucc && !fault) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
            } else if (!isSucc && fault) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
            }
        } else {
            this.outputData = null;
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorCodeList = new ArrayList<Integer>();
        errorCodeList.add(38662);
        return errorCodeList;
    }

    public int handleSlot(int islotid) {
        if (islotid >= 33) {
            int j = islotid >> 5;
            int k = islotid & 0x1F;
            int i = j * 100;
            int m = i + k;
            return m;
        }
        return islotid;
    }

    public int getTimeOut() {
        return OXC_QUERY_TIME_OUT;
    }

    protected boolean isSingletonLog() {
        return true;
    }

    protected void convertOXCDataToRowData(Datainterface output, ArrayList eventList, int neid) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        TEConfigurationDataMgr cfgData = TEConfigurationDataMgr.getInstance();
        TEWaveLengthInfoStaticData waveLeninfo = TEWaveLengthInfoStaticData.getInstance();
        RowParams rowparams = null;
        int size = eventList.size();
        for (int i = 0; i < size; ++i) {
            TEOXCDataBean record = (TEOXCDataBean)eventList.get(i);
            rowparams = new RowParams();
            rowparams.addParam("oxcid", record.getOxcID() + "");
            TEBoard srcBoard = ne.getBoard(record.getSrcSlotID());
            rowparams.addParam("srcSlotId", String.valueOf(record.getSrcSlotID()));
            rowparams.addParam("srcSlot", TEWDMOXCCommon.getName(neid, record.getSrcSlotID(), srcBoard.getBoardName()));
            String srcPortName = cfgData.getPortName(neid, record.getSrcSlotID(), srcBoard.getBoardType(), record.getSrcPortID());
            rowparams.addParam("srcPort", srcPortName);
            rowparams.addParam("srcBand", record.getSrcBandID() + "");
            rowparams.addParam("srcBandName", this.bandMap.get(String.valueOf(record.getSrcBandID())) + "");
            String srcWaveLenInfo = waveLeninfo.getNumberWaveLengthFrequency(record.getSrcBandID(), record.getSrcWaveLenNO());
            rowparams.addParam("srcWaveLenNO", srcWaveLenInfo);
            TEBoard sinkBoard = ne.getBoard(record.getSinkSlotID());
            String sinkBdTypeName = sinkBoard.getBoardTypeName();
            rowparams.addParam("sinkSlotId", String.valueOf(record.getSinkSlotID()));
            rowparams.addParam("sinkSlot", TEWDMOXCCommon.getName(neid, record.getSinkSlotID(), sinkBdTypeName));
            String sinkPortName = cfgData.getPortName(neid, record.getSinkSlotID(), sinkBoard.getBoardType(), record.getSinkPortID());
            rowparams.addParam("sinkPort", sinkPortName);
            rowparams.addParam("sinkBand", record.getSinkBandID() + "");
            rowparams.addParam("sinkBandName", this.bandMap.get(String.valueOf(record.getSinkBandID())) + "");
            String sinkWaveLenInfo = waveLeninfo.getNumberWaveLengthFrequency(record.getSinkBandID(), record.getSinkWaveLenNO());
            rowparams.addParam("sinkWaveLenNO", sinkWaveLenInfo);
            rowparams.addParam("belongoxcid", record.getBelongOXCID() + "");
            rowparams.addParam("manual", record.getManual() + "");
            rowparams.addParam("manualName", this.resourceUtil.getString(this.manualMap.get(String.valueOf(record.getManual())).toString()) + "");
            rowparams.addParam("serviceSource", record.getSerSource() + "");
            rowparams.addParam("serviceSourceName", this.resourceUtil.getString(this.ssMap.get(String.valueOf(record.getSerSource())).toString()) + "");
            if (srcBoard.getBoardType() == 1542 || srcBoard.getBoardType() == 2213 || srcBoard.getBoardType() == 2430 || sinkBoard.getBoardType() == 1542 || sinkBoard.getBoardType() == 2213 || sinkBoard.getBoardType() == 2430 || TESpecialAttrMgr.getInstance().isCPSupportByType(srcBoard.getBoardType(), "TE_FUNC_CFG_WDM_OXC", "OTN_ATTR_SUPPORT_PID_AND_OXCSRC")) {
                rowparams.addParam("isPIDoxc", "true");
            } else {
                rowparams.addParam("isPIDoxc", "false");
            }
            output.getBussinessParams().addRowParams(rowparams);
        }
    }
}

