/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.oxc;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEWaveLengthInfoStaticData;
import com.huawei.nglct.nemgr.ngwdm.oxc.TEWDMOXCCommon;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.File;
import java.util.ArrayList;

public class TEPrintSingleStationOxcBean
extends TENEExplorerBean {
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String STRING_SOURCE = "ngwdm" + File.separator + "res" + File.separator + "oxc" + File.separator + "oxcres_" + LANGUAGE + ".ini";
    private static final int FIND_NULL_ERROR_CODE = 38662;
    private TEResourceUtil resourceUtil = null;
    TEWaveLengthInfoStaticData waveLeninfo = TEWaveLengthInfoStaticData.getInstance();

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.resourceUtil = TEGetFilePath.getResource((int)neid, (String)STRING_SOURCE);
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        TENE ne = mgr.getNE(neid);
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        if (null != operationList && !operationList.isEmpty()) {
            Operation operation = null;
            RowParams rowparamsStation = null;
            Output output = null;
            int m = operationList.size();
            for (int i = 0; i < m; ++i) {
                operation = (Operation)operationList.get(i);
                String name = operation.getName();
                int size = operation.getOutputCount();
                for (int row = size - 1; row >= 0; --row) {
                    output = operation.getOutput(row);
                    boolean flag = false;
                    int n = output.getFaultCount();
                    for (int j = 0; j < n; ++j) {
                        String errorCode = output.getFault(j).getCode();
                        if (Integer.parseInt(errorCode) == 0) continue;
                        flag = true;
                        break;
                    }
                    if (flag) continue;
                    if (output.getPartValue("oxcid").equals("0")) {
                        operation.removeOutput(output);
                        continue;
                    }
                    rowparamsStation = new RowParams();
                    String srcSlot = output.getPartValue("srcSlot");
                    TEBoard srcBoard = ne.getBoard(Integer.parseInt(srcSlot));
                    String srcBdTypeName = srcBoard.getBoardTypeName();
                    String srcSlotStr = srcSlot + "-" + srcBdTypeName;
                    Param param = new Param("srcSlot", srcSlotStr);
                    rowparamsStation.addParam(param);
                    String srcPort = output.getPartValue("srcPort");
                    String srcPortName = TEConfigurationDataMgr.getInstance().getPortName(neid, srcBoard.getSlotID(), srcBoard.getBoardType(), Integer.parseInt(srcPort));
                    param = new Param("srcPort", srcPortName);
                    rowparamsStation.addParam(param);
                    String srcWaveBand = output.getPartValue("srcBand");
                    String srcBand = TEWDMOXCCommon.getBandName(Integer.parseInt(srcWaveBand));
                    param = new Param("srcBand", srcBand);
                    rowparamsStation.addParam(param);
                    String srcWaveLenNOa = output.getPartValue("srcWaveLenNO");
                    String srcWaveLenInfo = this.waveLeninfo.getNumberWaveLengthFrequency(Integer.parseInt(srcWaveBand), Integer.parseInt(srcWaveLenNOa));
                    param = new Param("srcWaveLenNO", srcWaveLenInfo);
                    rowparamsStation.addParam(param);
                    String sinkSlot = output.getPartValue("sinkSlot");
                    TEBoard sinkBoard = ne.getBoard(Integer.parseInt(sinkSlot));
                    String sinkBdTypeName = sinkBoard.getBoardTypeName();
                    String sinkSlotStr = sinkSlot + "-" + sinkBdTypeName;
                    param = new Param("sinkSlot", sinkSlotStr);
                    rowparamsStation.addParam(param);
                    String sinkPort = output.getPartValue("sinkPort");
                    String sinkPortName = TEConfigurationDataMgr.getInstance().getPortName(neid, sinkBoard.getSlotID(), sinkBoard.getBoardType(), Integer.parseInt(sinkPort));
                    param = new Param("sinkPort", sinkPortName);
                    rowparamsStation.addParam(param);
                    String sinkWaveBand = output.getPartValue("sinkBand");
                    String sinkBand = TEWDMOXCCommon.getBandName(Integer.parseInt(sinkWaveBand));
                    param = new Param("sinkBand", sinkBand);
                    rowparamsStation.addParam(param);
                    String sinkWaveLenNOa = output.getPartValue("sinkWaveLenNO");
                    String sinkWaveLenInfo = this.waveLeninfo.getNumberWaveLengthFrequency(Integer.parseInt(sinkWaveBand), Integer.parseInt(sinkWaveLenNOa));
                    param = new Param("sinkWaveLenNO", sinkWaveLenInfo);
                    rowparamsStation.addParam(param);
                    String serviceSource = this.getResource("hand");
                    if ("NSCMD_CFG_GET_ITG_E2EOXC".equalsIgnoreCase(name)) {
                        serviceSource = this.getResource("itg");
                    }
                    param = new Param("serviceSource", serviceSource);
                    rowparamsStation.addParam(param);
                    int mode = Integer.parseInt(output.getPartValue("manual"));
                    String manual = this.getManualName(mode);
                    param = new Param("manual", manual);
                    rowparamsStation.addParam(param);
                    this.outputData.getBussinessParams().addRowParams(rowparamsStation);
                }
            }
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorCodeList = new ArrayList<Integer>();
        errorCodeList.add(38662);
        return errorCodeList;
    }

    public boolean isNeedOperationlog() {
        return false;
    }

    private String getManualName(int mode) {
        String modeName = "";
        switch (mode) {
            case 1: {
                modeName = this.getResource("automodel");
                break;
            }
            case 2: {
                modeName = this.getResource("manualmodel");
            }
        }
        return modeName;
    }

    private String getResource(String str) {
        return this.resourceUtil.getString(str);
    }
}

