/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.oxc;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ngwdm.oxc.TEWDMOXCCommon;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class TEGetBroadcastOXCResourcSupereBean
extends TENEExplorerBean {
    private Map srcEdgePortMap = null;
    private Map snkEdgePortMap = null;
    private Map waveBandMap = new HashMap();
    private TEConfigurationDataMgr cfgData = TEConfigurationDataMgr.getInstance();

    public boolean isNeedOperationlog() {
        return false;
    }

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        int rowCount;
        super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
        this.srcEdgePortMap = new HashMap();
        this.snkEdgePortMap = new HashMap();
        this.operationList = new ArrayList();
        ArrayList<Integer> slotList = new ArrayList<Integer>();
        BussinessParams bParams = this.outputData.getBussinessParams();
        if (bParams != null && (rowCount = bParams.getRowParamsCount()) > 0) {
            RowParams rParams = null;
            for (int i = 0; i < rowCount; ++i) {
                List<Integer> portList;
                rParams = bParams.getRowParams(i);
                Integer slot = Integer.valueOf(rParams.getParam("Slot").getValue());
                if (null == slot || "".equals(slot.toString())) continue;
                Integer portId = Integer.valueOf(rParams.getParam("Port").getValue());
                int inAttr = Integer.parseInt(rParams.getParam("inPort").getValue());
                int outAttr = Integer.parseInt(rParams.getParam("outPort").getValue());
                if (inAttr > 0) {
                    if (this.srcEdgePortMap.containsKey(slot)) {
                        portList = (List)this.srcEdgePortMap.get(slot);
                        if (!portList.contains(portId)) {
                            portList.add(portId);
                        }
                    } else {
                        portList = new ArrayList<Integer>();
                        portList.add(portId);
                        this.srcEdgePortMap.put(slot, portList);
                    }
                }
                if (outAttr > 0) {
                    if (this.snkEdgePortMap.containsKey(slot)) {
                        portList = (List)this.snkEdgePortMap.get(slot);
                        if (!portList.contains(portId)) {
                            portList.add(portId);
                        }
                    } else {
                        portList = new ArrayList();
                        portList.add(portId);
                        this.snkEdgePortMap.put(slot, portList);
                    }
                }
                if (slotList.contains(slot)) continue;
                slotList.add(slot);
            }
        }
        this.setWaveBandMap(slotList);
        Datainterface outputDatainterface = new Datainterface();
        outputDatainterface.setBussinessParams(new BussinessParams());
        this.setRowParams(outputDatainterface, true);
        this.setRowParams(outputDatainterface, false);
        return outputDatainterface;
    }

    private void setRowParams(Datainterface output, boolean srcFlag) {
        String prefix = "snk";
        if (srcFlag) {
            prefix = "src";
        }
        Set entrySet = null;
        entrySet = srcFlag ? this.srcEdgePortMap.entrySet() : this.snkEdgePortMap.entrySet();
        Iterator iter = entrySet.iterator();
        while (iter.hasNext()) {
            Option option;
            RowParams rowParams = new RowParams();
            Map.Entry entry = iter.next();
            int slotId = (Integer)entry.getKey();
            int boardType = this.cfgData.getBoardType(this.neid, slotId);
            String boardName = this.cfgData.getBoardTypeName(this.neid, boardType);
            Param param = new Param(prefix + "slot", slotId + "-" + boardName);
            rowParams.addParam(param);
            List portList = (List)entry.getValue();
            Collections.sort(portList);
            param = new Param(prefix + "port", "");
            int m = portList.size();
            for (int i = 0; i < m; ++i) {
                int portId = (Integer)portList.get(i);
                String portName = this.cfgData.getPortName(this.neid, slotId, boardType, portId);
                if ("".equals(param.getValue())) {
                    param.setValue(portName);
                    continue;
                }
                option = new Option(portName);
                param.addOption(option);
            }
            rowParams.addParam(param);
            List bandList = (List)this.waveBandMap.get(slotId);
            param = new Param(prefix + "band", "");
            int n = bandList.size();
            for (int j = 0; j < n; ++j) {
                String bandId = (String)bandList.get(j);
                if ("".equals(param.getValue())) {
                    param.setValue(bandId);
                    continue;
                }
                option = new Option(bandId);
                param.addOption(option);
            }
            rowParams.addParam(param);
            output.getBussinessParams().addRowParams(rowParams);
        }
    }

    private void setWaveBandMap(List slotList) {
        int m = slotList.size();
        for (int i = 0; i < m; ++i) {
            int slotid = (Integer)slotList.get(i);
            if (this.waveBandMap.containsKey(slotid)) continue;
            int boardType = this.cfgData.getBoardType(this.neid, slotid);
            String cmdName = TEWDMOXCCommon.getFindWaveBandCmd(this.neid, boardType, 0);
            if ("".equals(cmdName)) {
                List bandList = TEWDMOXCCommon.getWorkBandList(this.neid, boardType);
                this.waveBandMap.put(slotid, bandList);
                continue;
            }
            this.setOperationList(cmdName, slotid);
        }
        this.getWaveBand();
    }

    private void setOperationList(String cmdName, int slotid) {
        Operation operation = TECreateObjectFactory.getOperation((int)this.neid, (String)cmdName);
        Input input = operation.getInput();
        input.setPartValue("slotid", String.valueOf(slotid));
        input.setPartValue("port", "0");
        if ("NSCMD_CFG_GET_WAVELEN_LOG".equals(cmdName) || "NSCMD_CFG_GET_MDBANDWAVE_LOG".equals(cmdName)) {
            input.setPartValue("path", String.valueOf(1));
        }
        this.operationList.add(operation);
    }

    private void getWaveBand() {
        try {
            int result = this.sendMessage(this.neid);
            if (result == 0) {
                Output output = null;
                int m = this.operationList.size();
                for (int i = 0; i < m; ++i) {
                    Operation operation = (Operation)this.operationList.get(i);
                    String cmdName = operation.getName();
                    int n = operation.getOutputCount();
                    for (int j = 0; j < n; ++j) {
                        output = operation.getOutput(j);
                        if (output == null || !output.getFault(0).getCode().equals("0")) continue;
                        Integer slotId = Integer.valueOf(output.getPartValue("slotid"));
                        ArrayList<String> bandList = new ArrayList<String>();
                        if (cmdName.equalsIgnoreCase("NSCMD_CFG_GET_WAVELEN_LOG")) {
                            bandList.add(output.getPartValue("W32BRD_ATTR_CFGWDMTYPE"));
                        } else if (cmdName.equalsIgnoreCase("NSCMD_CFG_GET_MDWAVE_LOG")) {
                            bandList.add(output.getPartValue("W32BRD_ATTR_CFGUPDOWNWDMTYPE"));
                        } else if (cmdName.equalsIgnoreCase("NSCMD_CFG_GET_MDBANDWAVE_LOG")) {
                            bandList.add(output.getPartValue("W32BRD_ATTR_MDWORKBAND"));
                        } else {
                            bandList.add(output.getPartValue("W32BRD_ATTR_CFGWORKBAND"));
                        }
                        if (bandList.size() <= 0) {
                            int boardType = this.cfgData.getBoardType(this.neid, slotId.intValue());
                            if (951 == boardType || 952 == boardType) {
                                bandList.add(String.valueOf(6));
                            } else {
                                bandList.add("1");
                            }
                        }
                        if (this.waveBandMap.containsKey(slotId)) continue;
                        this.waveBandMap.put(slotId, bandList);
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            TELogFactory.getNormalLogger().error("TEGetBroadcastOXCResourceBean.getWaveBand() fail!", (Throwable)e);
        }
        catch (NumberFormatException e) {
            TELogFactory.getNormalLogger().error("TEGetBroadcastOXCResourceBean.getWaveBand() fail!", (Throwable)e);
        }
    }
}

