/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.owsp;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.ngwdm.owsp.TEOWSPCommon;
import com.huawei.nglct.nemgr.ngwdm.owsp.TEProChannelData;
import com.huawei.nglct.nemgr.ngwdm.owsp.TEProChannelInstance;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.List;

public class TEProChannelQueryBean
extends TENEExplorerBean {
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            ArrayList<String> firstOperationNameList = new ArrayList<String>();
            firstOperationNameList.add("NSCMD_OWSP_GET_OSCPAIR");
            ArrayList<String> secondOperationNameList = new ArrayList<String>();
            secondOperationNameList.add("NSCMD_OWSP_GET_RINGUSE");
            ArrayList firstOperList = TEDataConverter.convertToOperation((SubFunc)subFunc, (Datainterface)inputData, (int)neid, firstOperationNameList);
            ArrayList secondOperList = TEDataConverter.convertToOperation((SubFunc)subFunc, (Datainterface)inputData, (int)neid, secondOperationNameList);
            int firstResult = this.sendMessage(firstOperList);
            if (firstResult == 0) {
                if (this.structureSecondlyData(firstOperList, secondOperList)) {
                    int secondResult = this.sendMessage(secondOperList);
                    if (secondResult == 0) {
                        this.updateMemery(secondOperList);
                        firstOperList.addAll(secondOperList);
                    } else {
                        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)secondResult));
                    }
                }
                ArrayList filterErrorCodeList = this.getFilterErrorCodeList();
                this.handleMessage(neid, firstOperList, subFunc, filterErrorCodeList);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)firstResult));
            }
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    private boolean structureSecondlyData(ArrayList firstOperList, ArrayList secondOperList) {
        if (firstOperList.size() == 0) {
            return false;
        }
        ArrayList<Operation> tempList = new ArrayList<Operation>();
        int size = firstOperList.size();
        for (int i = 0; i < size; ++i) {
            Operation firstOperation = (Operation)firstOperList.get(i);
            Output[] outPutArray = firstOperation.getOutput();
            for (int j = 0; j < outPutArray.length; ++j) {
                String channelID = outPutArray[j].getPart("channelid").getValue();
                if (channelID == null) continue;
                Operation aOperation = (Operation)((Operation)secondOperList.get(0)).clone();
                aOperation.getInput().setPartValue("channelid", channelID);
                tempList.add(aOperation);
            }
        }
        secondOperList.clear();
        secondOperList.addAll(tempList);
        return secondOperList.size() != 0;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorCodeList = new ArrayList<Integer>();
        errorCodeList.add(new Integer(38662));
        return errorCodeList;
    }

    public int sendMessage(ArrayList operList) {
        int retCode = 0;
        OperationResult result = TENECommMgr.getInstance().sendCommand(this.neid, (List)operList, this.getTimeOut());
        if (null != result) {
            retCode = result.retCode;
        }
        return retCode;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        super.handleMessage(neid, operationList, subfunc, filterErrorCodeList);
        ArrayList rowParamsList = this.outputData.getBussinessParams().getRowParamList();
        int size = rowParamsList.size();
        for (int i = 0; i < size; ++i) {
            RowParams rowParams = (RowParams)rowParamsList.get(i);
            RowErrors[] rowErrors = rowParams.getRowErrors();
            if (rowErrors.length != 0) continue;
            String wSlotID = rowParams.getParam("wslotid").getValue();
            String wPortID = rowParams.getParam("wportid").getValue();
            String eSlotID = rowParams.getParam("eslotid").getValue();
            String ePortID = rowParams.getParam("eportid").getValue();
            rowParams.addParam("wboardname", TEOWSPCommon.getBoardName(neid, wSlotID));
            rowParams.addParam("wportname", TEOWSPCommon.getPortName(neid, wSlotID, wPortID));
            rowParams.addParam("eboardname", TEOWSPCommon.getBoardName(neid, eSlotID));
            rowParams.addParam("eportname", TEOWSPCommon.getPortName(neid, eSlotID, ePortID));
            String subrack = TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)Integer.parseInt(wSlotID));
            if (!subrack.equals("")) {
                rowParams.addParam("subrack", subrack);
            }
            String channelID = rowParams.getParam("channelid").getValue();
            TEProChannelInstance newInstance = TEProChannelData.getInstance().getChannelByID(channelID);
            if (null == newInstance) {
                newInstance = new TEProChannelInstance(channelID);
                TEProChannelData.getInstance().addChannel(channelID, newInstance);
            }
            newInstance.setWSlotID(wSlotID);
            newInstance.setWPortID(wPortID);
            newInstance.setESlotID(eSlotID);
            newInstance.setEPortID(ePortID);
        }
    }

    private void updateMemery(ArrayList secondOperList) {
        TEProChannelData.getInstance().clear();
        int size = secondOperList.size();
        for (int i = 0; i < size; ++i) {
            Operation aOperation = (Operation)secondOperList.get(i);
            Output[] outputArr = aOperation.getOutput();
            for (int j = 0; j < outputArr.length; ++j) {
                if (!"0".equals(outputArr[j].getFault(0).getCode())) continue;
                String channelID = outputArr[j].getPart("channelid").getValue();
                String subChanID = outputArr[j].getPart("subchannelid").getValue();
                String chanStatus = outputArr[j].getPart("usedstatus").getValue();
                TEProChannelInstance newInstance = TEProChannelData.getInstance().getChannelByID(channelID);
                if (null == newInstance) {
                    newInstance = new TEProChannelInstance(channelID);
                    TEProChannelData.getInstance().addChannel(channelID, newInstance);
                }
                if (!"1".equals(chanStatus)) continue;
                newInstance.addUsedSubChan(subChanID);
            }
        }
    }
}

