/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.owsp;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.ngwdm.owsp.TEOWSPCommon;
import com.huawei.nglct.nemgr.ngwdm.owsp.TEOWSPData;
import com.huawei.nglct.nemgr.ngwdm.owsp.TEOWSPInstance;
import com.huawei.nglct.nemgr.ngwdm.owsp.TEProChannelData;
import com.huawei.nglct.nemgr.ngwdm.owsp.TEProChannelInstance;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TEOWSPQueryBean
extends TECommonWriteLogBean {
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            ArrayList<String> firstOperationNameList = new ArrayList<String>();
            firstOperationNameList.add("NSCMD_OWSP_GET_PG");
            ArrayList<String> secondOperationNameList = new ArrayList<String>();
            secondOperationNameList.add("NSCMD_OWSP_GET_BDPARA");
            secondOperationNameList.add("NSCMD_OWSP_GET_WTRPARA");
            secondOperationNameList.add("NSCMD_OWSP_GET_DELAYTIME");
            secondOperationNameList.add("NSCMD_OWSP_GET_SWITCH");
            secondOperationNameList.add("NSCMD_OWSP_GET_SDFLAG");
            secondOperationNameList.add("NSCMD_OWSP_GET_SVCID");
            secondOperationNameList.add("NSCMD_OWSP_GET_SVCBD");
            ArrayList firstOperList = TEDataConverter.convertToOperation((SubFunc)subFunc, (Datainterface)inputData, (int)neid, firstOperationNameList);
            ArrayList secondOperList = TEDataConverter.convertToOperation((SubFunc)subFunc, (Datainterface)inputData, (int)neid, secondOperationNameList);
            int firstResult = this.sendMessage(firstOperList);
            if (firstResult == 0) {
                if (this.structureSecondlyData(firstOperList, secondOperList)) {
                    int secondResult = this.sendMessage(secondOperList);
                    if (secondResult == 0) {
                        firstOperList.addAll(secondOperList);
                    } else {
                        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)secondResult));
                    }
                }
                this.handleMessage(neid, firstOperList, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)firstResult));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    private boolean structureSecondlyData(ArrayList firstOperList, ArrayList secondOperList) {
        if (firstOperList.size() == 0) {
            return false;
        }
        ArrayList<Object> tempList = new ArrayList<Object>();
        Operation firstOperation = (Operation)firstOperList.get(0);
        Output[] outPutArray = firstOperation.getOutput();
        for (int j = 0; j < outPutArray.length; ++j) {
            String owspID;
            if (!"0".equals(outPutArray[j].getFault(0).getCode()) || null == (owspID = outPutArray[j].getPartValue("owspid")) || owspID.equals("0") || !"3".equals(outPutArray[j].getPartValue("switchstatus"))) continue;
            int length = secondOperList.size();
            for (int k = 0; k < length; ++k) {
                int z;
                Operation aOperation = (Operation)((Operation)secondOperList.get(k)).clone();
                aOperation.getInput().setPartValue("owspid", owspID);
                String operName = aOperation.getName();
                if (operName.equals("NSCMD_OWSP_GET_DELAYTIME")) {
                    for (z = 1; z <= 4; ++z) {
                        aOperation.getInput().setPartValue("svcdirection", String.valueOf(z));
                        tempList.add(aOperation.clone());
                    }
                } else if (operName.equals("NSCMD_OWSP_GET_SVCID") || operName.equals("NSCMD_OWSP_GET_SVCBD")) {
                    for (z = 1; z <= 2; ++z) {
                        aOperation.getInput().setPartValue("svcdirection", String.valueOf(z));
                        tempList.add(aOperation.clone());
                    }
                }
                tempList.add(aOperation);
            }
        }
        secondOperList.clear();
        secondOperList.addAll(tempList);
        return secondOperList.size() != 0;
    }

    public int sendMessage(ArrayList operList) {
        int retCode = 0;
        OperationResult result = TENECommMgr.getInstance().sendCommand(this.neid, (List)operList, this.getTimeOut());
        if (null != result) {
            retCode = result.retCode;
        }
        return retCode;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        TEOWSPData.getInstance().clear();
        HashMap<String, String> eastOtuInfoMap = new HashMap<String, String>();
        HashMap<String, String> eastOtuMap = new HashMap<String, String>();
        HashMap<String, String> westOtuInfoMap = new HashMap<String, String>();
        HashMap<String, String> westOtuMap = new HashMap<String, String>();
        HashMap<String, String> channelIDMap = new HashMap<String, String>();
        int size = operationList.size();
        for (int i = 0; i < size; ++i) {
            Operation aOperation = (Operation)operationList.get(i);
            Output[] outPutArr = aOperation.getOutput();
            for (int j = 0; j < outPutArr.length; ++j) {
                String slotID;
                String delayTime;
                String svcDirection;
                String eProtectStatus;
                String eWorkStatus;
                String wProtectStatus;
                String wWorkStatus;
                String eSlotID;
                String wSlotID;
                String subChannelID;
                String channelID;
                if (!"0".equals(outPutArr[j].getFault(0).getCode())) continue;
                String owspID = outPutArr[j].getPartValue("owspid");
                TEOWSPInstance owspInstance = TEOWSPData.getInstance().getOWSPByID(owspID);
                if (null == owspInstance) {
                    owspInstance = new TEOWSPInstance(owspID);
                    TEOWSPData.getInstance().addOWSP(owspID, owspInstance);
                }
                if (null != (channelID = outPutArr[j].getPartValue("channelid"))) {
                    owspInstance.setChannelID(channelID);
                    channelIDMap.put(owspID, channelID);
                }
                if (null != (subChannelID = outPutArr[j].getPartValue("subchannelid"))) {
                    owspInstance.setSubChannelID(subChannelID);
                }
                if (null != (wSlotID = outPutArr[j].getPartValue("wdcpslotid"))) {
                    owspInstance.setWSlotID(wSlotID);
                }
                if (null != (eSlotID = outPutArr[j].getPartValue("edcpslotid"))) {
                    owspInstance.setESlotID(eSlotID);
                }
                if (null != (wWorkStatus = outPutArr[j].getPartValue("wworkstatus"))) {
                    owspInstance.setChannelStatus(0, wWorkStatus);
                }
                if (null != (wProtectStatus = outPutArr[j].getPartValue("wprotectstatus"))) {
                    owspInstance.setChannelStatus(1, wProtectStatus);
                }
                if (null != (eWorkStatus = outPutArr[j].getPartValue("eworkstatus"))) {
                    owspInstance.setChannelStatus(2, eWorkStatus);
                }
                if (null != (eProtectStatus = outPutArr[j].getPartValue("eprotectstatus"))) {
                    owspInstance.setChannelStatus(3, eProtectStatus);
                }
                if (null == (svcDirection = outPutArr[j].getPartValue("svcdirection"))) continue;
                String spanID = outPutArr[j].getPartValue("spanid");
                if (null != spanID) {
                    owspInstance.setSpanId(Integer.parseInt(svcDirection) - 1, spanID);
                }
                if (null != (delayTime = outPutArr[j].getPartValue("delaytime"))) {
                    owspInstance.setDelayTime(Integer.parseInt(svcDirection) - 1, delayTime);
                }
                if ((slotID = outPutArr[j].getPartValue("slotid")) == null || slotID.equals("-1") || slotID.equals("")) continue;
                String portID = outPutArr[j].getPartValue("portid");
                if (svcDirection.equals("1")) {
                    westOtuInfoMap.put(owspID, TEOWSPCommon.getPortInfo(neid, slotID, portID));
                    westOtuMap.put(owspID, slotID + "-" + portID);
                    continue;
                }
                eastOtuInfoMap.put(owspID, TEOWSPCommon.getPortInfo(neid, slotID, portID));
                eastOtuMap.put(owspID, slotID + "-" + portID);
            }
        }
        super.handleMessage(neid, operationList, subfunc, this.getFilterErrorCodeList());
        RowParams[] rParams = this.outputData.getBussinessParams().getRowParams();
        String eSlotID = "";
        String wSlotID = "";
        String ePortID = "";
        String wPortID = "";
        String owspID = "";
        for (int i = 0; i < rParams.length; ++i) {
            if (rParams[i].getRowErrors().length != 0) continue;
            owspID = rParams[i].getParam("owspid").getValue();
            if (westOtuInfoMap.get(owspID) != null) {
                rParams[i].addParam("westotu", (String)westOtuInfoMap.get(owspID));
                rParams[i].addParam("westotuid", (String)westOtuMap.get(owspID));
            } else {
                rParams[i].addParam("westotu", "none");
            }
            if (eastOtuInfoMap.get(owspID) != null) {
                rParams[i].addParam("eastotu", (String)eastOtuInfoMap.get(owspID));
                rParams[i].addParam("eastotuid", (String)eastOtuMap.get(owspID));
            } else {
                rParams[i].addParam("eastotu", "none");
            }
            TEProChannelInstance aChannelIstance = TEProChannelData.getInstance().getChannelByID((String)channelIDMap.get(owspID));
            if (aChannelIstance == null) continue;
            eSlotID = aChannelIstance.getESlotID();
            wSlotID = aChannelIstance.getWSlotID();
            ePortID = aChannelIstance.getEPortID();
            wPortID = aChannelIstance.getWPortID();
            rParams[i].addParam("wchannelinfo", TEOWSPCommon.getPortInfo(neid, wSlotID, wPortID));
            rParams[i].addParam("echannelinfo", TEOWSPCommon.getPortInfo(neid, eSlotID, ePortID));
            String subrack = TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)Integer.parseInt(wSlotID));
            if (subrack.equals("")) continue;
            rParams[i].addParam("subrack", subrack);
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorCodeList = new ArrayList<Integer>();
        errorCodeList.add(new Integer(38662));
        errorCodeList.add(new Integer(39326));
        return errorCodeList;
    }

    public boolean isNeedOperationlog() {
        Param isNeedLogParam = this.inputData.getBussinessParams().getRowParams()[0].getParam("isneedlog");
        return Boolean.parseBoolean(isNeedLogParam.getValue());
    }
}

