/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.owsp;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.ngwdm.owsp.TEOWSPCommon;
import com.huawei.nglct.nemgr.ngwdm.owsp.TEOWSPData;
import com.huawei.nglct.nemgr.ngwdm.owsp.TEOWSPInstance;

public class TEOWSPGetDetailBean
extends TENEExplorerBean {
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.inputData = inputData;
            this.subfunc = subFunc;
            this.outputData = new Datainterface();
            this.outputData.setBussinessParams(new BussinessParams());
            String owspID = inputData.getBussinessParams().getRowParams()[0].getParam("owspid").getValue();
            TEOWSPInstance aOWSP = TEOWSPData.getInstance().getOWSPByID(owspID);
            RowParams rowParams = null;
            String[] channelStatusArr = aOWSP.getChannelStatusArr();
            String[] delayTimeArr = aOWSP.getDelayTimeArr();
            String[] spanIDArr = aOWSP.getSpanIDArr();
            String wSlotID = aOWSP.getWSlotID();
            String eSlotID = aOWSP.getESlotID();
            for (int i = 0; i < channelStatusArr.length; ++i) {
                rowParams = new RowParams();
                rowParams.addParam("svcdirection", String.valueOf(i + 1));
                rowParams.addParam("channelstatus", channelStatusArr[i]);
                rowParams.addParam("delaytime", delayTimeArr[i]);
                switch (i + 1) {
                    case 1: {
                        rowParams.addParam("channelmaping", TEOWSPCommon.getPortInfowithSubrack(neid, wSlotID, "1"));
                        rowParams.addParam("spanid", spanIDArr[0]);
                        break;
                    }
                    case 2: {
                        rowParams.addParam("channelmaping", TEOWSPCommon.getPortInfowithSubrack(neid, wSlotID, "2"));
                        break;
                    }
                    case 3: {
                        rowParams.addParam("spanid", spanIDArr[1]);
                        rowParams.addParam("channelmaping", TEOWSPCommon.getPortInfowithSubrack(neid, eSlotID, "1"));
                        break;
                    }
                    case 4: {
                        rowParams.addParam("channelmaping", TEOWSPCommon.getPortInfowithSubrack(neid, eSlotID, "2"));
                        break;
                    }
                    default: {
                        TELogFactory.getNormalLogger().info("TEOWSPGetDetailBean.performBussinessProcess() direction channel:" + (i + 1) + " not in case!");
                    }
                }
                this.outputData.getBussinessParams().addRowParams(rowParams);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess failed!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

