/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.orderwire.beanplugin;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.explorer.beanplugin.TEBeanPluginLog;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEOrderWireMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfo;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class TEOrderWireModeDbMgr {
    private static final Logger logger = TELogFactory.getNormalLogger();

    private TEOrderWireModeDbMgr() {
    }

    public static List<TEOrderWireMOPO> getMoFromDB(int neID, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEOerderWireModeDbMgr.getMoFromDB";
        TEBeanPluginLog.logFuncBegin((String)"TEOerderWireModeDbMgr.getMoFromDB");
        ArrayList<TEOrderWireMOPO> moList = new ArrayList<TEOrderWireMOPO>();
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            if (null == ne) {
                TEOrderWireModeDbMgr.logNullNEError(neID);
                TEOrderWireModeDbMgr.setOperFail(neID, errRet, 1090596385);
                TEBeanPluginLog.logFuncEnd((String)"TEOerderWireModeDbMgr.getMoFromDB");
                return moList;
            }
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findAll((int[])new int[]{neID}, TEOrderWireMOPO.class) : TECommonDaoService.findAll_NonLock((int[])new int[]{neID}, TEOrderWireMOPO.class);
        }
        catch (Exception e) {
            TEOrderWireModeDbMgr.logExceptionOnGet(neID, e);
            TEOrderWireModeDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEOerderWireModeDbMgr.getMoFromDB");
            return moList;
        }
        if (null == dbResult) {
            TEOrderWireModeDbMgr.logNullErrorOnGet(neID);
            TEOrderWireModeDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEOerderWireModeDbMgr.getMoFromDB");
            return moList;
        }
        int retCode = dbResult.getResult();
        if (0 == retCode) {
            List data = dbResult.getData();
            if (null != data && !data.isEmpty()) {
                for (Object obj : data) {
                    moList.add((TEOrderWireMOPO)obj);
                }
            }
        } else {
            TEOrderWireModeDbMgr.logRetCodeErrorOnGet(neID, retCode);
            TEOrderWireModeDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TEOerderWireModeDbMgr.getMoFromDB");
        return moList;
    }

    public static void updateMOToDB(int neID, TEOrderWireMOPO mo, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEOerderWireModeDbMgr.updateMOToDB";
        TEBeanPluginLog.logFuncBegin((String)"TEOerderWireModeDbMgr.updateMOToDB");
        if (null == mo) {
            return;
        }
        if (null == errRet) {
            errRet = new TEErrInfoReturn();
        }
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.update((int[])new int[]{neID}, (Object)mo) : TECommonDaoService.update_NonLock((int[])new int[]{neID}, (Object)mo);
        }
        catch (Exception e) {
            TEOrderWireModeDbMgr.logExceptionErrorOnUpdate(neID, e);
            TEOrderWireModeDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEOerderWireModeDbMgr.updateMOToDB");
            return;
        }
        if (null == dbResult) {
            TEOrderWireModeDbMgr.logNullErrorOnUpdate(neID);
            TEOrderWireModeDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEOerderWireModeDbMgr.updateMOToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TEOrderWireModeDbMgr.logRetCodeErrorOnUpdate(neID, retCode);
            TEOrderWireModeDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TEOerderWireModeDbMgr.updateMOToDB");
    }

    private static void logExceptionErrorOnUpdate(int neID, Exception e1) {
        logger.error("update mo to db device fail! neID->" + neID, (Throwable)e1);
    }

    private static void logRetCodeErrorOnUpdate(int neID, int retCodeMode) {
        String tipStr = String.format("update mo to db device fail! neID:%d, retCode:%d", neID, retCodeMode);
        logger.error(tipStr);
    }

    private static void logNullErrorOnUpdate(int neID) {
        logger.error("update mo to db device fail! dbResult is null! neID->" + neID);
    }

    private static void setOperFail(int neID, TEErrInfoReturn rspErrRet, int retCodeMode) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String neName = ne.getNEName();
        rspErrRet.setResult(1090605056);
        rspErrRet.addErrInfo(TEOrderWireModeDbMgr.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, retCodeMode).getErrList());
    }

    private static TEErrInfoReturn constructErrInfoReturn(int[] objID, String[] objName, int retCodeMode) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        errRet.setResult(2);
        TEErrInfo errInfo = new TEErrInfo();
        errInfo.setObjID(objID);
        errInfo.setObjName(TEOrderWireModeDbMgr.getObjName(objName));
        errInfo.setErrorCode(retCodeMode);
        errRet.addErrInfo(errInfo);
        return errRet;
    }

    private static String getObjName(String[] objNameMode) {
        StringBuffer objNameBuffer = new StringBuffer();
        int len = objNameMode.length;
        for (int i = 0; i < len; ++i) {
            if (0 != i) {
                objNameBuffer.append('-');
            }
            objNameBuffer.append(objNameMode[i]);
        }
        return objNameBuffer.toString();
    }

    private static void logNullNEError(int neID) {
        logger.error("ne is null! neID->" + neID);
    }

    private static void logExceptionOnGet(int neID, Exception e) {
        logger.error("get mo from db fail! neID->" + neID, (Throwable)e);
    }

    private static void logNullErrorOnGet(int neID) {
        logger.error("get mo from db fail! dbResult is null! neID->" + neID);
    }

    private static void logRetCodeErrorOnGet(int neID, int retCode) {
        String tipStr = String.format("get mo from db device fail! neID:%d, retCode:%d", neID, retCode);
        logger.error(tipStr);
    }
}

