/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.opticalpower_v2r7c02;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.TEGenCfgDataConvertor;
import com.huawei.nglct.gencfg.TEGenCfgQueryBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.lpara.TEAlmObjTypeMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEPfmUtility;
import com.huawei.nglct.nelist.model.TEQueryLogicPort;
import com.huawei.nglct.nelist.model.channel.QueryWDMMode;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nelist.model.datamgr.TENEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgAttribute;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgModel;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgPortAttribute;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.ServiceTypeRowDataProcessor;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class OpticalPowerQueryBean
extends TEGenCfgQueryBean {
    private static final int INPOWER_EVENT = 203;
    private static final int SDH_INPOWER_EVENT = 107;
    private static final int OUTPOWER_EVENT = 200;
    private static final int SDH_OUTPOWER_EVENT = 104;
    private static final int SUM_INPOWER_EVENT = 212;
    private static final int SUM_OUTPOWER_EVENT = 215;
    private static final int EDTPL_OUTPOWER_EVENT = 123;
    private static final int FILTER_MAX = Integer.MAX_VALUE;
    private static final int FILTER_MIN = Integer.MIN_VALUE;
    private static final int SDH_LOW_INVALID_VALUE = Short.MIN_VALUE;
    private static final int SDH_HIGH_INVALID_VALUE = 32768;
    private static final int SDH_HIGH_INVALID_VALUE_NEW = Short.MAX_VALUE;
    private static final String NSCMD_PER_GET_CURDATA_NEW = "NSCMD_PER_GET_CURDATA_1";
    private static final String NSCMD_CFG_GET_ALM_TH = "NSCMD_CFG_GET_ALM_TH";
    private static final String NSCMD_CFG_GET_ALM_TH_OOP = "NSCMD_CFG_GET_ALM_TH_OOP";
    private int boardType = 0;
    private boolean opticalPowerObjectSupportPathFlag = false;
    String reptype = "144";
    private static final Set<Integer> INVALID_VALUES = new HashSet<Integer>();
    private static final Set<String> EXPAND_ATTRIBUTES = new HashSet<String>();
    private static final String ISOOP = "145";
    private static final int PEAK_INPOWER_CUR = 15382;
    private static final int VALLEY_INPOWER_CUR = 15385;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        RowParams rowParams = inputData.getBussinessParams().getRowParams(0);
        Param param = rowParams.getParam("reptype");
        if (param != null) {
            this.reptype = param.getValue();
        }
        this.filterAttr(neid, rowParams);
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    protected void filterOperationList(List operationList, int slotid, int boardType) {
        try {
            this.boardType = boardType;
            Operation curDataOper = null;
            Iterator iter = operationList.iterator();
            ArrayList list = new ArrayList();
            while (iter.hasNext()) {
                Operation tempOper;
                curDataOper = tempOper = (Operation)iter.next();
                if (NSCMD_PER_GET_CURDATA_NEW.equals(tempOper.getName())) {
                    this.setAttrIdQx(list, slotid, boardType, curDataOper, "W32PORT_ATTR_INPUTPOWER");
                    this.setAttrIdQx(list, slotid, boardType, curDataOper, "W32PORT_ATTR_OUTPUTPOWER");
                    this.setAttrIdQx(list, slotid, boardType, curDataOper, "W32PORT_ATTR_PEAK_INPOWER_CUR");
                    this.setAttrIdQx(list, slotid, boardType, curDataOper, "W32PORT_ATTR_VALLEY_INPOWER_CUR");
                    iter.remove();
                }
                if (NSCMD_CFG_GET_ALM_TH.equals(tempOper.getName()) && curDataOper.getInput().getPart("reptype") != null) {
                    curDataOper.getInput().getPart("reptype").setValue(this.reptype);
                }
                if (!NSCMD_CFG_GET_ALM_TH_OOP.equals(tempOper.getName()) || curDataOper.getInput().getPart("reptype") == null) continue;
                curDataOper.getInput().getPart("reptype").setValue(ISOOP);
            }
            operationList.addAll(list);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().info("Error:" + e.getMessage());
        }
    }

    private void setAttrIdQx(List list, int slotid, int boardType, Operation curDataOper, String attrId) {
        if (this.attrIdList.contains(attrId)) {
            Operation oper = (Operation)curDataOper.clone();
            Part part = new Part();
            part.setName(attrId);
            part.setValue(null);
            part.setType("int");
            part.setLength(2);
            oper.getInput().addPart(part);
            this.setQXData(list, oper, slotid, boardType, attrId);
        }
    }

    private void setQXData(List operationList, Operation oper, int slotid, int boardType, String attrId) {
        List customObjInfo;
        TENE neObj = TENEListMgr.getInstance().getNE(this.neid);
        String peidvar = "0";
        String objtypevar = "119";
        String paralenvar = "6";
        if (TENEConfigurationDataMgr.getInstance().isRTN900DomainNEByType(neObj.getNEType())) {
            if ("W32PORT_ATTR_INPUTPOWER".equals(attrId)) {
                peidvar = "107";
            } else if ("W32PORT_ATTR_OUTPUTPOWER".equals(attrId)) {
                peidvar = "104";
            }
            objtypevar = "172";
            paralenvar = "5";
        }
        Input input = oper.getInput();
        Part part = input.getPart("peid");
        part.setValue(peidvar);
        part = input.getPart("period");
        part.setValue("1");
        part = input.getPart("reserve");
        part.setValue("255");
        part = input.getPart("objtype");
        part.setValue(objtypevar);
        part = input.getPart("paralen");
        part.setValue(paralenvar);
        boolean isSDHLineBoard = TEConfigurationDataMgr.getInstance().isSDHLineBoard(this.neid, slotid);
        if (isSDHLineBoard) {
            input.getPart("objtype").setValue("84");
            input.getPart("paralen").setValue("4");
        }
        if (!(customObjInfo = TESpecialAttrMgr.getInstance().getCPAttrListValue(this.neid, slotid, "TE_FUNC_CFG_WDM_PM", "OTN_ATTR_SUPPORT_CUSTOM_OBJTYPE_ONINPUTOPPOWER")).isEmpty()) {
            input.getPart("objtype").setValue((String)customObjInfo.get(0));
            input.getPart("paralen").setValue((String)customObjInfo.get(1));
        }
        String slotneid = TEAlmObjTypeMgr.convertNMToNEHexString((int)slotid);
        List portnolist = this.getSupportPortList(this.neid, slotid, attrId);
        if (portnolist == null) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        int len = portnolist.size();
        for (int i = 0; i < len; ++i) {
            TEGenCfgPortAttribute tmp = (TEGenCfgPortAttribute)portnolist.get(i);
            int portid = tmp.getPort();
            int pathid = tmp.getPath();
            if (portid <= 0 || pathid <= 0) continue;
            if (pathid > 1) {
                this.opticalPowerObjectSupportPathFlag = true;
            }
            String sportid = Integer.toHexString(portid);
            String spathid = "0000" + Integer.toHexString(pathid);
            spathid = spathid.substring(spathid.length() - 4);
            if (TENEConfigurationDataMgr.getInstance().isRTN900DomainNEByType(neObj.getNEType())) {
                spathid = "";
                sportid = "000" + sportid;
            }
            if (sportid.length() == 1) {
                sportid = "0" + sportid;
            }
            if (list.contains(sportid = pathid == 0 ? sportid + "0001" : sportid + spathid)) continue;
            list.add(sportid);
            part = input.getPart("objpara");
            String objparaValue = slotneid + "FF" + sportid;
            int actParaLen = Integer.valueOf(input.getPart("paralen").getValue());
            part.setValue(objparaValue.substring(0, actParaLen * 2));
            operationList.add(oper.clone());
        }
    }

    private List getSupportPortList(int neid, int slotid, String attrId) {
        ArrayList<TEGenCfgPortAttribute> portList;
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        if (null == neObj) {
            return null;
        }
        TEBoard boardObj = neObj.getBoard(slotid);
        if (null == boardObj) {
            return null;
        }
        TEGenCfgModel genCfgModel = TEGenCfgDataMgr.getGenCfgMode((int)boardObj.getBoardType());
        if (null == genCfgModel) {
            return null;
        }
        TEGenCfgAttribute attrObj = genCfgModel.getAttrFromId(attrId);
        if (null == attrObj) {
            if (attrId.equals("W32PORT_ATTR_INPUTPOWER")) {
                attrId = "W32PORT_ATTR_GET_INPWR";
            }
            if (attrId.equals("W32PORT_ATTR_OUTPUTPOWER")) {
                attrId = "W32PORT_ATTR_GET_OUTPWR";
            }
            if (null == (attrObj = genCfgModel.getAttrFromId(attrId))) {
                return null;
            }
        }
        if ((portList = attrObj.getPortList()) == null) {
            return null;
        }
        this.getUsablePortAccordingToBoardMode(neid, slotid, boardObj.getBoardType(), (List<TEGenCfgPortAttribute>)portList);
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        boolean isDynBD = mgr.isDynPortBoardType(neid, boardObj.getBoardType());
        if (isDynBD) {
            ArrayList<TEGenCfgPortAttribute> tmpPortList = new ArrayList<TEGenCfgPortAttribute>();
            ArrayList existPortList = TEQueryLogicPort.getLogicPortList((int)neid, (int)slotid, (int)boardObj.getBoardType());
            for (Object e : portList) {
                TEGenCfgPortAttribute port = (TEGenCfgPortAttribute)e;
                if (!existPortList.contains(port.getPort())) continue;
                tmpPortList.add(port);
            }
            portList = tmpPortList;
        }
        Collections.sort(portList);
        return portList;
    }

    public void handleMessage(int neid, SubFunc subfunc, ArrayList operationList, ArrayList filterErrorCodeList) {
        this.getOperationList(neid, operationList);
        this.outputData = TEGenCfgDataConvertor.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        RowParams rowParams = null;
        if (this.outputData.getBussinessParams().getRowParamsCount() > 0 && 10 > (rowParams = this.outputData.getBussinessParams().getRowParams(0)).getParamCount()) {
            this.outputData.getBussinessParams().removeRowParams(0);
        }
        for (int i = this.outputData.getBussinessParams().getRowParamsCount() - 1; i >= 0; --i) {
            rowParams = this.outputData.getBussinessParams().getRowParams(i);
            if ((rowParams.getParamCount() == 0 || rowParams.getParam("slotid") != null && rowParams.getParam("slotid").getValue().equals("0") || rowParams.getParam("port") == null || rowParams.getParam("port") != null && rowParams.getParam("port").getValue().equals("0")) && rowParams.getRowErrorsCount() == 0) {
                this.outputData.getBussinessParams().removeRowParams(i);
                continue;
            }
            if (!this.checkRowParams(rowParams) && rowParams.getRowErrorsCount() == 0) {
                this.outputData.getBussinessParams().removeRowParams(i);
                continue;
            }
            if (!this.opticalPowerObjectSupportPathFlag && null != rowParams.getParam("path")) {
                rowParams.removeParam(rowParams.getParam("path"));
            }
            if (rowParams.getParam("startTime") != null) {
                rowParams.removeParam(rowParams.getParam("startTime"));
            }
            this.convertFloatValue(rowParams, "W32PORT_ATTR_MININPOW");
            this.convertFloatValue(rowParams, "W32PORT_ATTR_MAXINPOW");
            this.convertFloatValue(rowParams, "W32PORT_ATTR_MINOUTPOW");
            this.convertFloatValue(rowParams, "W32PORT_ATTR_MAXOUTPOW");
            this.convertFloatValue(rowParams, "W32PORT_ATTR_MININPOWLOW");
            this.convertFloatValue(rowParams, "W32PORT_ATTR_MININPOWHIGH");
            this.convertFloatValue(rowParams, "W32PORT_ATTR_MAXINPOWLOW");
            this.convertFloatValue(rowParams, "W32PORT_ATTR_MAXINPOWHIGH");
            this.convertFloatValue(rowParams, "W32PORT_ATTR_CFPMININPOW");
            this.convertFloatValue(rowParams, "W32PORT_ATTR_CFPMAXINPOW");
            this.convertFloatValue(rowParams, "W32PORT_ATTR_CFPMININPOWHIGH");
            this.convertFloatValue(rowParams, "W32PORT_ATTR_CFPMININPOWLOW");
            this.convertFloatValue(rowParams, "W32PORT_ATTR_CFPMAXINPOWHIGH");
            this.convertFloatValue(rowParams, "W32PORT_ATTR_CFPMAXINPOWLOW");
            this.convertFloatValue(rowParams, "W32PORT_ATTR_PUMP_OPMIN");
            this.convertFloatValue(rowParams, "W32PORT_ATTR_PUMP_OPMAX");
            this.convertFloatValue(rowParams, "W32PORT_ATTR_GET_INPWR");
            this.convertFloatValue(rowParams, "W32PORT_ATTR_GET_OUTPWR");
            if (rowParams.getParam("W32PORT_ATTR_GET_INPWR") != null) {
                rowParams.getParam("W32PORT_ATTR_GET_INPWR").setName("W32PORT_ATTR_INPUTPOWER");
            }
            if (rowParams.getParam("W32PORT_ATTR_GET_OUTPWR") != null) {
                rowParams.getParam("W32PORT_ATTR_GET_OUTPWR").setName("W32PORT_ATTR_OUTPUTPOWER");
            }
            if (!TESpecialAttrMgr.getInstance().isCPSupportByType(this.boardType, "TE_FUNC_CFG_WDM_PM", "OTN_ATTR_NEED_QUERY_PORTTYPE")) continue;
            int slotid = Integer.parseInt(rowParams.getParam("slotid").getValue());
            int port = Integer.parseInt(rowParams.getParam("port").getValue());
            int portType = ServiceTypeRowDataProcessor.getLogiPortType(neid, slotid, port);
            rowParams.addParam(new Param("portType", String.valueOf(portType)));
        }
    }

    private void convertFloatValue(RowParams rowParams, String attrId) {
        Param param = rowParams.getParam(attrId);
        if (null != param && !param.getValue().equals("/")) {
            String value = param.getValue();
            int intValue = new BigInteger(value).intValue();
            if (INVALID_VALUES.contains(intValue)) {
                param.setValue("/");
            } else {
                float floatValue = (float)intValue / 10.0f;
                param.setValue("" + floatValue);
            }
        }
    }

    public ArrayList<Integer> getFilterErrorCodeList() {
        ArrayList<Integer> errorCodeList = new ArrayList<Integer>();
        errorCodeList.add(38410);
        errorCodeList.add(38429);
        errorCodeList.add(38662);
        errorCodeList.add(38671);
        errorCodeList.add(38722);
        errorCodeList.add(38434);
        errorCodeList.add(38737);
        errorCodeList.add(39172);
        return errorCodeList;
    }

    private void getOperationList(int neID, ArrayList operationList) {
        Operation operation = null;
        Output output = null;
        Part part = null;
        long peValue = 0L;
        int peid = 0;
        int slotid = 0;
        int port = 0;
        int path = 1;
        int inSlotId = 0;
        int inPort = 0;
        int inpath = 1;
        ArrayList<Integer> filterErrorCode = this.getFilterErrorCodeList();
        TENE neObj = TENEListMgr.getInstance().getNE(this.neid);
        if (null != operationList) {
            int len = operationList.size();
            for (int i = 0; i < len; ++i) {
                operation = (Operation)operationList.get(i);
                if (!NSCMD_PER_GET_CURDATA_NEW.equals(operation.getName())) continue;
                Input input = operation.getInput();
                if (input.getPart("objpara") != null) {
                    byte[] objByte = input.getPart("objpara").getValue().getBytes();
                    byte[] temp = new byte[4];
                    System.arraycopy(objByte, 0, temp, 0, 4);
                    inSlotId = TEAlmObjTypeMgr.convertSlotidFromBytes((byte[])temp);
                    temp = new byte[2];
                    System.arraycopy(objByte, 4, temp, 0, 2);
                    temp = new byte[2];
                    System.arraycopy(objByte, 6, temp, 0, 2);
                    inPort = IOStreamConvertor.readPositiveShort((byte[])temp, (int)0);
                    if (objByte.length >= 10 && TENEConfigurationDataMgr.getInstance().isRTN900DomainNEByType(neObj.getNEType())) {
                        temp = new byte[4];
                        System.arraycopy(objByte, 6, temp, 0, 4);
                        inPort = TEAlmObjTypeMgr.convertSlotidFromBytes((byte[])temp);
                    }
                    if (objByte.length >= 12) {
                        temp = new byte[4];
                        System.arraycopy(objByte, 8, temp, 0, 4);
                        inpath = IOStreamConvertor.readPositiveInt((byte[])temp, (int)0);
                    }
                }
                for (int j = 0; j < operation.getOutputCount(); ++j) {
                    output = operation.getOutput(j);
                    Part[] partArr = output.getPart();
                    int len2 = partArr.length;
                    for (int k = 0; k < len2; ++k) {
                        if (TEPfmUtility.validatePart((Part)partArr[k], (String)"peValue")) {
                            String value = partArr[k].getValue();
                            peValue = this.getPvalue(value);
                            continue;
                        }
                        if (TEPfmUtility.validatePart((Part)partArr[k], (String)"peid")) {
                            peid = Integer.parseInt(partArr[k].getValue());
                            continue;
                        }
                        if (!TEPfmUtility.validatePart((Part)partArr[k], (String)"objpara")) continue;
                        byte[] objByte = partArr[k].getValue().getBytes();
                        byte[] temp = new byte[4];
                        System.arraycopy(objByte, 0, temp, 0, 4);
                        slotid = TEAlmObjTypeMgr.convertSlotidFromBytes((byte[])temp);
                        temp = new byte[2];
                        System.arraycopy(objByte, 4, temp, 0, 2);
                        temp = new byte[2];
                        System.arraycopy(objByte, 6, temp, 0, 2);
                        port = IOStreamConvertor.readPositiveShort((byte[])temp, (int)0);
                        if (objByte.length >= 10 && TENEConfigurationDataMgr.getInstance().isRTN900DomainNEByType(neObj.getNEType())) {
                            temp = new byte[4];
                            System.arraycopy(objByte, 6, temp, 0, 4);
                            port = TEAlmObjTypeMgr.convertSlotidFromBytes((byte[])temp);
                        }
                        if (objByte.length < 12) continue;
                        temp = new byte[4];
                        System.arraycopy(objByte, 8, temp, 0, 4);
                        path = IOStreamConvertor.readPositiveInt((byte[])temp, (int)0);
                    }
                    if (peid != 203 && peid != 200 && peid != 107 && peid != 104 && peid != 212 && peid != 215 && peid != 123 && peid != 15382 && peid != 15385) {
                        operation.removeOutput(j);
                        --j;
                        continue;
                    }
                    if (port != 0 && port != inPort) {
                        operation.removeOutput(j);
                        --j;
                        continue;
                    }
                    part = new Part();
                    part.setName("slotid");
                    part.setType("int");
                    part.setValue(slotid + "");
                    output.addPart(part);
                    part = new Part();
                    part.setName("port");
                    part.setType("int");
                    part.setValue(port + "");
                    output.addPart(part);
                    part = new Part();
                    part.setName("path");
                    part.setType("int");
                    part.setValue(path + "");
                    output.addPart(part);
                    long powerValue = peValue;
                    if ((peid == 203 || peid == 107 || peid == 212) && input.getPart("W32PORT_ATTR_INPUTPOWER") != null) {
                        float inputPower = (float)powerValue / 10.0f;
                        if ((2308 == this.boardType || 2836 == this.boardType || 2946 == this.boardType || 2875 == this.boardType) && 212 == peid) {
                            operation.removeOutput(j);
                            --j;
                            continue;
                        }
                        if (output.getPart("W32PORT_ATTR_INPUTPOWER") == null) {
                            part = new Part();
                            part.setType("int");
                            part.setLength(2);
                            part.setName("W32PORT_ATTR_INPUTPOWER");
                            part.setValue(inputPower + "");
                            output.addPart(part);
                            continue;
                        }
                        output.getPart("W32PORT_ATTR_INPUTPOWER").setValue(inputPower + "");
                        continue;
                    }
                    if ((peid == 200 || peid == 104 || peid == 215 || peid == 123) && input.getPart("W32PORT_ATTR_OUTPUTPOWER") != null) {
                        float outputPower = (float)powerValue / 10.0f;
                        if (935 == this.boardType && 215 == peid) continue;
                        if (output.getPart("W32PORT_ATTR_OUTPUTPOWER") == null) {
                            part = new Part();
                            part.setType("int");
                            part.setLength(2);
                            part.setName("W32PORT_ATTR_OUTPUTPOWER");
                            part.setValue(outputPower + "");
                            output.addPart(part);
                            continue;
                        }
                        output.getPart("W32PORT_ATTR_OUTPUTPOWER").setValue(outputPower + "");
                        continue;
                    }
                    if (peid == 15382 && input.getPart("W32PORT_ATTR_PEAK_INPOWER_CUR") != null) {
                        this.setOutputAttrValue(output, powerValue, "W32PORT_ATTR_PEAK_INPOWER_CUR");
                        continue;
                    }
                    if (peid == 15385 && input.getPart("W32PORT_ATTR_VALLEY_INPOWER_CUR") != null) {
                        this.setOutputAttrValue(output, powerValue, "W32PORT_ATTR_VALLEY_INPOWER_CUR");
                        continue;
                    }
                    operation.removeOutput(j);
                    --j;
                }
                if (operation.getOutputCount() != 0) continue;
                Output outputtemp = (Output)output.clone();
                if (filterErrorCode.contains(Integer.valueOf(outputtemp.getFault(0).getCode()))) {
                    outputtemp.getFault(0).setCode("0");
                }
                operation.addOutput(outputtemp);
                part = new Part();
                part.setName("slotid");
                part.setType("int");
                part.setValue(inSlotId + "");
                outputtemp.addPart((Part)part.clone());
                input.addPart((Part)part.clone());
                part = new Part();
                part.setName("port");
                part.setType("int");
                part.setValue(inPort + "");
                outputtemp.addPart((Part)part.clone());
                input.addPart((Part)part.clone());
                part = new Part();
                part.setName("path");
                part.setType("int");
                part.setValue(inpath + "");
                outputtemp.addPart((Part)part.clone());
                input.addPart((Part)part.clone());
                this.setInputAndOutputValueWhenNull(input, outputtemp, "W32PORT_ATTR_INPUTPOWER");
                this.setInputAndOutputValueWhenNull(input, outputtemp, "W32PORT_ATTR_OUTPUTPOWER");
                this.setInputAndOutputValueWhenNull(input, outputtemp, "W32PORT_ATTR_PEAK_INPOWER_CUR");
                this.setInputAndOutputValueWhenNull(input, outputtemp, "W32PORT_ATTR_VALLEY_INPOWER_CUR");
            }
        }
    }

    private void setOutputAttrValue(Output output, long powerValue, String attrId) {
        float outputValue = (float)powerValue / 10.0f;
        if (output.getPart(attrId) == null) {
            Part part = new Part();
            part.setType("int");
            part.setLength(2);
            part.setName(attrId);
            part.setValue(outputValue + "");
            output.addPart(part);
        } else {
            output.getPart(attrId).setValue(outputValue + "");
        }
    }

    private void setInputAndOutputValueWhenNull(Input input, Output outputtemp, String attrId) {
        if (input.getPart(attrId) != null) {
            if (outputtemp.getPart(attrId) == null) {
                Part part = new Part();
                part.setType("int");
                part.setLength(2);
                part.setName(attrId);
                part.setValue("/");
                outputtemp.addPart(part);
            } else {
                outputtemp.getPart(attrId).setValue("/");
            }
            input.getPart(attrId).setValue("/");
        }
    }

    private long getPvalue(String value) {
        byte[] t = IOStreamConvertor.getByteArrayFromString((String)value);
        long pValue = IOStreamConvertor.readLong((byte[])t, (int)0);
        return pValue;
    }

    public void copyInputToOutput(Input input, Output output) {
        if (output.getPart("objtype") != null) {
            if (output.getPart("objtype").getValue() == null || "-1".equals(output.getPart("objtype").getValue())) {
                output.getPart("objtype").setValue(input.getPart("objtype").getValue());
            }
            if (output.getPart("paralen").getValue() == null || "-1".equals(output.getPart("paralen").getValue())) {
                output.getPart("paralen").setValue(input.getPart("paralen").getValue());
            }
            if (output.getPart("objpara").getValue() == null || "-1".equals(output.getPart("objpara").getValue())) {
                output.getPart("objpara").setValue(input.getPart("objpara").getValue());
            }
        }
    }

    public boolean checkRowParams(RowParams rowParams) {
        boolean isvalid = false;
        for (int i = 0; i < rowParams.getParamCount(); ++i) {
            if (!this.attrIdList.contains(rowParams.getParam(i).getName())) continue;
            isvalid = true;
        }
        return isvalid;
    }

    public boolean isNeedExpandOperObj(String attrId) {
        return EXPAND_ATTRIBUTES.contains(attrId);
    }

    private void filterAttr(int neid, RowParams rowParams) {
        int slotid = Integer.parseInt(rowParams.getParam("slotid").getValue());
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
        if (TESpecialAttrMgr.getInstance().isCPSupportByType(boardType, "TE_FUNC_CFG_WDM_PM", "OTN_ATTR_CONVERT_POWERNAME")) {
            int paramNum = rowParams.getParamCount();
            for (int i = 0; i < paramNum; ++i) {
                Param tmpParam = rowParams.getParam(i);
                if (tmpParam.getValue().equals("W32PORT_ATTR_INPUTPOWER")) {
                    tmpParam.setValue("W32PORT_ATTR_GET_INPWR");
                }
                if (!tmpParam.getValue().equals("W32PORT_ATTR_OUTPUTPOWER")) continue;
                tmpParam.setValue("W32PORT_ATTR_GET_OUTPWR");
            }
        }
    }

    private void getUsablePortAccordingToBoardMode(int neID, int slotID, int boardType, List<TEGenCfgPortAttribute> portList) {
        String boardMode;
        if (boardType == 2281 && !"LINE_MODE".equals(boardMode = QueryWDMMode.queryBoardMode((int)neID, (int)slotID))) {
            Iterator<TEGenCfgPortAttribute> iterator = portList.iterator();
            while (iterator.hasNext()) {
                TEGenCfgPortAttribute portAttr = iterator.next();
                if (portAttr.getPort() != 3) continue;
                iterator.remove();
            }
        }
    }

    static {
        INVALID_VALUES.add((Integer)Short.MIN_VALUE);
        INVALID_VALUES.add(32768);
        INVALID_VALUES.add((Integer)Short.MAX_VALUE);
        INVALID_VALUES.add(Integer.MAX_VALUE);
        INVALID_VALUES.add(Integer.MIN_VALUE);
        EXPAND_ATTRIBUTES.add("W32PORT_ATTR_MININPOW");
        EXPAND_ATTRIBUTES.add("W32PORT_ATTR_MAXINPOW");
        EXPAND_ATTRIBUTES.add("W32PORT_ATTR_MININPOWHIGH");
        EXPAND_ATTRIBUTES.add("W32PORT_ATTR_MININPOWLOW");
        EXPAND_ATTRIBUTES.add("W32PORT_ATTR_MAXINPOWHIGH");
        EXPAND_ATTRIBUTES.add("W32PORT_ATTR_MAXINPOWLOW");
        EXPAND_ATTRIBUTES.add("W32PORT_ATTR_MAXOUTPOW");
        EXPAND_ATTRIBUTES.add("W32PORT_ATTR_MINOUTPOW");
        EXPAND_ATTRIBUTES.add("W32PORT_ATTR_GET_INPWR");
        EXPAND_ATTRIBUTES.add("W32PORT_ATTR_GET_OUTPWR");
        EXPAND_ATTRIBUTES.add("W32PORT_ATTR_CFPMININPOW");
        EXPAND_ATTRIBUTES.add("W32PORT_ATTR_CFPMAXINPOW");
        EXPAND_ATTRIBUTES.add("W32PORT_ATTR_CFPMAXINPOWHIGH");
        EXPAND_ATTRIBUTES.add("W32PORT_ATTR_CFPMAXINPOWLOW");
        EXPAND_ATTRIBUTES.add("W32PORT_ATTR_CFPMININPOWHIGH");
        EXPAND_ATTRIBUTES.add("W32PORT_ATTR_CFPMININPOWLOW");
        EXPAND_ATTRIBUTES.add("W32PORT_ATTR_PEAK_INPOWER_CUR");
        EXPAND_ATTRIBUTES.add("W32PORT_ATTR_VALLEY_INPOWER_CUR");
    }
}

