/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.opticalpower_bd05;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEQueryPortForDataMgr;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnDateTimeType;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnNameAndValueString;
import com.huawei.nglct.nemgr.f_interface.wdm.wdmconfig.opticalpower.AsnGetStdPowReq;
import com.huawei.nglct.nemgr.f_interface.wdm.wdmconfig.opticalpower.AsnPowerAttrResult;
import com.huawei.nglct.nemgr.f_interface.wdm.wdmconfig.opticalpower.AsnPowerPortIndex;
import com.huawei.nglct.nemgr.f_interface.wdm.wdmconfig.opticalpower.AsnStdPowNew;
import com.huawei.nglct.nemgr.ngwdm.opticalpower_bd05.TEInterOpticalPowerBaseBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.HashMap;
import net.commustru.fstru.FStruct;

public class TEInterQueryOpticalPowerBean
extends TEInterOpticalPowerBaseBean {
    @Override
    protected void stdPowerToParams(AsnStdPowNew stdPower, BussinessParams bussiness) {
        if (stdPower.inPortInfo.pathID > 0) {
            this.fillExtendAttrib(stdPower, bussiness);
        } else {
            int neID = stdPower.inPortInfo.neID;
            int slotID = stdPower.inPortInfo.slotID;
            int portID = TEConfigurationDataMgr.getPortRelativeID((int)stdPower.inPortInfo.portID);
            String nename = TEConfigurationDataMgr.getInstance().getNE(neID).getNEName();
            String subrackname = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotID);
            String boardname = TEConfigurationDataMgr.getInstance().getBoardName(neID, slotID);
            boardname = !"".equals(subrackname) ? subrackname + "-" + TEBoardUtil.getSlotIDFromSlot((int)neID, (int)slotID) + "-" + boardname : TEBoardUtil.getSlotIDFromSlot((int)neID, (int)slotID) + "-" + boardname;
            String portname = TEConfigurationDataMgr.getInstance().getPortName(neID, slotID, portID);
            String fullportname = nename + "-" + boardname + "-" + portname;
            RowParams row = new RowParams();
            row.addParam(new Param("portname", fullportname));
            row.addParam("canminbeEdit", String.valueOf(stdPower.canminbeEdit));
            row.addParam("canmaxbeEdit", String.valueOf(stdPower.canmaxbeEdit));
            row.addParam("canminOutbeEdit", String.valueOf(stdPower.canminOutbeEdit));
            row.addParam("canmaxOutbeEdit", String.valueOf(stdPower.canmaxOutbeEdit));
            row.addParam("canmaxWorkbeEdit", String.valueOf(0));
            row.addParam("canminWorkbeEdit", String.valueOf(0));
            row.addParam("canmaxRefOutbeEdit", String.valueOf(0));
            row.addParam("canminRefOutbeEdit", String.valueOf(0));
            row.addParam("canCFPMinBeEdit", String.valueOf(stdPower.canCFPMinBeEdit));
            row.addParam("canCFPMaxBeEdit", String.valueOf(stdPower.canCFPMaxBeEdit));
            int size = stdPower.nvList.size();
            for (int i = 0; i < size; ++i) {
                AsnNameAndValueString nameAndValue = (AsnNameAndValueString)stdPower.nvList.get(i);
                String name = new String(nameAndValue.name);
                String value = new String(nameAndValue.value);
                if (!"canmaxWorkbeEdit".equals(name) && !"canminWorkbeEdit".equals(name) && !"canmaxRefOutbeEdit".equals(name) && !"canminRefOutbeEdit".equals(name)) continue;
                row.getParam(name).setValue(value);
            }
            bussiness.addRowParams(row);
            bussiness.addRowParams(this.dealPowerValue(ATTR_INPOW, stdPower.inPow));
            bussiness.addRowParams(this.dealPowerValue(ATTR_INPOW_REVALUE, stdPower.stdInPow));
            bussiness.addRowParams(this.dealStdPowerTime(ATTR_INPOW_RETIME, stdPower.stdInPow, stdPower.stdInPowTime));
            bussiness.addRowParams(this.dealPowerValue(ATTR_INPOW_LOWTHRESHOLD, stdPower.minInPow));
            bussiness.addRowParams(this.dealPowerValue(ATTR_INPOW_LOWTHRESHOLD_MIN, stdPower.minInPowLow));
            bussiness.addRowParams(this.dealPowerValue(ATTR_INPOW_LOWTHRESHOLD_MAX, stdPower.minInPowHigh));
            bussiness.addRowParams(this.dealPowerValue(ATTR_INPOW_HIGHTHRESHOLD, stdPower.maxInPow));
            bussiness.addRowParams(this.dealPowerValue(ATTR_INPOW_HIGHTHRESHOLD_MIN, stdPower.maxInPowLow));
            bussiness.addRowParams(this.dealPowerValue(ATTR_INPOW_HIGHTHRESHOLD_MAX, stdPower.maxInPowHigh));
            bussiness.addRowParams(this.dealPowerValue(ATTR_INPOW_REF_LOWTHRESHOLD, stdPower.minWorkPow));
            bussiness.addRowParams(this.dealPowerValue(ATTR_INPOW_REF_HIGHTHRESHOLD, stdPower.maxWorkPow));
            bussiness.addRowParams(this.dealPowStat(ATTR_INPOW_STATE, stdPower.inPow, stdPower.stdInPow, stdPower.minWorkPow, stdPower.maxWorkPow));
            bussiness.addRowParams(this.dealPowerValue(ATTR_OUTPOW, stdPower.outPow));
            bussiness.addRowParams(this.dealPowerValue(ATTR_OUTPOW_REVALUE, stdPower.stdOutPow));
            bussiness.addRowParams(this.dealStdPowerTime(ATTR_OUTPOW_RETIME, stdPower.stdOutPow, stdPower.stdOutPowTime));
            bussiness.addRowParams(this.dealPowerValue(ATTR_OUTPOW_LOWTHRESHOLD, stdPower.minOutPow));
            bussiness.addRowParams(this.dealPowerValue(ATTR_OUTPOW_HIGHTHRESHOLD, stdPower.maxOutPow));
            bussiness.addRowParams(this.dealPowerValue(ATTR_OUTPOW_REF_LOWTHRESHOLD, stdPower.minRefOutPow));
            bussiness.addRowParams(this.dealPowerValue(ATTR_OUTPOW_REF_HIGHTHRESHOLD, stdPower.maxRefOutPow));
            bussiness.addRowParams(this.dealPowStat(ATTR_OUTPOW_STATE, stdPower.outPow, stdPower.stdOutPow, stdPower.minRefOutPow, stdPower.maxRefOutPow));
            bussiness.addRowParams(this.dealPowerValue(ATTR_INPOW_CFP_LOWTHRESHOLD, stdPower.minCFPInPow));
            bussiness.addRowParams(this.dealPowerValue(ATTR_INPOW_CFP_LOWTHRESHOLD_MIN, stdPower.minCFPInPowLow));
            bussiness.addRowParams(this.dealPowerValue(ATTR_INPOW_CFP_LOWTHRESHOLD_MAX, stdPower.minCFPInPowHigh));
            bussiness.addRowParams(this.dealPowerValue(ATTR_INPOW_CFP_HIGHTHRESHOLD, stdPower.maxCFPInPow));
            bussiness.addRowParams(this.dealPowerValue(ATTR_INPOW_CFP_HIGHTHRESHOLD_MIN, stdPower.maxCFPInPowLow));
            bussiness.addRowParams(this.dealPowerValue(ATTR_INPOW_CFP_HIGHTHRESHOLD_MAX, stdPower.maxCFPInPowHigh));
        }
    }

    private RowParams dealPowerValue(String name, int value) {
        String strValue = "-";
        strValue = value == 65535 ? "-" : (value == 0x7FFFFFFE || value == Integer.MIN_VALUE ? "/" : this.getFactor(value, 0.1f, 1));
        RowParams row = new RowParams();
        row.addParam(new Param("attribute", name));
        row.addParam(new Param("value", strValue));
        return row;
    }

    private RowParams dealStdPowerTime(String name, int stdPow, AsnDateTimeType dateTime) {
        String strValue = "-";
        if (stdPow == 65535) {
            strValue = "-";
        } else if (stdPow == 0x7FFFFFFE) {
            strValue = "/";
        } else {
            TimeZoneDateBean timeProccessor = TETimeTocalizationSwitchBean.getTimeZoneDateInstance((int)this.neid);
            Calendar cal = Calendar.getInstance();
            cal.set(dateTime.year, dateTime.month - 1, dateTime.day, dateTime.hour, dateTime.minute, dateTime.second);
            strValue = timeProccessor.utcCalendarToTime(cal);
        }
        RowParams row = new RowParams();
        row.addParam(new Param("attribute", name));
        row.addParam(new Param("value", strValue));
        return row;
    }

    private void fillExtendAttrib(AsnStdPowNew stdPower, BussinessParams bussiness) {
        AsnPowerAttrResult additionAttrib = null;
        int size = stdPower.aditionalAttrList.size();
        HashMap<Integer, Integer> extendArrtibs = new HashMap<Integer, Integer>(size);
        for (int i = 0; i < size; ++i) {
            additionAttrib = (AsnPowerAttrResult)stdPower.aditionalAttrList.get(i);
            extendArrtibs.put(additionAttrib.attrib.attribID, additionAttrib.attrib.intValue);
        }
        if (!extendArrtibs.isEmpty()) {
            bussiness.addRowParams(this.dealPowerValue(ATTR_INPOW_CFP_CURRENT_VALLEY, (Integer)extendArrtibs.get(272287)));
            bussiness.addRowParams(this.dealPowerValue(ATTR_INPOW_CFP_CURRENT_PEAK, (Integer)extendArrtibs.get(272288)));
        } else {
            RowParams row = new RowParams();
            row.addParam(new Param("attribute", ATTR_INPOW_CFP_CURRENT_VALLEY));
            row.addParam(new Param("value", "-"));
            bussiness.addRowParams(row);
            row = new RowParams();
            row.addParam(new Param("attribute", ATTR_INPOW_CFP_CURRENT_PEAK));
            row.addParam(new Param("value", "-"));
            bussiness.addRowParams(row);
        }
    }

    @Override
    protected FStruct convertParamstoReq(RowParams rowParams) {
        int neid = Integer.valueOf(rowParams.getParam("neid").getValue());
        int slotid = Integer.valueOf(rowParams.getParam("slotid").getValue());
        int portid = Integer.valueOf(rowParams.getParam("portid").getValue());
        AsnGetStdPowReq req = new AsnGetStdPowReq();
        req.userID = BigInteger.valueOf(Long.parseLong(this.user));
        req.missionID = BigInteger.valueOf(0L);
        req.reqType = BigInteger.valueOf(0L);
        AsnPowerPortIndex portIndex = new AsnPowerPortIndex();
        portIndex.inPortInfo.neID = neid;
        portIndex.inPortInfo.slotID = slotid;
        portIndex.inPortInfo.portID = TEQueryPortForDataMgr.getAbstractPortID((int)neid, (int)portid);
        portIndex.inPortInfo.pathID = 0;
        portIndex.stdInPow = 0x7FFFFFFE;
        portIndex.stdOutPow = 0x7FFFFFFE;
        portIndex.fiberId = 65535;
        portIndex.maxWorkPow = 0x7FFFFFFE;
        portIndex.minWorkPow = 0x7FFFFFFE;
        portIndex.maxInPow = 0x7FFFFFFE;
        portIndex.minInPow = 0x7FFFFFFE;
        portIndex.maxOutPow = 0x7FFFFFFE;
        portIndex.minOutPow = 0x7FFFFFFE;
        portIndex.maxRefOutPow = 0x7FFFFFFE;
        portIndex.minRefOutPow = 0x7FFFFFFE;
        portIndex.maxCFPInPow = 0x7FFFFFFE;
        portIndex.minCFPInPow = 0x7FFFFFFE;
        req.portList.add((Object)portIndex);
        return req;
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

