/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.opticalpower_bd05;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.explorer.integrateexplorer.TEInterNEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.f_interface.wdm.wdmconfig.opticalpower.AsnPowerAttrResult;
import com.huawei.nglct.nemgr.f_interface.wdm.wdmconfig.opticalpower.AsnSetStdPowNewRsp;
import com.huawei.nglct.nemgr.f_interface.wdm.wdmconfig.opticalpower.AsnStdPowNew;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.math.BigDecimal;
import java.text.NumberFormat;
import net.commustru.fstru.FStruct;

public class TEInterOpticalPowerBaseBean
extends TEInterNEExplorerBean {
    public static final int UN_SUPPORT_INT_VALUE = 65535;
    public static final String UN_SUPPORT_STR_VALUE = "-";
    public static final int UNKNOWN_INT_VALUE = 0x7FFFFFFE;
    public static final int UNKNOWN_INT_VALUE_MINUS = Integer.MIN_VALUE;
    public static final String UNKNOWN_STR_VALUE = "/";
    public static final float FACTOR = 0.1f;
    public static final int LIMIT = 1;
    public static String ATTR_INPOW = "INPOW";
    public static String ATTR_INPOW_REVALUE = "INPOW_REVALUE";
    public static String ATTR_INPOW_RETIME = "INPOW_RETIME";
    public static String ATTR_INPOW_LOWTHRESHOLD = "INPOW_LOWTHRESHOLD";
    public static String ATTR_INPOW_LOWTHRESHOLD_MIN = "INPOW_LOWTHRESHOLD_MIN";
    public static String ATTR_INPOW_LOWTHRESHOLD_MAX = "INPOW_LOWTHRESHOLD_MAX";
    public static String ATTR_INPOW_HIGHTHRESHOLD = "INPOW_HIGHTHRESHOLD";
    public static String ATTR_INPOW_HIGHTHRESHOLD_MIN = "INPOW_HIGHTHRESHOLD_MIN";
    public static String ATTR_INPOW_HIGHTHRESHOLD_MAX = "INPOW_HIGHTHRESHOLD_MAX";
    public static String ATTR_INPOW_REF_LOWTHRESHOLD = "INPOW_REF_LOWTHRESHOLD";
    public static String ATTR_INPOW_REF_HIGHTHRESHOLD = "INPOW_REF_HIGHTHRESHOLD";
    public static String ATTR_INPOW_STATE = "INPOW_STATE";
    public static String ATTR_OUTPOW = "OUTPOW";
    public static String ATTR_OUTPOW_REVALUE = "OUTPOW_REVALUE";
    public static String ATTR_OUTPOW_RETIME = "OUTPOW_RETIME";
    public static String ATTR_OUTPOW_LOWTHRESHOLD = "OUTPOW_LOWTHRESHOLD";
    public static String ATTR_OUTPOW_HIGHTHRESHOLD = "OUTPOW_HIGHTHRESHOLD";
    public static String ATTR_OUTPOW_REF_LOWTHRESHOLD = "OUTPOW_REF_LOWTHRESHOLD";
    public static String ATTR_OUTPOW_REF_HIGHTHRESHOLD = "OUTPOW_REF_HIGHTHRESHOLD";
    public static String ATTR_OUTPOW_STATE = "OUTPOW_STATE";
    public static String ATTR_INPOW_CFP_LOWTHRESHOLD = "INPOW_CFP_LOWTHRESHOLD";
    public static String ATTR_INPOW_CFP_LOWTHRESHOLD_MIN = "INPOW_CFP_LOWTHRESHOLD_MIN";
    public static String ATTR_INPOW_CFP_LOWTHRESHOLD_MAX = "INPOW_CFP_LOWTHRESHOLD_MAX";
    public static String ATTR_INPOW_CFP_HIGHTHRESHOLD = "INPOW_CFP_HIGHTHRESHOLD";
    public static String ATTR_INPOW_CFP_HIGHTHRESHOLD_MIN = "INPOW_CFP_HIGHTHRESHOLD_MIN";
    public static String ATTR_INPOW_CFP_HIGHTHRESHOLD_MAX = "INPOW_CFP_HIGHTHRESHOLD_MAX";
    public static String ATTR_INPOW_CFP_CURRENT_VALLEY = "INPOW_CFP_CURRENT_VALLEY";
    public static String ATTR_INPOW_CFP_CURRENT_PEAK = "INPOW_CFP_CURRENT_PEAK";
    public static final int INPUTVALLEY_ATTRIB = 272287;
    public static final int INPUTPEAK_ATTRIB = 272288;

    public Datainterface sendAsnMsg() {
        Datainterface output = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        RowParams rowParams = this.inputData.getBussinessParams().getRowParams(0);
        FStruct req = this.convertParamstoReq(rowParams);
        AsnSetStdPowNewRsp rsp = new AsnSetStdPowNewRsp();
        int result = this.sendCommand(this.neid, req, (FStruct)rsp, this.getCmd());
        boolean isAllSuccess = true;
        if (result == 0) {
            if (rsp.result.isSuccess) {
                for (int i = 0; i < rsp.stdPowerList.size(); ++i) {
                    AsnStdPowNew stdPower = (AsnStdPowNew)rsp.stdPowerList.elementAt(i);
                    if (!stdPower.totalErrCode.isSuccess) {
                        int errcode = 2;
                        if (rsp.result.retCode != null) {
                            errcode = rsp.result.retCode.intValue();
                        }
                        this.createErrorParams(stdPower, bussiness, errcode);
                        continue;
                    }
                    isAllSuccess = this.createErrorParams(stdPower, bussiness);
                    this.stdPowerToParams(stdPower, bussiness);
                }
                output.setBussinessParams(bussiness);
            } else if (rsp.result.retCode != null) {
                result = rsp.result.retCode.intValue();
            }
        }
        if (!isAllSuccess && result == 0) {
            output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1));
        } else {
            output.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
        }
        return output;
    }

    protected int getCmd() {
        return this.subfunc.getCode();
    }

    protected boolean createErrorParams(AsnStdPowNew stdPower, BussinessParams bussiness) {
        RowErrors tmpError;
        boolean isAllSuccess = true;
        RowParams row = new RowParams();
        RowErrors rowError = this.initRowErrors(stdPower);
        if (!stdPower.inPowErrCode.isSuccess) {
            tmpError = (RowErrors)rowError.clone();
            tmpError.addParam(new Param("attrId", ATTR_INPOW));
            tmpError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)stdPower.inPowErrCode.retCode.intValue()));
            row.addRowErrors(tmpError);
            isAllSuccess = false;
        }
        if (!stdPower.stdInPowErrCode.isSuccess) {
            tmpError = (RowErrors)rowError.clone();
            tmpError.addParam(new Param("attrId", ATTR_INPOW_REVALUE));
            tmpError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)stdPower.stdInPowErrCode.retCode.intValue()));
            row.addRowErrors(tmpError);
            isAllSuccess = false;
        }
        if (!stdPower.minInPowErrCode.isSuccess) {
            tmpError = (RowErrors)rowError.clone();
            tmpError.addParam(new Param("attrId", ATTR_INPOW_LOWTHRESHOLD));
            tmpError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)stdPower.minInPowErrCode.retCode.intValue()));
            row.addRowErrors(tmpError);
            isAllSuccess = false;
        }
        if (!stdPower.minInPowLowErrCode.isSuccess) {
            tmpError = (RowErrors)rowError.clone();
            tmpError.addParam(new Param("attrId", ATTR_INPOW_LOWTHRESHOLD_MIN));
            tmpError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)stdPower.minInPowLowErrCode.retCode.intValue()));
            row.addRowErrors(tmpError);
            isAllSuccess = false;
        }
        if (!stdPower.minInPowHighErrCode.isSuccess) {
            tmpError = (RowErrors)rowError.clone();
            tmpError.addParam(new Param("attrId", ATTR_INPOW_LOWTHRESHOLD_MAX));
            tmpError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)stdPower.minInPowHighErrCode.retCode.intValue()));
            row.addRowErrors(tmpError);
            isAllSuccess = false;
        }
        if (!stdPower.maxInPowErrCode.isSuccess) {
            tmpError = (RowErrors)rowError.clone();
            tmpError.addParam(new Param("attrId", ATTR_INPOW_HIGHTHRESHOLD));
            tmpError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)stdPower.maxInPowErrCode.retCode.intValue()));
            row.addRowErrors(tmpError);
            isAllSuccess = false;
        }
        if (!stdPower.maxInPowLowErrCode.isSuccess) {
            tmpError = (RowErrors)rowError.clone();
            tmpError.addParam(new Param("attrId", ATTR_INPOW_HIGHTHRESHOLD_MIN));
            tmpError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)stdPower.maxInPowLowErrCode.retCode.intValue()));
            row.addRowErrors(tmpError);
            isAllSuccess = false;
        }
        if (!stdPower.maxInPowHighErrCode.isSuccess) {
            tmpError = (RowErrors)rowError.clone();
            tmpError.addParam(new Param("attrId", ATTR_INPOW_HIGHTHRESHOLD_MAX));
            tmpError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)stdPower.maxInPowHighErrCode.retCode.intValue()));
            row.addRowErrors(tmpError);
            isAllSuccess = false;
        }
        if (!stdPower.minWorkPowErrCode.isSuccess) {
            tmpError = (RowErrors)rowError.clone();
            tmpError.addParam(new Param("attrId", ATTR_INPOW_REF_LOWTHRESHOLD));
            tmpError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)stdPower.minWorkPowErrCode.retCode.intValue()));
            row.addRowErrors(tmpError);
            isAllSuccess = false;
        }
        if (!stdPower.maxWorkPowErrCode.isSuccess) {
            tmpError = (RowErrors)rowError.clone();
            tmpError.addParam(new Param("attrId", ATTR_INPOW_REF_HIGHTHRESHOLD));
            tmpError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)stdPower.maxWorkPowErrCode.retCode.intValue()));
            row.addRowErrors(tmpError);
            isAllSuccess = false;
        }
        if (!stdPower.outPowErrCode.isSuccess) {
            tmpError = (RowErrors)rowError.clone();
            tmpError.addParam(new Param("attrId", ATTR_OUTPOW));
            tmpError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)stdPower.outPowErrCode.retCode.intValue()));
            row.addRowErrors(tmpError);
            isAllSuccess = false;
        }
        if (!stdPower.stdOutPowErrCode.isSuccess) {
            tmpError = (RowErrors)rowError.clone();
            tmpError.addParam(new Param("attrId", ATTR_OUTPOW_REVALUE));
            tmpError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)stdPower.stdOutPowErrCode.retCode.intValue()));
            row.addRowErrors(tmpError);
            isAllSuccess = false;
        }
        if (!stdPower.minOutPowErrCode.isSuccess) {
            tmpError = (RowErrors)rowError.clone();
            tmpError.addParam(new Param("attrId", ATTR_INPOW_LOWTHRESHOLD));
            tmpError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)stdPower.minOutPowErrCode.retCode.intValue()));
            row.addRowErrors(tmpError);
            isAllSuccess = false;
        }
        if (!stdPower.maxOutPowErrCode.isSuccess) {
            tmpError = (RowErrors)rowError.clone();
            tmpError.addParam(new Param("attrId", ATTR_INPOW_HIGHTHRESHOLD));
            tmpError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)stdPower.maxOutPowErrCode.retCode.intValue()));
            row.addRowErrors(tmpError);
            isAllSuccess = false;
        }
        if (!stdPower.minRefOutPowErrCode.isSuccess) {
            tmpError = (RowErrors)rowError.clone();
            tmpError.addParam(new Param("attrId", ATTR_INPOW_REF_LOWTHRESHOLD));
            tmpError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)stdPower.minRefOutPowErrCode.retCode.intValue()));
            row.addRowErrors(tmpError);
            isAllSuccess = false;
        }
        if (!stdPower.maxRefOutPowErrCode.isSuccess) {
            tmpError = (RowErrors)rowError.clone();
            tmpError.addParam(new Param("attrId", ATTR_INPOW_REF_HIGHTHRESHOLD));
            tmpError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)stdPower.maxRefOutPowErrCode.retCode.intValue()));
            row.addRowErrors(tmpError);
            isAllSuccess = false;
        }
        if (!stdPower.minCFPInPowErrCode.isSuccess) {
            tmpError = (RowErrors)rowError.clone();
            tmpError.addParam(new Param("attrId", ATTR_INPOW_CFP_LOWTHRESHOLD));
            tmpError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)stdPower.minCFPInPowErrCode.retCode.intValue()));
            row.addRowErrors(tmpError);
            isAllSuccess = false;
        }
        if (!stdPower.minCFPInPowLowErrCode.isSuccess) {
            tmpError = (RowErrors)rowError.clone();
            tmpError.addParam(new Param("attrId", ATTR_INPOW_CFP_LOWTHRESHOLD_MIN));
            tmpError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)stdPower.minCFPInPowLowErrCode.retCode.intValue()));
            row.addRowErrors(tmpError);
            isAllSuccess = false;
        }
        if (!stdPower.minCFPInPowHighErrCode.isSuccess) {
            tmpError = (RowErrors)rowError.clone();
            tmpError.addParam(new Param("attrId", ATTR_INPOW_CFP_LOWTHRESHOLD_MAX));
            tmpError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)stdPower.minCFPInPowHighErrCode.retCode.intValue()));
            row.addRowErrors(tmpError);
            isAllSuccess = false;
        }
        if (!stdPower.maxCFPInPowErrCode.isSuccess) {
            tmpError = (RowErrors)rowError.clone();
            tmpError.addParam(new Param("attrId", ATTR_INPOW_CFP_HIGHTHRESHOLD));
            tmpError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)stdPower.maxCFPInPowErrCode.retCode.intValue()));
            row.addRowErrors(tmpError);
            isAllSuccess = false;
        }
        if (!stdPower.maxCFPInPowLowErrCode.isSuccess) {
            tmpError = (RowErrors)rowError.clone();
            tmpError.addParam(new Param("attrId", ATTR_INPOW_CFP_HIGHTHRESHOLD_MIN));
            tmpError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)stdPower.maxCFPInPowLowErrCode.retCode.intValue()));
            row.addRowErrors(tmpError);
            isAllSuccess = false;
        }
        if (!stdPower.maxCFPInPowHighErrCode.isSuccess) {
            tmpError = (RowErrors)rowError.clone();
            tmpError.addParam(new Param("attrId", ATTR_INPOW_CFP_HIGHTHRESHOLD_MAX));
            tmpError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)stdPower.maxCFPInPowHighErrCode.retCode.intValue()));
            row.addRowErrors(tmpError);
            isAllSuccess = false;
        }
        int size = stdPower.aditionalAttrList.size();
        for (int i = 0; i < size; ++i) {
            RowErrors tmpError2;
            AsnPowerAttrResult additionAttrib = (AsnPowerAttrResult)stdPower.aditionalAttrList.get(i);
            if (additionAttrib.result.isSuccess) continue;
            if (additionAttrib.attrib.attribID == 272287) {
                tmpError2 = (RowErrors)rowError.clone();
                tmpError2.addParam(new Param("attrId", ATTR_INPOW_CFP_CURRENT_VALLEY));
                tmpError2.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)additionAttrib.result.retCode.intValue()));
                row.addRowErrors(tmpError2);
                isAllSuccess = false;
                continue;
            }
            if (additionAttrib.attrib.attribID != 272288) continue;
            tmpError2 = (RowErrors)rowError.clone();
            tmpError2.addParam(new Param("attrId", ATTR_INPOW_CFP_CURRENT_PEAK));
            tmpError2.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)additionAttrib.result.retCode.intValue()));
            row.addRowErrors(tmpError2);
            isAllSuccess = false;
        }
        bussiness.addRowParams(row);
        return isAllSuccess;
    }

    private RowErrors initRowErrors(AsnStdPowNew stdPower) {
        int neID = stdPower.inPortInfo.neID;
        int slotID = stdPower.inPortInfo.slotID;
        int portID = TEConfigurationDataMgr.getPortRelativeID((int)stdPower.inPortInfo.portID);
        String nename = TEConfigurationDataMgr.getInstance().getNE(neID).getNEName();
        String subrackname = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotID);
        String boardname = TEConfigurationDataMgr.getInstance().getBoardName(neID, slotID);
        boardname = !"".equals(subrackname) ? subrackname + UN_SUPPORT_STR_VALUE + TEBoardUtil.getSlotIDFromSlot((int)neID, (int)slotID) + UN_SUPPORT_STR_VALUE + boardname : TEBoardUtil.getSlotIDFromSlot((int)neID, (int)slotID) + UN_SUPPORT_STR_VALUE + boardname;
        String portname = TEConfigurationDataMgr.getInstance().getPortName(neID, slotID, portID);
        RowErrors rowError = new RowErrors();
        rowError.addParam(new Param("nename", nename));
        rowError.addParam(new Param("boardname", boardname));
        rowError.addParam(new Param("portname", portname));
        return rowError;
    }

    protected FStruct convertParamstoReq(RowParams rowParams) {
        return null;
    }

    protected void stdPowerToParams(AsnStdPowNew stdPower, BussinessParams bussiness) {
    }

    protected BussinessParams createErrorParams(AsnStdPowNew stdPower, BussinessParams bussiness, int errorCode) {
        int neID = stdPower.inPortInfo.neID;
        int slotID = stdPower.inPortInfo.slotID;
        String nename = TEConfigurationDataMgr.getInstance().getNE(neID).getNEName();
        String subrackname = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotID);
        String boardname = TEConfigurationDataMgr.getInstance().getBoardName(neID, slotID);
        boardname = !"".equals(subrackname) ? subrackname + UN_SUPPORT_STR_VALUE + TEBoardUtil.getSlotIDFromSlot((int)neID, (int)slotID) + UN_SUPPORT_STR_VALUE + boardname : TEBoardUtil.getSlotIDFromSlot((int)neID, (int)slotID) + UN_SUPPORT_STR_VALUE + boardname;
        int portID = TEConfigurationDataMgr.getPortRelativeID((int)stdPower.inPortInfo.portID);
        String portname = TEConfigurationDataMgr.getInstance().getPortName(neID, slotID, portID);
        RowParams row = new RowParams();
        RowErrors rowError = new RowErrors();
        rowError.addParam(new Param("nename", nename));
        rowError.addParam(new Param("boardname", boardname));
        rowError.addParam(new Param("portname", portname));
        rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)errorCode));
        row.addRowErrors(rowError);
        bussiness.addRowParams(row);
        return bussiness;
    }

    protected RowParams dealPowStat(String name, int power, int stdPower, int minRefPower, int maxRefPower) {
        BigDecimal powValue;
        String strPowStat = UN_SUPPORT_STR_VALUE;
        if (power == 65535 || stdPower == 65535 && (minRefPower == 65535 || maxRefPower == 65535)) {
            strPowStat = UN_SUPPORT_STR_VALUE;
        } else if (power != 0x7FFFFFFE && stdPower != 0x7FFFFFFE && stdPower != 65535) {
            powValue = new BigDecimal(this.getFactorDouble(power, 0.1f, 1));
            BigDecimal stdPowerValue = new BigDecimal(this.getFactorDouble(stdPower, 0.1f, 1));
            strPowStat = this.getWarningLevelFromStd(powValue, stdPowerValue);
        } else if (power != 0x7FFFFFFE && minRefPower != 0x7FFFFFFE && maxRefPower != 0x7FFFFFFE && minRefPower != 65535 && maxRefPower != 65535) {
            powValue = new BigDecimal(this.getFactorDouble(power, 0.1f, 1));
            BigDecimal maxPowerValue = new BigDecimal(this.getFactorDouble(maxRefPower, 0.1f, 1));
            BigDecimal minPowerValue = new BigDecimal(this.getFactorDouble(minRefPower, 0.1f, 1));
            strPowStat = this.getWarningLevel(powValue, maxPowerValue, minPowerValue);
        } else {
            strPowStat = UNKNOWN_STR_VALUE;
        }
        RowParams row = new RowParams();
        row.addParam(new Param("attribute", name));
        row.addParam(new Param("value", strPowStat));
        return row;
    }

    protected String getFactor(int value, float factor, int limit) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(limit);
        nf.setMinimumFractionDigits(limit);
        Double tmp = Double.valueOf("" + factor);
        double tempD = Math.round((double)value);
        return String.valueOf(nf.format(tempD * tmp));
    }

    protected double getFactorDouble(double value, float factor, int limit) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(limit);
        nf.setMinimumFractionDigits(limit);
        Double tmp = Double.valueOf("" + factor);
        double tempD = Math.round(value);
        return tempD * tmp;
    }

    protected String getWarningLevelFromStd(BigDecimal currentPow, BigDecimal stdPow) {
        String stdPowStat = null;
        float absPow = currentPow.subtract(stdPow).abs().floatValue();
        if (absPow <= 2.0f) {
            stdPowStat = "Normal_Stat";
        } else if (absPow > 2.0f && absPow <= 4.0f) {
            stdPowStat = "War_Alert";
        } else if (absPow > 4.0f) {
            stdPowStat = "Sev_Alert";
        }
        return stdPowStat;
    }

    protected String getWarningLevel(BigDecimal currentPow, BigDecimal maxPow, BigDecimal minPow) {
        String stdPowStat = null;
        BigDecimal bigDecimalTwo = BigDecimal.valueOf(2.0);
        BigDecimal lengthPow = maxPow.subtract(minPow).divide(bigDecimalTwo);
        BigDecimal middlePow = maxPow.add(minPow).divide(bigDecimalTwo);
        float absPow = currentPow.subtract(middlePow).abs().subtract(lengthPow).floatValue();
        stdPowStat = absPow > 0.0f && absPow <= 2.0f ? "War_Alert" : (absPow > 2.0f ? "Sev_Alert" : "Normal_Stat");
        return stdPowStat;
    }
}

