/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.opticalpower;

import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.TEGenCfgDataConvertor;
import com.huawei.nglct.gencfg.TEGenCfgQueryBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.math.BigInteger;
import java.util.ArrayList;

public class OpticalPowerQueryBean
extends TEGenCfgQueryBean {
    private static final int SUM_INPOWER_EVENT = 212;
    private static final int SUM_OUTPOWER_EVENT = 215;
    private static final int EDTPL_OUTPOWER_EVENT = 123;
    private static final int INPOWER_EVENT = 203;
    private static final int OUTPOWER_EVENT = 200;
    private static final int FILTER_MAX = Integer.MAX_VALUE;
    private static final int FILTER_MIN = Integer.MIN_VALUE;
    private static final int FIND_NULL_ERROR_CODE_38410 = 38410;
    private static final int FIND_NULL_ERROR_CODE_38662 = 38662;

    public void handleMessage(int neid, SubFunc subfunc, ArrayList operationList, ArrayList filterErrorCodeList) {
        ArrayList tempOperationList = this.getOperationList(neid, operationList);
        this.outputData = TEGenCfgDataConvertor.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)tempOperationList, (ArrayList)filterErrorCodeList);
        RowParams rows = null;
        if (this.outputData.getBussinessParams().getRowParamsCount() > 0 && 10 > (rows = this.outputData.getBussinessParams().getRowParams(0)).getParamCount()) {
            this.outputData.getBussinessParams().removeRowParams(0);
        }
        for (int i = this.outputData.getBussinessParams().getRowParamsCount() - 1; i >= 0; --i) {
            float maxInpow;
            int intMaxInpow;
            String strMaxInpow;
            float minInpow;
            int intMinInpow;
            String strMinInpow;
            rows = this.outputData.getBussinessParams().getRowParams(i);
            if (rows.getParamCount() == 0 || rows.getParam("slotid").getValue().equals("0") || rows.getParam("port") == null || rows.getParam("port").getValue().equals("0")) {
                if (rows.getRowErrorsCount() != 0) continue;
                this.outputData.getBussinessParams().removeRowParams(i);
                continue;
            }
            if (this.isIntValue(rows, "W32PORT_ATTR_MININPOW")) {
                strMinInpow = rows.getParam("W32PORT_ATTR_MININPOW").getValue();
                intMinInpow = new BigInteger(strMinInpow).intValue();
                if (Integer.MAX_VALUE == intMinInpow || Integer.MIN_VALUE == intMinInpow) {
                    rows.getParam("W32PORT_ATTR_MININPOW").setValue("/");
                } else {
                    minInpow = (float)intMinInpow / 10.0f;
                    rows.getParam("W32PORT_ATTR_MININPOW").setValue("" + minInpow);
                }
            }
            if (this.isIntValue(rows, "W32PORT_ATTR_MAXINPOW")) {
                strMaxInpow = rows.getParam("W32PORT_ATTR_MAXINPOW").getValue();
                intMaxInpow = new BigInteger(strMaxInpow).intValue();
                if (Integer.MAX_VALUE == intMaxInpow || Integer.MIN_VALUE == intMaxInpow) {
                    rows.getParam("W32PORT_ATTR_MAXINPOW").setValue("/");
                } else {
                    maxInpow = (float)intMaxInpow / 10.0f;
                    rows.getParam("W32PORT_ATTR_MAXINPOW").setValue("" + maxInpow);
                }
            }
            if (this.isIntValue(rows, "W32PORT_ATTR_PUMP_OPMIN")) {
                strMinInpow = rows.getParam("W32PORT_ATTR_PUMP_OPMIN").getValue();
                intMinInpow = new BigInteger(strMinInpow).intValue();
                if (Integer.MAX_VALUE == intMinInpow || Integer.MIN_VALUE == intMinInpow) {
                    rows.getParam("W32PORT_ATTR_PUMP_OPMIN").setValue("/");
                } else {
                    minInpow = (float)intMinInpow / 10.0f;
                    rows.getParam("W32PORT_ATTR_PUMP_OPMIN").setValue("" + minInpow);
                }
            }
            if (!this.isIntValue(rows, "W32PORT_ATTR_PUMP_OPMAX")) continue;
            strMaxInpow = rows.getParam("W32PORT_ATTR_PUMP_OPMAX").getValue();
            intMaxInpow = new BigInteger(strMaxInpow).intValue();
            if (Integer.MAX_VALUE == intMaxInpow || Integer.MIN_VALUE == intMaxInpow) {
                rows.getParam("W32PORT_ATTR_PUMP_OPMAX").setValue("/");
                continue;
            }
            maxInpow = (float)intMaxInpow / 10.0f;
            rows.getParam("W32PORT_ATTR_PUMP_OPMAX").setValue("" + maxInpow);
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorCodeList = new ArrayList<Integer>();
        errorCodeList.add(38410);
        errorCodeList.add(38662);
        return errorCodeList;
    }

    private boolean isIntValue(RowParams rowParams, String attrId) {
        return null != rowParams.getParam(attrId) && !rowParams.getParam(attrId).getValue().equals("/");
    }

    private ArrayList getOperationList(int neID, ArrayList operationList) {
        ArrayList<Object> operList;
        block13: {
            TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
            operList = new ArrayList<Object>();
            Operation oper = null;
            Output output = null;
            Part part = null;
            if (null == operationList) break block13;
            int len = operationList.size();
            for (int i = 0; i < len; ++i) {
                block14: {
                    oper = (Operation)operationList.get(i);
                    if (!oper.getName().equalsIgnoreCase("NSCMD_PER_GET_CURDATA_1")) break block14;
                    Input input = oper.getInput();
                    int slotID = Integer.parseInt(input.getPart("slotid").getValue());
                    int boardType = mgr.getBoardType(neID, slotID);
                    output = oper.getOutput(0);
                    Part[] partArrs = output.getPart();
                    int len2 = partArrs.length;
                    for (int k = 0; k < len2; ++k) {
                        if (!partArrs[k].getName().equalsIgnoreCase("record")) continue;
                        if (partArrs[k].getValue() == null) {
                            return operationList;
                        }
                        byte[] bValue = partArrs[k].getValue().getBytes();
                        int nParaSize = bValue.length;
                        output.removePart(partArrs[k]);
                        output.getPart("periodstime").setValue("");
                        oper.removeOutput(output);
                        int nCount = 18;
                        int nPos = 0;
                        while (nPos + nCount <= nParaSize) {
                            block15: {
                                boolean flag;
                                int path;
                                int port;
                                Output tmpOut;
                                block17: {
                                    int powerValue;
                                    int eventType;
                                    block16: {
                                        tmpOut = (Output)output.clone();
                                        byte[] byteTmp = new byte[4];
                                        System.arraycopy(bValue, nPos + 0, byteTmp, 0, 4);
                                        eventType = IOStreamConvertor.readPositiveInt((byte[])byteTmp, (int)0);
                                        if (eventType != 203 && eventType != 200 && eventType != 212 && eventType != 215 && eventType != 123) break block15;
                                        byteTmp = new byte[2];
                                        System.arraycopy(bValue, nPos + 4, byteTmp, 0, 2);
                                        port = IOStreamConvertor.readPositiveShort((byte[])byteTmp, (int)0);
                                        byteTmp = new byte[4];
                                        System.arraycopy(bValue, nPos + 6, byteTmp, 0, 4);
                                        path = IOStreamConvertor.readPositiveInt((byte[])byteTmp, (int)0);
                                        flag = false;
                                        int count = oper.getOutputCount();
                                        for (int j = 0; j < count; ++j) {
                                            Output out = oper.getOutput(j);
                                            String slot = out.getPartValue("slotid");
                                            String portid = out.getPartValue("port");
                                            String pathid = out.getPartValue("path");
                                            if (slot == null || portid == null || pathid == null || Integer.parseInt(slot) != slotID || Integer.parseInt(portid) != port || Integer.parseInt(pathid) != path) continue;
                                            tmpOut = out;
                                            flag = true;
                                            break;
                                        }
                                        byteTmp = new byte[8];
                                        System.arraycopy(bValue, nPos + 10, byteTmp, 0, 8);
                                        powerValue = IOStreamConvertor.readPositiveLong((byte[])byteTmp, (int)0);
                                        if (eventType != 203 && eventType != 212) break block16;
                                        float inputPower = (float)powerValue / 10.0f;
                                        if (tmpOut.getPart("W32PORT_ATTR_INPUTPOWER") == null) {
                                            part = new Part();
                                            part.setType("int");
                                            part.setLength(2);
                                            part.setName("W32PORT_ATTR_INPUTPOWER");
                                            part.setValue(inputPower + "");
                                            tmpOut.addPart(part);
                                        } else {
                                            tmpOut.getPart("W32PORT_ATTR_INPUTPOWER").setValue(inputPower + "");
                                        }
                                        break block17;
                                    }
                                    if (eventType != 200 && eventType != 215 && eventType != 123) break block17;
                                    float outputPower = (float)powerValue / 10.0f;
                                    if (935 == boardType && 215 == eventType) break block15;
                                    if (tmpOut.getPart("W32PORT_ATTR_OUTPUTPOWER") == null) {
                                        part = new Part();
                                        part.setType("int");
                                        part.setLength(2);
                                        part.setName("W32PORT_ATTR_OUTPUTPOWER");
                                        part.setValue(outputPower + "");
                                        tmpOut.addPart(part);
                                    } else {
                                        tmpOut.getPart("W32PORT_ATTR_OUTPUTPOWER").setValue(outputPower + "");
                                    }
                                }
                                if (!flag) {
                                    part = new Part();
                                    part.setType("byte");
                                    part.setLength(1);
                                    part.setName("port");
                                    part.setValue(port + "");
                                    tmpOut.addPart(part);
                                    part = new Part();
                                    part.setType("int");
                                    part.setLength(2);
                                    part.setName("path");
                                    part.setValue(path + "");
                                    tmpOut.addPart(part);
                                    oper.addOutput((Output)tmpOut.clone());
                                }
                            }
                            nPos += nCount;
                        }
                        break;
                    }
                    operList.add(oper.clone());
                    continue;
                }
                operList.add(oper.clone());
            }
        }
        return operList;
    }
}

