/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.ophbyte.otn.objtypeid;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ngwdm.ophbyte.otn.TEOtnInfStaticData;
import com.huawei.nglct.nemgr.ngwdm.ophbyte.otn.objtypeid.TETcmObjTypeIDCreator;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.objtypeid.TEPartSource;
import gnu.trove.TIntObjectHashMap;
import org.slf4j.Logger;

public class TEObjTypeIDCreator {
    private Logger logger = TELogFactory.getNormalLogger();
    private TIntObjectHashMap<TEObjTypeIDCreator> creatorMap = new TIntObjectHashMap();
    private TIntObjectHashMap<TEObjTypeIDCreator> creatorObjTypeMap = new TIntObjectHashMap();
    private static TEObjTypeIDCreator instance = null;

    protected TEObjTypeIDCreator() {
    }

    private void initCreator() {
        if (this.creatorMap.isEmpty()) {
            this.creatorMap.put(61607, (Object)new TETcmObjTypeIDCreator());
        }
    }

    public static synchronized TEObjTypeIDCreator getInstance() {
        if (null == instance) {
            instance = new TEObjTypeIDCreator();
            instance.initCreator();
        }
        return instance;
    }

    public int[] createObjectID(int neID, int objectTypeID, TEPartSource partSource) {
        TEObjTypeIDCreator creator = this.getCreator(objectTypeID);
        return creator.createObjTypeIDImpl(neID, partSource);
    }

    public int getObjTypeID(int neID, String attrName, String objTypeStr, TEPartSource partSource) {
        int slotID = Integer.parseInt(partSource.getPart("slotid").getValue());
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotID);
        TEObjTypeIDCreator creator = this.getObjTypeCreator(boardType);
        if (creator != null) {
            return creator.createObjTypeID(attrName, objTypeStr, partSource, boardType);
        }
        return this.createObjTypeID(attrName, objTypeStr, partSource, boardType);
    }

    protected int createObjTypeID(String attrName, String objTypeStr, TEPartSource partSource, int boardType) {
        Integer objType = null;
        objType = TEOtnInfStaticData.getObjTypeNameIDMap().get(objTypeStr);
        if (null != objType) {
            return objType;
        }
        TELogFactory.getNormalLogger().error("get objtype error->" + objTypeStr);
        return -1;
    }

    private TEObjTypeIDCreator getCreator(int objectTypeID) {
        TEObjTypeIDCreator creator = (TEObjTypeIDCreator)this.creatorMap.get(objectTypeID);
        if (null == creator) {
            this.logger.error("Get objectTypeID Creator fail! objectTypeID" + objectTypeID);
        }
        return creator;
    }

    private TEObjTypeIDCreator getObjTypeCreator(int boardType) {
        TEObjTypeIDCreator creator = (TEObjTypeIDCreator)this.creatorObjTypeMap.get(boardType);
        return creator;
    }

    protected int[] createObjTypeIDImpl(int neID, TEPartSource partSource) {
        return null;
    }
}

