/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.ophbyte.otn;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.TEGenCfgQueryBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgModel;
import com.huawei.nglct.nemgr.ngwdm.ophbyte.otn.TEOtnInfUtil;
import com.huawei.nglct.nemgr.ngwdm.ophbyte.otn.TEQueryOtnInterBean;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;

public class TEQueryNEOtnBean
extends TEGenCfgQueryBean {
    private static final Logger logger = TELogFactory.getNormalLogger();
    private TENE neObj = null;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subFunc = subFunc;
        this.inputData = inputData;
        this.neObj = TENEListMgr.getInstance().getNE(neid);
        this.outputData = new Datainterface();
        if (null == this.neObj) {
            log.info("Get ne object fail!");
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090596385));
            return this.outputData;
        }
        this.slotId = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
        String queryflag = String.valueOf(1);
        Param queryflagParam = inputData.getBussinessParams().getRowParams(0).getParam("queryflag");
        if (queryflagParam != null && TESysManagerBean.getInstance().isIntegratedStatus()) {
            queryflag = queryflagParam.getValue();
        }
        if ((inputData = this.createQueryOTNInfInput(this.slotId, queryflag)).getBussinessParams().isEmpty()) {
            log.info("inputData is empty!");
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            return this.outputData;
        }
        TEQueryOtnInterBean queryBean = new TEQueryOtnInterBean();
        try {
            this.outputData = queryBean.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
        }
        catch (Exception e) {
            String tipStr = "TEQueryNEOtnBean run fail! ";
            logger.error(tipStr, (Throwable)e);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
            return this.outputData;
        }
        return this.outputData;
    }

    private Datainterface createQueryOTNInfInput(int slotid, String queryflag) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        inputData.setBussinessParams(bussiness);
        if (slotid == 0) {
            Map supportMap = TEGenCfgModel.getAllSupportPortListInNE((int)this.neid, (String[])TEOtnInfUtil.attrNamesList.toArray(new String[0]));
            ArrayList<Integer> boardList = new ArrayList<Integer>();
            for (Map.Entry entry : supportMap.entrySet()) {
                TEBoard board = (TEBoard)entry.getKey();
                boardList.add(board.getSlotID());
            }
            Collections.sort(boardList);
            Iterator itor = boardList.iterator();
            while (itor.hasNext()) {
                RowParams rowparams = new RowParams();
                int itorSlotid = (Integer)((Object)itor.next());
                Param param = new Param("neid", String.valueOf(this.neid));
                rowparams.addParam(param);
                param = new Param("slotid", String.valueOf(itorSlotid));
                rowparams.addParam(param);
                param = new Param("srcObjType", "ID_OBJECT_TYPE_NE_BOARD");
                rowparams.addParam(param);
                param = new Param("attrId", "port");
                rowparams.addParam(param);
                param = new Param("attrId", "level");
                rowparams.addParam(param);
                param = new Param("islogDetail", "0");
                rowparams.addParam(param);
                param = new Param("queryflag", queryflag);
                rowparams.addParam(param);
                for (String attr : TEOtnInfUtil.attrNamesList) {
                    param = new Param("attrId", attr);
                    rowparams.addParam(param);
                }
                bussiness.addRowParams(rowparams);
            }
        } else {
            RowParams rowparams = new RowParams();
            TEBoard board = this.neObj.getBoard(slotid);
            Param param = new Param("neid", String.valueOf(this.neid));
            rowparams.addParam(param);
            param = new Param("slotid", String.valueOf(board.getSlotID()));
            rowparams.addParam(param);
            param = new Param("srcObjType", "ID_OBJECT_TYPE_NE_BOARD");
            rowparams.addParam(param);
            param = new Param("attrId", "port");
            rowparams.addParam(param);
            param = new Param("attrId", "level");
            rowparams.addParam(param);
            param = new Param("queryflag", queryflag);
            rowparams.addParam(param);
            for (String attr : TEOtnInfUtil.attrNamesList) {
                param = new Param("attrId", attr);
                rowparams.addParam(param);
            }
            bussiness.addRowParams(rowparams);
        }
        return inputData;
    }
}

