/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.ophbyte.otn;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TECircuitPackDescription;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.circuitpack.TEPortParaRecord;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgAttribute;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgModel;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgPortAttribute;
import com.huawei.nglct.ngwdm_pub.TEOTNModelDataMgr;
import com.huawei.nglct.ngwdm_pub.TEOTNModelShowPathMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEStringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TEQueryMSISupportLevelBean
extends TENEExplorerBean {
    private static String OTN_SUPPORT_MSIOVERHEAD = "OTN_SUPPORT_MSIOVERHEAD";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        int slotID = this.getRowParamValue(inputData, "slotid");
        int bdType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotID);
        int grade = TEOTNModelDataMgr.getInstance().getGradeFromBoard(bdType);
        int portid = this.getRowParamValue(inputData, "port");
        this.outputData.setBussinessParams(new BussinessParams());
        this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        if (slotID == -1 || portid == -1) {
            return this.outputData;
        }
        HashMap<String, ArrayList<Integer>> levelMap = new HashMap<String, ArrayList<Integer>>();
        List<Integer> pathList = this.getPortParaPath(bdType, portid);
        for (int path : pathList) {
            int nepath = TEOTNModelDataMgr.getInstance().getNePath(1, grade, path, bdType);
            if (nepath == 1) continue;
            String level = TEOTNModelShowPathMgr.getInstance().getODULevelFormPath(path);
            String maxTimeslots = this.getMaxTimeSlots(grade, level);
            String key = level + "-" + maxTimeslots;
            ArrayList<Integer> tempList = levelMap.get(key);
            if (tempList == null) {
                tempList = new ArrayList();
                levelMap.put(key, tempList);
            }
            if (tempList.contains(path)) continue;
            tempList.add(path);
        }
        this.buildOutput(levelMap);
        return this.outputData;
    }

    private String getMaxTimeSlots(int grade, String oduk) {
        int tmp = 80;
        if (oduk.equalsIgnoreCase("ODU0")) {
            tmp = 1;
        } else if (oduk.equalsIgnoreCase("ODU1")) {
            tmp = 2;
        } else if (oduk.equalsIgnoreCase("ODU2")) {
            tmp = 8;
        } else if (oduk.equalsIgnoreCase("ODU4")) {
            tmp = 80;
        } else if (oduk.equalsIgnoreCase("ODU3")) {
            tmp = grade == 3 ? 32 : 31;
        } else if (oduk.equalsIgnoreCase("ODUFlex")) {
            switch (grade) {
                case 1: {
                    tmp = 2;
                    break;
                }
                case 2: {
                    tmp = 8;
                    break;
                }
                case 3: {
                    tmp = 32;
                    break;
                }
                case 6: {
                    tmp = 80;
                    break;
                }
            }
        }
        return String.valueOf(tmp);
    }

    private void buildOutput(HashMap<String, ArrayList<Integer>> levelMap) {
        for (Map.Entry<String, ArrayList<Integer>> entry : levelMap.entrySet()) {
            String level = entry.getKey();
            String value = TEStringUtils.parseIntegerList(entry.getValue());
            RowParams rowparams = new RowParams();
            rowparams.addParam("level", level);
            rowparams.addParam("pathList", value);
            this.outputData.getBussinessParams().addRowParams(rowparams);
        }
    }

    private int getRowParamValue(Datainterface inputData, String paramName) {
        int value = -1;
        try {
            value = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam(paramName).getValue());
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("parse input param error. paramName = " + paramName);
        }
        return value;
    }

    private List<Integer> getPortParaPath(int bdType, int port) {
        ArrayList<Integer> pathList = new ArrayList<Integer>();
        TEGenCfgModel genCfgMode = TEGenCfgDataMgr.getGenCfgMode((int)bdType);
        TEGenCfgAttribute cfgAttr = genCfgMode.getAttrFromId(OTN_SUPPORT_MSIOVERHEAD);
        if (cfgAttr != null && !cfgAttr.getPortList().isEmpty()) {
            ArrayList portList = cfgAttr.getPortList();
            int len = portList.size();
            for (int i = 0; i < len; ++i) {
                TEGenCfgPortAttribute portAttr = (TEGenCfgPortAttribute)portList.get(i);
                pathList.add(portAttr.getPath());
            }
        } else {
            TEPortParaRecord paraRecod = TECircuitPackDescription.getInstance().getCPPortPara(bdType, port);
            pathList.addAll(paraRecod.snkPathIDList);
        }
        return pathList;
    }
}

