/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.ophbyte.otn;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.ngwdm_pub.TEOTNModelDataMgr;
import com.huawei.nglct.ngwdm_pub.TEOTNModelShowPathMgr;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.TEStringUtils;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.List;

public class TEQueryMSIOverheadBean
extends TENEExplorerBean {
    private static int NSCMD_CFG_GET_STMSI = 40864;
    private static int NSCMD_CFG_GET_SRMSI = 40866;
    private static int NSCMD_CFG_GET_RMSI = 40867;
    private static int ODU_LEVEL = 1;
    private int bdType = -1;
    private int slotID = -1;
    private List<Integer> pathList = new ArrayList<Integer>();

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        int bdType;
        int pathid;
        Operation curoper;
        ArrayList operList = super.getOperation(neid, subFunc, inputData, memeryData);
        if (operList == null || operList.isEmpty()) {
            return operList;
        }
        this.slotID = this.getRowParamValue(inputData, "slotid");
        int portid = this.getRowParamValue(inputData, "port");
        this.bdType = TEConfigurationDataMgr.getInstance().getBoardType(neid, this.slotID);
        if (this.slotID == -1 || portid == -1) {
            return null;
        }
        ArrayList<Operation> tmpList = new ArrayList<Operation>();
        int count = inputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < count; ++i) {
            String pathStr = inputData.getBussinessParams().getRowParams(i).getParam("path").getValue();
            TEStringUtils.strToNumList((String)pathStr, this.pathList);
        }
        Operation oper = this.getMSIOper(operList, NSCMD_CFG_GET_STMSI);
        if (oper != null) {
            for (int path : this.pathList) {
                curoper = (Operation)oper.clone();
                pathid = path;
                bdType = TEConfigurationDataMgr.getInstance().getBoardType(neid, this.slotID);
                if (TEOTNModelDataMgr.getInstance().isSimpleModelBoard(bdType)) {
                    pathid = TEOTNModelDataMgr.getNePath((int)neid, (int)this.slotID, (int)path);
                }
                curoper.getInput().getPart("path").setValue(String.valueOf(pathid));
                tmpList.add(curoper);
            }
        }
        if ((oper = this.getMSIOper(operList, NSCMD_CFG_GET_SRMSI)) != null) {
            for (int path : this.pathList) {
                curoper = (Operation)oper.clone();
                pathid = path;
                bdType = TEConfigurationDataMgr.getInstance().getBoardType(neid, this.slotID);
                if (TEOTNModelDataMgr.getInstance().isSimpleModelBoard(bdType)) {
                    pathid = TEOTNModelDataMgr.getNePath((int)neid, (int)this.slotID, (int)path);
                }
                curoper.getInput().getPart("path").setValue(String.valueOf(pathid));
                tmpList.add(curoper);
            }
        }
        if ((oper = this.getMSIOper(operList, NSCMD_CFG_GET_RMSI)) != null) {
            Operation curoper2 = (Operation)oper.clone();
            curoper2.getInput().getPart("path").setValue("0");
            tmpList.add(curoper2);
        }
        return tmpList;
    }

    private Operation getMSIOper(ArrayList<Operation> operList, int cmdid) {
        for (Operation oper : operList) {
            if (oper.getCmdid() != cmdid) continue;
            return oper;
        }
        return null;
    }

    private int getRowParamValue(Datainterface inputData, String paramName) {
        int value = -1;
        try {
            value = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam(paramName).getValue());
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("parse input param error. paramName = " + paramName);
        }
        return value;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        int size = operationList.size();
        for (int i = 0; i < size; ++i) {
            Operation oper = (Operation)operationList.get(i);
            this.handleMSITimeslotsNumber(oper);
            this.addUnConfigPart(oper);
        }
        Datainterface outputDataReturn = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)this.getFilterErrorCodeList());
        this.outputData.setBussinessParams(new BussinessParams());
        this.outputData.setErrorMessage(outputDataReturn.getErrorMessage());
        int count = outputDataReturn.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < count; ++i) {
            RowParams rowParams = outputDataReturn.getBussinessParams().getRowParams(i);
            this.outputData.getBussinessParams().addRowParams(rowParams);
            if (rowParams.getRowErrors().length == 0) {
                String path = this.getParamValue(rowParams, "path");
                if (!this.pathList.contains(Integer.valueOf(path))) continue;
                String level = TEOTNModelShowPathMgr.getInstance().getODULevelFormPath(Integer.parseInt(path));
                rowParams.addParam("oduklevel", level);
                int port = Integer.parseInt(this.getParamValue(rowParams, "port"));
                String portName = TEConfigurationDataMgr.getInstance().getPortName(neid, this.slotID, port);
                rowParams.addParam("portname", portName);
                String msiValue = this.getParamValue(rowParams, "stmsi_value");
                if (msiValue.isEmpty() || msiValue.equals("0")) {
                    msiValue = this.getParamValue(rowParams, "srmsi_value");
                }
                rowParams.addParam("number", msiValue);
                String msiTimeSlots = this.getParamValue(rowParams, "stmsi_timeslotsamount");
                if ((msiTimeSlots.isEmpty() || msiTimeSlots.equals("0")) && ((msiTimeSlots = this.getParamValue(rowParams, "srmsi_timeslotsamount")).isEmpty() || msiTimeSlots.equals("0"))) {
                    msiTimeSlots = this.getParamValue(rowParams, "rmsi_timeslotsamount");
                }
                rowParams.addParam("timeslots", msiTimeSlots);
                String stTimeslotsNumber = this.getParamValue(rowParams, "stmsi_timeslotsnumber");
                rowParams.addParam("OTN_MSI_ST", stTimeslotsNumber);
                String srTimeslotsNumber = this.getParamValue(rowParams, "srmsi_timeslotsnumber");
                rowParams.addParam("OTN_MSI_SR", srTimeslotsNumber);
                String rTimeslotsNumber = this.getParamValue(rowParams, "rmsi_timeslotsnumber");
                rowParams.addParam("OTN_MSI_R", rTimeslotsNumber);
                continue;
            }
            RowErrors rowErrors = rowParams.getRowErrors()[0];
            rowErrors.addParam(new Param("", ""));
        }
    }

    private void addUnConfigPart(Operation oper) {
        Output output = null;
        int m = oper.getOutputCount();
        for (int i = 0; i < m; ++i) {
            int errCode;
            output = oper.getOutput(i);
            if (TEOTNModelDataMgr.getInstance().isSimpleModelBoard(this.bdType)) {
                String path = oper.getInput().getPartValue("path");
                int grade = TEOTNModelDataMgr.getInstance().getGradeFromBoard(this.bdType);
                if (output.getPart("path").getValue() != null) {
                    int nePath = Integer.parseInt(output.getPart("path").getValue());
                    path = String.valueOf(TEOTNModelDataMgr.getInstance().getNmPathFromNePath(ODU_LEVEL, grade, nePath, this.bdType));
                } else {
                    output.getPart("slotid").setValue(oper.getInput().getPartValue("slotid"));
                    output.getPart("port").setValue(oper.getInput().getPartValue("port"));
                    path = String.valueOf(TEOTNModelDataMgr.getInstance().getNmPathFromNePath(ODU_LEVEL, grade, Integer.parseInt(path), this.bdType));
                }
                if (output.getPart("path").getValue() == null || output.getPart("path").getValue().isEmpty()) {
                    oper.getInput().getPart("path").setValue(String.valueOf(path));
                } else {
                    output.getPart("path").setValue(String.valueOf(path));
                }
            }
            if ((errCode = Integer.valueOf(output.getFault(0).getCode()).intValue()) == 38722 || errCode == 38777) {
                output.getFault(0).setCode("00");
                if (oper.getCmdid() == NSCMD_CFG_GET_STMSI) {
                    output.getPart("stmsi_value").setValue("");
                    output.getPart("stmsi_timeslotsamount").setValue("");
                    output.getPart("stmsi_timeslotsnumber").setValue("");
                } else if (oper.getCmdid() == NSCMD_CFG_GET_SRMSI) {
                    output.getPart("srmsi_value").setValue("");
                    output.getPart("srmsi_timeslotsamount").setValue("");
                    output.getPart("srmsi_timeslotsnumber").setValue("");
                } else if (oper.getCmdid() == NSCMD_CFG_GET_RMSI) {
                    output.getPart("rmsi_timeslotsamount").setValue("");
                    output.getPart("rmsi_timeslotsnumber").setValue("");
                }
            }
            if (errCode == 0 || oper.getCmdid() != NSCMD_CFG_GET_RMSI) continue;
            output.getPart("rmsi_timeslotsamount").setValue("/");
            output.getPart("rmsi_timeslotsnumber").setValue("/");
        }
    }

    private void handleMSITimeslotsNumber(Operation oper) {
        int errCode = Integer.valueOf(oper.getOutput(0).getFault(0).getCode());
        if (0 == errCode) {
            String timesNumber;
            String timesAmount;
            if (oper.getCmdid() == NSCMD_CFG_GET_STMSI) {
                timesAmount = "stmsi_timeslotsamount";
                timesNumber = "stmsi_timeslotsnumber";
            } else if (oper.getCmdid() == NSCMD_CFG_GET_SRMSI) {
                timesAmount = "srmsi_timeslotsamount";
                timesNumber = "srmsi_timeslotsnumber";
            } else if (oper.getCmdid() == NSCMD_CFG_GET_RMSI) {
                timesAmount = "rmsi_timeslotsamount";
                timesNumber = "rmsi_timeslotsnumber";
            } else {
                timesAmount = "";
                timesNumber = "";
            }
            Output output = null;
            int m = oper.getOutputCount();
            for (int i = 0; i < m; ++i) {
                output = oper.getOutput(i);
                this.convertOutput(output, timesAmount, timesNumber);
            }
        }
    }

    private void convertOutput(Output output, String timesAmount, String timesNumber) {
        String timeSlotStr = "";
        int timeSlotNum = Integer.valueOf(output.getPartValue(timesAmount));
        Part part = output.getPart(timesNumber);
        if (0 < timeSlotNum) {
            ArrayList<Integer> timeSlotList = new ArrayList<Integer>();
            int timeSlot = -1;
            int nCount = 4;
            byte[] bValue = part.getValue().getBytes();
            int nPos = 0;
            int nParaSize = bValue.length;
            while (nPos + nCount <= nParaSize && nParaSize > 0) {
                timeSlot = IOStreamConvertor.readPositiveInt((byte[])bValue, (int)nPos);
                timeSlotList.add(timeSlot);
                nPos += nCount;
            }
            timeSlotStr = TEStringUtils.parseIntegerList(timeSlotList);
        }
        part.setValue(timeSlotStr);
    }

    private String getParamValue(RowParams rowparam, String name) {
        if (rowparam != null && rowparam.getParam(name) != null && rowparam.getParam(name).getValue() != null) {
            return rowparam.getParam(name).getValue();
        }
        return "";
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errcodeList = new ArrayList<Integer>();
        if (null != this.subfunc) {
            errcodeList.addAll(this.subfunc.getFilterErrCodeList());
        }
        errcodeList.add(39171);
        errcodeList.add(38722);
        errcodeList.add(38777);
        errcodeList.add(38662);
        return errcodeList;
    }
}

