/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.ophbyte.otn;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.db.jni.dbservice.TEGeneralKeyValue;
import com.huawei.nglct.db.jni.dbservice.TEGeneralValue;
import com.huawei.nglct.db.jni.dbservice.TEGnlValueElement;
import com.huawei.nglct.gencfg.TEGenCfgFunAttr;
import com.huawei.nglct.gencfg.TEGenCfgFunCmd;
import com.huawei.nglct.gencfg.frame.TEGnlAttrMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ngwdm.ophbyte.otn.TEOtnInfStaticData;
import com.huawei.nglct.nemgr.ngwdm.ophbyte.otn.objtypeid.TEObjTypeIDCreator;
import com.huawei.nglct.nemgr.ngwdm.ophbyte.otn.specialprocess.TEAttrHandler;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.objtypeid.TEPartSource;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class TEOtnInfUtil {
    public static final int TE_ERR_WNEMGR_GET_FROM_DB_FAIL = 1090615127;
    public static final String DEFAULT_SUB_CARD_ID = "255";
    public static final String DEFAULT_PATH_ID = "1";
    public static final String VALUE_INVALID_STR = "/";
    public static final List<String> attrNamesList = new ArrayList<String>();
    public static final int QUERY_FROM_NE = 1;
    public static final int QUERY_FROM_NM = 0;
    private static String EMPTY_TTI = "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00";

    private TEOtnInfUtil() {
    }

    public static void getOperFromDB(Map<TEGeneralKeyValue, Operation> keyOperMap, int neid) {
        ArrayList<TEGnlValueElement> elementList = new ArrayList<TEGnlValueElement>();
        TEGnlValueElement element = null;
        TEGeneralKeyValue key2 = null;
        Set<TEGeneralKeyValue> keySet = keyOperMap.keySet();
        for (TEGeneralKeyValue key2 : keySet) {
            element = new TEGnlValueElement();
            element.setGnlKeyValue(key2);
            elementList.add(element);
        }
        StringBuffer buffer = new StringBuffer(0);
        buffer.append("find gnl value. req->").append('\n');
        for (TEGnlValueElement ele : elementList) {
            buffer.append(ele.toString()).append('\n');
        }
        TELogFactory.getNormalLogger().info("find gnl value. req->" + buffer.toString());
        TEDaoOperationResult result = TECommonDaoService.findGnlValue(elementList);
        TELogFactory.getNormalLogger().info("find gnl value. rsp->" + result.getResult());
        int retCode = result.getResult();
        List data = result.getData();
        TELogFactory.getNormalLogger().info("find gnl value. data.size->" + data.size());
        TELogFactory.getNormalLogger().info("find gnl value. result->" + result.toString());
        Fault fault = null;
        ArrayList<Operation> neOperList = new ArrayList<Operation>();
        if (!data.isEmpty()) {
            TEGnlValueElement ele2 = null;
            Operation oper = null;
            int errCode = -1;
            int attrID = -1;
            for (TEGnlValueElement ele2 : data) {
                key2 = ele2.getGnlKeyValue();
                oper = keyOperMap.get(key2);
                Output output = oper.getOutput(0);
                TEOtnInfUtil.fillObjIDPartValue(ele2, output);
                boolean isFill = TEOtnInfUtil.fillAttrPartValue(ele2, attrID, output);
                errCode = ele2.getGnlValue().getErrCode();
                fault = oper.getOutput(0).getFault(0);
                fault.setCode(String.valueOf(errCode));
                if (!isFill) {
                    neOperList.add(oper);
                    continue;
                }
                keyOperMap.remove(key2);
            }
            TEOtnInfUtil.handleFailedOper(keyOperMap, 1090615127);
        } else {
            TEOtnInfUtil.handleFailedOper(keyOperMap, retCode);
        }
        if (!neOperList.isEmpty()) {
            OperationResult operResult = TEOtnInfUtil.sendBatCommand(neid, neOperList);
            if (0 != operResult.retCode) {
                TELogFactory.getNormalLogger().debug("send command fail!The errorCode is :" + operResult.retCode);
            } else {
                TELogFactory.getNormalLogger().debug("send command success!");
            }
        }
    }

    protected static OperationResult sendBatCommand(int neID, List<Operation> allOperList) {
        OperationResult result = null;
        ArrayList<Operation> operList = null;
        int m = 200;
        int n = allOperList.size();
        for (int i = 0; i < n; i += m) {
            operList = new ArrayList<Operation>();
            if (i + m > n) {
                operList.addAll(allOperList.subList(i, n));
            } else {
                operList.addAll(allOperList.subList(i, i + m));
            }
            result = TENECommMgr.getInstance().sendCommand(neID, operList, 120);
            if (0 != result.retCode) break;
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                TELogFactory.getNormalLogger().error("TEGenCfgQueryBean thread sleep error! ", (Throwable)e);
            }
        }
        return result;
    }

    public static String getAttrValueFromDB_NoLock(TEGeneralKeyValue key) {
        String attrValue = null;
        ArrayList<TEGnlValueElement> elementList = new ArrayList<TEGnlValueElement>();
        TEGnlValueElement element = new TEGnlValueElement();
        element.setGnlKeyValue(key);
        elementList.add(element);
        StringBuffer buffer = new StringBuffer(0);
        buffer.append("find gnl value. req->").append('\n');
        for (TEGnlValueElement ele : elementList) {
            buffer.append(ele.toString()).append('\n');
        }
        TELogFactory.getNormalLogger().info("find gnl value. req->" + buffer.toString());
        TEDaoOperationResult result = TECommonDaoService.findGnlValue_NoLock(elementList);
        TELogFactory.getNormalLogger().info("find gnl value. rsp->" + result.getResult());
        List data = result.getData();
        TELogFactory.getNormalLogger().info("find gnl value. data.size->" + data.size());
        TELogFactory.getNormalLogger().info("find gnl value. result->" + result.toString());
        if (!data.isEmpty()) {
            TEGnlValueElement ele2 = null;
            for (TEGnlValueElement ele2 : data) {
                int valueType = TEGnlAttrMgr.getInstance().getAttrValueType(key.getAttrID());
                if (0 == valueType) {
                    attrValue = String.valueOf(ele2.getGnlValue().getiValue());
                    continue;
                }
                attrValue = ele2.getGnlValue().getsValue();
            }
        }
        return attrValue;
    }

    private static void handleFailedOper(Map<TEGeneralKeyValue, Operation> keyOperMap, int errorCode) {
        Collection<Operation> operList = keyOperMap.values();
        for (Operation oper : operList) {
            Fault fault = oper.getOutput(0).getFault(0);
            fault.setCode(String.valueOf(errorCode));
        }
    }

    private static String getAttrValue(TEGnlValueElement ele, int attrID) {
        int valueType = TEGnlAttrMgr.getInstance().getAttrValueType(attrID);
        String attrValue = null;
        int iValue = -1;
        String sValue = null;
        if (0 == valueType) {
            iValue = ele.getGnlValue().getiValue();
            attrValue = String.valueOf(iValue);
        } else {
            attrValue = sValue = ele.getGnlValue().getsValue();
        }
        return attrValue;
    }

    private static boolean fillAttrPartValue(TEGnlValueElement ele, int attrID, Output output) {
        attrID = ele.getGnlKeyValue().getAttrID();
        String attrValue = TEOtnInfUtil.getAttrValue(ele, attrID);
        if (attrValue == null || attrValue.isEmpty() || VALUE_INVALID_STR.equals(attrValue) || EMPTY_TTI.equals(attrValue)) {
            return false;
        }
        if (attrID == 272406) {
            attrValue = attrValue.replace(" ", "");
            Part part = output.getPart("ST_SRC_FLAG");
            if (attrValue.length() >= 124) {
                TEAttrHandler.getInstance().setAttrPartValue(ele, attrValue.substring(0, 30), "ST_SRC_FLAG", output, part);
                part = output.getPart("ST_SINK_FLAG");
                TEAttrHandler.getInstance().setAttrPartValue(ele, attrValue.substring(30, 60), "ST_SINK_FLAG", output, part);
                part = output.getPart("ST_USER_FLAG");
                TEAttrHandler.getInstance().setAttrPartValue(ele, attrValue.substring(60, 124), "ST_USER_FLAG", output, part);
            }
        } else if (attrID == 272408) {
            if ((attrValue = attrValue.replace(" ", "")).length() >= 124) {
                Part part = output.getPart("R_SRC_FLAG");
                TEAttrHandler.getInstance().setAttrPartValue(ele, attrValue.substring(0, 30), "R_SRC_FLAG", output, part);
                part = output.getPart("R_SINK_FLAG");
                TEAttrHandler.getInstance().setAttrPartValue(ele, attrValue.substring(30, 60), "R_SINK_FLAG", output, part);
                part = output.getPart("R_USER_FLAG");
                TEAttrHandler.getInstance().setAttrPartValue(ele, attrValue.substring(60, 124), "R_USER_FLAG", output, part);
            }
        } else {
            Set attrNameSet = (Set)TEOtnInfStaticData.getAttrIDNameMap().get(attrID);
            if (null != attrNameSet) {
                String attrName2 = null;
                Part part = null;
                for (String attrName2 : attrNameSet) {
                    part = output.getPart(attrName2);
                    if (null == part) continue;
                    TEAttrHandler.getInstance().setAttrPartValue(ele, attrValue, attrName2, output, part);
                }
            }
        }
        return true;
    }

    private static void fillObjIDPartValue(TEGnlValueElement ele, Output output) {
        int[] objID = ele.getGnlKeyValue().getTEOBJECTID();
        Part part = output.getPart("neid");
        if (null != part && objID.length >= 2) {
            part.setValue(String.valueOf(objID[1]));
        }
        if (null != (part = output.getPart("subCardId"))) {
            part.setValue(DEFAULT_SUB_CARD_ID);
        }
        if (null != (part = output.getPart("slotid")) && objID.length >= 3) {
            int slotID = objID[2];
            part.setValue(String.valueOf(slotID));
        }
        if (null != (part = output.getPart("port")) && objID.length >= 4) {
            int portID = objID[3];
            portID = TEConfigurationDataMgr.getPortRelativeID((int)portID);
            part.setValue(String.valueOf(portID));
        }
        if (null != (part = output.getPart("path"))) {
            if (objID.length >= 4) {
                part.setValue(String.valueOf(objID[4]));
            } else {
                part.setValue(DEFAULT_PATH_ID);
            }
        }
        if (null != (part = output.getPart("grade"))) {
            if (objID.length >= 5) {
                part.setValue(String.valueOf(objID[5]));
            } else {
                part.setValue(DEFAULT_PATH_ID);
            }
        }
        if (null != (part = output.getPart("level"))) {
            if (objID.length >= 6) {
                part.setValue(String.valueOf(objID[6] + 1));
            } else {
                part.setValue(DEFAULT_PATH_ID);
            }
        }
    }

    public static Map<TEGeneralKeyValue, Operation> getKeyOperMap(int neid, TEGenCfgFunCmd funCmd, String attrName, Operation oper) {
        HashMap<TEGeneralKeyValue, Operation> keyOperMap = new HashMap<TEGeneralKeyValue, Operation>();
        String objTypeStr = TEOtnInfUtil.getObjTypeByAttr(funCmd, attrName);
        TEGeneralKeyValue key = TEOtnInfUtil.constructGnlKey(neid, attrName, objTypeStr, new TEPartSource(oper.getInput()));
        keyOperMap.put(key, oper);
        return keyOperMap;
    }

    public static String getObjTypeByAttr(TEGenCfgFunCmd funCmd, String attrName) {
        String objTypeStr = TEOtnInfStaticData.getAttrNameObjTypeNameMap().get(attrName);
        if (null == objTypeStr) {
            TEGenCfgFunAttr funAttr = funCmd.getGenCfgFunAttr(attrName, "query");
            objTypeStr = funAttr.getObjectType();
        }
        return objTypeStr;
    }

    public static int getAttrID(String attrName) {
        Integer attrID = TEOtnInfStaticData.getAttrNameIDMap().get(attrName);
        if (null != attrID) {
            return attrID;
        }
        TELogFactory.getNormalLogger().error("get objtype error->" + attrName);
        return -1;
    }

    public static boolean isOutputContainNMQueryAttr(Operation oper) {
        Output output = null;
        int len = oper.getOutputCount();
        for (int i = 0; i < len; ++i) {
            output = oper.getOutput(i);
            if (output.getPart("ST_SRC_FLAG") == null && output.getPart("R_SRC_FLAG") == null) continue;
            return true;
        }
        return false;
    }

    protected static boolean isInputContainNMQueryAttr(Operation oper) {
        Input input = oper.getInput();
        return input.getPart("ST_SRC_FLAG") != null || input.getPart("R_SRC_FLAG") != null;
    }

    public static int saveAttrInfoToDB(Map<TEGnlValueElement, Operation> keyOperMap) {
        Set<TEGnlValueElement> elementSet = keyOperMap.keySet();
        ArrayList<TEGnlValueElement> elementList = new ArrayList<TEGnlValueElement>(elementSet);
        TEDaoOperationResult result = TEOtnInfUtil.saveAttrInfoToDB(elementList);
        int retCode = result.getResult();
        if (0 != retCode) {
            Operation oper2 = null;
            Fault fault = null;
            Collection<Operation> operList = keyOperMap.values();
            for (Operation oper2 : operList) {
                fault = new Fault();
                fault.setCode(String.valueOf(retCode));
                oper2.getOutput(0).addFault(fault);
            }
        }
        return retCode;
    }

    public static TEDaoOperationResult saveAttrInfoToDB(List<TEGnlValueElement> elementList) {
        TEDaoOperationResult result = null;
        if (null != elementList && 0 != elementList.size()) {
            StringBuffer buffer = new StringBuffer(50);
            buffer.append("save attr to database.\n");
            for (TEGnlValueElement element : elementList) {
                buffer.append(element.toString()).append('\n');
            }
            TELogFactory.getNormalLogger().info(buffer.toString());
            result = TECommonDaoService.saveGnlValueToDB(elementList);
        } else {
            result = new TEDaoOperationResult();
            result.setResult(0);
        }
        TELogFactory.getNormalLogger().info("save gnl value. result->" + result.getResult());
        return result;
    }

    public static TEGnlValueElement constructElement(int neid, TEGenCfgFunCmd funCmd, TEPartSource partSource, String attrName, String valueStr) {
        TEGnlValueElement element = new TEGnlValueElement();
        String objTypeStr = TEOtnInfUtil.getObjTypeByAttr(funCmd, attrName);
        TEGeneralKeyValue key = TEOtnInfUtil.constructGnlKey(neid, attrName, objTypeStr, partSource);
        element.setGnlKeyValue(key);
        TEGeneralValue value = TEOtnInfUtil.constructGnlValue(partSource, attrName);
        element.setGnlValue(value);
        return element;
    }

    public static TEGeneralKeyValue constructGnlKey(int neid, String attrName, String objTypeStr, TEPartSource partSource) {
        TEGeneralKeyValue key = new TEGeneralKeyValue();
        key.setAttrID(TEOtnInfUtil.getAttrID(attrName));
        int objTpID = TEObjTypeIDCreator.getInstance().getObjTypeID(neid, attrName, objTypeStr, partSource);
        int[] objTypeID = TEObjTypeIDCreator.getInstance().createObjectID(neid, objTpID, partSource);
        key.setTEOBJECTID(objTypeID);
        return key;
    }

    private static TEGeneralValue constructGnlValue(TEPartSource partSource, String attrName) {
        TEGeneralValue value = new TEGeneralValue();
        TEAttrHandler.getInstance().setElementValue(partSource, attrName, value);
        return value;
    }

    public static String addSpace(String value) {
        String svalue = value.replaceAll(VALUE_INVALID_STR, "2F").replaceAll("-", "2D");
        StringBuilder temp = new StringBuilder();
        int len = svalue.length();
        for (int i = 0; i < len; ++i) {
            temp.append(svalue.substring(i, i + 2));
            if (i < len - 1) {
                temp.append(" ");
            }
            ++i;
        }
        return temp.toString();
    }

    public static String addZero(String name, String value) {
        StringBuilder sb;
        block5: {
            block6: {
                block4: {
                    if (value == null) {
                        return "";
                    }
                    sb = new StringBuilder(value);
                    if (!"ST_SRC_FLAG".equals(name) && !"R_SRC_FLAG".equals(name)) break block4;
                    while (sb.length() < 30) {
                        sb.append("00");
                    }
                    break block5;
                }
                if (!"ST_SINK_FLAG".equals(name) && !"R_SINK_FLAG".equals(name)) break block6;
                while (sb.length() < 30) {
                    sb.append("00");
                }
                break block5;
            }
            if (!"ST_USER_FLAG".equals(name) && !"R_USER_FLAG".equals(name)) break block5;
            while (sb.length() < 64) {
                sb.append("00");
            }
        }
        return sb.toString();
    }

    public static String removeZero(String name, String value) {
        return value;
    }

    static {
        attrNamesList.add("OTN_SM_ST_TTI");
        attrNamesList.add("OTN_SM_R_TTI");
    }
}

