/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.ophbyte.otn;

import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.db.jni.dbservice.TEGnlValueElement;
import com.huawei.nglct.gencfg.TEGenCfgCmdFactory;
import com.huawei.nglct.gencfg.TEGenCfgDataConvertor;
import com.huawei.nglct.gencfg.TEGenCfgFunCmd;
import com.huawei.nglct.gencfg.TEGenCfgSetBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.ngwdm.ophbyte.otn.TEOtnInfUtil;
import com.huawei.nglct.nemgr.ngwdm.wdminterface.objtypeid.TEPartSource;
import com.huawei.nglct.ngwdm_pub.TEOTNModelDataMgr;
import com.huawei.nglct.ngwdm_pub.TEOTNModelShowPathMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TEOTNSetBean
extends TEGenCfgSetBean {
    private static final String[][] ODUGRADE = new String[][]{{"ODU1"}, {"ODU2"}, {"ODU3"}, {"ODU5g"}, {"ODU0"}, {"ODU4"}, {"ODUFLEX"}};
    private static final String[][] OTUGRADE = new String[][]{{"OTU1"}, {"OTU2"}, {"OTU3"}, {"OTU5g"}, {"OTU0"}, {"OTU4"}};
    private static final String[][] TCMLEVEL = new String[][]{{"TCM1"}, {"TCM2"}, {"TCM3"}, {"TCM4"}, {"TCM5"}, {"TCM6"}};
    private static final int PMLEVEL = 1;
    private static final int SMLEVEL = 8;
    private static final int OTSLEVEL = 9;
    private static final int GRADE_NULL = 255;

    public TEOTNSetBean() {
        this.TIME_OUT = 120;
    }

    public ArrayList getSetOperationList(TEGenCfgFunCmd funCmd, Datainterface inputData) {
        this.handleOtnModelPath(inputData);
        ArrayList operationList = super.getSetOperationList(funCmd, inputData);
        TENE ne = TENEListMgr.getInstance().getNE(this.neid);
        if (null != ne && (112 == ne.getNEType() || 111 == ne.getNEType() || 117 == ne.getNEType() || 118 == ne.getNEType() || TESpecialAttrMgr.getInstance().isNENotSupport(this.neid, "TE_FUNC_CFG_OTN_OVERHEAD", "NE_ATTR_NOSUPPORT_VERIFY"))) {
            for (int i = operationList.size() - 1; i >= 0; --i) {
                Operation oper = (Operation)operationList.get(i);
                if (!"NSCMD_CFG_VERIFY".equals(oper.getName())) continue;
                operationList.remove(i);
            }
        }
        return operationList;
    }

    private void handleOtnModelPath(Datainterface inputData) {
        int len = inputData.getBussinessParams().getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            int layer;
            int nePath;
            RowParams rowparams = inputData.getBussinessParams().getRowParams(i);
            int slotId = Integer.parseInt(rowparams.getParam("slotid").getValue());
            int boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slotId);
            TEOTNModelDataMgr otnModelInstance = TEOTNModelDataMgr.getInstance();
            int grade = otnModelInstance.getGradeFromBoard(boardType);
            int nmPath = 1;
            if (rowparams.getParam("path") != null && rowparams.getParam("path").getValue() != null) {
                nmPath = Integer.parseInt(rowparams.getParam("path").getValue());
            }
            if (rowparams.getParam("grade") != null && rowparams.getParam("grade").getValue() != null && !rowparams.getParam("grade").getValue().equals("")) {
                grade = Integer.parseInt(rowparams.getParam("grade").getValue());
                if (grade > 1200) {
                    grade -= 1200;
                }
                rowparams.getParam("grade").setValue(String.valueOf(grade));
            }
            if ((nePath = otnModelInstance.getNePath(layer = this.getOtnLayer(), grade, nmPath, boardType)) == -1) continue;
            rowparams.getParam("path").setValue(String.valueOf(nePath));
        }
    }

    private int getOtnLayer() {
        int layer = -1;
        switch (this.subFunc.getCode()) {
            case 2105848: {
                layer = 1;
                break;
            }
            case 2105854: {
                layer = 1;
                break;
            }
            case 2105852: 
            case 2180061: {
                layer = 8;
                break;
            }
            case 2106555: {
                layer = 1;
                break;
            }
            case 2105850: {
                layer = 1;
                break;
            }
        }
        return layer;
    }

    public String getOperObjStr(TENE neObj, Datainterface inputData) {
        StringBuffer operObj = new StringBuffer();
        if (null == neObj) {
            operObj.append(String.valueOf(this.neid));
        } else {
            operObj.append(neObj.getNEName());
        }
        int slotid = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
        int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slotid);
        int portID = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("port").getValue());
        Param param = inputData.getBussinessParams().getRowParams(0).getParam("path");
        int path = 255;
        if (null != param) {
            path = Integer.parseInt(param.getValue());
        }
        operObj.append("-");
        String subrackName = TEBoardUtil.getSubrackNameFromSlot((int)this.neid, (int)slotid);
        if (!"".equals(subrackName)) {
            operObj.append(subrackName).append("-");
        }
        operObj.append(TEBoardUtil.getSlotIDFromSlot((int)this.neid, (int)slotid)).append("-").append(TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, boardtype));
        operObj.append("-").append(TEConfigurationDataMgr.getInstance().getPortName(this.neid, slotid, boardtype, portID));
        param = inputData.getBussinessParams().getRowParams(0).getParam("grade");
        int grade = 255;
        if (null != param && (grade = Integer.parseInt(param.getValue())) > 1200) {
            grade -= 1200;
        }
        int level = -1;
        level = null != inputData.getBussinessParams().getRowParams(0).getParam("level") ? Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("level").getValue()) : this.getOtnLayer();
        int nmPath = -1;
        nmPath = path > 1200 ? path : TEOTNModelDataMgr.getInstance().getNmPath(level, grade, path, boardtype);
        if (nmPath > 1200 && TEOTNModelDataMgr.getInstance().isSupportSimpleModePort(boardtype, portID)) {
            operObj.append("-").append(TEOTNModelShowPathMgr.getInstance().getOTNModelShowPath(nmPath));
        } else {
            if (255 != grade) {
                if (level == 1) {
                    operObj.append("-").append(ODUGRADE[grade - 1][0]);
                } else if (level == 8) {
                    operObj.append("-").append(OTUGRADE[grade - 1][0]);
                }
            }
            if (255 != path) {
                operObj.append("-").append(path);
            }
        }
        if (level != -1 && level != 1 && level != 8 && level != 9 && level - 2 > 0) {
            operObj.append("-").append(TCMLEVEL[level - 2][0]);
        }
        return operObj.toString();
    }

    public String specialHandle(String attrId, String attrValue, Datainterface inputData, String actvalue, TEResourceUtil res) {
        int value = Integer.parseInt(actvalue);
        if (value > 17 && value < 128 && value != 32 && value != 33 || value > 143 && value < 253) {
            return actvalue + "-" + res.getString(attrId + "_" + "18");
        }
        if (value > 127 && value < 144) {
            return actvalue + "-" + res.getString(attrId + "_" + "128");
        }
        return actvalue + "-" + attrValue;
    }

    public boolean isNeedHandle(String attrId, String attrValue) {
        return attrId.equals("SR_OTN_OTN_PT") || attrId.equals("ST_OTN_OTN_PT");
    }

    public void handleMessage(int neid, SubFunc subfunc, ArrayList operationList, ArrayList filterErrorCodeList) {
        if (TESysManagerBean.getInstance().isIntegratedStatus()) {
            this.doAfterSendCmd(operationList);
        }
        this.hanldeOtnModelPath(operationList);
        this.outputData = TEGenCfgDataConvertor.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
    }

    private void hanldeOtnModelPath(List<Operation> operationList) {
        Operation operation = null;
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            operation = operationList.get(i);
            if (operation.getInput().getPart("level") == null || Integer.parseInt(operation.getInput().getPartValue("level")) != 8) continue;
            int slotid = Integer.parseInt(operation.getInput().getPartValue("slotid"));
            int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slotid);
            int grade = Integer.parseInt(operation.getInput().getPartValue("grade"));
            int path = Integer.parseInt(operation.getInput().getPartValue("path"));
            int nmPath = TEOTNModelDataMgr.getInstance().getNmPath(8, grade, path, boardtype);
            operation.getInput().getPart("path").setValue(String.valueOf(nmPath));
        }
    }

    protected void doAfterSendCmd(List<Operation> operationList) {
        int boardType;
        Input input = operationList.get(0).getInput();
        int slotID = Integer.parseInt(input.getPartValue("slotid"));
        List<Operation> nmOperList = this.filterSetSaveDBOper(operationList, slotID, boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slotID));
        if (!nmOperList.isEmpty()) {
            String fileName = this.subFunc.getGenCfgAttrDesPath().getContent();
            StringBuffer funCmdFilePath = new StringBuffer("nemgr").append(File.separator).append(fileName);
            String path = TEResourceManager.getPath() + funCmdFilePath.toString();
            TEGenCfgFunCmd funCmd = TEGenCfgCmdFactory.getInstance().getFunCmd(path);
            TEOTNSetBean.saveAttrInfoToDBOnSet(this.neid, funCmd, nmOperList);
        }
    }

    private List<Operation> filterSetSaveDBOper(List operationList, int slotId, int boardType) {
        ArrayList<Operation> nmOperList = new ArrayList<Operation>();
        Operation oper = null;
        for (int i = operationList.size() - 1; i >= 0; --i) {
            oper = (Operation)operationList.get(i);
            if (!TEOtnInfUtil.isInputContainNMQueryAttr(oper)) continue;
            nmOperList.add(oper);
        }
        return nmOperList;
    }

    public static void saveAttrInfoToDBOnSet(int neid, TEGenCfgFunCmd funCmd, List<Operation> nmOperList) {
        Input input = null;
        String valueStr = null;
        HashMap<TEGnlValueElement, Operation> elementOperMap = new HashMap<TEGnlValueElement, Operation>();
        TEGnlValueElement element = null;
        Fault fault = null;
        int errorCode = -1;
        for (Operation oper : nmOperList) {
            input = oper.getInput();
            fault = oper.getOutput(0).getFault(0);
            if (null != fault && 0 != (errorCode = Integer.parseInt(fault.getCode())) || !"NSCMD_CFG_SET_ST_OTNTTI".equals(oper.getName())) continue;
            String srcflag = TEOtnInfUtil.addZero("ST_SRC_FLAG", input.getPartValue("ST_SRC_FLAG"));
            input.setPartValue("ST_SRC_FLAG", srcflag);
            String snkflag = TEOtnInfUtil.addZero("ST_SINK_FLAG", input.getPartValue("ST_SINK_FLAG"));
            input.setPartValue("ST_SINK_FLAG", snkflag);
            String userflag = TEOtnInfUtil.addZero("ST_USER_FLAG", input.getPartValue("ST_USER_FLAG"));
            input.setPartValue("ST_USER_FLAG", userflag);
            valueStr = srcflag + snkflag + userflag;
            element = TEOtnInfUtil.constructElement(neid, funCmd, new TEPartSource(input), "OTN_SM_ST_TTI", valueStr);
            elementOperMap.put(element, oper);
        }
        TEOtnInfUtil.saveAttrInfoToDB(elementOperMap);
    }
}

