/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.ophbyte.otn;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.TEGenCfgCmdFactory;
import com.huawei.nglct.gencfg.TEGenCfgDataConvertor;
import com.huawei.nglct.gencfg.TEGenCfgFunCmd;
import com.huawei.nglct.gencfg.TEGenCfgQueryBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgAttribute;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nemgr.necommon.fault.TEAlarmAdapterCache;
import com.huawei.nglct.ngwdm_pub.TEOTNModelDataMgr;
import com.huawei.nglct.ngwdm_pub.TESimpleModelUtil;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.io.TEFileUtil;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.EscapeUnescape;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class TEAbstractOTNQueryBean
extends TEGenCfgQueryBean {
    protected boolean isUploadFlag = false;
    private static final int CMD_NOSUPPORT = 38737;
    private static final String PORT_INVALIDE = "38671";
    private static final String PORT_IS_NOT_EXIST = "41761";
    private static final String NOTSUPPORTBOARD = "38664";
    private static final String PATH_INVALIDE = "38777";
    private static final String GRADE_INCOREECT = "41534";
    private static final int TCM_1 = 2;
    private static final int TCM_6 = 7;
    private static final String BOARDNOTSUPPORT = "38751";
    private static final String BOARDNOTPERMIT = "38759";
    private static final String SERVICE_ATTRI_LIMIT = "41102";
    private static final String ERR_CROSS_PORT = "39170";
    private static final String PATH_INVALIDE_EX = "39171";
    private static final String BIP8_MODE_INVALIDE = "41795";
    private static final String BIP8_MODE_ERR = "41643";
    private static final String PARAMINVALID = "38752";
    private static final String CROSS_LAYER_NUMBER_ERR = "39198";
    private static final String TIMMODE_ERR = "41536";
    private static final HashMap<Integer, Integer> gradeSortMap = new HashMap();

    protected abstract void doBeforeQuery(TEGenCfgFunCmd var1, int var2);

    protected abstract void doAfterQuery(TEGenCfgFunCmd var1, int var2);

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        TEGenCfgFunCmd funCmd;
        this.neid = neid;
        this.subFunc = subFunc;
        this.inputData = inputData;
        this.operationList = new ArrayList();
        RowParams[] rowparams = inputData.getBussinessParams().getRowParams();
        String fileName = subFunc.getGenCfgAttrDesPath().getContent();
        StringBuffer funCmdFilePath = new StringBuffer("nemgr").append(File.separator).append(fileName);
        String path = TEResourceManager.getPath() + funCmdFilePath.toString();
        String queryflag = String.valueOf(1);
        Param queryflagParam = inputData.getBussinessParams().getRowParams(0).getParam("queryflag");
        if (queryflagParam != null) {
            queryflag = queryflagParam.getValue();
        }
        if (null == (funCmd = TEGenCfgCmdFactory.getInstance().getFunCmd(path))) {
            log.info("Parse atrribute To qx mapping file fail!");
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
            return this.outputData;
        }
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        this.outputData = new Datainterface();
        if (null == neObj) {
            log.info("Get ne object fail!");
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090596385));
            return this.outputData;
        }
        String parentPath = TEFileUtil.getParentPath((String)TEFileUtil.getParentPath((String)TEFileUtil.getParentPath((String)fileName)));
        StringBuffer filePath = new StringBuffer("nemgr").append(File.separator).append(parentPath).append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("gencfg").append(File.separator).append("attribres_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        this.res = TEResourceUtil.getInstance((String)filePath.toString());
        int boardType = 0;
        int iLength = rowparams.length;
        for (int i = 0; i < iLength; ++i) {
            Param slotIDParam = rowparams[i].getParam("slotid");
            if (slotIDParam == null) continue;
            this.slotId = Integer.parseInt(slotIDParam.getValue());
            boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, this.slotId);
            Datainterface newInputData = new Datainterface();
            newInputData.setBussinessParams(new BussinessParams());
            newInputData.getBussinessParams().addRowParams(rowparams[i]);
            this.operationList.addAll(this.getQueryOperationList(funCmd, newInputData));
            if (subFunc.getCode() == 2180060) continue;
            this.filterOperationList(this.operationList, this.slotId, boardType);
            if (!this.operationList.isEmpty() || i != iLength - 1) continue;
            log.info("Filter result:The operationlist is null!");
            return this.outputData;
        }
        this.doBeforeQuery(funCmd, boardType);
        if (String.valueOf(1).equals(queryflag)) {
            if (!this.operationList.isEmpty()) {
                OperationResult result = this.sendBatCommand(this.neid, this.operationList);
                if (0 != result.retCode) {
                    log.debug("send command fail!The errorCode is :" + result.retCode);
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result.retCode));
                    return this.outputData;
                }
                log.debug("send command success!");
            } else {
                log.info("The operationlist is null!");
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090596479));
            }
        }
        this.doAfterQuery(funCmd, boardType);
        ArrayList filterErrorCodeList = this.getFilterErrorCodeList();
        if (String.valueOf(0).equals(queryflag)) {
            filterErrorCodeList.add(38669);
            filterErrorCodeList.add(38720);
            filterErrorCodeList.add(38666);
            filterErrorCodeList.add(39188);
        }
        this.handleMessage(neid, subFunc, this.operationList, filterErrorCodeList);
        if (this.isNeedOperationlog() && null != user) {
            this.writeLog(neid, subFunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    protected OperationResult sendBatCommand(int neID, List<Operation> allOperList) {
        OperationResult result = null;
        ArrayList<Operation> operList = null;
        int m = 200;
        int n = allOperList.size();
        for (int i = 0; i < n; i += m) {
            operList = new ArrayList<Operation>();
            if (i + m > n) {
                operList.addAll(allOperList.subList(i, n));
            } else {
                operList.addAll(allOperList.subList(i, i + m));
            }
            result = TENECommMgr.getInstance().sendCommand(neID, operList, this.getTimeOut());
            if (0 != result.retCode) break;
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                log.error("TEGenCfgQueryBean thread sleep error! ", (Throwable)e);
            }
        }
        return result;
    }

    public Datainterface expandOperObj(String srcObjType, String sinkObjType, String attrId, Datainterface inputData) {
        switch (this.subFunc.getCode()) {
            case 2105847: {
                sinkObjType = "ID_OBJECT_TYPE_NE_BOARD_PORT_ODU_TCM";
                break;
            }
            case 2105853: {
                sinkObjType = "ID_OBJECT_TYPE_NE_BOARD_PORT_ODU_PM";
                break;
            }
            case 2105851: 
            case 2180060: {
                sinkObjType = "ID_OBJECT_TYPE_NE_BOARD_PORT_ODU_SM";
                break;
            }
            case 2107500: {
                sinkObjType = "ID_OBJECT_TYPE_NE_BOARD_PORT_ODU_OTS";
                break;
            }
        }
        return super.expandOperObj(srcObjType, sinkObjType, attrId, inputData);
    }

    public void handleMessage(int neid, SubFunc subfunc, ArrayList operationList, ArrayList filterErrorCodeList) {
        if (2105847 == this.subFunc.getCode()) {
            this.handleQueryTCMStatusOper(operationList);
        } else if (2106554 == this.subFunc.getCode()) {
            this.handleQueryFTFLResult(operationList);
        }
        this.hanldeOtnModelPath(operationList);
        this.outputData = TEGenCfgDataConvertor.convertToDatainterface((int)neid, (int)this.slotId, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        this.sortByPortOtn(this.outputData);
        RowParams[] rows = this.outputData.getBussinessParams().getRowParams();
        RowParams row = null;
        String value = "";
        String[] params = "FTFL_PROPRIETOR_CUSTOM_INFO,FTFL_FORWARD_FAULT_TYPE,FTFL_FORWARD_FAULT_INTERNATIONALID,FTFL_FORWARD_FAULT_INTERNALID,FTFL_FORWARD_FAULT_CUSTOMID,FTFL_BACK_FAULT_TYPE,FLFT_BACK_FAULT_INTERNATIONALID,FLFT_BACK_FAULT_INTERNAL,FTFL_BACK_FAULT_CUSTOMID".split(",");
        String[] keys = "ST_SRC_FLAG,ST_SINK_FLAG,ST_USER_FLAG,SR_SRC_FLAG,SR_SINK_FLAG,SR_USER_FLAG,R_SRC_FLAG,R_SINK_FLAG,R_USER_FLAG".split(",");
        for (int i = rows.length - 1; i >= 0; --i) {
            int j;
            row = rows[i];
            if (row.getRowErrorsCount() > 0) continue;
            if (null != row.getParam("OTN_SM_BIP8_MODE")) {
                this.handleBIP8Mode(row, "OTN_SM_BIP8_MODE");
            } else if (null != row.getParam("OTN_PM_BIP8_MODE")) {
                this.handleBIP8Mode(row, "OTN_PM_BIP8_MODE");
            } else if (null != row.getParam("OTN_TCM_BIP8_MODE")) {
                this.handleBIP8Mode(row, "OTN_TCM_BIP8_MODE");
            }
            if (2106554 == subfunc.getCode()) {
                for (j = 0; j < params.length; ++j) {
                    if (null == row.getParam(params[j])) continue;
                    value = row.getParam(params[j]).getValue();
                    value = EscapeUnescape.escape((String)IOStreamConvertor.replaceSpecialStr((String)value));
                    row.getParam(params[j]).setValue(value);
                }
            }
            for (j = 0; j < keys.length; ++j) {
                Param tempParam = row.getParam(keys[j]);
                if (null == tempParam) continue;
                value = tempParam.getValue();
                tempParam.setValue(this.delInvalidSeq(value));
            }
            if (null == row.getParam("path")) continue;
            this.handleGrade(row);
        }
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        if (neObj != null && neObj.getPhyBoard(this.slotId) == null) {
            BussinessParams bus = this.outputData.getBussinessParams();
            int iLen = bus.getRowParamsCount();
            for (int i = 0; i < iLen; ++i) {
                row = bus.getRowParams(i);
                if (null == row.getParam("R_SRC_FLAG") || !"".equals(row.getParam("R_SRC_FLAG").getValue())) continue;
                row.getParam("R_SRC_FLAG").setValue("/");
            }
        }
        this.sortByPort(this.outputData);
    }

    private void sortByPort(Datainterface outputData) {
        int size = outputData.getBussinessParams().getRowParamsCount();
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, this.slotId);
        RowParams params1 = null;
        RowParams params2 = null;
        for (int out = size - 1; out > 0; --out) {
            for (int in = 0; in < out; ++in) {
                int grade2;
                int path2;
                int path1;
                int port2;
                params1 = outputData.getBussinessParams().getRowParams(in);
                params2 = outputData.getBussinessParams().getRowParams(in + 1);
                if (null == params1.getParam("port") || null == params2.getParam("port")) continue;
                int port1 = Integer.parseInt(params1.getParam("port").getValue());
                if (port1 > (port2 = Integer.parseInt(params2.getParam("port").getValue()))) {
                    this.swap(outputData, params1, params2, in, in + 1);
                    continue;
                }
                if (port1 != port2) continue;
                if (TEOTNModelDataMgr.getInstance().isSimpleModelBoard(boardType)) {
                    if (null == params1.getParam("path") || null == params2.getParam("path")) continue;
                    path1 = Integer.parseInt(params1.getParam("path").getValue());
                    path2 = Integer.parseInt(params2.getParam("path").getValue());
                    path1 = path1 == 65537 ? 1 : path1;
                    int n = path2 = path2 == 65537 ? 1 : path2;
                    if (path1 <= path2) continue;
                    this.swap(outputData, params1, params2, in, in + 1);
                    continue;
                }
                if (null == params1.getParam("grade") || null == params2.getParam("grade")) continue;
                int grade1 = this.getSortGrade(Integer.parseInt(params1.getParam("grade").getValue()));
                if (grade1 > (grade2 = this.getSortGrade(Integer.parseInt(params2.getParam("grade").getValue())))) {
                    this.swap(outputData, params1, params2, in, in + 1);
                    continue;
                }
                if (grade1 != grade2 || null == params1.getParam("path") || null == params2.getParam("path")) continue;
                path1 = Integer.parseInt(params1.getParam("path").getValue());
                path2 = Integer.parseInt(params2.getParam("path").getValue());
                path1 = path1 == 65537 ? 1 : path1;
                int n = path2 = path2 == 65537 ? 1 : path2;
                if (path1 <= path2) continue;
                this.swap(outputData, params1, params2, in, in + 1);
            }
        }
    }

    private int getSortGrade(int parseInt) {
        Integer value = gradeSortMap.get(parseInt);
        if (value != null) {
            return value;
        }
        return parseInt;
    }

    private void swap(Datainterface outputData, RowParams params1, RowParams params2, int one, int two) {
        outputData.getBussinessParams().setRowParams(one, params2);
        outputData.getBussinessParams().setRowParams(two, params1);
    }

    private void hanldeOtnModelPath(ArrayList operationList) {
        HashMap<Integer, Integer> bdTypeCacheMap = new HashMap<Integer, Integer>();
        Operation aOperation = null;
        TEOTNModelDataMgr otnModelInstance = TEOTNModelDataMgr.getInstance();
        for (int index = operationList.size() - 1; index >= 0; --index) {
            int boardType;
            aOperation = (Operation)operationList.get(index);
            Part slotidPart = aOperation.getInput().getPart("slotid");
            Integer tmpBoardType = (Integer)bdTypeCacheMap.get(Integer.valueOf(slotidPart.getValue()));
            if (null == tmpBoardType) {
                boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, Integer.valueOf(slotidPart.getValue()).intValue());
                bdTypeCacheMap.put(Integer.valueOf(slotidPart.getValue()), boardType);
            } else {
                boardType = tmpBoardType;
            }
            int grade = otnModelInstance.getGradeFromBoard(boardType);
            Part portPart = aOperation.getInput().getPart("port");
            if (portPart == null || !otnModelInstance.isSupportSimpleModePort(boardType, Integer.parseInt(portPart.getValue())) || Integer.parseInt(portPart.getValue()) > 51) continue;
            Output[] outputArr = aOperation.getOutput();
            Part inputPathPart = aOperation.getInput().getPart("path");
            for (int i = 0; i < outputArr.length; ++i) {
                int nmPath;
                int nePath;
                if (outputArr[i].getPart("port").getValue() != null) {
                    portPart = outputArr[i].getPart("port");
                }
                int tempGrade = grade;
                Part gradePart = outputArr[i].getPart("grade");
                if (gradePart != null && gradePart.getValue() != null && gradePart.getValue() != "") {
                    tempGrade = Integer.parseInt(gradePart.getValue());
                } else {
                    Part inputGradePart = aOperation.getInput().getPart("grade");
                    if (inputGradePart != null && inputGradePart.getValue() != null && inputGradePart.getValue() != "") {
                        tempGrade = Integer.parseInt(inputGradePart.getValue());
                    }
                }
                int layer = this.getOtnLayer();
                Part pathPart = outputArr[i].getPart("path");
                if (pathPart != null && pathPart.getValue() != null && layer != -1) {
                    nePath = Integer.parseInt(pathPart.getValue());
                    nmPath = TESimpleModelUtil.getSimplePath((int)boardType, (int)Integer.parseInt(portPart.getValue()), (int)nePath, (int)layer, (int)tempGrade);
                    pathPart.setValue(String.valueOf(nmPath));
                    if (inputPathPart == null) continue;
                    inputPathPart.setValue(String.valueOf(nmPath));
                    continue;
                }
                if (inputPathPart == null || layer == -1) continue;
                nePath = Integer.parseInt(inputPathPart.getValue());
                nmPath = TESimpleModelUtil.getSimplePath((int)boardType, (int)Integer.parseInt(portPart.getValue()), (int)nePath, (int)layer, (int)tempGrade);
                inputPathPart.setValue(String.valueOf(nmPath));
            }
        }
    }

    private int getOtnLayer() {
        int layer = -1;
        switch (this.subFunc.getCode()) {
            case 2105847: {
                layer = 1;
                break;
            }
            case 2105853: {
                layer = 1;
                break;
            }
            case 2105851: 
            case 2180060: 
            case 2180062: {
                layer = 8;
                break;
            }
            case 2106554: {
                layer = 1;
                break;
            }
            case 2105849: {
                layer = 1;
                break;
            }
        }
        return layer;
    }

    private void handleGrade(RowParams row) {
        int path = Integer.parseInt(row.getParam("path").getValue());
        if (path > 1200 && row.getParam("grade") != null) {
            int value = 1200 + Integer.parseInt(row.getParam("grade").getValue());
            row.getParam("grade").setValue(String.valueOf(value));
        }
    }

    private void handleBIP8Mode(RowParams rowParams, String attrId) {
        int slotid = Integer.valueOf(rowParams.getParam("slotid").getValue());
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(this.neid, slotid);
        TEGenCfgAttribute attribute = TEGenCfgDataMgr.getGenCfgMode((int)board.getBoardType()).getAttrFromId(attrId);
        ArrayList bip8ModeList = attribute.getDomainList();
        StringBuilder sb = new StringBuilder();
        if (null != bip8ModeList) {
            int m = bip8ModeList.size();
            for (int i = 0; i < m; ++i) {
                sb.append(bip8ModeList.get(i).toString());
                if (i == m - 1) continue;
                sb.append(",");
            }
        }
        rowParams.addParam("bip8mode", sb.toString());
    }

    public void handleQueryFTFLResult(ArrayList operationList) {
        Operation tcmStatusOper = null;
        Output output = null;
        Part part = null;
        for (int i = operationList.size() - 1; i >= 0; --i) {
            tcmStatusOper = (Operation)operationList.get(i);
            for (int j = tcmStatusOper.getOutputCount() - 1; j >= 0; --j) {
                output = tcmStatusOper.getOutput(j);
                if (output.getFault(0).getCode().equals("0")) continue;
                for (int k = output.getPartCount() - 1; k >= 0; --k) {
                    part = output.getPart(k);
                    if (part.getValue() != null || part.getName().toLowerCase().equals("slotid") || part.getName().toLowerCase().equals("port") || part.getName().toLowerCase().equals("path") || part.getName().toLowerCase().equals("grade") || part.getName().toLowerCase().equals("level")) continue;
                    part.setValue("/");
                }
            }
        }
    }

    private void handleQueryTCMStatusOper(ArrayList operationList) {
        Operation tcmStatusOper = null;
        ArrayList<Operation> tcmStatusOperList = new ArrayList<Operation>();
        Operation tempOper = null;
        Input input = null;
        Output output = null;
        Output tempOutput = null;
        Part part = null;
        HashSet<Integer> tcmLevelSet = new HashSet<Integer>();
        Param tcmLevelParam = this.inputData.getBussinessParams().getRowParams(0).getParam("tcmlevel");
        if (tcmLevelParam != null && tcmLevelParam.getValue() != null) {
            String[] args = tcmLevelParam.getValue().split(",");
            int iLength = args.length;
            for (int i = 0; i < iLength; ++i) {
                tcmLevelSet.add(Integer.parseInt(args[i]));
            }
        }
        for (int i = operationList.size() - 1; i >= 0; --i) {
            tcmStatusOper = (Operation)operationList.get(i);
            if (!"NSCMD_CFG_GET_TCM_STATE".equals(tcmStatusOper.getName())) continue;
            operationList.remove(i);
            for (int j = 2; j <= 7; ++j) {
                if (tcmLevelSet.size() != 0 && !tcmLevelSet.contains(j)) continue;
                tempOper = (Operation)tcmStatusOper.clone();
                input = tempOper.getInput();
                part = new Part();
                part.setName("level");
                part.setValue("" + j);
                part.setType("byte");
                input.addPart(part);
                output = tempOper.getOutput(0);
                tempOper.removeOutput(0);
                tempOutput = new Output();
                tempOutput.addFault(output.getFault(0));
                tempOutput.addPart(output.getPart(0));
                tempOutput.addPart(output.getPart(1));
                tempOutput.addPart(output.getPart(2));
                tempOutput.addPart(output.getPart(3));
                tempOutput.addPart(part);
                part = output.getPart("tcm" + (j - 1) + "Status");
                part.setName("TCM_STAT_STATUS");
                tempOutput.addPart(part);
                tempOper.addOutput(tempOutput);
                tcmStatusOperList.add(tempOper);
            }
        }
        operationList.addAll(tcmStatusOperList);
    }

    public boolean isNeedExpandOperObj(String attrId) {
        return true;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorCodeList = new ArrayList<Integer>();
        errorCodeList.add(38737);
        errorCodeList.add(Integer.valueOf(PORT_INVALIDE));
        errorCodeList.add(Integer.valueOf(PORT_IS_NOT_EXIST));
        errorCodeList.add(Integer.valueOf(NOTSUPPORTBOARD));
        errorCodeList.add(Integer.valueOf(PATH_INVALIDE));
        errorCodeList.add(Integer.valueOf(BOARDNOTSUPPORT));
        errorCodeList.add(Integer.valueOf(BOARDNOTPERMIT));
        errorCodeList.add(Integer.valueOf(PARAMINVALID));
        errorCodeList.add(Integer.valueOf(SERVICE_ATTRI_LIMIT));
        errorCodeList.add(Integer.valueOf(ERR_CROSS_PORT));
        errorCodeList.add(Integer.valueOf(PATH_INVALIDE_EX));
        errorCodeList.add(Integer.valueOf(GRADE_INCOREECT));
        errorCodeList.add(Integer.valueOf(BIP8_MODE_INVALIDE));
        errorCodeList.add(Integer.valueOf(BIP8_MODE_ERR));
        errorCodeList.add(Integer.valueOf(CROSS_LAYER_NUMBER_ERR));
        errorCodeList.add(Integer.valueOf(TIMMODE_ERR));
        errorCodeList.add(41533);
        return errorCodeList;
    }

    protected void filterOperationList(List operationList, int slotid, int boardType) {
        super.filterOperationList(operationList, slotid, boardType);
        if (boardType == 1200 || boardType == 1199) {
            Map map;
            ArrayList<Integer> portList = new ArrayList<Integer>();
            portList.add(71);
            portList.add(72);
            if (boardType == 1277) {
                portList.add(73);
                portList.add(74);
            }
            if ((map = TEAlarmAdapterCache.getInstatce().queryPayloadMode(this.neid, slotid, portList, 1)).size() > 0) {
                for (Map.Entry entry : map.entrySet()) {
                    if ("71".equals(entry.getKey()) && "2".equals((String)entry.getValue())) {
                        this.filterOperationByPort(operationList, 51);
                        continue;
                    }
                    if ("72".equals(entry.getKey()) && "2".equals((String)entry.getValue())) {
                        this.filterOperationByPort(operationList, 52);
                        continue;
                    }
                    if ("73".equals(entry.getKey()) && "2".equals((String)entry.getValue())) {
                        this.filterOperationByPort(operationList, 53);
                        continue;
                    }
                    if (!"74".equals(entry.getKey()) || !"2".equals((String)entry.getValue())) continue;
                    this.filterOperationByPort(operationList, 54);
                }
            }
        }
    }

    private void filterOperationByPort(List operationList, int port) {
        Iterator iter = operationList.iterator();
        while (iter.hasNext()) {
            Operation operation = (Operation)iter.next();
            Part part = operation.getInput().getPart("port");
            if (!operation.getName().equals("NSCMD_CFG_GET_ST_OTNTTI") && !operation.getName().equals("NSCMD_CFG_GET_SR_OTNTTI") && !operation.getName().equals("NSCMD_CFG_GET_R_OTNTTI") && !operation.getName().equals("NSCMD_CFG_SET_ST_OTNOPUPT") && !operation.getName().equals("NSCMD_CFG_GET_R_OTNOPUPT") && !operation.getName().equals("NSCMD_CFG_GET_SR_OTNOPUPT") && !operation.getName().equals("NSCMD_CFG_GET_SR_OTNOPUVCPT") && !operation.getName().equals("NSCMD_CFG_GET_R_OTNOPUVCPT") || part == null || !String.valueOf(port).equals(part.getValue())) continue;
            iter.remove();
        }
    }

    private String delInvalidSeq(String str) {
        String param = "00";
        if (str.length() % 2 > 0) {
            return str;
        }
        if (str.length() <= 0) {
            return str;
        }
        while (str.lastIndexOf("00") == str.length() - "00".length()) {
            str = str.substring(0, str.length() - "00".length());
        }
        return str;
    }

    static {
        gradeSortMap.put(5, 1);
        gradeSortMap.put(7, 2);
        gradeSortMap.put(1, 3);
        gradeSortMap.put(4, 4);
        gradeSortMap.put(2, 5);
        gradeSortMap.put(3, 6);
        gradeSortMap.put(6, 7);
    }
}

