/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.odukspring_v2r7c02;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ngwdm.odukspring.TEODUkSPRingUtil;
import com.huawei.nglct.ngwdm_pub.TEOTNModelDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;

public class TECreateODUkSPRingBean
extends TENEExplorerBean {
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String ODUK_SPRING_RES = "ngwdm" + File.separator + "res" + File.separator + "odukspring" + File.separator + "odukspringres_" + LANGUAGE + ".ini";
    private TEResourceUtil res = null;
    private int groupId = 0;

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        for (int i = 1; i < inputData.getBussinessParams().getRowParamsCount(); ++i) {
            int tempPathID;
            int slotId = Integer.parseInt(inputData.getBussinessParams().getRowParams(i).getParam("slotId").getValue());
            String pathId = inputData.getBussinessParams().getRowParams(i).getParam("pathId").getValue();
            int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotId);
            if (!TEOTNModelDataMgr.getInstance().isSimpleModelBoard(boardType) || (tempPathID = TEOTNModelDataMgr.getInstance().getNePath(Integer.parseInt(pathId), boardType)) == -1) continue;
            inputData.getBussinessParams().getRowParams(i).getParam("pathId").setValue(String.valueOf(tempPathID));
        }
        try {
            this.groupId = Integer.valueOf(inputData.getBussinessParams().getRowParams()[0].getParam("groupId").getValue());
            this.operationList = TEDataConverter.convertToOperation((SubFunc)subFunc, (Datainterface)inputData, (int)neid);
            return this.operationList;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        try {
            this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList);
            int errorCode = Integer.parseInt(this.outputData.getErrorMessage().getErrorcode());
            if (0 == errorCode || 1 == errorCode) {
                RowParams rowParams = new RowParams();
                rowParams.addParam(new Param("groupId", String.valueOf(this.groupId)));
                this.outputData.getBussinessParams().addRowParams(rowParams);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Exception in calling sendVerify method:", (Throwable)e);
        }
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            this.res = TEGetFilePath.getResource((int)neid, (String)ODUK_SPRING_RES);
            TELogInfo loginfo = new TELogInfo();
            int userID = 0;
            if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = 0;
                }
            }
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            String operObj = "";
            operObj = null == neObj ? String.valueOf(neid) : neObj.getNEName();
            loginfo.setCmdID(subfunc.getCode());
            loginfo.setLocation(ipAddress);
            loginfo.setUserID(userID);
            loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
            String operateName = subfunc.getSubFuncDes(neid);
            loginfo.setOperateName(operateName);
            loginfo.setOperateObject(operObj);
            StringBuffer desc = new StringBuffer();
            desc.append(this.res.getString("protection_group_id")).append(this.groupId).append(",");
            RowParams rowParams = inputData.getBussinessParams().getRowParams(0);
            int level = Integer.parseInt(rowParams.getParam("protectionType").getValue());
            desc.append(this.res.getString("protection_group_level")).append(TEODUkSPRingUtil.getProtectionType(level, this.res)).append(",");
            int rowCount = inputData.getBussinessParams().getRowParamsCount();
            for (int i = 1; i < rowCount; ++i) {
                rowParams = inputData.getBussinessParams().getRowParams(i);
                String pathMapped = rowParams.getParam("pathMapped").getValue();
                int proUnit = Integer.parseInt(rowParams.getParam("protectionUnit").getValue());
                String strUnit = "";
                switch (proUnit) {
                    case 1: {
                        strUnit = this.res.getString("west_work_unit");
                        break;
                    }
                    case 2: {
                        strUnit = this.res.getString("west_protection_unit");
                        break;
                    }
                    case 3: {
                        strUnit = this.res.getString("east_work_unit");
                        break;
                    }
                    case 4: {
                        strUnit = this.res.getString("east_protection_unit");
                        break;
                    }
                }
                desc.append(strUnit).append(pathMapped).append(",");
            }
            loginfo.setOperateDesc(desc.substring(0, desc.length() - 1));
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            if (0 == errorCode) {
                loginfo.setResult(0);
                loginfo.setErrCode(0);
                loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
            } else {
                loginfo.setResult(2);
                if (1 == errorCode || 2 == errorCode) {
                    rowParams = outputData.getBussinessParams().getRowParams(0);
                    int errorCount = rowParams.getRowErrorsCount();
                    for (int j = 0; j < errorCount; ++j) {
                        RowErrors rowErrors = rowParams.getRowErrors(j);
                        loginfo.setErrCode(Integer.parseInt(rowErrors.getErrorMessage().getErrorcode()));
                        loginfo.setErrInfo(rowErrors.getErrorMessage().getErrorinfo());
                    }
                } else {
                    loginfo.setResult(2);
                    loginfo.setErrCode(errorCode);
                    loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                }
            }
            TELogMgr.writeLog((TELogInfo)loginfo);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }

    public int sendMessage(int neid) {
        return this.sendMessage(neid, this.subfunc);
    }
}

