/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ngwdm.odukspring;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;
import java.util.ArrayList;

public class TESwitchODUkSPRingBean
extends TENEExplorerBean {
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String ODUK_SPRING_RES = "ngwdm" + File.separator + "res" + File.separator + "odukspring" + File.separator + "odukspringres_" + LANGUAGE + ".ini";

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            TEResourceUtil res = TEGetFilePath.getResource((int)neid, (String)ODUK_SPRING_RES);
            ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
            int userID = 0;
            if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = 0;
                }
            }
            String operateObject = "";
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            operateObject = null == neObj ? String.valueOf(neid) : neObj.getNEName();
            TELogInfo logInfo = new TELogInfo();
            logInfo.setCmdID(subfunc.getCode());
            logInfo.setLocation(ipAddress);
            logInfo.setUserID(userID);
            logInfo.setUserName(TESysManagerBean.getInstance().getSysUser());
            logInfo.setOperateObject(operateObject);
            logInfo.setOperateName(subfunc.getSubFuncDes(neid));
            StringBuffer desc = new StringBuffer();
            RowParams rowParams = inputData.getBussinessParams().getRowParams(0);
            String groupId = rowParams.getParam("groupId").getValue();
            desc.append(res.getString("protection_group_id")).append(groupId).append(",");
            int direction = Integer.parseInt(rowParams.getParam("direction").getValue());
            String switchDirection = "";
            switch (direction) {
                case 1: {
                    switchDirection = res.getString("switch_direction_west");
                    break;
                }
                case 2: {
                    switchDirection = res.getString("switch_direction_east");
                    break;
                }
            }
            desc.append(res.getString("switch_direction")).append(switchDirection).append(",");
            int cmd = Integer.parseInt(rowParams.getParam("switchcmd").getValue());
            String switchCmd = "";
            switch (cmd) {
                case 22: {
                    switchCmd = res.getString("switch_cmd_lp");
                    break;
                }
                case 14: {
                    switchCmd = res.getString("switch_cmd_force");
                    break;
                }
                case 8: {
                    switchCmd = res.getString("switch_cmd_manual");
                    break;
                }
                case 3: {
                    switchCmd = res.getString("switch_cmd_exer");
                    break;
                }
                case 23: {
                    switchCmd = res.getString("switch_cmd_clear");
                    break;
                }
            }
            desc.append(res.getString("switch_cmd")).append(switchCmd);
            logInfo.setOperateDesc(desc.toString());
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            if (errorCode == 0) {
                logInfo.setResult(0);
                logInfo.setErrCode(0);
                logInfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                loginfoList.add(logInfo);
            } else if (errorCode == 2) {
                rowParams = outputData.getBussinessParams().getRowParams(0);
                int errorCount = rowParams.getRowErrorsCount();
                for (int i = 0; i < errorCount; ++i) {
                    RowErrors rowErrors = rowParams.getRowErrors(i);
                    if ("0".equals(rowErrors.getErrorMessage().getErrorcode())) continue;
                    logInfo.setResult(2);
                    logInfo.setErrCode(Integer.parseInt(rowErrors.getErrorMessage().getErrorcode()));
                    logInfo.setErrInfo(rowErrors.getErrorMessage().getErrorinfo());
                    break;
                }
                loginfoList.add(logInfo);
            } else {
                logInfo.setResult(2);
                logInfo.setErrCode(errorCode);
                logInfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
                loginfoList.add(logInfo);
            }
            int size = loginfoList.size();
            for (int i = 0; i < size; ++i) {
                TELogMgr.writeLog((TELogInfo)((TELogInfo)loginfoList.get(i)));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }
}

